/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.flow.PatternProcessor;
import com.wm.lang.flow.PatternSetMatcher;
import com.wm.lang.flow.SchemaProcessor;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordUtil;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.WmPathItem;
import java.util.List;
import java.util.Vector;

public class WmPathItemProcessor {
    private static final boolean debug = false;
    static final int ACCESS_DEFAULT = 0;
    static final int ACCESS_NODUPS = 1;
    static final int ACCESS_NOSCHEMA = 2;
    static final int ACCESS_DATATYPE = 3;
    WmPathItem pathItem;
    int position;
    WmPathItem posItem;
    WmPathItem posItem_clone;
    int numDups;
    Vector fieldList;
    boolean ambiguity;
    int accessType;
    PatternProcessor pProcessor;
    SchemaProcessor sProcessor;

    WmPathItemProcessor(NSRecord record, WmPathItem pathItem) {
        this(record, pathItem, true);
    }

    WmPathItemProcessor(NSRecord record, WmPathItem pathItem, boolean checkTypeAndDim) {
        this.pathItem = pathItem;
        try {
            this.init(record, checkTypeAndDim);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void init(NSRecord record, boolean checkTypeAndDim) {
        this.position = NSRecordWmPathProcessor.getAbsPosition(record, this.pathItem, checkTypeAndDim);
        if (this.position < 0) {
            this.posItem = this.pathItem;
        } else {
            this.posItem = (WmPathItem)this.pathItem.clone();
            this.posItem.setPosition(this.position);
            this.posItem.setPathType(1);
            Vector<NSField> v = new Vector<NSField>();
            for (int i = 0; i < this.position; ++i) {
                v.addElement(record.getField(i));
            }
            if (v.size() > 0) {
                this.fieldList = v;
            }
        }
        this.posItem_clone = (WmPathItem)this.posItem.clone();
        this.ambiguity = this.checkForAmbiguity(record);
        this.accessType = this.dataAccessType(record);
        this.sProcessor = new SchemaProcessor(record, this.pathItem, this.posItem);
    }

    public int getAccessType() {
        return this.accessType;
    }

    public void setAccessType(int type) {
        this.accessType = type;
    }

    int dataAccessType(NSRecord record) {
        if (record == null) {
            return 2;
        }
        if (this.pathItem.getPosition() < 0) {
            return 1;
        }
        NSField[] fields = record.getFieldsByName(this.pathItem.getName());
        NSField find = NSRecordWmPathProcessor.get(record, this.pathItem);
        if (fields == null || find == null) {
            return 0;
        }
        this.numDups = fields.length;
        int type = find.getType();
        for (int i = 0; i < fields.length; ++i) {
            if (!PatternSetMatcher.matchType(type, fields[i].getType()) || find == fields[i]) continue;
            return 0;
        }
        return 3;
    }

    boolean checkForAmbiguity(NSRecord record) {
        if (record == null) {
            return false;
        }
        NSField[] fields = record.getFieldNodes();
        if (fields == null || fields.length == 0) {
            return false;
        }
        String name = this.pathItem.getName();
        for (int i = 0; i < fields.length; ++i) {
            if (!name.equals(fields[i].getName()) || !this.isOptional(fields[i])) continue;
            boolean found = false;
            boolean next = false;
            for (int j = i + 1; j < fields.length; ++j) {
                boolean sameName = name.equals(fields[j].getName());
                boolean optional = this.isOptional(fields[j]);
                if (!optional && !sameName) {
                    found = true;
                    break;
                }
                if (!sameName) continue;
                next = true;
                break;
            }
            if (!next || found) continue;
            return true;
        }
        return false;
    }

    boolean isOptional(NSField field) {
        boolean isRecordRef = NSRecordUtil.isRecordRefAncester(field);
        if (isRecordRef) {
            return field.isOptional();
        }
        return true;
    }

    public Object get(IData parent, IData origPipe) {
        if (parent == null) {
            return null;
        }
        if (this.accessType == 1) {
            return IDataWmPathProcessor.get(parent, this.pathItem, origPipe);
        }
        if (this.accessType == 2) {
            return IDataWmPathProcessor.get(parent, this.pathItem, origPipe);
        }
        if (this.accessType == 3) {
            int pos = IDataWmPathProcessor.findByType(parent, this.pathItem);
            if (pos > -1) {
                return this.getByPosition(parent, pos, origPipe);
            }
            return IDataWmPathProcessor.get(parent, this.pathItem, origPipe);
        }
        int[] dups = IDataWmPathProcessor.findByName(parent, this.pathItem.getName());
        if (dups != null && dups.length == this.numDups) {
            return IDataWmPathProcessor.get(parent, this.pathItem, origPipe);
        }
        if (this.ambiguity) {
            return IDataWmPathProcessor.get(parent, this.pathItem, origPipe);
        }
        int pos = this.sProcessor.find(parent);
        if (pos != -1) {
            return this.getByPosition(parent, pos, origPipe);
        }
        return IDataWmPathProcessor.get(parent, this.pathItem, origPipe);
    }

    public boolean find(IData parent) {
        if (parent == null) {
            return false;
        }
        if (this.accessType == 1) {
            return IDataWmPathProcessor.find(parent, this.pathItem);
        }
        if (this.accessType == 2 || this.ambiguity) {
            return IDataWmPathProcessor.find(parent, this.pathItem);
        }
        if (this.accessType == 3) {
            int pos = IDataWmPathProcessor.findByType(parent, this.pathItem);
            if (pos > -1) {
                return true;
            }
            return IDataWmPathProcessor.find(parent, this.pathItem);
        }
        int[] dups = IDataWmPathProcessor.findByName(parent, this.pathItem.getName());
        if (dups != null && dups.length == this.numDups) {
            return IDataWmPathProcessor.find(parent, this.pathItem);
        }
        int pos = this.sProcessor.find(parent);
        if (pos != -1) {
            return true;
        }
        return IDataWmPathProcessor.find(parent, this.pathItem);
    }

    public Object put(IData parent, Object value, IData origPipe) {
        int[] dups;
        int pos;
        IDataCursor cursor = null;
        Object putObj = null;
        if (parent == null) {
            return null;
        }
        if (this.accessType == 2 || this.ambiguity) {
            cursor = IDataWmPathProcessor.findCursor(parent, this.pathItem);
            if (cursor != null) {
                putObj = IDataWmPathProcessor.putAtCursor(parent, cursor, value, this.pathItem, origPipe);
                cursor.destroy();
            } else {
                putObj = IDataWmPathProcessor.putAtCursor(parent, cursor, value, this.posItem, origPipe);
            }
            return putObj;
        }
        if (this.accessType == 1) {
            cursor = IDataWmPathProcessor.findCursor(parent, this.pathItem);
            if (cursor != null) {
                putObj = IDataWmPathProcessor.putAtCursor(parent, cursor, value, this.pathItem, origPipe);
                cursor.destroy();
                return putObj;
            }
        } else if (this.accessType == 3 && (pos = IDataWmPathProcessor.findByType(parent, this.pathItem)) > -1) {
            return this.setByPosition(parent, value, pos, origPipe);
        }
        if ((dups = IDataWmPathProcessor.findByName(parent, this.pathItem.getName())) != null && dups.length == this.numDups && (cursor = IDataWmPathProcessor.findCursor(parent, this.pathItem)) != null) {
            putObj = IDataWmPathProcessor.putAtCursor(parent, cursor, value, this.pathItem, origPipe);
            cursor.destroy();
            return putObj;
        }
        List keyList = IDataWmPathProcessor.getKeyList(parent);
        if (keyList != null && this.fieldList != null && keyList.size() <= this.fieldList.size()) {
            boolean find = true;
            Vector list = (Vector)this.fieldList.clone();
            for (int i = 0; i < keyList.size(); ++i) {
                int len = list.size();
                boolean findj = false;
                for (int j = 0; j < len; ++j) {
                    NSField field = (NSField)list.elementAt(j);
                    if (!field.getName().equals(keyList.get(i))) continue;
                    list.removeElementAt(j);
                    findj = true;
                    break;
                }
                if (findj) continue;
                find = false;
                break;
            }
            if (find) {
                cursor = IDataWmPathProcessor.findCursor(parent, this.pathItem);
                if (cursor != null) {
                    putObj = IDataWmPathProcessor.putAtCursor(parent, cursor, value, this.pathItem, origPipe);
                    cursor.destroy();
                } else {
                    putObj = IDataWmPathProcessor.putAtCursor(parent, cursor, value, this.posItem, origPipe);
                }
                return putObj;
            }
        }
        return this.sProcessor.put(parent, value, origPipe);
    }

    final Object getByPosition(IData parent, int pos, IData origPipe) {
        this.posItem_clone.setPosition(pos);
        return IDataWmPathProcessor.get(parent, this.posItem_clone, origPipe);
    }

    final Object setByPosition(IData parent, Object value, int pos, IData origPipe) {
        this.posItem_clone.setPosition(pos);
        return IDataWmPathProcessor.put(parent, value, this.posItem_clone, origPipe);
    }

    public int getAbsPosition() {
        return this.position;
    }

    public WmPathItem getPathItem() {
        return this.pathItem;
    }

    public WmPathItem getPosPathItem() {
        return this.posItem;
    }
}

