/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataIndexCursor;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.resources.FlowExceptionBundle;
import com.wm.lang.ns.WmPathItem;
import com.wm.util.LocalizedException;
import com.wm.util.pluggable.WmIDataList;

public class TableUtil {
    public static WmIDataList findTable(IData parent, WmPathItem pathItem, boolean bestEffort, IData origPipe) {
        if (parent == null || pathItem == null) {
            return null;
        }
        Object value = IDataWmPathProcessor.get(parent, pathItem, bestEffort, origPipe);
        if (!(value instanceof IData[])) {
            return null;
        }
        value = null;
        if (pathItem.getPathType() == 0) {
            IDataCursor cursor = parent.getCursor();
            String name = pathItem.getName();
            boolean done = false;
            if (cursor.first(name) && (value = cursor.getValue()) instanceof WmIDataList) {
                done = true;
            }
            if (!done) {
                while (cursor.next(name)) {
                    if (!(cursor.getValue() instanceof WmIDataList)) continue;
                    value = cursor.getValue();
                    done = true;
                    break;
                }
            }
            cursor.destroy();
            if (done) {
                return (WmIDataList)value;
            }
            return null;
        }
        if (pathItem.getPathType() == 1) {
            if (pathItem.getPosition() < 0) {
                return null;
            }
            IDataIndexCursor cursor = parent.getIndexCursor();
            if (cursor.seek(pathItem.getPosition())) {
                value = cursor.getValue();
            }
            cursor.destroy();
            if (value instanceof WmIDataList) {
                return (WmIDataList)value;
            }
            return null;
        }
        if (pathItem.getPathType() == 2) {
            if (pathItem.getPosition() < 0) {
                return null;
            }
            IDataCursor cursor = parent.getCursor();
            String name = pathItem.getName();
            int position = pathItem.getPosition();
            boolean find = true;
            for (int i = 0; i <= position; ++i) {
                if (cursor.next(name)) continue;
                find = false;
                break;
            }
            if (find) {
                value = cursor.getValue();
            }
            cursor.destroy();
            if (value instanceof WmIDataList) {
                return (WmIDataList)value;
            }
            return null;
        }
        if (pathItem.getPathType() == 3) {
            new LocalizedException(FlowExceptionBundle.class, FlowExceptionBundle.NO_COMPLEX_GET, "").printStackTrace();
            return null;
        }
        return null;
    }

    public static WmIDataList[] findTable(IData parent, String scope, IData origPipe) {
        MapWmPathInfo path = MapWmPathInfo.create(scope);
        if (path == null) {
            return null;
        }
        return TableUtil.findTable(parent, path.getPathItems(), origPipe);
    }

    public static WmIDataList[] findTable(IData parent, WmPathItem[] pathInfo, IData origPipe) {
        if (parent == null || pathInfo == null || pathInfo.length == 0) {
            return null;
        }
        WmIDataList[] find = new WmIDataList[pathInfo.length];
        for (int i = 0; i < pathInfo.length; ++i) {
            Object value = IDataWmPathProcessor.get(parent, pathInfo[i], origPipe);
            if (!(value instanceof IData)) {
                if (!(value instanceof IData[])) break;
                find[i] = TableUtil.findTable(parent, pathInfo[i], true, origPipe);
                break;
            }
            parent = (IData)value;
        }
        return find;
    }

    public static void recoverTable(IData parent, String scope, WmIDataList[] find) {
        MapWmPathInfo path = MapWmPathInfo.create(scope);
        if (path == null) {
            return;
        }
        TableUtil.recoverTable(parent, path.getPathItems(), find);
    }

    public static void recoverTable(IData parent, WmPathItem[] items, WmIDataList[] find) {
        TableUtil.recoverTable(parent, items, find, parent);
    }

    public static void recoverTable(IData parent, WmPathItem[] items, WmIDataList[] find, IData origPipe) {
        if (parent == null || items == null || find == null) {
            return;
        }
        for (int i = 0; i < find.length; ++i) {
            Object value = IDataWmPathProcessor.get(parent, items[i], origPipe);
            if (!(value instanceof IData)) {
                if (!(value instanceof IData[]) || find[i] == null) break;
                find[i].putItems((IData[])value);
                IDataWmPathProcessor.put(parent, find[i], items[i], origPipe);
                break;
            }
            parent = (IData)value;
        }
    }
}

