/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.WmPathItem;
import com.wm.lang.schema.Model;
import com.wm.lang.schema.Sequence;
import com.wm.util.QName;
import java.util.HashSet;
import java.util.List;

public class SchemaProcessor {
    private static final boolean debug = false;
    public static final int FIND_NO = -1;
    public static final int FIND_YES = Integer.MAX_VALUE;
    Model model;
    boolean isDupModel = false;
    WmPathItem pathItem;
    WmPathItem posItem;
    WmPathItem posItem_clone;

    public SchemaProcessor(NSRecord record, WmPathItem pathItem, WmPathItem posItem) {
        this.pathItem = pathItem;
        this.posItem = posItem;
        this.posItem_clone = (WmPathItem)posItem.clone();
        if (record == null || pathItem == null || posItem == null) {
            return;
        }
        int pos = posItem.getPosition();
        if (pos >= 0 && pos < record.getFieldCount()) {
            NSField[] fields = new NSField[pos + 1];
            for (int i = 0; i <= pos; ++i) {
                fields[i] = record.getField(i);
            }
            this.model = this.createModel(fields);
        }
    }

    Model createModel(NSField[] fields) {
        if (fields == null || fields.length == 0) {
            return null;
        }
        int minOccurs = 0;
        int maxOccurs = 1;
        Sequence parent = (Sequence)Model.create(1, 1, 2);
        HashSet<String> dupList = new HashSet<String>();
        for (int i = 0; i < fields.length; ++i) {
            String original;
            String name = original = fields[i].getName();
            int x = 1;
            while (dupList.contains(name)) {
                name = original + '[' + x + ']';
                this.isDupModel = true;
                ++x;
            }
            dupList.add(name);
            Model child = Model.create(name, minOccurs, maxOccurs);
            parent.addModel(child);
        }
        return parent;
    }

    public int find(IData parent) {
        if (parent == null || this.model == null) {
            return -1;
        }
        List keyList = IDataWmPathProcessor.getKeyList(parent);
        if (keyList == null) {
            return -1;
        }
        HashSet<String> dupList = new HashSet<String>();
        QName[] input = new QName[keyList.size() + 1];
        for (int i = 0; i < keyList.size(); ++i) {
            String original;
            String name = original = (String)keyList.get(i);
            int x = 1;
            while (dupList.contains(name)) {
                name = original + '[' + x + ']';
                ++x;
            }
            dupList.add(name);
            input[i] = QName.create(null, name);
        }
        input[input.length - 1] = QName.create(null, "$");
        try {
            int index = this.model.validate(input, false);
            if (index > 0 && index < keyList.size() && this.pathItem.getName().equals(keyList.get(index - 1))) {
                return index - 1;
            }
            return -1;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public Object put(IData parent, Object value, IData origPipe) {
        if (parent == null) {
            return null;
        }
        if (this.model == null) {
            return IDataWmPathProcessor.put(parent, value, this.posItem, origPipe);
        }
        List keyList = IDataWmPathProcessor.getKeyList(parent);
        if (keyList == null) {
            return IDataWmPathProcessor.put(parent, value, this.posItem, origPipe);
        }
        QName[] input = new QName[keyList.size() + 1];
        HashSet<String> dupList = new HashSet<String>();
        for (int i = 0; i < keyList.size(); ++i) {
            String original;
            if (!this.isDupModel) {
                input[i] = QName.create(null, (String)keyList.get(i));
                continue;
            }
            String name = original = (String)keyList.get(i);
            int x = 1;
            while (dupList.contains(name)) {
                name = original + '[' + x + ']';
                ++x;
            }
            dupList.add(name);
            input[i] = QName.create(null, name);
        }
        input[input.length - 1] = QName.create(null, "$");
        try {
            int index = this.model.validate(input, false);
            if (index < 0) {
                return IDataWmPathProcessor.put(parent, value, this.posItem, origPipe);
            }
            if (index > 0) {
                Object indxKey;
                String piName = this.pathItem.getName();
                if (!piName.equals(indxKey = keyList.get(index - 1))) {
                    this.posItem_clone.setPosition(index);
                }
            } else {
                this.posItem_clone.setPosition(index);
            }
            return IDataWmPathProcessor.put(parent, value, this.posItem_clone, origPipe);
        }
        catch (Exception e) {
            return IDataWmPathProcessor.put(parent, value, this.posItem, origPipe);
        }
    }
}

