/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.lang.flow.MapUtil;
import com.wm.lang.flow.PatternSet;
import com.wm.lang.flow.PatternSetMatcher;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.WmPathItem;
import java.util.Vector;

public class PatternSource {
    static final int SIZE_MIN = 3;
    NSField[] fields;
    NSField field;
    int position;
    String[] fieldNames;
    int[] fieldTypes;
    PatternSet schemaPattern;

    public PatternSource(NSRecord record, WmPathItem pathItem) {
        NSField[] fields = record.getFieldNodes();
        NSField field = NSRecordWmPathProcessor.get(record, pathItem);
        this.init(fields, field);
    }

    PatternSource(NSField[] fields, NSField field) {
        this.init(fields, field);
    }

    void init(NSField[] fields, NSField field) {
        this.fields = fields;
        this.field = field;
        this.position = -1;
        if (field != null && fields != null) {
            int i;
            for (i = 0; i < fields.length; ++i) {
                if (field != fields[i]) continue;
                this.position = i;
                break;
            }
            this.fieldNames = new String[fields.length];
            this.fieldTypes = new int[fields.length];
            for (i = 0; i < fields.length; ++i) {
                this.fieldNames[i] = fields[i].getName();
                this.fieldTypes[i] = fields[i].getType();
            }
        }
    }

    PatternSet getPattern(int size) {
        if (this.field == null || this.fields == null || this.position < 0) {
            return null;
        }
        return this.getPattern(this.fieldNames, this.fieldTypes, this.position, size);
    }

    PatternSet getPattern(String[] names, int[] types, int pos, int size) {
        if (names == null || types == null) {
            return null;
        }
        int len = size / 2;
        len = pos <= len && pos - 1 > 0 ? pos - 1 : 0;
        String[] uNames = new String[len];
        int[] uTypes = new int[len];
        for (int i = 0; i < len; ++i) {
            uNames[i] = names[pos - i - 1];
            uTypes[i] = types[pos - i - 1];
        }
        if (pos + (len = size - len + 1) >= names.length) {
            len = names.length - pos - 1;
        }
        String[] lNames = new String[len];
        int[] lTypes = new int[len];
        for (int i = 0; i < len; ++i) {
            lNames[i] = names[pos + i + 1];
            lTypes[i] = types[pos + i + 1];
        }
        return new PatternSet(names[pos], types[pos], uNames, uTypes, lNames, lTypes, pos);
    }

    public PatternSet getSchemaPattern() {
        boolean found;
        if (this.schemaPattern != null) {
            return this.schemaPattern;
        }
        if (this.fields == null || this.field == null) {
            return null;
        }
        int size = 3;
        PatternSet set = this.getPattern(size);
        if (this.fields.length - 1 <= set.getSize()) {
            return set;
        }
        Vector<PatternSource> creators = new Vector<PatternSource>();
        for (int i = 0; i < this.fields.length; ++i) {
            String name = this.fields[i].getName();
            if (name == null || !name.equals(this.field.getName()) || this.fields[i] == this.field) continue;
            creators.addElement(new PatternSource(this.fields, this.fields[i]));
        }
        int len = creators.size();
        block1: do {
            PatternSetMatcher matcher = new PatternSetMatcher(set);
            found = false;
            for (int i = 0; i < len; ++i) {
                PatternSet pattern = ((PatternSource)creators.elementAt(i)).getPattern(size);
                int weight = matcher.match(pattern);
                if (weight != size) continue;
                set = this.getPattern(++size);
                found = true;
                continue block1;
            }
        } while (found && size < this.fields.length - 1);
        this.schemaPattern = set;
        return this.schemaPattern;
    }

    public PatternSet[] getDataPatternSets(String[] keys, Object[] values) {
        if (keys == null || keys.length == 0) {
            return null;
        }
        if (values == null || values.length == 0) {
            return null;
        }
        if (keys.length != values.length) {
            return null;
        }
        if (this.getSchemaPattern() == null) {
            return null;
        }
        int size = this.getSchemaPattern().getSize();
        String name = this.field.getName();
        int type = this.field.getType();
        if (name == null) {
            return null;
        }
        int[] dTypes = new int[values.length];
        for (int i = 0; i < values.length; ++i) {
            dTypes[i] = MapUtil.getType(values[i]);
        }
        Vector<PatternSet> patterns = new Vector<PatternSet>();
        for (int i = 0; i < keys.length; ++i) {
            int dataType = MapUtil.getType(values[i]);
            if (!PatternSetMatcher.matchName(name, keys[i]) || !PatternSetMatcher.matchType(type, dataType)) continue;
            patterns.addElement(this.getPattern(keys, dTypes, i, size));
        }
        Object[] result = null;
        if (patterns.size() != 0) {
            result = new PatternSet[patterns.size()];
            patterns.copyInto(result);
        }
        return result;
    }
}

