/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.lang.flow.PatternSet;
import com.wm.lang.ns.NSField;

public class PatternSetMatcher {
    public static final int MATCH_OWNER = 0;
    public static final int MATCH_NO = -1;
    PatternSet schema;

    public PatternSetMatcher(PatternSet schema) {
        this.schema = schema;
    }

    public int match(PatternSet data) {
        int weight = this.matchOwner(data);
        if (weight < 0) {
            return weight;
        }
        weight += this.matchPattern(this.schema.getUNames(), this.schema.getUTypes(), data.getUNames(), data.getUTypes());
        return weight += this.matchPattern(this.schema.getLNames(), this.schema.getLTypes(), data.getLNames(), data.getLTypes());
    }

    int matchOwner(PatternSet data) {
        if (!PatternSetMatcher.matchName(this.schema.getName(), data.getName())) {
            return -1;
        }
        if (!PatternSetMatcher.matchType(this.schema.getType(), data.getType())) {
            return -1;
        }
        return 0;
    }

    int matchPattern(String[] sNames, int[] sTypes, String[] dNames, int[] dTypes) {
        int weight = 0;
        int index = 0;
        block0: for (int i = 0; i < dNames.length; ++i) {
            String name = dNames[i];
            int type = dTypes[i];
            while (index < sNames.length) {
                if (PatternSetMatcher.matchName(sNames[index], name) && PatternSetMatcher.matchType(sTypes[index], type)) {
                    ++weight;
                    continue block0;
                }
                ++index;
            }
        }
        return weight;
    }

    public static boolean matchName(String schemaName, String dataName) {
        if (schemaName == null) {
            return false;
        }
        return schemaName.equals(dataName);
    }

    public static boolean matchType(int schemaType, int dataType) {
        if (schemaType == 3) {
            return true;
        }
        if (schemaType == dataType) {
            return true;
        }
        return NSField.isRecordType(schemaType) && NSField.isRecordType(dataType);
    }
}

