/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.lang.flow.PatternSet;
import com.wm.lang.flow.PatternSetMatcher;
import com.wm.lang.flow.PatternSource;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.WmPathItem;
import java.util.Vector;

public class PatternProcessor {
    PatternSource source;
    PatternSetMatcher matcher;

    public PatternProcessor(NSRecord record, WmPathItem pathItem) {
        if (record == null || pathItem == null) {
            return;
        }
        this.source = new PatternSource(record, pathItem);
        this.matcher = new PatternSetMatcher(this.source.getSchemaPattern());
    }

    public int find(IData parent) {
        if (this.source == null || this.matcher == null) {
            return -1;
        }
        System.out.println("Schema Set: " + this.matcher.schema.toString());
        IDataCursor cursor = parent.getCursor();
        Vector<String> keys = new Vector<String>();
        Vector<Object> values = new Vector<Object>();
        while (cursor.next()) {
            keys.addElement(cursor.getKey());
            values.addElement(cursor.getValue());
        }
        if (keys.size() == 0) {
            return -1;
        }
        Object[] keyList = new String[keys.size()];
        Object[] valueList = new Object[values.size()];
        keys.copyInto(keyList);
        values.copyInto(valueList);
        PatternSet[] sets = this.source.getDataPatternSets((String[])keyList, valueList);
        if (sets == null) {
            return -1;
        }
        int match = -1;
        int pos = -1;
        for (int i = 0; i < sets.length; ++i) {
            System.out.println("Data Set: " + sets[i].toString());
            int k = this.matcher.match(sets[i]);
            if (k <= match) continue;
            match = k;
            pos = i;
        }
        if (match > -1) {
            return sets[pos].getPosition();
        }
        return -1;
    }
}

