/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.lang.flow.MapError;
import com.wm.lang.flow.WmPathItemProcessor;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.WmPathItem;
import com.wm.util.JournalLogger;
import com.wm.util.pluggable.WmIDataList;
import java.util.Date;

public class MapWmPathUtil {
    private static final boolean debug = false;

    public static void setData(IData pipeline, Object data, int dataDim, WmPathItemProcessor pathProc, boolean overwrite, MapError mapError, IData origPipe) {
        Object exist = pathProc.get(pipeline, origPipe);
        if (exist != null && !overwrite) {
            return;
        }
        WmPathItem pathItem = pathProc.getPathItem();
        if (dataDim == pathItem.getDimension()) {
            if (MapWmPathUtil.dataCheck(data, pathItem, mapError)) {
                pathProc.put(pipeline, data, origPipe);
            }
            return;
        }
        Object value = null;
        value = exist != null ? MapWmPathUtil.dimCollapse(exist, data, dataDim, pathItem, mapError) : MapWmPathUtil.dimCollapse(data, dataDim, pathItem);
        if (MapWmPathUtil.dataCheck(value, pathItem, mapError)) {
            pathProc.put(pipeline, value, origPipe);
        }
    }

    static Object dimCollapse(Object exist, Object data, int dataDim, WmPathItem pathItem, MapError mapError) {
        Object value = null;
        int reqDim = pathItem.getDimension();
        int reqType = pathItem.getType();
        if (dataDim == 2) {
            Object[][] table = (Object[][])data;
            if (reqDim == 0) {
                value = table[0][0];
            } else if (reqDim == 1) {
                value = table[0];
            }
        } else if (dataDim == 1) {
            if (reqDim == 0) {
                if (reqType == 3 && data instanceof WmIDataList) {
                    value = data;
                } else {
                    Object[] list = (Object[])data;
                    value = list[0];
                }
            } else if (reqDim == 2) {
                Object[] list = (Object[])data;
                Object[][] table = (Object[][])exist;
                boolean valid = true;
                for (int i = 0; i < table.length; ++i) {
                    try {
                        table[i] = list;
                        continue;
                    }
                    catch (Exception e) {
                        valid = false;
                    }
                }
                if (!valid && mapError != null) {
                    mapError.logError("setData", "Data type mismatch.");
                }
                value = table;
            }
        } else if (dataDim == 0) {
            if (reqDim == 1) {
                Object[] list = (Object[])exist;
                boolean valid = true;
                for (int i = 0; i < list.length; ++i) {
                    try {
                        list[i] = data;
                        continue;
                    }
                    catch (Exception e) {
                        valid = false;
                    }
                }
                if (!valid && mapError != null) {
                    mapError.logError("setData", "Data type mismatch.");
                }
                value = list;
            } else if (reqDim == 2) {
                Object[][] table = (Object[][])exist;
                boolean valid = true;
                for (int i = 0; i < table.length; ++i) {
                    for (int j = 0; j < table[i].length; ++j) {
                        try {
                            table[i][j] = data;
                            continue;
                        }
                        catch (Exception e) {
                            valid = false;
                        }
                    }
                }
                if (!valid && mapError != null) {
                    mapError.logError("setData", "Data type mismatch.");
                }
                value = table;
            }
        }
        return value;
    }

    static Object dimCollapse(Object data, int dataDim, WmPathItem pathItem) {
        Object value = null;
        int reqDim = pathItem.getDimension();
        int reqType = pathItem.getType();
        int javaReqType = pathItem.getJavaType();
        if (dataDim == 2) {
            Object[][] table = (Object[][])data;
            if (reqDim == 0) {
                value = table[0][0];
            } else if (reqDim == 1) {
                value = table[0];
            }
        } else if (dataDim == 1) {
            if (reqDim == 0) {
                if (reqType == 3 && data instanceof WmIDataList) {
                    value = data;
                } else {
                    Object[] list = (Object[])data;
                    value = list[0];
                }
            } else if (reqDim == 2) {
                Object[] list = (Object[])data;
                Object[][] table = MapWmPathUtil.createTable(reqType, 1, 0);
                table[0] = list;
                value = table;
            }
        } else if (dataDim == 0) {
            if (reqDim == 1) {
                Object[] list = MapWmPathUtil.createList(reqType, javaReqType, 1);
                list[0] = data;
                value = list;
            } else if (reqDim == 2) {
                Object[][] table = MapWmPathUtil.createTable(reqType, 1, 1);
                table[0][0] = data;
                value = table;
            }
        }
        return value;
    }

    public static void setData(IData[] container, WmPathItemProcessor pathProc, Object[] data, boolean overwrite, MapError mapError, IData origPipe) {
        int i;
        Object exist;
        if (!overwrite && (exist = pathProc.get(container[0], origPipe)) != null) {
            return;
        }
        WmPathItem pathItem = pathProc.getPathItem();
        for (i = 0; i < data.length; ++i) {
            if (MapWmPathUtil.dataCheck(data[i], pathItem, mapError)) continue;
            return;
        }
        if (data.length >= container.length) {
            for (i = 0; i < container.length; ++i) {
                pathProc.put(container[i], data[i], origPipe);
            }
        } else {
            int block = data.length;
            int len = container.length / block;
            for (int i2 = 0; i2 < len; ++i2) {
                int k = i2 * block;
                for (int j = 0; j < block; ++j) {
                    pathProc.put(container[j + k], data[j], origPipe);
                }
            }
        }
    }

    public static void setData(IData[] container, WmPathItemProcessor toProc, IData[] source, WmPathItemProcessor fromProc, boolean overwrite, MapError mapError, IData origPipe) {
        Object exist;
        if (!overwrite && (exist = toProc.get(container[0], origPipe)) != null) {
            return;
        }
        WmPathItem toKey = toProc.getPathItem();
        if (source.length >= container.length) {
            int i;
            Object[] sourceData = new Object[container.length];
            for (i = 0; i < container.length; ++i) {
                sourceData[i] = fromProc.get(source[i], origPipe);
                if (MapWmPathUtil.dataCheck(sourceData[i], toKey, mapError)) continue;
                return;
            }
            for (i = 0; i < container.length; ++i) {
                toProc.put(container[i], sourceData[i], origPipe);
            }
        } else {
            int block = source.length;
            Object[] data = new Object[block];
            for (int i = 0; i < block; ++i) {
                data[i] = fromProc.get(source[i], origPipe);
                if (MapWmPathUtil.dataCheck(data[i], toKey, mapError)) continue;
                return;
            }
            int len = container.length / block;
            for (int i = 0; i < len; ++i) {
                int k = i * block;
                for (int j = 0; j < block; ++j) {
                    toProc.put(container[j + k], data[j], origPipe);
                }
            }
        }
    }

    public static void setData(Object[] container, Object[] data, boolean overwrite, MapError mapError) {
        if (container.length == 0 || data.length == 0 || !(container[0] instanceof Object[])) {
            return;
        }
        Object[] aContainer = (Object[])container[0];
        for (int i = 0; i < aContainer.length; ++i) {
            if (overwrite || aContainer[i] == null) continue;
            return;
        }
        if (data.length >= container.length * aContainer.length) {
            boolean valid = true;
            for (int i = 0; i < container.length; ++i) {
                aContainer = (Object[])container[i];
                int k = i * aContainer.length;
                for (int j = 0; j < aContainer.length; ++j) {
                    try {
                        aContainer[j] = data[j + k];
                        continue;
                    }
                    catch (Exception e) {
                        valid = false;
                    }
                }
            }
            if (!valid && mapError != null) {
                mapError.logError("setData", "Data type mismatch.");
            }
        } else {
            int block = data.length;
            int len1 = block / aContainer.length;
            int len2 = container.length / len1;
            boolean valid = true;
            for (int i = 0; i < len2; ++i) {
                for (int j = 0; j < len1; ++j) {
                    aContainer = (Object[])container[j + i * len1];
                    int k = j * aContainer.length;
                    for (int l = 0; l < aContainer.length; ++l) {
                        try {
                            aContainer[l] = data[l + k];
                            continue;
                        }
                        catch (Exception e) {
                            valid = false;
                        }
                    }
                }
            }
            if (!valid && mapError != null) {
                mapError.logError("setData", "Data type mismatch.");
            }
        }
    }

    static final Object[][] createTable(int reqType, int len1, int len2) {
        Object[][] table = null;
        if (len2 != -1) {
            switch (reqType) {
                case 1: {
                    table = new String[len1][len2];
                    break;
                }
                case 2: {
                    table = new IData[len1][len2];
                    break;
                }
                case 3: {
                    table = new Object[len1][len2];
                    break;
                }
                case 4: {
                    table = new IData[len1][len2];
                }
            }
        } else {
            switch (reqType) {
                case 1: {
                    table = new String[len1][];
                    break;
                }
                case 2: {
                    table = new IData[len1][];
                    break;
                }
                case 3: {
                    table = new Object[len1][];
                    break;
                }
                case 4: {
                    table = new IData[len1][];
                }
            }
        }
        return table;
    }

    static final Object[] createList(int reqType, int len) {
        return MapWmPathUtil.createList(reqType, 0, len);
    }

    static final Object[] createList(int reqType, int javaReqType, int len) {
        Object[] list = null;
        switch (reqType) {
            case 1: {
                list = new String[len];
                break;
            }
            case 2: {
                list = new IData[len];
                break;
            }
            case 3: {
                if (javaReqType == 0) {
                    list = new Object[len];
                    break;
                }
                if (javaReqType == 1) {
                    list = new Boolean[len];
                    break;
                }
                if (javaReqType == 2) {
                    list = new Byte[len];
                    break;
                }
                if (javaReqType == 3) {
                    list = new Character[len];
                    break;
                }
                if (javaReqType == 4) {
                    list = new Double[len];
                    break;
                }
                if (javaReqType == 5) {
                    list = new Float[len];
                    break;
                }
                if (javaReqType == 6) {
                    list = new Integer[len];
                    break;
                }
                if (javaReqType == 7) {
                    list = new Long[len];
                    break;
                }
                if (javaReqType == 8) {
                    list = new Short[len];
                    break;
                }
                if (javaReqType == 9) {
                    list = new Date[len];
                    break;
                }
                list = new Object[len];
                break;
            }
            case 4: {
                list = new IData[len];
            }
        }
        return list;
    }

    public static boolean dataCheck(Object data, WmPathItem pathItem, MapError mapError) {
        if (data == null) {
            return true;
        }
        int type = pathItem.getType();
        if (data instanceof WmIDataList) {
            data = ((WmIDataList)data).getItems();
        }
        if (type == 3) {
            return true;
        }
        if (data instanceof String && type == 1) {
            return true;
        }
        if (data instanceof String[] && type == 1) {
            return true;
        }
        if (data instanceof String[][] && type == 1) {
            return true;
        }
        if (data instanceof IData && NSField.isRecordType(type)) {
            return true;
        }
        if (data instanceof IData[] && NSField.isRecordType(type)) {
            return true;
        }
        JournalLogger.logDebugPlus(2, 12, 50);
        if (mapError != null) {
            mapError.logError("Set operation: dataCheck", "Data type mismatch");
        }
        return false;
    }
}

