/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataFactory;
import com.wm.lang.flow.MapFlatData;
import com.wm.lang.flow.MapPathProcessorIf;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.MapWmPathUtil;
import com.wm.lang.flow.WmPathItemProcessor;
import com.wm.lang.ns.WmPathItem;
import com.wm.util.JournalLogger;
import java.util.Vector;

public class MapWmPathProcessor
implements MapPathProcessorIf {
    MapWmPathInfo pathInfo;

    public MapWmPathProcessor(MapWmPathInfo pathInfo) {
        this.pathInfo = pathInfo;
    }

    public MapWmPathInfo getPathInfo() {
        return this.pathInfo;
    }

    public void setPathInfo(MapWmPathInfo pathInfo) {
        this.pathInfo = pathInfo;
    }

    public MapFlatData getDataContainer(MapFlatData pathContainer, IData origPipe) {
        if (pathContainer == null) {
            return null;
        }
        if (this.pathInfo.getDataDimension() == 0) {
            pathContainer.setSize(1, this.pathInfo.getPathDepth() - 1);
            return pathContainer;
        }
        IData[] next = (IData[])pathContainer.getData();
        if (next == null || next.length == 0) {
            return null;
        }
        Object[] obj = new Object[next.length];
        WmPathItemProcessor dataProc = this.pathInfo.getDataProcessor();
        for (int i = 0; i < next.length; ++i) {
            obj[i] = dataProc.get(next[i], origPipe);
            if (obj[i] != null) continue;
            return null;
        }
        int dim = this.pathInfo.getDataDimension();
        Object[] data = null;
        int[] dataSize = null;
        if (dim == 1) {
            data = obj;
            dataSize = pathContainer.getSizes();
            dataSize[dataSize.length - 1] = obj.length;
        } else if (dim == 2) {
            Vector<Object[]> collector = new Vector<Object[]>();
            for (int i = 0; i < obj.length; ++i) {
                if (!(obj[i] instanceof Object[][])) continue;
                Object[][] aValue = (Object[][])obj[i];
                for (int j = 0; j < aValue.length; ++j) {
                    collector.addElement(aValue[j]);
                }
            }
            if (collector.size() > 0) {
                data = new Object[collector.size()];
                collector.copyInto(data);
            }
            dataSize = pathContainer.getSizes();
            dataSize[dataSize.length - 1] = data.length / obj.length;
        }
        return data == null ? null : new MapFlatData(data, dataSize);
    }

    public MapFlatData getDataObject(MapFlatData dataContainer, IData origPipe) {
        if (dataContainer == null) {
            return null;
        }
        int dim = this.pathInfo.getDataDimension();
        int type = this.pathInfo.getDataType();
        int javaType = this.pathInfo.getJavaType();
        Object[] data = null;
        int[] dataSize = null;
        if (dim == 0) {
            IData[] parent = (IData[])dataContainer.getData();
            data = new Object[parent.length];
            WmPathItemProcessor dataProc = this.pathInfo.getDataProcessor();
            for (int i = 0; i < parent.length; ++i) {
                data[i] = dataProc.get(parent[i], origPipe);
            }
            dataSize = dataContainer.getSizes();
            dataSize[dataSize.length - 1] = 1;
        } else {
            Object[] parent = dataContainer.getData();
            if (parent == null || parent.length == 0) {
                return null;
            }
            Vector<Object> collector = new Vector<Object>();
            for (int i = 0; i < parent.length; ++i) {
                Object[] aValue = (Object[])parent[i];
                if (aValue == null) continue;
                for (int j = 0; j < aValue.length; ++j) {
                    collector.addElement(aValue[j]);
                }
            }
            int size = collector.size() / parent.length;
            data = MapWmPathUtil.createList(type, javaType, collector.size());
            collector.copyInto(data);
            if (dim == 1) {
                dataSize = dataContainer.getSizes();
                dataSize[dataSize.length - 1] = size;
            } else {
                int[] sizes = dataContainer.getSizes();
                dataSize = new int[sizes.length + 1];
                System.arraycopy(sizes, 0, dataSize, 0, sizes.length);
                dataSize[dataSize.length - 1] = size;
            }
        }
        return new MapFlatData(data, dataSize);
    }

    public MapFlatData getDataObject(IData pipeline, IData origPipe) {
        MapFlatData pathContainer = this.getPathContainer(pipeline, origPipe);
        if (pathContainer == null) {
            return null;
        }
        MapFlatData dataContainer = this.getDataContainer(pathContainer, origPipe);
        if (dataContainer == null) {
            return null;
        }
        return this.getDataObject(dataContainer, origPipe);
    }

    public MapFlatData createDataContainer(MapFlatData pathContainer, int[] expectedSize, IData origPipe) {
        MapFlatData dataContainer = this.getDataContainer(pathContainer, origPipe);
        if (dataContainer != null) {
            return dataContainer;
        }
        int type = this.pathInfo.getDataType();
        int dim = this.pathInfo.getDataDimension();
        if (dim == 0) {
            return pathContainer;
        }
        IData[] parents = (IData[])pathContainer.getData();
        int[] dataSize = pathContainer.getSizes();
        Object[] data = new Object[parents.length];
        WmPathItemProcessor dataProc = this.pathInfo.getDataProcessor();
        for (int i = 0; i < parents.length; ++i) {
            data[i] = this.createDataContainer(type, dim, expectedSize);
            dataProc.put(parents[i], data[i], origPipe);
        }
        if (dim == 1) {
            dataSize[dataSize.length - 1] = expectedSize[0];
        } else if (dim == 2) {
            Object[] aValue = (Object[])data[0];
            Object[] result = new Object[data.length * aValue.length];
            for (int i = 0; i < data.length; ++i) {
                aValue = (Object[])data[i];
                int k = i * aValue.length;
                for (int j = 0; j < aValue.length; ++j) {
                    result[j + k] = aValue[j];
                }
            }
            data = result;
            int[] sizes = pathContainer.getSizes();
            dataSize = new int[dataSize.length + 1];
            System.arraycopy(sizes, 0, dataSize, 0, sizes.length - 1);
            dataSize[sizes.length - 1] = expectedSize[0];
            dataSize[sizes.length] = expectedSize[1];
        }
        return new MapFlatData(data, dataSize);
    }

    Object createDataContainer(int type, int dim, int[] size) {
        Object obj = null;
        if (type == 1) {
            if (dim == 0) {
                obj = null;
            } else if (dim == 1) {
                obj = new String[size[0]];
            } else if (dim == 2) {
                obj = new String[size[0]][size[1]];
            }
        } else if (type == 2 || type == 4) {
            if (dim == 0) {
                obj = IDataFactory.create(1);
            } else if (dim == 1) {
                obj = new IData[size[0]];
            }
        } else if (type == 3) {
            if (dim == 0) {
                obj = new Object();
            } else if (dim == 1) {
                obj = new Object[size[0]];
            }
        }
        return obj;
    }

    public MapFlatData getPathContainer(IData pipeline, IData origPipe) {
        Object[] next = new IData[]{pipeline};
        WmPathItem[] pathItems = this.pathInfo.getPathItems();
        WmPathItemProcessor[] itemProcs = this.pathInfo.getItemProcessors();
        int[] dataSize = new int[pathItems.length];
        boolean hasArray = false;
        for (int i = 0; i < dataSize.length - 1; ++i) {
            if (pathItems[i].getDimension() == 0) {
                if ((next = this.retrieveScalarContainer((IData[])next, itemProcs[i], hasArray, origPipe)) == null) {
                    return null;
                }
                dataSize[i] = 1;
                continue;
            }
            if (pathItems[i].getDimension() == 1) {
                IData[] containers = this.retrieveArrayContainer((IData[])next, itemProcs[i], origPipe);
                if (containers == null) {
                    return null;
                }
                dataSize[i] = containers.length / next.length;
                next = containers;
                hasArray = true;
                continue;
            }
            JournalLogger.logDebugPlus(2, 8, 50, this.pathInfo.getPathID());
            return null;
        }
        return new MapFlatData(next, dataSize);
    }

    public MapFlatData createPathContainer(IData pipeline, int[] valuesSize, IData origPipe) {
        WmPathItem[] findPath = this.pathInfo.getPathItems();
        WmPathItemProcessor[] itemProcs = this.pathInfo.getItemProcessors();
        Object[] next = new IData[]{pipeline};
        int[] dataSize = new int[findPath.length];
        for (int i = 0; i < findPath.length - 1; ++i) {
            if (findPath[i].getDimension() == 0) {
                next = this.createScalarContainer((IData[])next, itemProcs[i], origPipe);
                dataSize[i] = valuesSize[i];
                continue;
            }
            if (findPath[i].getDimension() == 1) {
                IData[] containers = this.createArrayContainer((IData[])next, itemProcs[i], valuesSize[i], origPipe);
                if (containers == null) {
                    return null;
                }
                dataSize[i] = valuesSize[i];
                next = containers;
                continue;
            }
            JournalLogger.logDebugPlus(2, 8, 50, this.pathInfo.getPathID());
            return null;
        }
        return new MapFlatData(next, dataSize);
    }

    IData[] retrieveScalarContainer(IData[] parent, WmPathItemProcessor pathItem, boolean create, IData origPipe) {
        if (parent == null || parent.length == 0) {
            return null;
        }
        IData[] data = new IData[parent.length];
        for (int j = 0; j < parent.length; ++j) {
            Object o = pathItem.get(parent[j], origPipe);
            if (o instanceof IData) {
                data[j] = (IData)o;
                continue;
            }
            if (create) {
                data[j] = IDataFactory.create(1);
                continue;
            }
            return null;
        }
        return data;
    }

    IData[] retrieveArrayContainer(IData[] parent, WmPathItemProcessor pathItem, IData origPipe) {
        IData[] o;
        int j;
        Object[] objs = new Object[parent.length];
        int len = 0;
        int num = 0;
        int commonSize = 0;
        boolean found = false;
        for (j = 0; j < parent.length; ++j) {
            o = pathItem.get(parent[j], origPipe);
            if (o instanceof IData[]) {
                objs[j] = o;
                int curSize = ((IData[])o).length;
                if (commonSize == 0 && curSize != 0) {
                    commonSize = curSize;
                }
                if (curSize != 0 && curSize != commonSize) {
                    return null;
                }
                len += curSize;
                ++num;
                continue;
            }
            objs[j] = null;
            found = true;
        }
        if (num == 0) {
            return null;
        }
        if (found) {
            len /= num;
            for (j = 0; j < objs.length; ++j) {
                if (objs[j] != null) continue;
                o = new IData[len];
                for (int k = 0; k < len; ++k) {
                    o[k] = IDataFactory.create(1);
                }
                objs[j] = o;
            }
        }
        Vector<IData> collector = new Vector<IData>();
        for (int j2 = 0; j2 < parent.length; ++j2) {
            if (!(objs[j2] instanceof IData[])) continue;
            IData[] aValue = (IData[])objs[j2];
            for (int k = 0; k < aValue.length; ++k) {
                if (aValue[k] == null) {
                    aValue[k] = IDataFactory.create(1);
                }
                collector.addElement(aValue[k]);
            }
        }
        if (collector.size() == 0) {
            return null;
        }
        Object[] data = new IData[collector.size()];
        collector.copyInto(data);
        return data;
    }

    IData[] createScalarContainer(IData[] parent, WmPathItemProcessor itemProc, IData origPipe) {
        if (parent == null || parent.length == 0) {
            return null;
        }
        IData[] data = new IData[parent.length];
        for (int j = 0; j < parent.length; ++j) {
            Object o = itemProc.get(parent[j], origPipe);
            data[j] = o instanceof IData ? (IData)o : null;
            if (data[j] != null) continue;
            data[j] = IDataFactory.create(1);
            itemProc.put(parent[j], data[j], origPipe);
        }
        return data;
    }

    IData[] createArrayContainer(IData[] parent, WmPathItemProcessor itemProc, int size, IData origPipe) {
        if (parent == null || parent.length == 0) {
            return null;
        }
        IData[] data = this.retrieveArrayContainer(parent, itemProc, origPipe);
        if (data == null && size > 0) {
            data = new IData[parent.length * size];
            for (int j = 0; j < parent.length; ++j) {
                IData[] aValue = new IData[size];
                for (int i = 0; i < size; ++i) {
                    aValue[i] = IDataFactory.create(1);
                }
                itemProc.put(parent[j], aValue, origPipe);
                for (int k = 0; k < size; ++k) {
                    data[k + j * size] = aValue[k];
                }
            }
        }
        return data;
    }
}

