/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.WmPathItemProcessor;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.WmPathInfo;
import com.wm.lang.ns.WmPathItem;
import com.wm.util.JournalLogger;
import com.wm.util.coder.IDataCodable;
import java.lang.reflect.Method;

public class MapWmPathInfo {
    public static final int PATH_GENERAL = 0;
    public static final int PATH_SINGLE = 1;
    public static final int PATH_SIMPLE = 2;
    String path;
    WmPathItem[] pathInfo;
    WmPathItemProcessor[] itemProcs;
    String[] names;
    int[] dims;
    int[] types;
    int pathDim;
    int nodePathDim;
    int pathChar;
    String className;
    boolean bestEffort = true;

    private MapWmPathInfo(String path) {
        this.path = path;
        this.init();
    }

    public static MapWmPathInfo create(String path) {
        if (path == null || path.length() == 0) {
            return null;
        }
        try {
            MapWmPathInfo aPathInfo = new MapWmPathInfo(path);
            if (aPathInfo.getPathItems() == null) {
                return null;
            }
            return aPathInfo;
        }
        catch (Exception e) {
            return null;
        }
    }

    public void compile(NSRecord schemaInfo) {
        this.compile(schemaInfo, true);
    }

    public void compile(NSRecord schemaInfo, boolean checkTypeAndDim) {
        if (this.pathInfo == null || this.pathInfo.length < 1) {
            return;
        }
        this.itemProcs = new WmPathItemProcessor[this.pathInfo.length];
        NSRecord parent = schemaInfo;
        for (int i = 0; i < this.pathInfo.length; ++i) {
            this.itemProcs[i] = new WmPathItemProcessor(parent, this.pathInfo[i], !checkTypeAndDim);
            NSField find = NSRecordWmPathProcessor.get(parent, this.pathInfo[i], checkTypeAndDim);
            parent = find instanceof NSRecord ? (NSRecord)find : null;
        }
    }

    private void init() {
        int i;
        this.pathInfo = WmPathInfo.parsePath(this.path);
        if (this.pathInfo == null) {
            JournalLogger.logDebugPlus(2, 6, 50, this.path);
            return;
        }
        this.names = new String[this.pathInfo.length];
        for (i = 0; i < this.pathInfo.length; ++i) {
            this.names[i] = this.pathInfo[i].getName();
        }
        this.dims = new int[this.pathInfo.length];
        for (i = 0; i < this.pathInfo.length; ++i) {
            this.dims[i] = this.pathInfo[i].getNodeDimension();
        }
        this.types = new int[this.pathInfo.length];
        for (i = 0; i < this.pathInfo.length; ++i) {
            this.types[i] = this.pathInfo[i].getType();
        }
        this.pathDim = 0;
        for (i = 0; i < this.pathInfo.length; ++i) {
            this.pathDim += this.pathInfo[i].getDimension();
        }
        this.nodePathDim = 0;
        for (i = 0; i < this.pathInfo.length; ++i) {
            this.nodePathDim += this.pathInfo[i].getNodeDimension();
        }
        this.pathChar = this.pathInfo.length == 1 ? 1 : (this.pathDim == this.pathInfo[this.pathInfo.length - 1].getDimension() ? 2 : 0);
    }

    public String[] getPathInfo() {
        return this.names;
    }

    public WmPathItemProcessor[] getItemProcessors() {
        if (this.itemProcs == null) {
            this.compile(null);
        }
        return this.itemProcs;
    }

    public int[] getTypeInfo() {
        return this.types;
    }

    public int[] getNodeDimInfo() {
        return this.dims;
    }

    public WmPathItem[] getPathItems() {
        return this.pathInfo;
    }

    public WmPathItem getDataPathItem() {
        return this.pathInfo[this.pathInfo.length - 1];
    }

    public WmPathItemProcessor getDataProcessor() {
        return this.itemProcs[this.itemProcs.length - 1];
    }

    public int getPathType() {
        return this.pathInfo[this.pathInfo.length - 1].getType();
    }

    public int getPathDimension() {
        return this.pathDim;
    }

    public int getNodePathDimension() {
        return this.nodePathDim;
    }

    public String getPathString() {
        if (this.pathInfo != null && this.pathInfo.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.pathInfo.length; ++i) {
                sb.append(this.pathInfo[i].toString());
            }
            this.path = sb.toString();
        }
        return this.path;
    }

    public String getPathDisplayString() {
        if (this.pathInfo != null && this.pathInfo.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.pathInfo.length; ++i) {
                sb.append(this.pathInfo[i].getDisplayString());
            }
            this.path = sb.toString();
        }
        return this.path;
    }

    public int getPathCharacter() {
        return this.pathChar;
    }

    public void setPathCharacter(int mode) {
        this.pathChar = mode;
    }

    public String getDataName() {
        return this.pathInfo[this.pathInfo.length - 1].getName();
    }

    public int getJavaType() {
        return this.pathInfo[this.pathInfo.length - 1].getJavaType();
    }

    public int getDataType() {
        return this.pathInfo[this.pathInfo.length - 1].getType();
    }

    public int getDataDimension() {
        return this.pathInfo[this.pathInfo.length - 1].getDimension();
    }

    public int getPathDepth() {
        return this.pathInfo.length;
    }

    public int getIndexForDimension(int num) {
        if (this.pathDim < num) {
            return -1;
        }
        int sum = 0;
        if (this.getDataDimension() == 1) {
            if (++sum == num) {
                return this.pathInfo.length - 1;
            }
        } else if (this.getDataDimension() == 2) {
            if (++sum == num) {
                return this.pathInfo.length;
            }
            if (++sum == num) {
                return this.pathInfo.length - 1;
            }
        }
        for (int i = this.pathInfo.length - 2; i >= 0; --i) {
            if (this.pathInfo[i].getDimension() != 1 || ++sum != num) continue;
            return i;
        }
        return -1;
    }

    public String getPathID() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.pathInfo.length; ++i) {
            sb.append(this.pathInfo[i].getID());
        }
        return sb.toString();
    }

    public String[] getPathIDInfo() {
        String[] id = new String[this.pathInfo.length];
        for (int i = 0; i < this.pathInfo.length; ++i) {
            id[i] = this.pathInfo[i].getID();
        }
        return id;
    }

    public void setBestEffort(boolean b) {
        this.bestEffort = b;
    }

    public boolean isBestEffort() {
        return this.bestEffort;
    }

    public int[] getAbsPosition() {
        if (this.itemProcs == null || this.itemProcs.length == 0) {
            return null;
        }
        int[] pos = new int[this.itemProcs.length];
        int find = 0;
        for (int i = 0; i < this.itemProcs.length; ++i) {
            pos[i] = this.itemProcs[i].getAbsPosition();
            if (pos[i] < 0) continue;
            ++find;
        }
        if (find == 0) {
            return null;
        }
        return pos;
    }

    public WmPathItem[] getPosPathItems() {
        if (this.itemProcs == null || this.itemProcs.length == 0) {
            return null;
        }
        WmPathItem[] pos = new WmPathItem[this.itemProcs.length];
        for (int i = 0; i < this.itemProcs.length; ++i) {
            pos[i] = this.itemProcs[i].getPosPathItem();
        }
        return pos;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    Object convertData(Object data) {
        String dataName;
        if (this.className == null || data == null) {
            return data;
        }
        int dataDim = this.getDataDimension(data);
        if (this.getDataDimension() != dataDim) {
            return data;
        }
        String string = dataName = data.getClass().isArray() ? data.getClass().getComponentType().getName() : data.getClass().getName();
        if (this.className.equals(dataName)) {
            return data;
        }
        Object target = null;
        Method create = null;
        try {
            Class<?> dataClass = Class.forName(this.className);
            create = dataClass.getMethod("create", null);
            target = create.invoke(null, (Object[])null);
            if (!(target instanceof IData)) {
                return data;
            }
        }
        catch (Exception e) {
            return data;
        }
        if (data instanceof IData) {
            if (target instanceof IDataCodable) {
                ((IDataCodable)target).setIData((IData)data);
            } else {
                IDataUtil.copy((IData)data, (IData)target);
            }
            return target;
        }
        if (data instanceof IData[]) {
            int i;
            IData[] array = (IData[])data;
            IData[] targets = new IData[array.length];
            for (i = 0; i < targets.length; ++i) {
                try {
                    targets[i] = (IData)create.invoke(null, (Object[])null);
                    continue;
                }
                catch (Exception e) {
                    return data;
                }
            }
            if (target instanceof IDataCodable) {
                for (i = 0; i < targets.length; ++i) {
                    ((IDataCodable)((Object)targets[i])).setIData(array[i]);
                }
            } else {
                for (i = 0; i < targets.length; ++i) {
                    IDataUtil.copy(array[i], targets[i]);
                }
            }
            return targets;
        }
        return data;
    }

    private int getDataDimension(Object data) {
        if (data instanceof Object[][]) {
            return 2;
        }
        if (data instanceof Object[]) {
            return 1;
        }
        return 0;
    }

    public static void main(String[] args) {
        String path = "/A(1)[1]/B;0;1";
        MapWmPathInfo pathInfo = MapWmPathInfo.create(path);
        System.out.println("path=" + pathInfo.getPathString());
        WmPathItem[] items = pathInfo.getPathItems();
        items[1].setArrayIndex(1);
        System.out.println("path=" + pathInfo.getPathString());
    }
}

