/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowException;
import com.wm.lang.flow.FlowMap;
import com.wm.lang.flow.FlowMapCopy;
import com.wm.lang.flow.FlowMapDelete;
import com.wm.lang.flow.FlowMapInvoke;
import com.wm.lang.flow.FlowMapSet;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.resources.FlowExceptionBundle;
import com.wm.lang.ns.WmPathItem;
import com.wm.util.JournalLogger;
import com.wm.util.LocalizedException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class MapValidator {
    FlowMap flowMap;
    Hashtable assignedFields;
    LocalizedException error;

    public MapValidator(FlowMap map) {
        this.flowMap = map;
    }

    public FlowMapCopy[] getCopyMaps() {
        if (this.flowMap.getNodeCount() < 1) {
            return null;
        }
        Vector<FlowElement> copys = new Vector<FlowElement>();
        FlowElement[] nodes = this.flowMap.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FlowMapCopy)) continue;
            copys.addElement(nodes[i]);
        }
        if (copys.size() == 0) {
            return null;
        }
        Object[] copyMaps = new FlowMapCopy[copys.size()];
        copys.copyInto(copyMaps);
        return copyMaps;
    }

    public FlowMapSet[] getSetMaps() {
        if (this.flowMap.getNodeCount() < 1) {
            return null;
        }
        Vector<FlowElement> sets = new Vector<FlowElement>();
        FlowElement[] nodes = this.flowMap.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FlowMapSet)) continue;
            sets.addElement(nodes[i]);
        }
        if (sets.size() == 0) {
            return null;
        }
        Object[] setMaps = new FlowMapSet[sets.size()];
        sets.copyInto(setMaps);
        return setMaps;
    }

    public FlowMapDelete[] getDeleteMaps() {
        if (this.flowMap.getNodeCount() < 1) {
            return new FlowMapDelete[0];
        }
        Vector<FlowElement> deletes = new Vector<FlowElement>();
        FlowElement[] nodes = this.flowMap.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FlowMapDelete)) continue;
            deletes.addElement(nodes[i]);
        }
        Object[] deleteMaps = new FlowMapDelete[deletes.size()];
        if (deletes.size() == 0) {
            return deleteMaps;
        }
        deletes.copyInto(deleteMaps);
        return deleteMaps;
    }

    public FlowMapInvoke[] getInvokeMaps() {
        if (this.flowMap.getNodeCount() < 1) {
            return null;
        }
        Vector<FlowElement> invokes = new Vector<FlowElement>();
        FlowElement[] nodes = this.flowMap.getNodes();
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FlowMapInvoke)) continue;
            invokes.addElement(nodes[i]);
        }
        if (invokes.size() == 0) {
            return null;
        }
        Object[] invokeMaps = new FlowMapInvoke[invokes.size()];
        invokes.copyInto(invokeMaps);
        return invokeMaps;
    }

    public boolean isValid(FlowElement map) {
        if (map == null) {
            return false;
        }
        if (map instanceof FlowMapCopy) {
            FlowMapCopy copy = (FlowMapCopy)map;
            boolean hasCond = copy.getCondition() != null;
            return this.isValidCopy(copy.getMapFrom(), copy.getMapTo(), hasCond);
        }
        if (map instanceof FlowMapDelete) {
            return this.isValidAssignedField(((FlowMapDelete)map).getField());
        }
        if (map instanceof FlowMapSet) {
            if (!((FlowMapSet)map).isValid()) {
                return false;
            }
            return this.isValidAssignedField(((FlowMapSet)map).getField());
        }
        if (map instanceof FlowMapInvoke) {
            return this.isValidInvoke((FlowMapInvoke)map);
        }
        return false;
    }

    public String getValidation(FlowElement map) {
        if (map == null) {
            this.error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.NULL_FLOWMAP, "");
            return this.error.getLocalizedMessage(Locale.getDefault());
        }
        if (map instanceof FlowMapCopy) {
            FlowMapCopy copy = (FlowMapCopy)map;
            boolean hasCond = copy.getCondition() != null;
            return this.validateCopy(copy.getMapFrom(), copy.getMapTo(), hasCond);
        }
        if (map instanceof FlowMapDelete) {
            String path = ((FlowMapDelete)map).getField();
            if (!this.isValidAssignedField(path)) {
                this.error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.PATH_USED, "");
                return this.error.getLocalizedMessage(Locale.getDefault());
            }
            return null;
        }
        if (map instanceof FlowMapSet) {
            if (!((FlowMapSet)map).isValid()) {
                this.error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.DATA_TYPE_NOT_MATCH, "");
                return this.error.getLocalizedMessage(Locale.getDefault());
            }
            if (this.isValidAssignedField(((FlowMapSet)map).getField())) {
                this.error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.PATH_USED, "");
                return this.error.getLocalizedMessage(Locale.getDefault());
            }
            return null;
        }
        return null;
    }

    public boolean isValidAssignedField(String to) {
        MapWmPathInfo toPath = MapWmPathInfo.create(to);
        return this.isValidAssignedField(this.getAllAssignedFields(), toPath);
    }

    public boolean isValidCopy(String from, String to, boolean condition) {
        boolean isValidAssignedField;
        MapWmPathInfo toPath;
        MapWmPathInfo fromPath = MapWmPathInfo.create(from);
        String validCopy = FlowMapCopy.getValidation(fromPath, toPath = MapWmPathInfo.create(to));
        if (validCopy != null) {
            JournalLogger.logDebugPlus(5, 1, 50, validCopy);
            return false;
        }
        if (!condition && !(isValidAssignedField = this.isValidAssignedField(this.getAllAssignedFields(), toPath))) {
            JournalLogger.logDebugPlus(5, 2, 50, String.valueOf(isValidAssignedField));
            return false;
        }
        boolean hasValidCommonParents = this.hasValidCommonParents(fromPath, toPath);
        if (!hasValidCommonParents) {
            JournalLogger.logDebugPlus(5, 3, 50, String.valueOf(hasValidCommonParents));
        }
        return hasValidCommonParents;
    }

    boolean isValidInvoke(FlowMapInvoke mapInvoke) {
        return true;
    }

    public String validateCopy(String from, String to, boolean condition) {
        boolean isValidAssignedField;
        MapWmPathInfo toPath;
        MapWmPathInfo fromPath = MapWmPathInfo.create(from);
        String validCopy = FlowMapCopy.getValidation(fromPath, toPath = MapWmPathInfo.create(to));
        if (validCopy != null) {
            return validCopy;
        }
        if (!condition && !(isValidAssignedField = this.isValidAssignedField(this.getAllAssignedFields(), toPath))) {
            this.error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.CANT_COPY_PATH, "", toPath.getPathID());
            return this.error.getLocalizedMessage(Locale.getDefault());
        }
        boolean hasValidCommonParents = this.hasValidCommonParents(fromPath, toPath);
        if (!hasValidCommonParents) {
            this.error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.BAD_COPY, "", toPath.getPathID());
            return this.error.getLocalizedMessage(Locale.getDefault());
        }
        return null;
    }

    public void validate() {
        MapWmPathInfo[] fields = this.getAllAssignedFields();
        if (fields == null) {
            return;
        }
        int numFields = fields.length;
        if (numFields == 0) {
            return;
        }
        block0: for (int i = numFields - 1; i > 0; --i) {
            if (fields[i] == null) continue;
            for (int j = 0; j < i; ++j) {
                if (fields[j] == null || !this.isOverlap(fields[i], fields[j])) continue;
                System.out.println("Invalid assigned field: " + fields[i].getPathID() + " overlaps " + fields[j].getPathID());
                if (this.flowMap.getNodeCount() <= i) continue block0;
                Enumeration e = this.assignedFields.keys();
                while (e.hasMoreElements()) {
                    FlowElement key = (FlowElement)e.nextElement();
                    MapWmPathInfo value = (MapWmPathInfo)this.assignedFields.get(key);
                    if (!fields[i].equals(value)) continue;
                    System.out.println(" Rejecting: " + key);
                    this.flowMap.deleteNode(key);
                }
                System.out.println(" Rejecting: " + this.flowMap.getNodeAt(i));
                continue block0;
            }
        }
        FlowElement[] nodes = this.flowMap.getNodes();
        for (int i = nodes.length - 1; i > 0; --i) {
            if (nodes[i] instanceof FlowMapCopy) {
                FlowMapCopy copy = (FlowMapCopy)nodes[i];
                this.flowMap.deleteNodeAt(i);
                if (!copy.isValid() || !this.hasValidCommonParents(copy.getParsedFrom(), copy.getParsedTo())) {
                    System.err.println("Rejecting: " + nodes[i] + "  from=" + copy.getMapFrom() + "  to=" + copy.getMapTo());
                    continue;
                }
                this.flowMap.insertNodeAt(copy, i);
                continue;
            }
            if (!(nodes[i] instanceof FlowMapSet) || ((FlowMapSet)nodes[i]).isValid()) continue;
            System.err.println("Rejecting: " + nodes[i] + " field=" + ((FlowMapSet)nodes[i]).getField());
            this.flowMap.deleteNodeAt(i);
        }
    }

    boolean hasValidCommonParents(MapWmPathInfo newFrom, MapWmPathInfo newTo) {
        FlowElement[] nodes = this.flowMap.getNodes();
        if (nodes == null || nodes.length == 0) {
            return true;
        }
        int[] toDims = newTo.getNodeDimInfo();
        int fromPathDim = newFrom.getNodePathDimension();
        int[] commonDims = this.getCommonDims(toDims, fromPathDim);
        WmPathItem[] newToInfo = newTo.getPathItems();
        boolean valid = true;
        block0: for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FlowMapCopy)) continue;
            FlowMapCopy copy = (FlowMapCopy)nodes[i];
            MapWmPathInfo oldTo = copy.getParsedTo();
            MapWmPathInfo oldFrom = copy.getParsedFrom();
            WmPathItem[] oldToInfo = oldTo.getPathItems();
            if (newToInfo[0].getName() == null || !newToInfo[0].getName().equals(oldToInfo[0].getName()) || newToInfo[0].getPosition() != oldToInfo[0].getPosition()) continue;
            int[] oldCommonDims = this.getCommonDims(oldTo.getNodeDimInfo(), oldFrom.getNodePathDimension());
            for (int j = 0; j < commonDims.length - 1 && newToInfo[j].getName() != null && newToInfo[j].getName().equals(oldToInfo[j].getName()) && newToInfo[j].getPosition() == oldToInfo[j].getPosition(); ++j) {
                if (commonDims[j] == oldCommonDims[j]) continue;
                valid = false;
                continue block0;
            }
        }
        return valid;
    }

    private int[] getCommonDims(int[] dims, int pathDim) {
        int i;
        int[] commonDims = new int[dims.length];
        for (i = 0; i < dims.length; ++i) {
            commonDims[i] = 0;
        }
        for (i = dims.length - 1; i >= 0; --i) {
            if (pathDim >= dims[i]) {
                commonDims[i] = dims[i];
                pathDim -= dims[i];
                continue;
            }
            if (pathDim <= 0) continue;
            commonDims[i] = pathDim;
            pathDim = 0;
        }
        return commonDims;
    }

    final boolean isValidAssignedField(MapWmPathInfo[] fields, MapWmPathInfo toPath) {
        if (fields == null || fields.length == 0) {
            return true;
        }
        for (int i = 0; i < fields.length; ++i) {
            if (!this.isOverlap(toPath, fields[i])) continue;
            return false;
        }
        return true;
    }

    final boolean isOverlap(String pathA, String pathB) {
        if (pathA == null || pathA.length() == 0 || pathB == null || pathB.length() == 0) {
            return false;
        }
        MapWmPathInfo mapA = MapWmPathInfo.create(pathA);
        MapWmPathInfo mapB = MapWmPathInfo.create(pathB);
        return this.isOverlap(mapA, mapB);
    }

    final boolean isOverlap(MapWmPathInfo mapA, MapWmPathInfo mapB) {
        if (mapA == null || mapB == null) {
            return false;
        }
        WmPathItem[] mapPathA = mapA.getPathItems();
        WmPathItem[] mapPathB = mapB.getPathItems();
        if (mapPathA == null || mapPathB == null) {
            return false;
        }
        int len = Math.min(mapPathA.length, mapPathB.length);
        for (int i = 0; i < len; ++i) {
            String nameA = mapPathA[i].getName();
            String nameB = mapPathB[i].getName();
            if (nameA == null || nameB == null) {
                return false;
            }
            if (!nameA.equals(nameB)) {
                return false;
            }
            if (mapPathA[i].getPosition() != mapPathB[i].getPosition()) {
                return false;
            }
            if (mapPathA[i].getArrayIndex() != mapPathB[i].getArrayIndex()) {
                return false;
            }
            if (mapPathA[i].getArrayIndex() == -2 && !mapPathA[i].getVarArrayIndex().equals(mapPathB[i].getVarArrayIndex())) {
                return false;
            }
            if (mapPathA[i].getArrayIndex() == -1) continue;
            if (mapPathA[i].getTableIndex() != mapPathB[i].getTableIndex()) {
                return false;
            }
            if (mapPathA[i].getTableIndex() != -2 || mapPathA[i].getVarTableIndex().equals(mapPathB[i].getVarTableIndex())) continue;
            return false;
        }
        return true;
    }

    MapWmPathInfo[] getAllAssignedFields() {
        if (this.flowMap.getNodeCount() < 1) {
            return null;
        }
        if (this.assignedFields == null) {
            FlowElement[] nodes = this.flowMap.getNodes();
            for (int i = 0; i < nodes.length; ++i) {
                this.addAssignedField(nodes[i]);
            }
        }
        if (this.assignedFields.size() > 0) {
            Vector v = new Vector();
            Enumeration keys = this.assignedFields.keys();
            while (keys.hasMoreElements()) {
                Object node = keys.nextElement();
                if (node instanceof FlowMapCopy && ((FlowMapCopy)node).getCondition() != null) continue;
                v.addElement(this.assignedFields.get(node));
            }
            if (v.size() == 0) {
                return null;
            }
            Object[] fields = new MapWmPathInfo[v.size()];
            v.copyInto(fields);
            return fields;
        }
        return null;
    }

    void addAssignedField(FlowElement node) {
        if (node == null) {
            return;
        }
        if (this.assignedFields == null) {
            this.assignedFields = new Hashtable();
        }
        if (node instanceof FlowMapCopy) {
            this.assignedFields.put(node, ((FlowMapCopy)node).getParsedTo());
        } else if (node instanceof FlowMapDelete) {
            this.assignedFields.put(node, ((FlowMapDelete)node).getParsedPath());
        } else if (node instanceof FlowMapSet) {
            this.assignedFields.put(node, ((FlowMapSet)node).getParsedPath());
        }
    }

    void deleteAssignedField(FlowElement node) {
        if (this.assignedFields == null || node == null) {
            return;
        }
        this.assignedFields.remove(node);
    }

    FlowMapInvoke[] getInvalidTransformers() {
        Object[] invokes = this.getInvokeMaps();
        if (invokes == null || invokes.length == 0) {
            return null;
        }
        Vector<FlowMapInvoke> invalids = new Vector<FlowMapInvoke>();
        for (int i = 0; i < invokes.length; ++i) {
            if (invokes[i].hasValidInputMap()) continue;
            invalids.addElement(invokes[i]);
        }
        if (invalids.size() == 0) {
            return null;
        }
        invokes = new FlowMapInvoke[invalids.size()];
        invalids.copyInto(invokes);
        return invokes;
    }
}

