/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.util.Table;
import com.wm.util.Values;
import com.wm.util.pluggable.WmIDataList;
import java.lang.reflect.Array;

public class MapUtil {
    public static Object cloneData(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String[][]) {
            String[][] table = (String[][])data;
            if (table.length == 0) {
                String[][] clone = new String[0][0];
                return clone;
            }
            String[][] clone = new String[table.length][];
            for (int i = 0; i < table.length; ++i) {
                clone[i] = new String[table[i].length];
                for (int j = 0; j < table[i].length; ++j) {
                    clone[i][j] = table[i][j];
                }
            }
            return clone;
        }
        if (data instanceof String[]) {
            String[] list = (String[])data;
            String[] clone = new String[list.length];
            for (int i = 0; i < list.length; ++i) {
                clone[i] = list[i];
            }
            return clone;
        }
        if (data instanceof String) {
            return data;
        }
        if (data instanceof Values) {
            Values values = (Values)data;
            String[] keys = values.getValueKeys();
            if (keys == null || keys.length == 0) {
                return values.clone();
            }
            int i = values.size();
            Values clone = new Values(i + (i + 1 >> 1));
            for (i = 0; i < keys.length; ++i) {
                clone.put(keys[i], MapUtil.cloneData(values.get(keys[i])));
            }
            return clone;
        }
        if (data instanceof WmIDataList) {
            return MapUtil.cloneData(((WmIDataList)data).getItems());
        }
        if (data instanceof IData) {
            return IDataUtil.clone((IData)data);
        }
        if (data instanceof Object[]) {
            Object[] list = (Object[])data;
            Object[] clone = null;
            try {
                clone = (Object[])Array.newInstance(data.getClass().getComponentType(), list.length);
            }
            catch (Exception e) {
                clone = new Object[list.length];
            }
            for (int i = 0; i < clone.length; ++i) {
                clone[i] = MapUtil.cloneData(list[i]);
            }
            return clone;
        }
        return data;
    }

    public static IData cloneIDataObject(IData data) {
        IData clone = IDataUtil.clone(data);
        IDataCursor cursor = clone.getCursor();
        while (cursor.next()) {
            Object value = cursor.getValue();
            if (value instanceof IData) {
                cursor.setValue(MapUtil.cloneIDataObject((IData)value));
                continue;
            }
            if (!(value instanceof Object[])) continue;
            Object[] old = (Object[])value;
            Object[] obj = null;
            try {
                obj = (Object[])Array.newInstance(value.getClass().getComponentType(), old.length);
            }
            catch (Exception e) {
                obj = new Object[old.length];
            }
            boolean isCloned = false;
            for (int i = 0; i < old.length; ++i) {
                if (old[i] instanceof IData) {
                    obj[i] = MapUtil.cloneIDataObject((IData)old[i]);
                    isCloned = true;
                    continue;
                }
                obj[i] = old[i];
            }
            if (!isCloned) continue;
            cursor.setValue(obj);
        }
        cursor.destroy();
        return clone;
    }

    public static int getType(Object o) {
        if (o instanceof String || o instanceof String[] || o instanceof String[][]) {
            return 1;
        }
        if (o instanceof IData || o instanceof IData[] || o instanceof WmIDataList) {
            return 2;
        }
        return 3;
    }

    public static Values cloneValuesObject(Values data) {
        int i = data.size();
        Values clone = new Values(i + (i + 1 >> 1));
        String[] keys = data.getValueKeys();
        if (keys == null || keys.length == 0) {
            return clone;
        }
        for (i = 0; i < keys.length; ++i) {
            Object obj = data.get(keys[i]);
            if (obj instanceof Values) {
                clone.put(keys[i], MapUtil.cloneValuesObject((Values)obj));
                continue;
            }
            if (obj instanceof Values[] || obj instanceof Table) {
                Values[] list = obj instanceof Values[] ? (Values[])obj : ((Table)obj).getValues();
                Values[] listClone = new Values[list.length];
                for (int j = 0; j < list.length; ++j) {
                    listClone[j] = MapUtil.cloneValuesObject(list[j]);
                }
                clone.put(keys[i], listClone);
                continue;
            }
            clone.put(keys[i], obj);
        }
        return clone;
    }
}

