/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.flow.MapError;
import com.wm.lang.flow.MapFlatData;
import com.wm.lang.flow.MapPathProcessorFactory;
import com.wm.lang.flow.MapPathProcessorIf;
import com.wm.lang.flow.MapUtil;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.MapWmPathUtil;
import com.wm.lang.ns.WmPathItem;
import java.util.Vector;

public class MapSet {
    private static final boolean debug = false;
    Object data;
    boolean variables;
    boolean overwrite;
    int dataType;
    int dataDim;
    MapWmPathInfo mapPath;
    MapPathProcessorIf pathProcessor;
    String targetName;
    int targetType;
    int targetDim;

    public MapSet(Object data, boolean variables, boolean overwrite, MapWmPathInfo mapPath) {
        this.mapPath = mapPath;
        this.variables = variables;
        this.overwrite = overwrite;
        this.data = mapPath.convertData(data);
        this.targetName = mapPath.getDataName();
        this.targetType = mapPath.getDataType();
        this.targetDim = mapPath.getDataDimension();
        mapPath.setBestEffort(true);
        this.pathProcessor = MapPathProcessorFactory.create(mapPath);
        this.init();
    }

    private void init() {
        if (this.data != null) {
            if (this.data instanceof String) {
                this.dataType = 1;
                this.dataDim = 0;
            } else if (this.data instanceof String[]) {
                this.dataType = 1;
                this.dataDim = 1;
            } else if (this.data instanceof String[][]) {
                this.dataType = 1;
                this.dataDim = 2;
            } else if (this.data instanceof IData) {
                this.dataType = 2;
                this.dataDim = 0;
            } else if (this.data instanceof IData[]) {
                this.dataType = 2;
                this.dataDim = 1;
            } else if (this.data instanceof Object[]) {
                this.dataType = 3;
                this.dataDim = 1;
            } else {
                this.dataType = 3;
                this.dataDim = 0;
            }
        }
    }

    public void set(IData pipeline, IData source) throws Exception {
        RunTimeMapSet rt = new RunTimeMapSet();
        rt.set(pipeline, source);
        rt = null;
    }

    public static String substituteVars(Object[] list, IData pipeline) {
        StringBuffer sb = new StringBuffer();
        int length = list.length / 2 * 2;
        for (int i = 0; i < length; i += 2) {
            sb.append((String)list[i]);
            MapWmPathInfo pathInfo = (MapWmPathInfo)list[i + 1];
            Object ob = IDataWmPathProcessor.getNode(pipeline, pathInfo.getPathItems());
            if (ob instanceof String) {
                sb.append((String)ob);
                continue;
            }
            sb.append("%" + pathInfo.path + "%");
        }
        if (list.length / 2 * 2 != list.length) {
            sb.append((String)list[list.length - 1]);
        }
        return sb.toString();
    }

    public static String[] parseVars(String str) {
        if (str == null || str.indexOf(37) < 0 && str.indexOf(65285) < 0) {
            return null;
        }
        Vector<String> tokens = new Vector<String>();
        int index = 0;
        int last = 0;
        int flag = 0;
        do {
            int end;
            int begin = -1;
            while (begin < 0) {
                int double_percent;
                int single_percent = str.indexOf(37, index);
                if (single_percent < (double_percent = str.indexOf(65285, index)) && single_percent != -1 || double_percent == -1) {
                    begin = single_percent;
                } else if (double_percent < single_percent && double_percent != -1 || single_percent == -1) {
                    begin = double_percent;
                }
                if (begin < 0) break;
                if (begin + 1 >= str.length() || str.charAt(begin + 1) != '%' && str.charAt(begin + 1) != '\uff05') continue;
                index = begin + 2;
                begin = -1;
            }
            if (begin < 0) break;
            if (begin + 1 < str.length()) {
                end = -1;
                index = begin + 1;
                while (end < 0 && ((end = str.indexOf(37, index)) >= 0 || (end = str.indexOf(65285, index)) >= 0)) {
                }
                if (end < 0) break;
                if (begin == last) {
                    tokens.addElement(new String());
                } else {
                    tokens.addElement(str.substring(last, begin));
                }
            } else {
                last = str.length();
                break;
            }
            tokens.addElement(str.substring(begin + 1, end));
            last = index = end + 1;
            flag = index;
        } while (index < str.length());
        if (last < str.length() && tokens.size() > 1) {
            tokens.addElement(str.substring(last));
        }
        if (last == str.length() && tokens.size() > 1) {
            tokens.addElement(str.substring(flag, last));
        }
        if (tokens.size() < 2) {
            return null;
        }
        Object[] tokenArray = new String[tokens.size()];
        tokens.copyInto(tokenArray);
        return tokenArray;
    }

    public static Object[] processPath(String[] list) {
        if (list == null || list.length < 1) {
            return null;
        }
        Object[] result = new Object[list.length];
        int length = list.length / 2 * 2;
        for (int i = 0; i < length; i += 2) {
            result[i] = list[i];
            result[i + 1] = MapWmPathInfo.create(list[i + 1]);
        }
        if (list.length / 2 * 2 != list.length) {
            result[result.length - 1] = list[list.length - 1];
        }
        return result;
    }

    class RunTimeMapSet {
        Object clonedData;
        Object[] subList;

        public RunTimeMapSet() {
            this.clonedData = MapUtil.cloneData(MapSet.this.data);
            if (!MapSet.this.variables || MapSet.this.data == null) {
                return;
            }
            if (MapSet.this.data instanceof String) {
                String[] find = MapSet.parseVars((String)this.clonedData);
                this.subList = MapSet.processPath(find);
                return;
            }
            Vector vars = new Vector();
            if (this.clonedData instanceof String[]) {
                this.seekVariables(vars, (String[])this.clonedData);
            } else if (this.clonedData instanceof String[][]) {
                this.seekVariables(vars, (String[][])this.clonedData);
            } else if (this.clonedData instanceof IData) {
                this.seekVariables(vars, (IData)this.clonedData);
            } else if (this.clonedData instanceof IData[]) {
                this.seekVariables(vars, (IData[])this.clonedData);
            }
            if (vars.size() > 0) {
                this.subList = new Object[vars.size()];
                vars.copyInto(this.subList);
            }
        }

        void substitute(IData pipeline) {
            if (this.subList == null || this.subList.length < 1) {
                return;
            }
            if (MapSet.this.data instanceof String) {
                String strClonedData;
                this.clonedData = MapSet.substituteVars(this.subList, pipeline);
                if (this.clonedData != null && this.clonedData instanceof String && (strClonedData = (String)this.clonedData).startsWith("%") && strClonedData.endsWith("%") && (((String)MapSet.this.data).startsWith("\uff05") || ((String)MapSet.this.data).endsWith("\uff05"))) {
                    this.clonedData = MapSet.this.data;
                }
            } else if (MapSet.this.data instanceof String[] || MapSet.this.data instanceof String[][] || MapSet.this.data instanceof IData || MapSet.this.data instanceof IData[]) {
                for (int i = 0; i < this.subList.length; ++i) {
                    Object[] vars = (Object[])this.subList[i];
                    Object parent = vars[0];
                    Object[] list = (Object[])vars[2];
                    if (parent instanceof String[]) {
                        String[] array = (String[])parent;
                        array[((Integer)vars[1]).intValue()] = MapSet.substituteVars(list, pipeline);
                        continue;
                    }
                    if (!(parent instanceof IData)) continue;
                    IDataWmPathProcessor.put((IData)parent, MapSet.substituteVars(list, pipeline), (WmPathItem)vars[1], pipeline);
                }
            }
        }

        public void set(IData pipeline, IData source) throws Exception {
            if (MapSet.this.mapPath == null || MapSet.this.data == null) {
                return;
            }
            MapError mapError = MapError.create(pipeline);
            if (MapSet.this.variables) {
                this.substitute(source);
            }
            if (MapSet.this.mapPath.getPathCharacter() == 1) {
                MapWmPathUtil.setData(pipeline, MapUtil.cloneData(this.clonedData), MapSet.this.dataDim, MapSet.this.mapPath.getDataProcessor(), MapSet.this.overwrite, mapError, source);
            } else if (MapSet.this.mapPath.getPathCharacter() == 2) {
                MapFlatData pathContainer = MapSet.this.pathProcessor.createPathContainer(pipeline, null, source);
                IData[] parents = (IData[])pathContainer.getData();
                MapWmPathUtil.setData(parents[0], MapUtil.cloneData(this.clonedData), MapSet.this.dataDim, MapSet.this.mapPath.getDataProcessor(), MapSet.this.overwrite, mapError, source);
            } else if (MapSet.this.mapPath.getDataDimension() == MapSet.this.dataDim) {
                int[] sourceSize = new int[MapSet.this.mapPath.getPathDepth()];
                for (int i = 0; i < sourceSize.length; ++i) {
                    sourceSize[i] = 1;
                }
                MapFlatData pathContainer = MapSet.this.pathProcessor.createPathContainer(pipeline, sourceSize, source);
                IData[] targetValues = (IData[])pathContainer.getData();
                Object[] obj = new Object[]{MapUtil.cloneData(this.clonedData)};
                MapWmPathUtil.setData(targetValues, MapSet.this.mapPath.getDataProcessor(), obj, MapSet.this.overwrite, mapError, source);
            } else if (MapSet.this.mapPath.getPathCharacter() == 0) {
                throw new RuntimeException("Data doesn't have the same type or dimension.");
            }
        }

        void seekVariables(Vector varList, String[] list) {
            if (list.length < 1) {
                return;
            }
            for (int i = 0; i < list.length; ++i) {
                String[] find = MapSet.parseVars(list[i]);
                if (find == null) continue;
                Object[] vars = new Object[]{list, new Integer(i), MapSet.processPath(find)};
                varList.addElement(vars);
            }
        }

        void seekVariables(Vector varList, String[][] table) {
            if (table.length < 1) {
                return;
            }
            for (int i = 0; i < table.length; ++i) {
                this.seekVariables(varList, table[i]);
            }
        }

        void seekVariables(Vector varList, IData value) {
            IDataCursor cursor = value.getCursor();
            int index = 0;
            while (cursor.next()) {
                Object data = cursor.getValue();
                if (data instanceof String) {
                    String[] find = MapSet.parseVars((String)data);
                    if (find != null) {
                        Object[] vars = new Object[3];
                        vars[0] = value;
                        vars[1] = new WmPathItem(cursor.getKey(), null, index, -1, -1, 1, 0);
                        ((WmPathItem)vars[1]).setPathType(1);
                        vars[2] = MapSet.processPath(find);
                        varList.addElement(vars);
                    }
                } else if (data instanceof String[]) {
                    this.seekVariables(varList, (String[])data);
                } else if (data instanceof String[][]) {
                    this.seekVariables(varList, (String[][])data);
                } else if (data instanceof IData) {
                    this.seekVariables(varList, (IData)data);
                } else if (data instanceof IData[]) {
                    this.seekVariables(varList, (IData[])data);
                }
                ++index;
            }
            cursor.destroy();
        }

        void seekVariables(Vector varList, IData[] data) {
            if (data.length < 1) {
                return;
            }
            for (int i = 0; i < data.length; ++i) {
                this.seekVariables(varList, data[i]);
            }
        }
    }
}

