/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.flow.MapFlatData;
import com.wm.lang.flow.MapPathProcessorFactory;
import com.wm.lang.flow.MapPathProcessorIf;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.ns.WmPathItem;

public class MapDelete {
    MapWmPathInfo mapPath;
    MapPathProcessorIf pathProcessor;

    public MapDelete(MapWmPathInfo pathInfo) {
        this.mapPath = pathInfo;
        this.mapPath.setBestEffort(true);
        this.pathProcessor = MapPathProcessorFactory.create(pathInfo);
    }

    public void markDelete(IData pipeline) {
        if (this.mapPath == null) {
            return;
        }
        if (this.mapPath.getPathCharacter() == 1) {
            IDataWmPathProcessor.markDelete(pipeline, this.mapPath.getDataPathItem());
            return;
        }
        if (this.mapPath.getPathCharacter() == 2) {
            MapFlatData pathContainer = this.pathProcessor.getPathContainer(pipeline, pipeline);
            if (pathContainer != null) {
                Object[] containers = pathContainer.getData();
                IDataWmPathProcessor.markDelete((IData)containers[0], this.mapPath.getDataPathItem());
            }
            return;
        }
        if (this.mapPath.getPathCharacter() == 0) {
            MapFlatData pathContainer = this.pathProcessor.getPathContainer(pipeline, pipeline);
            if (pathContainer != null) {
                Object[] containers = pathContainer.getData();
                WmPathItem pathItem = this.mapPath.getDataPathItem();
                for (int i = 0; i < containers.length; ++i) {
                    IDataWmPathProcessor.markDelete((IData)containers[i], pathItem);
                }
            }
            return;
        }
    }

    public void deleteMarker(IData pipeline) {
        if (this.mapPath == null) {
            return;
        }
        if (this.mapPath.getPathCharacter() == 1) {
            IDataWmPathProcessor.deleteMarker(pipeline, this.mapPath.getDataPathItem());
            return;
        }
        if (this.mapPath.getPathCharacter() == 2) {
            MapFlatData pathContainer = this.pathProcessor.getPathContainer(pipeline, pipeline);
            if (pathContainer != null) {
                Object[] containers = pathContainer.getData();
                IDataWmPathProcessor.deleteMarker((IData)containers[0], this.mapPath.getDataPathItem());
            }
            return;
        }
        if (this.mapPath.getPathCharacter() == 0) {
            MapFlatData pathContainer = this.pathProcessor.getPathContainer(pipeline, pipeline);
            if (pathContainer != null) {
                Object[] containers = pathContainer.getData();
                WmPathItem pathItem = this.mapPath.getDataPathItem();
                for (int i = 0; i < containers.length; ++i) {
                    IDataWmPathProcessor.deleteMarker((IData)containers[i], pathItem);
                }
            }
            return;
        }
    }
}

