/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.MapCopyIf;
import com.wm.lang.flow.MapError;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.MapWmPathUtil;
import com.wm.lang.flow.TableUtil;
import com.wm.lang.flow.WmPathItemProcessor;
import com.wm.util.JournalLogger;
import com.wm.util.pluggable.WmIDataList;

public class MapCopySingle
implements MapCopyIf {
    MapWmPathInfo fromPath;
    MapWmPathInfo toPath;

    public MapCopySingle(MapWmPathInfo fromPath, MapWmPathInfo toPath) {
        this.fromPath = fromPath;
        this.toPath = toPath;
    }

    public void copy(IData original, IData cloned) throws Exception {
        MapError mapError = MapError.create(original);
        WmIDataList[] findTable = TableUtil.findTable(cloned, this.toPath.getPathItems(), cloned);
        WmPathItemProcessor sProc = this.fromPath.getDataProcessor();
        boolean isExisted = sProc.find(cloned);
        if (!isExisted) {
            if (JournalLogger.isLogEnabledDebugPlus(2, 19, 50)) {
                Object[] o = new Object[]{this.toPath.getPathDisplayString(), this.fromPath.getPathDisplayString()};
                JournalLogger.logDebugPlus(2, 19, 50, o);
                if (mapError != null) {
                    mapError.logError("Copy", "(Single) No source data available at" + this.fromPath.getPathID());
                }
            }
            return;
        }
        IData tempData = IDataFactory.create();
        IDataUtil.merge(cloned, tempData);
        IDataUtil.merge(original, tempData);
        Object sourceData = sProc.get(cloned, tempData);
        MapWmPathUtil.setData(original, sourceData, this.fromPath.getDataDimension(), this.toPath.getDataProcessor(), true, mapError, tempData);
        if (findTable != null && findTable.length > 0) {
            TableUtil.recoverTable(original, this.toPath.getPathItems(), findTable, tempData);
        }
    }
}

