/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.MapCopyIf;
import com.wm.lang.flow.MapError;
import com.wm.lang.flow.MapFlatData;
import com.wm.lang.flow.MapPathProcessorFactory;
import com.wm.lang.flow.MapPathProcessorIf;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.MapWmPathUtil;
import com.wm.lang.flow.TableUtil;
import com.wm.lang.flow.WmPathItemProcessor;
import com.wm.util.JournalLogger;
import com.wm.util.pluggable.WmIDataList;

public class MapCopySimple
implements MapCopyIf {
    MapWmPathInfo fromPath;
    MapWmPathInfo toPath;
    MapPathProcessorIf fromProcessor;
    MapPathProcessorIf toProcessor;

    public MapCopySimple(MapWmPathInfo fromPath, MapWmPathInfo toPath) {
        this.fromPath = fromPath;
        this.toPath = toPath;
        toPath.setBestEffort(false);
        this.fromProcessor = MapPathProcessorFactory.create(fromPath);
        this.toProcessor = MapPathProcessorFactory.create(toPath);
    }

    public void copy(IData original, IData cloned) throws Exception {
        MapError mapError = MapError.create(original);
        WmIDataList[] findTable = TableUtil.findTable(cloned, this.toPath.getPathItems(), cloned);
        MapFlatData pathContainer = this.fromProcessor.getPathContainer(cloned, cloned);
        IData sourceValues = null;
        if (pathContainer != null) {
            Object[] data = pathContainer.getData();
            sourceValues = (IData)data[0];
        }
        WmPathItemProcessor sProc = this.fromPath.getDataProcessor();
        boolean isExisted = false;
        if (sourceValues != null) {
            isExisted = sProc.find(sourceValues);
        }
        if (!isExisted) {
            if (JournalLogger.isLogEnabledDebugPlus(2, 19, 50)) {
                Object[] o = new Object[]{this.toPath.getPathDisplayString(), this.fromPath.getPathDisplayString()};
                JournalLogger.logDebugPlus(2, 19, 50, o);
                if (mapError != null) {
                    mapError.logError("Copy", "(Simple) No source data available at" + this.fromPath.getPathID());
                }
            }
            return;
        }
        IData tempData = IDataFactory.create();
        IDataUtil.merge(cloned, tempData);
        IDataUtil.merge(original, tempData);
        Object sourceData = sProc.get(sourceValues, tempData);
        pathContainer = this.toProcessor.createPathContainer(original, null, tempData);
        IData targetValues = (IData)pathContainer.getData()[0];
        MapWmPathUtil.setData(targetValues, sourceData, this.fromPath.getDataDimension(), this.toPath.getDataProcessor(), true, mapError, tempData);
        if (findTable != null && findTable.length > 0) {
            TableUtil.recoverTable(original, this.toPath.getPathItems(), findTable, tempData);
        }
    }
}

