/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.lang.flow.MapCopy;
import com.wm.lang.flow.MapError;
import com.wm.lang.flow.MapFlatData;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.MapWmPathUtil;
import com.wm.lang.flow.TableUtil;
import com.wm.util.JournalLogger;
import com.wm.util.pluggable.WmIDataList;

public class MapCopySameData
extends MapCopy {
    int toDepth;

    public MapCopySameData(MapWmPathInfo fromPath, MapWmPathInfo toPath) {
        super(fromPath, toPath);
        this.toDepth = toPath.getPathDepth();
    }

    public void copy(IData original, IData cloned) {
        MapError mapError = MapError.create(original);
        WmIDataList[] findTable = TableUtil.findTable(cloned, this.toPath.getPathItems(), cloned);
        MapFlatData pathContainer = this.fromProcessor.getPathContainer(cloned, cloned);
        if (pathContainer == null) {
            if (JournalLogger.isLogEnabled(19, 50, 6)) {
                Object[] o = new Object[]{this.toPath.getPathDisplayString(), this.fromPath.getPathDisplayString()};
                JournalLogger.log(19, 50, 6, o);
                if (mapError != null) {
                    mapError.logError("Copy", "(SDT-1) No source data available at" + this.fromPath.getPathID());
                }
            }
            return;
        }
        IData[] source = (IData[])pathContainer.getData();
        int[] sourceSize = pathContainer.getSizes();
        int[] expectedSize = new int[this.commonPath.length];
        int depthDiff = this.fromPath.getPathDepth() - sourceSize.length;
        for (int i = 0; i < this.toDepth; ++i) {
            expectedSize[i] = this.commonPath[i] != -1 ? sourceSize[this.commonPath[i] - depthDiff] : 1;
        }
        pathContainer = this.toProcessor.createPathContainer(original, expectedSize, cloned);
        if (pathContainer == null) {
            if (JournalLogger.isLogEnabled(20, 50, 6)) {
                Object[] o = new Object[]{this.toPath.getPathDisplayString(), this.fromPath.getPathDisplayString()};
                JournalLogger.log(20, 50, 6, o);
                if (mapError != null) {
                    mapError.logError("Copy", "(SDT) Cannot create target data at" + this.toPath.getPathID());
                }
            }
            return;
        }
        IData[] target = (IData[])pathContainer.getData();
        int[] targetSize = pathContainer.getSizes();
        MapWmPathUtil.setData(target, this.toPath.getDataProcessor(), source, this.fromPath.getDataProcessor(), true, mapError, cloned);
        if (findTable != null && findTable.length > 0) {
            TableUtil.recoverTable(original, this.toPath.getPathItems(), findTable, cloned);
        }
    }
}

