/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.flow.MapCopyIf;
import com.wm.lang.flow.MapError;
import com.wm.lang.flow.MapFlatData;
import com.wm.lang.flow.MapPathProcessorFactory;
import com.wm.lang.flow.MapPathProcessorIf;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.MapWmPathUtil;
import com.wm.lang.flow.TableUtil;
import com.wm.lang.ns.WmPathItem;
import com.wm.util.JournalLogger;
import com.wm.util.pluggable.WmIDataList;

public class MapCopy
implements MapCopyIf {
    MapWmPathInfo fromPath;
    MapWmPathInfo toPath;
    MapPathProcessorIf fromProcessor;
    MapPathProcessorIf toProcessor;
    int[] commonPath;

    public MapCopy(MapWmPathInfo fromPath, MapWmPathInfo toPath) {
        this.fromPath = fromPath;
        this.toPath = toPath;
        toPath.setBestEffort(false);
        this.fromProcessor = MapPathProcessorFactory.create(fromPath);
        this.toProcessor = MapPathProcessorFactory.create(toPath);
        int len = toPath.getPathDepth();
        if (toPath.getDataDimension() == 2) {
            ++len;
        }
        this.commonPath = new int[len];
        for (int i = 0; i < this.commonPath.length; ++i) {
            this.commonPath[i] = -1;
        }
        int sum = Math.min(fromPath.getPathDimension(), toPath.getPathDimension());
        if (sum < 1) {
            return;
        }
        for (int i = 1; i <= sum; ++i) {
            int j = toPath.getIndexForDimension(i);
            int k = fromPath.getIndexForDimension(i);
            if (j == -1 || k == -1) continue;
            this.commonPath[j] = k;
        }
    }

    public void copy(IData original, IData cloned) throws Exception {
        MapError mapError = MapError.create(original);
        WmIDataList[] findTable = TableUtil.findTable(cloned, this.toPath.getPathItems(), cloned);
        MapFlatData sourceObject = this.fromProcessor.getDataObject(cloned, cloned);
        if (sourceObject == null) {
            if (JournalLogger.isLogEnabled(19, 50, 6)) {
                Object[] o = new Object[]{this.toPath.getPathDisplayString(), this.fromPath.getPathDisplayString()};
                JournalLogger.log(19, 50, 6, o);
                if (mapError != null) {
                    mapError.logError("Copy", "(GC) No source data available at " + this.fromPath.getPathID());
                }
            }
            return;
        }
        Object[] sourceData = sourceObject.getData();
        int[] sourceSize = sourceObject.getSizes();
        int[] expectedSize = new int[this.commonPath.length];
        int depthDiff = this.fromPath.getPathDepth() - sourceSize.length;
        for (int i = 0; i < expectedSize.length; ++i) {
            expectedSize[i] = this.commonPath[i] != -1 ? sourceSize[this.commonPath[i] - depthDiff] : 1;
        }
        MapFlatData pathContainer = this.toProcessor.createPathContainer(original, expectedSize, cloned);
        if (pathContainer == null) {
            if (JournalLogger.isLogEnabled(20, 50, 6)) {
                Object[] o = new Object[]{this.toPath.getPathDisplayString(), this.fromPath.getPathDisplayString()};
                JournalLogger.log(20, 50, 6, o);
                if (mapError != null) {
                    mapError.logError("Copy", "(GC-1) Cannot create target data at" + this.toPath.getPathID());
                }
            }
            return;
        }
        int[] dataSize = null;
        if (this.toPath.getDataDimension() == 1) {
            dataSize = new int[]{expectedSize[expectedSize.length - 1]};
        } else if (this.toPath.getDataDimension() == 2) {
            dataSize = new int[]{expectedSize[expectedSize.length - 2], expectedSize[expectedSize.length - 1]};
        }
        MapFlatData dataContainer = this.toProcessor.createDataContainer(pathContainer, dataSize, cloned);
        if (dataContainer == null) {
            if (JournalLogger.isLogEnabled(20, 50, 6)) {
                Object[] o = new Object[]{this.toPath.getPathDisplayString(), this.fromPath.getPathDisplayString()};
                JournalLogger.log(20, 50, 6, o);
                if (mapError != null) {
                    mapError.logError("Copy", "(GC-2) Cannot create target data at" + this.toPath.getPathID());
                }
            }
            return;
        }
        Object[] targetParent = dataContainer.getData();
        if (targetParent instanceof IData[]) {
            MapWmPathUtil.setData((IData[])targetParent, this.toPath.getDataProcessor(), sourceData, true, mapError, cloned);
        } else {
            MapWmPathUtil.setData(targetParent, sourceData, true, mapError);
        }
        if (findTable != null && findTable.length > 0) {
            TableUtil.recoverTable(original, this.toPath.getPathItems(), findTable, cloned);
        }
        if (this.toPath.getClassName() != null) {
            this.classNameSupport(original, mapError);
        }
    }

    private void classNameSupport(IData pipeline, MapError mapError) {
        MapFlatData pathContainer = this.toProcessor.getPathContainer(pipeline, pipeline);
        if (pathContainer == null) {
            if (JournalLogger.isLogEnabled(21, 50, 6)) {
                Object[] o = new Object[]{this.toPath.getPathDisplayString(), this.fromPath.getPathDisplayString()};
                JournalLogger.log(21, 50, 6, o);
                if (mapError != null) {
                    mapError.logError("Copy", "(GC-1) Cannot support the required class name at" + this.toPath.getPathID());
                }
            }
            return;
        }
        Object[] targetParent = pathContainer.getData();
        if (targetParent instanceof IData[]) {
            WmPathItem dataPathItem = this.toPath.getDataPathItem();
            for (int i = 0; i < targetParent.length; ++i) {
                Object data = IDataWmPathProcessor.get((IData)targetParent[i], dataPathItem, pipeline);
                if (data == null) continue;
                data = this.toPath.convertData(data);
                IDataWmPathProcessor.put((IData)targetParent[i], data, dataPathItem, pipeline);
            }
        } else if (JournalLogger.isLogEnabled(21, 50, 6)) {
            Object[] o = new Object[]{this.toPath.getPathDisplayString(), this.fromPath.getPathDisplayString()};
            JournalLogger.log(21, 50, 6, o);
            if (mapError != null) {
                mapError.logError("Copy", "(GC-1) Cannot support the required class name at" + this.toPath.getPathID());
            }
        }
    }
}

