/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowMap;
import com.wm.lang.flow.FlowMapCopy;
import com.wm.lang.flow.FlowMapDelete;
import com.wm.lang.flow.FlowMapInvoke;
import com.wm.lang.flow.FlowMapSet;
import com.wm.lang.flow.MapIf;
import com.wm.lang.flow.MapValidator;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.SuperMapCopy;
import com.wm.lang.ns.NSRecord;
import java.math.BigInteger;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MapCompiler
implements Cloneable {
    public static final int NODE_MAX = 512;
    FlowMap flowMap;
    Object[] execNodes;
    boolean clonePipeline;
    NSRecord source;
    NSRecord target;
    FlowMapDelete[] deletes;

    public MapCompiler(FlowMap map) {
        this.flowMap = map;
    }

    public boolean clonePipeline() {
        return this.clonePipeline;
    }

    public Object[] getExecNodes() {
        return this.execNodes;
    }

    public void init(NSRecord source, NSRecord target) {
        this.source = source;
        this.target = target;
        FlowElement[] nodes = this.flowMap.getNodes();
        if (nodes == null || nodes.length == 0) {
            this.execNodes = null;
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            ((MapIf)((Object)nodes[i])).init(source, target);
        }
        this.execNodes = this.reorderMaps();
        this.clonePipeline = this.checkForClone();
    }

    boolean checkForClone() {
        if (this.execNodes == null || this.execNodes.length == 0) {
            return false;
        }
        Vector<MapWmPathInfo> source = new Vector<MapWmPathInfo>();
        Vector<MapWmPathInfo> target = new Vector<MapWmPathInfo>();
        for (int i = 0; i < this.execNodes.length; ++i) {
            if (this.execNodes[i] instanceof FlowMapCopy) {
                source.addElement(((FlowMapCopy)this.execNodes[i]).getParsedFrom());
                target.addElement(((FlowMapCopy)this.execNodes[i]).getParsedTo());
                continue;
            }
            if (this.execNodes[i] instanceof FlowMapInvoke) {
                FlowMapCopy[] copys;
                FlowMap input_map = ((FlowMapInvoke)this.execNodes[i]).getInputMap();
                if (input_map == null || (copys = input_map.getCopyMaps()) == null) continue;
                int numTos = 0;
                FlowMap flowMap = ((FlowElement)this.execNodes[i]).getOutputMap();
                FlowElement[] copyTos = null;
                if (flowMap != null && (copyTos = flowMap.getNodes()) != null) {
                    numTos = copyTos.length;
                }
                String[] toStrings = new String[numTos];
                for (int k = 0; k < numTos; ++k) {
                    toStrings[k] = ((FlowMapCopy)copyTos[k]).getMapTo();
                }
                for (int j = 0; j < copys.length; ++j) {
                    boolean selfModify = false;
                    String fromString = copys[j].getMapFrom();
                    for (int k = 0; k < numTos; ++k) {
                        if (!fromString.equals(toStrings[k])) continue;
                        selfModify = true;
                        break;
                    }
                    if (selfModify) continue;
                    source.addElement(copys[j].getParsedFrom());
                }
                continue;
            }
            if (!(this.execNodes[i] instanceof SuperMapCopy)) continue;
            FlowMapCopy copy = ((SuperMapCopy)this.execNodes[i]).getMapCopy();
            target.addElement(copy.getParsedTo());
        }
        if (source.size() == 0) {
            return false;
        }
        Object[] froms = new MapWmPathInfo[source.size()];
        source.copyInto(froms);
        if (this.findPreSetMaps((MapWmPathInfo[])froms) != null) {
            return true;
        }
        if (target.size() == 0) {
            return false;
        }
        Object[] tos = new MapWmPathInfo[target.size()];
        target.copyInto(tos);
        MapValidator validator = this.flowMap.getValidator();
        for (int i = 0; i < source.size(); ++i) {
            for (int j = 0; j < tos.length; ++j) {
                if (!validator.isOverlap((MapWmPathInfo)froms[i], (MapWmPathInfo)tos[j])) continue;
                return true;
            }
        }
        return false;
    }

    FlowMapSet[] findPreSetMaps(MapWmPathInfo[] froms) {
        if (froms == null) {
            return null;
        }
        MapValidator validator = this.flowMap.getValidator();
        Object[] setMaps = validator.getSetMaps();
        if (setMaps == null) {
            return null;
        }
        Vector<Object> sets = new Vector<Object>();
        block0: for (int i = 0; i < setMaps.length; ++i) {
            MapWmPathInfo setField = setMaps[i].getParsedPath();
            for (int j = 0; j < froms.length; ++j) {
                if (setField.getPathDepth() > froms[j].getPathDepth() || !validator.isOverlap(setField, froms[j])) continue;
                sets.addElement(setMaps[i]);
                continue block0;
            }
        }
        if (sets.size() == 0) {
            return null;
        }
        setMaps = new FlowMapSet[sets.size()];
        sets.copyInto(setMaps);
        return setMaps;
    }

    Object[] reorderMaps() {
        int i;
        Hashtable<int[], FlowElement> order = new Hashtable<int[], FlowElement>();
        Vector<FlowElement> nonorder = new Vector<FlowElement>();
        Vector<FlowElement> deletes = new Vector<FlowElement>();
        FlowElement[] nodes = this.flowMap.getNodes();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            int[] pos;
            MapWmPathInfo pathInfo;
            if (nodes[i2] instanceof FlowMapCopy) {
                pathInfo = ((FlowMapCopy)nodes[i2]).getParsedTo();
                if (pathInfo == null) continue;
                pos = pathInfo.getAbsPosition();
                if (pos != null) {
                    order.put(pos, nodes[i2]);
                    continue;
                }
                nonorder.addElement(nodes[i2]);
                continue;
            }
            if (nodes[i2] instanceof FlowMapSet) {
                pathInfo = ((FlowMapSet)nodes[i2]).getParsedPath();
                if (pathInfo == null) continue;
                pos = pathInfo.getAbsPosition();
                if (pos != null) {
                    order.put(pos, nodes[i2]);
                    continue;
                }
                nonorder.addElement(nodes[i2]);
                continue;
            }
            if (nodes[i2] instanceof FlowMapDelete) {
                deletes.addElement(nodes[i2]);
                continue;
            }
            if (!(nodes[i2] instanceof FlowMapInvoke)) continue;
            this.addFieldsForInvoke(order, nonorder, (FlowMapInvoke)nodes[i2]);
        }
        Object[] execOrder = null;
        if (order.size() > 0) {
            execOrder = MapCompiler.lazySort(order);
        }
        if (execOrder != null) {
            Vector<Object> v = new Vector<Object>();
            for (int i3 = 0; i3 < execOrder.length; ++i3) {
                SuperMapCopy copy;
                if (execOrder[i3] instanceof SuperMapCopy && !(copy = (SuperMapCopy)execOrder[i3]).isFound()) {
                    v.addElement(copy.getInvokeNode());
                    copy.setFound(true);
                }
                v.addElement(execOrder[i3]);
            }
            execOrder = new Object[v.size()];
            v.copyInto(execOrder);
        }
        if (nonorder.size() > 0) {
            int len = nonorder.size();
            Vector<FlowMapInvoke> v = new Vector<FlowMapInvoke>();
            for (int i4 = 0; i4 < len; ++i4) {
                SuperMapCopy copy;
                Object o = nonorder.elementAt(i4);
                if (o instanceof SuperMapCopy && !(copy = (SuperMapCopy)o).isFound()) {
                    v.addElement(copy.getInvokeNode());
                    copy.setFound(true);
                }
                v.addElement((FlowMapInvoke)o);
            }
            nonorder = v;
        }
        int num = nonorder.size() + deletes.size();
        if (execOrder != null) {
            num += execOrder.length;
        }
        Object[] execs = new Object[num];
        int kkk = 0;
        int len = nonorder.size();
        for (i = 0; i < len; ++i) {
            execs[kkk++] = nonorder.elementAt(i);
        }
        if (execOrder != null) {
            for (i = 0; i < execOrder.length; ++i) {
                execs[kkk++] = execOrder[i];
            }
        }
        len = deletes.size();
        for (i = 0; i < deletes.size(); ++i) {
            execs[kkk++] = deletes.elementAt(i);
        }
        return execs;
    }

    void addFieldsForInvoke(Hashtable order, Vector nonorder, FlowMapInvoke invoke) {
        FlowMap map = invoke.getOutputMap();
        if (map == null) {
            nonorder.addElement(invoke);
            return;
        }
        FlowElement[] nodes = map.getNodes();
        if (nodes == null || nodes.length == 0) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FlowMapCopy)) continue;
            FlowMapCopy copy = (FlowMapCopy)nodes[i];
            copy.init(this.source, this.target);
            SuperMapCopy sup = new SuperMapCopy(invoke, copy);
            MapWmPathInfo pathInfo = ((FlowMapCopy)nodes[i]).getParsedTo();
            if (pathInfo == null) continue;
            int[] pos = pathInfo.getAbsPosition();
            if (pos != null) {
                order.put(pos, sup);
                continue;
            }
            nonorder.addElement(sup);
        }
    }

    public static Object[] lazySort(Hashtable nodes) {
        int i;
        if (nodes.size() == 0) {
            return null;
        }
        Object[] order = new Object[nodes.size()];
        if (order.length == 1) {
            Enumeration elements = nodes.elements();
            order[0] = elements.nextElement();
            return order;
        }
        Object[] pathPos = new Object[order.length];
        int node_max = 512;
        int k = 0;
        int depth = 0;
        Enumeration keys = nodes.keys();
        while (keys.hasMoreElements()) {
            int[] pos = (int[])keys.nextElement();
            if (pos != null) {
                for (int i2 = 0; i2 < pos.length; ++i2) {
                    if (pos[i2] <= node_max) continue;
                    node_max = pos[i2];
                }
            }
            pathPos[k++] = pos;
            if (pos.length <= depth) continue;
            depth = pos.length;
        }
        BigInteger[] power = new BigInteger[depth];
        BigInteger inc = BigInteger.valueOf(node_max);
        for (int i3 = 0; i3 < depth; ++i3) {
            power[i3] = inc.pow(depth - i3 - 1);
        }
        BigInteger[] index = new BigInteger[order.length];
        for (i = 0; i < pathPos.length; ++i) {
            int[] pos = (int[])pathPos[i];
            BigInteger bigInt = BigInteger.valueOf(0L);
            for (int j = 0; j < pos.length; ++j) {
                bigInt = bigInt.add(power[j].multiply(BigInteger.valueOf(pos[j] + 1)));
            }
            index[i] = bigInt;
        }
        for (i = 0; i < pathPos.length; ++i) {
            BigInteger bigInt = index[i];
            k = i;
            for (int j = i + 1; j < pathPos.length; ++j) {
                int comp = bigInt.compareTo(index[j]);
                if (comp == 1) {
                    bigInt = index[j];
                    k = j;
                    continue;
                }
                if (comp != 0) continue;
                if (nodes.get(pathPos[i]) instanceof FlowMapSet) {
                    bigInt = index[j];
                    k = j;
                    continue;
                }
                if (!(nodes.get(pathPos[i]) instanceof SuperMapCopy) || nodes.get(pathPos[j]) instanceof FlowMapSet) continue;
                bigInt = index[j];
                k = j;
            }
            index[k] = index[i];
            index[i] = bigInt;
            Object o = pathPos[k];
            pathPos[k] = pathPos[i];
            pathPos[i] = o;
        }
        for (i = 0; i < order.length; ++i) {
            order[i] = nodes.get(pathPos[i]);
        }
        return order;
    }

    FlowMapDelete[] getDeleteMaps() {
        if (this.deletes == null) {
            this.deletes = this.flowMap.getDeleteMaps();
        }
        if (this.deletes.length == 0) {
            return null;
        }
        return this.deletes;
    }

    public Object clone() {
        try {
            if (this.execNodes != null) {
                for (int i = 0; i < this.execNodes.length; ++i) {
                    if (!(this.execNodes[i] instanceof FlowMapInvoke)) continue;
                    return this.specialClone();
                }
            }
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    private Object specialClone() {
        try {
            Object[] newNodes = new Object[this.execNodes.length];
            for (int i = 0; i < this.execNodes.length; ++i) {
                Object o = this.execNodes[i];
                if (o instanceof FlowMapInvoke) {
                    newNodes[i] = ((FlowMapInvoke)o).clone();
                    ((FlowMapInvoke)newNodes[i]).donor = (FlowMapInvoke)o;
                    continue;
                }
                if (o instanceof SuperMapCopy) {
                    SuperMapCopy smc = (SuperMapCopy)o;
                    FlowMapInvoke fmi = smc.invoke;
                    smc = (SuperMapCopy)smc.clone();
                    int fmiIndex = -1;
                    int x = 0;
                    while (fmiIndex == -1) {
                        if (fmi == this.execNodes[x]) {
                            fmiIndex = x;
                        }
                        ++x;
                    }
                    smc.invoke = (FlowMapInvoke)newNodes[fmiIndex];
                    newNodes[i] = smc;
                    continue;
                }
                newNodes[i] = this.execNodes[i];
            }
            MapCompiler mc = (MapCompiler)super.clone();
            mc.execNodes = newNodes;
            return mc;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

