/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.flow.DeleteMarker;
import com.wm.lang.flow.MapSet;
import com.wm.lang.flow.MapWmPathUtil;
import com.wm.lang.flow.resources.FlowExceptionBundle;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.WmPathInfo;
import com.wm.lang.ns.WmPathItem;
import com.wm.util.JournalLogger;
import com.wm.util.LocalizedException;
import com.wm.util.pluggable.WmIDataList;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class IDataWmPathProcessor {
    private static final boolean debug = false;
    private static DeleteMarker marker;

    public static Object get(IData parent, WmPathItem pathItem, IData origPipe) {
        return IDataWmPathProcessor.get(parent, pathItem, true, origPipe);
    }

    public static Object get(IData parent, WmPathItem pathItem, boolean bestEffort, IData origPipe) {
        if (parent == null || pathItem == null) {
            return null;
        }
        Object value = null;
        if (pathItem.getPathType() == 0) {
            String name;
            IDataCursor cursor = parent.getCursor();
            if (cursor.first(name = pathItem.getName())) {
                value = cursor.getValue();
            }
            cursor.destroy();
        } else if (pathItem.getPathType() == 1) {
            if (pathItem.getPosition() < 0) {
                return null;
            }
            IDataCursor cursor = parent.getCursor();
            if (IDataWmPathProcessor.seek(cursor, pathItem.getPosition())) {
                value = cursor.getValue();
            }
            cursor.destroy();
        } else if (pathItem.getPathType() == 2) {
            if (pathItem.getPosition() < 0) {
                return null;
            }
            IDataCursor cursor = parent.getCursor();
            String name = pathItem.getName();
            int position = pathItem.getPosition();
            boolean find = true;
            for (int i = 0; i <= position; ++i) {
                if (cursor.next(name)) continue;
                find = false;
                break;
            }
            if (find) {
                value = cursor.getValue();
            }
            cursor.destroy();
        } else if (pathItem.getPathType() == 3) {
            new LocalizedException(FlowExceptionBundle.class, FlowExceptionBundle.NO_COMPLEX_GET, "").printStackTrace();
            return null;
        }
        if (!bestEffort && !IDataWmPathProcessor.dataCheck(value, pathItem)) {
            value = null;
        }
        if (value instanceof WmIDataList) {
            value = ((WmIDataList)value).getItems();
        }
        if (pathItem.getArrayIndex() == -1) {
            return value;
        }
        return IDataWmPathProcessor.getByArrayIndex(value, pathItem, origPipe);
    }

    public static boolean find(IData parent, WmPathItem pathItem) {
        if (parent == null || pathItem == null) {
            return false;
        }
        boolean find = false;
        if (pathItem.getPathType() == 0) {
            IDataCursor cursor = parent.getCursor();
            String name = pathItem.getName();
            find = cursor.first(name);
            cursor.destroy();
        } else if (pathItem.getPathType() == 1) {
            if (pathItem.getPosition() < 0) {
                return false;
            }
            IDataCursor cursor = parent.getCursor();
            find = IDataWmPathProcessor.seek(cursor, pathItem.getPosition());
            cursor.destroy();
        } else if (pathItem.getPathType() == 2) {
            if (pathItem.getPosition() < 0) {
                return false;
            }
            IDataCursor cursor = parent.getCursor();
            String name = pathItem.getName();
            int position = pathItem.getPosition();
            find = true;
            for (int i = 0; i <= position; ++i) {
                if (cursor.next(name)) continue;
                find = false;
                break;
            }
            cursor.destroy();
        } else if (pathItem.getPathType() == 3) {
            new LocalizedException(FlowExceptionBundle.class, FlowExceptionBundle.NO_COMPLEX_GET, "").printStackTrace();
            return false;
        }
        return find;
    }

    public static IDataCursor findCursor(IData parent, WmPathItem pathItem) {
        if (parent == null || pathItem == null) {
            return null;
        }
        IDataCursor cursor = null;
        if (pathItem.getPathType() == 0) {
            String name;
            cursor = parent.getCursor();
            if (!cursor.first(name = pathItem.getName())) {
                cursor.destroy();
                cursor = null;
            }
        } else if (pathItem.getPathType() == 1) {
            if (pathItem.getPosition() < 0) {
                return null;
            }
            cursor = parent.getCursor();
            if (!IDataWmPathProcessor.seek(cursor, pathItem.getPosition())) {
                cursor.destroy();
                cursor = null;
            }
        } else if (pathItem.getPathType() == 2) {
            if (pathItem.getPosition() < 0) {
                return null;
            }
            cursor = parent.getCursor();
            String name = pathItem.getName();
            int position = pathItem.getPosition();
            for (int i = 0; i <= position; ++i) {
                if (cursor.next(name)) continue;
                cursor.destroy();
                cursor = null;
                break;
            }
        } else if (pathItem.getPathType() == 3) {
            new LocalizedException(FlowExceptionBundle.class, FlowExceptionBundle.NO_COMPLEX_GET, "").printStackTrace();
            return null;
        }
        return cursor;
    }

    public static int findByType(IData parent, WmPathItem pathItem) {
        if (parent == null || pathItem == null) {
            return -1;
        }
        IDataCursor cursor = parent.getCursor();
        int pos = -1;
        boolean find = false;
        while (cursor.next()) {
            ++pos;
            if (!IDataWmPathProcessor.nameCheck(cursor.getKey(), pathItem) || !IDataWmPathProcessor.typeCheck(cursor.getValue(), pathItem)) continue;
            find = true;
            break;
        }
        cursor.destroy();
        if (find) {
            return pos;
        }
        return -1;
    }

    public static int[] findByName(IData parent, String name) {
        if (parent == null || name == null) {
            return null;
        }
        int k = 0;
        Vector<Integer> v = new Vector<Integer>();
        IDataCursor cursor = parent.getCursor();
        while (cursor.next()) {
            if (name.equals(cursor.getKey())) {
                v.addElement(new Integer(k));
            }
            ++k;
        }
        if (v.size() == 0) {
            return null;
        }
        int[] pos = new int[v.size()];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = (Integer)v.elementAt(i);
        }
        return pos;
    }

    public static String[] getKeys(IData parent) {
        if (parent == null) {
            return null;
        }
        IDataCursor cursor = parent.getCursor();
        Vector<String> v = new Vector<String>();
        while (cursor.next()) {
            v.addElement(cursor.getKey());
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] keys = new String[v.size()];
        v.copyInto(keys);
        return keys;
    }

    public static List getKeyList(IData parent) {
        if (parent == null) {
            return null;
        }
        IDataCursor cursor = parent.getCursor();
        ArrayList<String> a = new ArrayList<String>();
        while (cursor.next()) {
            a.add(cursor.getKey());
        }
        cursor.destroy();
        if (a.size() == 0) {
            return null;
        }
        return a;
    }

    public static Object put(IData parent, Object value, WmPathItem pathItem, IData origPipe) {
        if (parent == null || pathItem == null) {
            return null;
        }
        if (pathItem.getPathType() == 0) {
            String name;
            IDataCursor cursor = parent.getCursor();
            if (cursor.first(name = pathItem.getName())) {
                if (IDataWmPathProcessor.dataCheck(cursor.getValue(), pathItem)) {
                    value = IDataWmPathProcessor.putByArrayIndex(value, cursor.getValue(), pathItem, origPipe);
                    cursor.setValue(value);
                } else {
                    value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                    cursor.setValue(value);
                }
            } else {
                cursor.last();
                value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                cursor.insertAfter(name, value);
            }
            cursor.destroy();
        } else if (pathItem.getPathType() == 1) {
            if (pathItem.getPosition() < 0) {
                return null;
            }
            IDataCursor cursor = parent.getCursor();
            if (IDataWmPathProcessor.seek(cursor, pathItem.getPosition())) {
                if (IDataWmPathProcessor.nameCheck(cursor.getKey(), pathItem)) {
                    if (IDataWmPathProcessor.dataCheck(cursor.getValue(), pathItem)) {
                        value = IDataWmPathProcessor.putByArrayIndex(value, cursor.getValue(), pathItem, origPipe);
                        cursor.setValue(value);
                    } else {
                        value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                        cursor.insertBefore(pathItem.getName(), value);
                    }
                } else {
                    value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                    cursor.insertBefore(pathItem.getName(), value);
                }
            } else {
                cursor.last();
                value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                cursor.insertAfter(pathItem.getName(), value);
            }
            cursor.destroy();
        } else if (pathItem.getPathType() == 2) {
            int position = pathItem.getPosition();
            if (position < 0) {
                return null;
            }
            IDataCursor cursor = parent.getCursor();
            String name = pathItem.getName();
            for (int i = 0; i <= position; ++i) {
                if (cursor.next(name)) continue;
                cursor.last();
                value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                cursor.insertAfter(pathItem.getName(), value);
                cursor.destroy();
                return value;
            }
            if (IDataWmPathProcessor.dataCheck(cursor.getValue(), pathItem)) {
                value = IDataWmPathProcessor.putByArrayIndex(value, cursor.getValue(), pathItem, origPipe);
                cursor.setValue(value);
            } else {
                value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                cursor.setValue(value);
            }
            cursor.destroy();
        } else if (pathItem.getPathType() == 3) {
            new LocalizedException(FlowExceptionBundle.class, FlowExceptionBundle.NO_COMPLEX_PUT, "").printStackTrace();
            return null;
        }
        return value;
    }

    public static Object putAtCursor(IData parent, IDataCursor cursor, Object value, WmPathItem pathItem, IData origPipe) {
        if (parent == null || pathItem == null) {
            return null;
        }
        if (pathItem.getPathType() == 0) {
            if (cursor != null) {
                if (IDataWmPathProcessor.dataCheck(cursor.getValue(), pathItem)) {
                    value = IDataWmPathProcessor.putByArrayIndex(value, cursor.getValue(), pathItem, origPipe);
                    cursor.setValue(value);
                } else {
                    value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                    cursor.setValue(value);
                }
            } else {
                cursor = parent.getCursor();
                cursor.last();
                value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                cursor.insertAfter(pathItem.getName(), value);
                cursor.destroy();
                cursor = null;
            }
        } else if (pathItem.getPathType() == 1) {
            boolean needsDestroy = false;
            if (pathItem.getPosition() < 0) {
                return null;
            }
            if (cursor == null) {
                needsDestroy = true;
                cursor = parent.getCursor();
                if (!IDataWmPathProcessor.seek(cursor, pathItem.getPosition())) {
                    cursor.last();
                    value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                    cursor.insertAfter(pathItem.getName(), value);
                    cursor.destroy();
                    needsDestroy = false;
                    cursor = null;
                }
            }
            if (cursor != null) {
                if (IDataWmPathProcessor.nameCheck(cursor.getKey(), pathItem)) {
                    if (IDataWmPathProcessor.dataCheck(cursor.getValue(), pathItem)) {
                        value = IDataWmPathProcessor.putByArrayIndex(value, cursor.getValue(), pathItem, origPipe);
                        cursor.setValue(value);
                    } else {
                        value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                        cursor.insertBefore(pathItem.getName(), value);
                    }
                } else {
                    value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                    cursor.insertBefore(pathItem.getName(), value);
                }
                if (needsDestroy) {
                    cursor.destroy();
                    cursor = null;
                }
            }
        } else if (pathItem.getPathType() == 2) {
            int position = pathItem.getPosition();
            if (position < 0) {
                return null;
            }
            if (cursor == null) {
                cursor = parent.getCursor();
                cursor.last();
                value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                cursor.insertAfter(pathItem.getName(), value);
                cursor.destroy();
                cursor = null;
                return value;
            }
            if (IDataWmPathProcessor.dataCheck(cursor.getValue(), pathItem)) {
                value = IDataWmPathProcessor.putByArrayIndex(value, cursor.getValue(), pathItem, origPipe);
                cursor.setValue(value);
            } else {
                value = IDataWmPathProcessor.putByArrayIndex(value, null, pathItem, origPipe);
                cursor.setValue(value);
            }
        } else if (pathItem.getPathType() == 3) {
            new LocalizedException(FlowExceptionBundle.class, FlowExceptionBundle.NO_COMPLEX_PUT, "").printStackTrace();
            return null;
        }
        return value;
    }

    private static boolean seek(IDataCursor ic, int position) {
        if (ic.first()) {
            for (int curPos = 0; curPos < position; ++curPos) {
                if (ic.next()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void markDelete(IData parent, WmPathItem pathItem) {
        if (parent == null || pathItem == null) {
            return;
        }
        if (pathItem.getPathType() == 0) {
            String name;
            IDataCursor cursor = parent.getCursor();
            if (cursor.first(name = pathItem.getName())) {
                cursor.setValue(IDataWmPathProcessor.getMarker());
            }
            cursor.destroy();
        } else if (pathItem.getPathType() == 1) {
            if (pathItem.getPosition() < 0) {
                return;
            }
            IDataCursor cursor = parent.getCursor();
            if (IDataWmPathProcessor.seek(cursor, pathItem.getPosition()) && IDataWmPathProcessor.nameCheck(cursor.getKey(), pathItem)) {
                cursor.setValue(IDataWmPathProcessor.getMarker());
            }
            cursor.destroy();
        } else if (pathItem.getPathType() == 2) {
            if (pathItem.getPosition() < 0) {
                return;
            }
            IDataCursor cursor = parent.getCursor();
            String name = pathItem.getName();
            int position = pathItem.getPosition();
            for (int i = 0; i <= position; ++i) {
                if (cursor.next(name)) continue;
                cursor.destroy();
                return;
            }
            cursor.setValue(IDataWmPathProcessor.getMarker());
            cursor.destroy();
        } else if (pathItem.getPathType() == 3) {
            new LocalizedException(FlowExceptionBundle.class, FlowExceptionBundle.NO_COMPLEX_DELETE, "").printStackTrace();
        }
    }

    static DeleteMarker getMarker() {
        if (marker == null) {
            marker = new DeleteMarker();
        }
        return marker;
    }

    public static void deleteMarker(IData parent, WmPathItem pathItem) {
        if (parent == null || pathItem == null) {
            return;
        }
        IDataCursor cursor = parent.getCursor();
        String name = pathItem.getName();
        while (cursor.next(name)) {
            if (cursor.getValue() != IDataWmPathProcessor.getMarker()) continue;
            cursor.delete();
        }
        cursor.destroy();
    }

    public static boolean dataCheck(Object data, WmPathItem pathItem) {
        if (data instanceof WmIDataList) {
            data = ((WmIDataList)data).getItems();
        }
        if (data == null) {
            return true;
        }
        int type = pathItem.getType();
        int dim = pathItem.getNodeDimension();
        if (type == -1) {
            if (dim == 2) {
                return data instanceof Object[][];
            }
            if (dim == 1) {
                return data instanceof Object[];
            }
            return true;
        }
        if (dim == -1) {
            if (type == 1) {
                return data instanceof String || data instanceof String[] || data instanceof String[][];
            }
            if (NSField.isRecordType(type)) {
                return data instanceof IData;
            }
            return true;
        }
        if (type == 3 && dim == 0) {
            return true;
        }
        if (data instanceof String && type == 1 && dim == 0) {
            return true;
        }
        if (data instanceof String[] && type == 1 && dim == 1) {
            return true;
        }
        if (data instanceof String[][] && type == 1 && dim == 2) {
            return true;
        }
        if (data instanceof IData && NSField.isRecordType(type) && dim == 0) {
            return true;
        }
        if (data instanceof IData[] && NSField.isRecordType(type) && dim == 1) {
            return true;
        }
        if (data instanceof Object[] && type == 3 && dim == 1) {
            return true;
        }
        JournalLogger.log(12, 50, 6);
        return false;
    }

    public static boolean nameCheck(String name, WmPathItem pathItem) {
        if (name == null || pathItem.getName() == null) {
            return false;
        }
        return name.equals(pathItem.getName());
    }

    public static boolean typeCheck(Object value, WmPathItem pathItem) {
        if (pathItem.getType() == 3) {
            return true;
        }
        if (pathItem.getType() == 1 && (value instanceof String || value instanceof String[] || value instanceof String[][])) {
            return true;
        }
        return NSField.isRecordType(pathItem.getType()) && (value instanceof IData || value instanceof IData[] || value instanceof WmIDataList);
    }

    static Object getByArrayIndex(Object value, WmPathItem pathItem, IData origPipe) {
        if (pathItem.getArrayIndex() == -1) {
            return value;
        }
        if (pathItem.getTableIndex() != -1 && value instanceof Object[][]) {
            Object[][] obj = (Object[][])value;
            int arrayIndex = pathItem.getArrayIndex();
            if (arrayIndex == -2) {
                arrayIndex = IDataWmPathProcessor.getIndexFromPipe(pathItem.getVarArrayIndex(), origPipe);
            }
            if (arrayIndex < obj.length) {
                int tableIndex = pathItem.getTableIndex();
                if (tableIndex == -2) {
                    tableIndex = IDataWmPathProcessor.getIndexFromPipe(pathItem.getVarTableIndex(), origPipe);
                }
                if (tableIndex < obj[arrayIndex].length) {
                    return obj[arrayIndex][tableIndex];
                }
                return null;
            }
        } else if (value instanceof Object[]) {
            Object[] obj = (Object[])value;
            int index = pathItem.getArrayIndex();
            if (index == -2) {
                index = IDataWmPathProcessor.getIndexFromPipe(pathItem.getVarArrayIndex(), origPipe);
            }
            if (index < obj.length) {
                return obj[index];
            }
            return null;
        }
        return null;
    }

    static Object putByArrayIndex(Object value, Object parent, WmPathItem pathItem, IData origPipe) {
        if (pathItem.getArrayIndex() == -1) {
            return value;
        }
        if (parent instanceof WmIDataList) {
            parent = ((WmIDataList)parent).getItems();
        }
        parent = IDataWmPathProcessor.createParent(parent, pathItem, origPipe);
        if (pathItem.getTableIndex() != -1 && parent instanceof Object[][]) {
            Object[][] obj = (Object[][])parent;
            int arrayIndex = pathItem.getArrayIndex();
            if (arrayIndex == -2) {
                arrayIndex = IDataWmPathProcessor.getIndexFromPipe(pathItem.getVarArrayIndex(), origPipe);
            }
            if (arrayIndex < obj.length) {
                int tableIndex = pathItem.getTableIndex();
                if (tableIndex == -2) {
                    tableIndex = IDataWmPathProcessor.getIndexFromPipe(pathItem.getVarTableIndex(), origPipe);
                }
                if (tableIndex < obj[arrayIndex].length) {
                    Object o = obj[arrayIndex][tableIndex];
                    try {
                        obj[arrayIndex][tableIndex] = value;
                    }
                    catch (Exception e) {
                        obj[arrayIndex][tableIndex] = o;
                    }
                    return parent;
                }
            }
        } else if (parent instanceof Object[]) {
            Object[] obj = parent;
            int index = pathItem.getArrayIndex();
            if (index == -2) {
                index = IDataWmPathProcessor.getIndexFromPipe(pathItem.getVarArrayIndex(), origPipe);
            }
            if (index < obj.length) {
                Object o = obj[index];
                try {
                    obj[index] = value;
                }
                catch (Exception e) {
                    obj[index] = o;
                }
                return parent;
            }
        }
        return parent;
    }

    static Object createParent(Object parent, WmPathItem pathItem, IData origPipe) {
        int len1 = pathItem.getArrayIndex();
        int len2 = pathItem.getTableIndex();
        if (len1 == -2) {
            len1 = IDataWmPathProcessor.getIndexFromPipe(pathItem.getVarArrayIndex(), origPipe);
        }
        if (len2 == -2) {
            len2 = IDataWmPathProcessor.getIndexFromPipe(pathItem.getVarTableIndex(), origPipe);
        }
        boolean reqTable = len2 != -1;
        boolean reqArray = len1 != -1;
        boolean isTable = parent instanceof Object[][];
        boolean isArray = parent instanceof Object[];
        if (reqTable && isTable) {
            parent = IDataWmPathProcessor.extendTable((Object[][])parent, len1 + 1, len2 + 1);
        } else if (reqArray && isArray) {
            parent = IDataWmPathProcessor.extendArray(parent, len1 + 1);
        } else if (reqTable) {
            parent = MapWmPathUtil.createTable(pathItem.getType(), len1 + 1, len2 + 1);
        } else if (reqArray) {
            parent = MapWmPathUtil.createList(pathItem.getType(), pathItem.getJavaType(), len1 + 1);
        }
        return parent;
    }

    static Object[] extendArray(Object[] exist, int newSize) {
        if (exist == null || newSize <= 0) {
            return exist;
        }
        if (newSize <= exist.length) {
            return exist;
        }
        Object[] extended = null;
        extended = exist instanceof String[] ? new String[newSize] : (exist instanceof IData[] ? new IData[newSize] : new Object[newSize]);
        for (int i = 0; i < exist.length; ++i) {
            extended[i] = exist[i];
        }
        return extended;
    }

    static Object[][] extendTable(Object[][] exist, int len1, int len2) {
        if (exist == null || len1 <= 0 || len2 <= 0) {
            return null;
        }
        if (len1 <= exist.length && len2 <= exist[len1 - 1].length) {
            return exist;
        }
        int tableLen = exist[0].length;
        for (int i = 1; i < exist.length; ++i) {
            if (exist[i].length <= tableLen) continue;
            tableLen = exist[i].length;
        }
        Object extended = null;
        len1 = Math.max(exist.length, len1);
        len2 = Math.max(tableLen, len2);
        extended = exist instanceof String[][] ? new String[len1][len2] : new Object[len1][len2];
        for (int i = 0; i < exist.length; ++i) {
            for (int j = 0; j < exist[i].length; ++j) {
                extended[i][j] = exist[i][j];
            }
        }
        return extended;
    }

    public static Object putNode(IData pipeline, Object value, WmPathItem[] items) {
        if (pipeline == null || items == null || items.length == 0) {
            return null;
        }
        if (items.length == 1) {
            IDataWmPathProcessor.put(pipeline, value, items[0], pipeline);
            return pipeline;
        }
        IData parent = pipeline;
        for (int i = 0; i < items.length - 1; ++i) {
            Object o = IDataWmPathProcessor.get(parent, items[i], pipeline);
            if (o == null) {
                if (items[i].getArrayIndex() != -1) {
                    int idx = -1;
                    idx = items[i].getArrayIndex() == -2 ? IDataWmPathProcessor.getIndexFromPipe(items[i].getVarArrayIndex(), parent) : items[i].getArrayIndex();
                    IData[] next = new IData[idx + 1];
                    for (int j = 0; j < next.length; ++j) {
                        next[j] = IDataFactory.create(0);
                    }
                    IDataWmPathProcessor.put(parent, next, items[i], pipeline);
                    parent = next[idx];
                    continue;
                }
                IData next = IDataFactory.create(0);
                IDataWmPathProcessor.put(parent, next, items[i], pipeline);
                parent = next;
                continue;
            }
            if (o instanceof IData) {
                parent = (IData)o;
                continue;
            }
            return o;
        }
        return IDataWmPathProcessor.put(parent, value, items[items.length - 1], pipeline);
    }

    public static Object putNode(IData pipeline, Object value, String path) {
        WmPathItem[] items = WmPathInfo.parsePath(path);
        if (items == null) {
            return null;
        }
        return IDataWmPathProcessor.putNode(pipeline, value, items);
    }

    public static Object getNode(IData pipeline, WmPathItem[] items) {
        if (pipeline == null || items == null || items.length == 0) {
            return null;
        }
        if (items.length == 1) {
            return IDataWmPathProcessor.get(pipeline, items[0], pipeline);
        }
        IData parent = pipeline;
        for (int i = 0; i < items.length - 1; ++i) {
            Object o = IDataWmPathProcessor.get(parent, items[i], pipeline);
            if (!(o instanceof IData)) {
                return null;
            }
            parent = (IData)o;
        }
        return IDataWmPathProcessor.get(parent, items[items.length - 1], pipeline);
    }

    public static Object getNode(IData pipeline, String path) {
        WmPathItem[] items = WmPathInfo.parsePath(path);
        if (items == null) {
            return null;
        }
        return IDataWmPathProcessor.getNode(pipeline, items);
    }

    public static void deleteNode(IData pipeline, WmPathItem[] items) {
        if (pipeline == null || items == null || items.length == 0) {
            return;
        }
        if (items.length == 1) {
            IDataWmPathProcessor.markDelete(pipeline, items[0]);
            IDataWmPathProcessor.deleteMarker(pipeline, items[0]);
            return;
        }
        IData parent = pipeline;
        for (int i = 0; i < items.length - 1; ++i) {
            Object o = IDataWmPathProcessor.get(parent, items[i], pipeline);
            if (!(o instanceof IData)) {
                return;
            }
            parent = (IData)o;
        }
        IDataWmPathProcessor.markDelete(parent, items[items.length - 1]);
        IDataWmPathProcessor.deleteMarker(parent, items[items.length - 1]);
    }

    public static void deleteNode(IData pipeline, String path) {
        WmPathItem[] items = WmPathInfo.parsePath(path);
        if (items == null) {
            return;
        }
        IDataWmPathProcessor.deleteNode(pipeline, items);
    }

    public static int getIndexFromPipe(String expr, IData pipe) {
        String[] vars = MapSet.parseVars(expr);
        Object[] paths = MapSet.processPath(vars);
        if (paths == null) {
            return -1;
        }
        String val = MapSet.substituteVars(paths, pipe);
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return -1;
        }
    }
}

