/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.util.JournalLogger;
import com.wm.util.Values;

public class FlowWait
extends FlowElement {
    public static final String KEY_WAIT_OUTPUT = "output";
    public static final String KEY_WAIT_WAITFOR = "wait-for";
    MapWmPathInfo outputPath;
    String waitFor;

    public FlowWait(Values val) {
        super(val);
        this.type = "WAIT";
    }

    public NSRecord getProperties() {
        NSRecord params = super.getProperties();
        params.addField(new NSField(null, KEY_WAIT_OUTPUT, 1, 0));
        params.addField(new NSField(null, KEY_WAIT_WAITFOR, 1, 0));
        return params;
    }

    public String getWaitFor() {
        return this.waitFor;
    }

    public String getOutputPath() {
        return this.outputPath == null ? null : this.outputPath.getPathString();
    }

    public void setWaitFor(String waitString) {
        this.waitFor = waitString;
    }

    public boolean hasNodes() {
        return false;
    }

    public Values getValues() {
        String outputPathString = this.outputPath != null ? this.outputPath.getPathString() : null;
        Object[][] o = new Object[][]{{KEY_WAIT_OUTPUT, outputPathString}, {KEY_WAIT_WAITFOR, this.waitFor}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
        this.outputPath = MapWmPathInfo.create(val.getString(KEY_WAIT_OUTPUT));
        this.waitFor = val.getString(KEY_WAIT_WAITFOR);
    }

    public IData getAsData() {
        String outputPathString = this.outputPath != null ? this.outputPath.getPathString() : null;
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        if (outputPathString != null) {
            IDataUtil.put(ic, KEY_WAIT_OUTPUT, outputPathString);
        }
        if (this.waitFor != null) {
            IDataUtil.put(ic, KEY_WAIT_WAITFOR, this.waitFor);
        }
        ic.destroy();
        return val;
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this.outputPath = MapWmPathInfo.create(IDataUtil.getString(ic, KEY_WAIT_OUTPUT));
        this.waitFor = IDataUtil.getString(ic, KEY_WAIT_WAITFOR);
        ic.destroy();
    }

    public Values getStateValues() {
        return super.getStateValues();
    }

    public void setStateValues(Values val) {
        super.setStateValues(val);
        this.setValues(val);
    }

    public void init(FlowState state) {
    }

    public void invoke(FlowState state) {
        if (JournalLogger.isLogEnabled(6, 49, 7)) {
            JournalLogger.log(6, 49, 7, this.getDebugLabel(), state.toString());
        }
        if (state.shouldExit(this)) {
            state.willExit();
        }
    }

    public Values getReportable() {
        String outputPathString = this.outputPath != null ? this.outputPath.getPathString() : null;
        Object[][] o = new Object[][]{{KEY_WAIT_OUTPUT, outputPathString}, {KEY_WAIT_WAITFOR, this.waitFor}};
        return super.getReportable().copyFrom(new Values(o));
    }
}

