/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.g11n.util.iContext;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowException;
import com.wm.lang.flow.FlowExceptionHandler;
import com.wm.lang.flow.FlowExit;
import com.wm.lang.flow.FlowInvoke;
import com.wm.lang.flow.FlowMap;
import com.wm.lang.flow.FlowMapInvoke;
import com.wm.lang.flow.FlowRoot;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.flow.MapError;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.TableUtil;
import com.wm.lang.flow.resources.FlowExceptionBundle;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.Namespace;
import com.wm.util.Values;
import com.wm.util.pluggable.WmIDataList;
import java.util.Locale;
import java.util.Stack;
import java.util.Vector;

public class FlowState {
    private static final boolean debug = false;
    Stack state = new Stack();
    Namespace query;
    boolean incremental = false;
    boolean ignoreTimeouts = false;
    String exceptionPath = null;
    boolean stepMap = false;
    boolean mapInvokeInput = false;
    boolean mapInvokeOutput = false;
    int nextMap = 0;
    boolean lastMapStep = false;
    String[] supermapPath = null;
    Exception error = null;
    boolean mapInvokeError = false;
    IData pipeline;
    FlowElement last = null;
    static int flowElementID = 0;
    FlowExit exit;
    FlowState parentFlow;
    IData childPipeline;
    IData preScopePipe;
    IData scopedPipe;
    IData pipelet;
    FlowMapInvoke tformFlowMapInvoke;
    IData lastErrorInfo;
    IData childLastErrorInfo;
    FlowExceptionHandler flowExHandler;
    Exception childException;
    IData savedPipelineClone;
    WmIDataList[] findTable;
    MapError mapError;
    iContext ic = new iContext();
    static final String KEY_STATE_STACK = "stack";
    static final String KEY_STATE_PIPELINE = "pipeline";
    static final String KEY_STATE_LAST = "last";
    static final String KEY_STATE_EXIT = "exit";

    public String toString() {
        if (this.state.empty()) {
            return "index=0 depth=0";
        }
        return "index=" + (this.current().getNodeIndex() + 1) + " depth=" + (this.state.size() - 1);
    }

    public FlowState(FlowRoot root, Namespace query, Values pipeline) {
        this(root, query, (IData)pipeline);
    }

    public FlowState(FlowRoot root, Namespace query, IData pipeline) {
        this.pipeline = pipeline;
        this.query = query;
        root.init(query);
        this.push((FlowRoot)root.clone());
    }

    public FlowState(Values val, Namespace query) {
        this.setStateValues(val);
        this.query = query;
    }

    public void setIncremental(boolean incr) {
        this.incremental = incr;
    }

    public boolean isIncremental() {
        return this.incremental;
    }

    public Namespace getNamespace() {
        return this.query;
    }

    public IData getPipeline() {
        return this.pipeline;
    }

    public void setPipeline(IData pipe) {
        this.pipeline = pipe;
    }

    public void mergePipeline(IData pipe) {
        IDataUtil.merge(pipe, this.pipeline);
        if (pipe != null && pipe instanceof Values) {
            this.pipeline = Values.use(this.pipeline);
            ((Values)this.pipeline).copyPrivateDataFrom((Values)pipe);
        }
    }

    public void clearError() {
        this.error = null;
    }

    public Exception getError() {
        return this.error;
    }

    public void setError(Exception error) {
        this.error = error;
        this.setExceptionPath();
    }

    public void setError(Throwable error) {
        if (error == null) {
            return;
        }
        String msg = error.getMessage();
        this.error = msg == null ? new Exception(error.getClass().getName()) : new Exception(msg);
        this.setExceptionPath();
    }

    public String getExceptionPath() {
        return this.exceptionPath;
    }

    public void setExceptionPath() {
        this.exceptionPath = this.currentPath();
    }

    public boolean isDone() {
        return this.state.empty();
    }

    public void setDone(boolean done) {
        this.current().setDone(done);
    }

    public FlowElement last() {
        return this.last;
    }

    public void setIgnoreTimeouts(boolean value) {
        this.ignoreTimeouts = value;
    }

    public boolean getIgnoreTimeouts() {
        return this.ignoreTimeouts;
    }

    public FlowExit getExit() {
        return this.exit;
    }

    public void setExit(FlowExit exit) {
        this.exit = exit;
        this.setExceptionPath();
    }

    public void willExit() {
        if (this.exit != null) {
            if (this.exit.isExitDone()) {
                this.error = this.exit.getFailure();
                this.exit = null;
            } else if (!this.exit.isExitDone() && this.current().parent == null) {
                if (this.exit.isExitLabel()) {
                    this.error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.BAD_LABEL, "", new Object[]{this.exit.getName(), this.exit.from});
                    this.exit = null;
                } else if (this.exit.isExitLoop()) {
                    String exitName = this.exit.getName();
                    if (exitName == null) {
                        exitName = "";
                    }
                    this.error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.NO_ANCESTOR, "", exitName);
                    this.exit = null;
                } else {
                    this.error = this.exit.getFailure();
                    this.exit = null;
                }
            }
        }
    }

    public boolean shouldExit(FlowElement current) {
        if (this.exit != null) {
            return this.exit.shouldExit(current);
        }
        return false;
    }

    public FlowElement pushNextNode() {
        FlowElement parent = this.current();
        FlowElement child = this.pushNode(parent.getNodeIndex());
        parent.nextNodeIndex();
        return child;
    }

    public void setNextNode(int next) {
        this.current().setNodeIndex(next);
    }

    public FlowElement push(FlowElement node) {
        if (node.getID() == 0) {
            node.setID(FlowState.newFlowElementID());
        }
        FlowElement next = (FlowElement)node.clone();
        if (!this.ignoreTimeouts) {
            next.startTimer(this);
        }
        this.state.push(next);
        return next;
    }

    private FlowElement pushNode(int index) {
        if (this.hasMoreNodes()) {
            return this.push(this.current().getNodeAt(index));
        }
        return null;
    }

    public FlowElement current() {
        if (this.state.empty()) {
            return null;
        }
        return (FlowElement)this.state.peek();
    }

    public String currentPath() {
        FlowElement fe = this.current();
        return fe == null ? "" : fe.getPath();
    }

    public void pop() {
        if (!this.state.empty()) {
            this.last = (FlowElement)this.state.pop();
            if (!this.ignoreTimeouts) {
                this.last.cancelTimer();
            }
        }
    }

    public boolean hasMoreNodes() {
        if (this.state.empty()) {
            return false;
        }
        return this.current().getNodeIndex() < this.current().getNodeCount();
    }

    public FlowElement invoke() {
        if (this.incremental) {
            while (!this.isDone() && this.stepIncremental(this.current())) {
            }
            if (this.parentFlow != null) {
                FlowExceptionHandler fex;
                this.parentFlow.setChildResults(this.pipeline);
                Exception e = this.getError();
                this.parentFlow.setChildException(e);
                if (e != null && this.getLastErrorInfo() == null && (fex = this.getFlowExceptionHandler()) != null) {
                    fex.handleError(e, Values.use(this.getPipeline()));
                    this.setLastErrorInfo(fex.getException());
                }
                this.parentFlow.setChildLastErrorInfo(this.getLastErrorInfo());
            }
            return this.current();
        }
        while (!this.isDone()) {
            this.step(this.current());
        }
        if (this.parentFlow != null) {
            this.parentFlow.setChildResults(this.pipeline);
            this.parentFlow.setChildException(this.getError());
            this.parentFlow.setChildLastErrorInfo(this.getLastErrorInfo());
        }
        return null;
    }

    void step(FlowElement node) {
        if (!node.isEnabled()) {
            this.pop();
        }
        if (node.pipeStart) {
            node.pipeStart = false;
            node.init(this);
        } else {
            this.checkExpiration(node);
            this.invokeNode(node);
            if (node.isDone()) {
                this.pop();
                node.setDone(false);
            }
        }
    }

    public void checkExpiration(FlowElement node) {
        if (node.isExpired()) {
            FlowExit exit = new FlowExit(new Values(new Object[][]{{"from", "$parent"}, {"signal", FlowExit.signalOptions[1]}}));
            exit.setLocalizedExceptionInfo(FlowExceptionBundle.TIMEOUT, "", node.getVerboseName(this.ic.getJavaLocale(true)));
            this.setExceptionPath();
            this.setExit(exit);
        }
    }

    boolean stepIncremental(FlowElement node) {
        if (!node.isEnabled()) {
            this.pop();
            return true;
        }
        if (node.pipeStart) {
            node.pipeStart = false;
            node.init(this);
            return FlowState.isRoot(node);
        }
        this.checkExpiration(node);
        this.invokeNode(node);
        if (node.inputMapOnly()) {
            node.setInputMapOnly(false);
            return false;
        }
        if (this.isStepMap()) {
            return false;
        }
        if (node.isDone()) {
            this.pop();
            node.setDone(false);
            return true;
        }
        return !FlowState.isLast(this.current());
    }

    public void invokeNode(FlowElement node) {
        FlowMap fm_in = node.getInputMap();
        FlowMap fm_out = node.getOutputMap();
        if (this.tformFlowMapInvoke != null) {
            if (this.getChildResults() != null) {
                this.tformFlowMapInvoke.setPipelet(this.getChildResults());
                this.setChildResults(null);
            }
            this.tformFlowMapInvoke = null;
        }
        WmIDataList[] findTable = null;
        String scope = node.getFullScope();
        if (!node.outputMapOnly) {
            this.preScopePipe = this.getPipeline();
            findTable = TableUtil.findTable(this.preScopePipe, scope, this.preScopePipe);
            try {
                this.scopedPipe = this.getScope(node, this.preScopePipe);
                if (this.scopedPipe != null) {
                    this.setPipeline(this.scopedPipe);
                }
            }
            catch (FlowException fe) {
                FlowExit exit = new FlowExit(new Values(new Object[][]{{"from", "$flow"}, {"signal", FlowExit.signalOptions[1]}}));
                exit.setLocalizedExceptionInfo(FlowExceptionBundle.BAD_SCOPE, "", new Object[]{node.getScope(), node.getVerboseName(this.ic.getJavaLocale(true))});
                this.setExit(exit);
                this.setDone(true);
                return;
            }
            if (fm_in != null) {
                fm_in.invoke(this);
            }
            if (node.inputMapOnly()) {
                if (node instanceof FlowInvoke) {
                    this.savePipelineClone((FlowInvoke)node);
                }
                return;
            }
            node.invoke(this);
        }
        if (this.childPipeline != null) {
            this.mergePipeline(this.childPipeline);
            this.childPipeline = null;
        }
        if (this.getChildException() != null) {
            this.setError(this.getChildException());
            this.setChildException(null);
        }
        if (this.getChildLastErrorInfo() != null) {
            this.setLastErrorInfo(this.getChildLastErrorInfo());
            this.setChildLastErrorInfo(null);
        }
        if (this.getError() == null) {
            if (node.outputMapOnly() && this.savedPipelineClone != null) {
                this.restorePipelineClone();
            }
            if (fm_out != null) {
                fm_out.invoke(this);
            }
        }
        if (findTable != null && findTable.length > 0) {
            TableUtil.recoverTable(this.preScopePipe, scope, findTable);
        }
        if (this.scopedPipe != null) {
            this.setPipeline(this.preScopePipe);
        }
        if (node.outputMapOnly()) {
            node.setOutputMapOnly(false);
            node.setDone(true);
            this.savedPipelineClone = null;
        }
    }

    public IData getScope(FlowElement node, IData pipe) throws FlowException {
        String scope = node.getFullScope();
        if (scope == null || scope.equals("")) {
            return null;
        }
        MapWmPathInfo scopePath = MapWmPathInfo.create(scope);
        if (scopePath == null) {
            throw new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.BAD_SCOPE_PATH, "");
        }
        Object o = IDataWmPathProcessor.getNode(pipe, scopePath.getPathItems());
        if (o instanceof IData) {
            return (IData)o;
        }
        if (o == null) {
            IData v = IDataFactory.create(1);
            IDataWmPathProcessor.putNode(pipe, (Object)v, scopePath.getPathItems());
            return v;
        }
        throw new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.BAD_SCOPE_PATH, "");
    }

    static boolean isRoot(FlowElement node) {
        return node.type.equals("ROOT");
    }

    public static boolean isLast(FlowElement node) {
        if (node == null) {
            return true;
        }
        return node.parent == null && node.type.equals("ROOT");
    }

    public static boolean isLastChild(FlowElement node) {
        if (node == null || node.parent == null) {
            return true;
        }
        FlowElement parent = node.parent;
        return parent.getNodeAt(parent.getNodeCount() - 1) == node;
    }

    static int newFlowElementID() {
        return flowElementID++;
    }

    Vector getStackValues() {
        Vector v = new Vector();
        for (int i = 0; i < this.state.size(); ++i) {
            v.addElement(this.state.elementAt(i));
        }
        return v;
    }

    void setStackValues(Vector val) {
        for (int i = 0; i < val.size(); ++i) {
            this.state.addElement(val.elementAt(i));
        }
    }

    public void setStateValues(Values val) {
        this.setStackValues((Vector)val.get(KEY_STATE_STACK));
        this.exit = new FlowExit(val.getValues(KEY_STATE_EXIT));
        this.pipeline = val.getValues(KEY_STATE_PIPELINE);
        this.last = FlowElement.create(val.getValues(KEY_STATE_LAST));
    }

    public Values getStateValues() {
        Object[][] o = new Object[][]{{KEY_STATE_STACK, this.getStackValues()}, {KEY_STATE_EXIT, this.exit}, {KEY_STATE_PIPELINE, this.pipeline}, {KEY_STATE_LAST, this.last}};
        return new Values(o);
    }

    public void setParent(FlowState fs) {
        this.parentFlow = fs;
    }

    public FlowState getParent() {
        return this.parentFlow;
    }

    public void setChildResults(IData pipeline) {
        this.childPipeline = pipeline;
    }

    public IData getChildResults() {
        return this.childPipeline;
    }

    public void setChildException(Exception e) {
        this.childException = e;
    }

    public Exception getChildException() {
        return this.childException;
    }

    public void invokeInputMap() {
    }

    public FlowElement invokeOutputMap() {
        return null;
    }

    public void setServerPipeline(IData pipeline) {
    }

    public boolean isConnected() {
        return false;
    }

    public boolean isStepMap() {
        return this.stepMap;
    }

    public void setStepMap(boolean flag) {
        this.stepMap = flag;
    }

    public boolean isMapInvokeError() {
        return this.mapInvokeError;
    }

    public void setMapInvokeError(boolean flag) {
        this.mapInvokeError = flag;
    }

    public FlowElement invokeNextMap() {
        System.out.println("Invalid call to FlowState.invokeNextMap");
        return null;
    }

    public IData invokeCurrentInputMap() {
        System.out.println("Invalid call to FlowState.invokeCurrentInputMap");
        return null;
    }

    public FlowElement invokeCurrentOutputMap() {
        System.out.println("Invalid call to FlowState.invokeCurrentOutputMap");
        return null;
    }

    public IData getPipelet() {
        return this.pipelet;
    }

    public void setPipelet(IData pipelet) {
        this.pipelet = pipelet;
    }

    public String[] getFlowMapErrors() {
        if (this.mapError == null) {
            return null;
        }
        return this.mapError.getLogs();
    }

    MapError getMapLog() {
        return this.mapError;
    }

    public void setNextMap(int nextMap) {
        this.nextMap = nextMap;
    }

    public int getNextMap() {
        return this.nextMap;
    }

    public boolean mapInvokeInput() {
        return this.mapInvokeInput;
    }

    public void setMapInvokeInput(boolean flag) {
        this.mapInvokeInput = flag;
    }

    public boolean mapInvokeOutput() {
        return this.mapInvokeOutput;
    }

    public void setMapInvokeOutput(boolean flag) {
        this.mapInvokeOutput = flag;
    }

    public String[] getSupermapPath() {
        return this.supermapPath;
    }

    public boolean isLastMapStep() {
        return this.lastMapStep;
    }

    public void setLastMapStep(boolean flag) {
        this.lastMapStep = flag;
    }

    public void setTformFlowMapInvoke(FlowMapInvoke fmi) {
        this.tformFlowMapInvoke = fmi;
    }

    public IData getLastErrorInfo() {
        return this.lastErrorInfo;
    }

    public void setLastErrorInfo(IData v) {
        this.lastErrorInfo = v;
    }

    public Locale getLocale() {
        return this.ic.getJavaLocale(true);
    }

    public void setLocale(Locale l) {
        this.ic = new iContext(l);
    }

    public iContext getIContext() {
        return this.ic;
    }

    public void setIContext(iContext p_ic) {
        this.ic = new iContext(p_ic);
    }

    public void setIContext(String rfc3066) {
        this.ic = new iContext(rfc3066);
    }

    public IData getChildLastErrorInfo() {
        return this.childLastErrorInfo;
    }

    public void setChildLastErrorInfo(IData v) {
        this.childLastErrorInfo = v;
    }

    private void savePipelineClone(FlowInvoke node) {
        NSService svc = node.getService(this.getNamespace(), node.service);
        String svcName = svc.getNSName().getFullName();
        if (svc.getServiceType().isFlowService()) {
            this.savedPipelineClone = IDataUtil.clone(this.getPipeline());
        }
    }

    private void restorePipelineClone() {
        IDataCursor c = this.getPipeline().getCursor();
        IDataCursor s = this.savedPipelineClone.getCursor();
        while (c.next()) {
            if (!s.first(c.getKey())) continue;
            s.delete();
        }
        c.destroy();
        IDataUtil.append(this.savedPipelineClone, this.getPipeline());
        s.destroy();
    }

    public void clearLastErrorInfo() {
        this.lastErrorInfo = null;
    }

    public void setFlowExceptionHandler(FlowExceptionHandler feh) {
        this.flowExHandler = feh;
    }

    public FlowExceptionHandler getFlowExceptionHandler() {
        return this.flowExHandler;
    }

    public void updateServerPipeline(String operation, String path, Object updateObj) {
    }
}

