/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.Namespace;
import com.wm.util.JournalLogger;
import com.wm.util.Values;

public class FlowSpawn
extends FlowElement {
    public static final String KEY_SPAWN_INPUT = "input";
    public static final String KEY_SPAWN_FLOWID = "flowId";
    public static final String KEY_SPAWN_SERVICE = "service";
    MapWmPathInfo inputPath;
    MapWmPathInfo flowIdPath;
    NSName service;

    public FlowSpawn(Values val) {
        super(val);
        this.type = "SPAWN";
    }

    public NSRecord getProperties() {
        NSRecord params = super.getProperties();
        params.addField(new NSField(null, KEY_SPAWN_INPUT, 1, 0));
        params.addField(new NSField(null, KEY_SPAWN_FLOWID, 1, 0));
        params.addField(new NSField(null, KEY_SPAWN_SERVICE, 1, 0));
        return params;
    }

    public NSName getService() {
        return this.service;
    }

    public NSService getService(Namespace ns, NSName name) {
        NSNode svc = ns.getNode(name);
        if (svc != null && svc.getNodeTypeObj().equals(NSService.TYPE)) {
            return (NSService)svc;
        }
        return null;
    }

    public boolean hasNodes() {
        return false;
    }

    public String getInputPath() {
        return this.inputPath == null ? null : this.inputPath.getPathString();
    }

    public String getFlowIdPath() {
        return this.flowIdPath == null ? null : this.flowIdPath.getPathString();
    }

    public void setService(NSName service) {
        this.service = service;
    }

    public Values getValues() {
        String inputPathString = this.inputPath != null ? this.inputPath.getPathString() : null;
        String flowIdPathString = this.flowIdPath != null ? this.flowIdPath.getPathString() : null;
        Object[][] o = new Object[][]{{KEY_SPAWN_INPUT, inputPathString}, {KEY_SPAWN_FLOWID, flowIdPathString}, {KEY_SPAWN_SERVICE, this.service != null ? this.service.toString() : null}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
        this.inputPath = MapWmPathInfo.create(val.getString(KEY_SPAWN_INPUT));
        this.flowIdPath = MapWmPathInfo.create(val.getString(KEY_SPAWN_FLOWID));
        this.service = NSName.create(val.getString(KEY_SPAWN_SERVICE));
    }

    public IData getAsData() {
        String inputPathString = this.inputPath != null ? this.inputPath.getPathString() : null;
        String flowIdPathString = this.flowIdPath != null ? this.flowIdPath.getPathString() : null;
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        IDataUtil.put(ic, KEY_SPAWN_INPUT, inputPathString);
        IDataUtil.put(ic, KEY_SPAWN_FLOWID, flowIdPathString);
        IDataUtil.put(ic, KEY_SPAWN_SERVICE, this.service != null ? this.service.toString() : null);
        ic.destroy();
        return val;
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this.inputPath = MapWmPathInfo.create(IDataUtil.getString(ic, KEY_SPAWN_INPUT));
        this.flowIdPath = MapWmPathInfo.create(IDataUtil.getString(ic, KEY_SPAWN_FLOWID));
        this.service = NSName.create(IDataUtil.getString(ic, KEY_SPAWN_SERVICE));
        ic.destroy();
    }

    public Values getStateValues() {
        return super.getStateValues();
    }

    public void setStateValues(Values val) {
        super.setStateValues(val);
        this.setValues(val);
    }

    public void init(FlowState state) {
    }

    public void invoke(FlowState state) {
        if (JournalLogger.isLogEnabled(6, 49, 7)) {
            JournalLogger.log(6, 49, 7, this.getDebugLabel(), state.toString());
        }
        if (state.shouldExit(this)) {
            state.willExit();
        }
    }

    public Values getReportable() {
        String inputPathString = this.inputPath != null ? this.inputPath.getPathString() : null;
        String flowIdPathString = this.flowIdPath != null ? this.flowIdPath.getPathString() : null;
        Object[][] o = new Object[][]{{KEY_SPAWN_INPUT, inputPathString}, {KEY_SPAWN_FLOWID, flowIdPathString}, {KEY_SPAWN_SERVICE, this.service != null ? this.service.getNodeName().toString() : null}};
        return super.getReportable().copyFrom(new Values(o));
    }
}

