/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowRoot;
import com.wm.lang.flow.FlowState;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSPackage;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSServiceType;
import com.wm.lang.ns.Namespace;
import com.wm.util.Values;

public abstract class FlowService
extends NSService {
    public static final NSServiceType SVC_FLOW = NSServiceType.create("flow", "default");
    FlowRoot flow;
    String parentWSD;
    public static final String KEY_FLOW_ROOT = "flow";
    public static final String KEY_FLOW_PARENT_WSD = "parentWsd";

    public FlowService(Namespace ns, NSPackage pkg, NSName node, FlowRoot flow) {
        super(ns, pkg, node, SVC_FLOW);
        this.flow = flow;
    }

    protected FlowService(Namespace ns, Values vals) {
        super(ns, vals);
    }

    public FlowRoot getFlowRoot() {
        return this.flow;
    }

    public void setFlowRoot(FlowRoot fr) {
        this.flow = fr;
    }

    public String getParentWSD() {
        return this.parentWSD;
    }

    public void setParentWSD(String parent) {
        this.parentWSD = parent;
    }

    public Values getValues() {
        Values v = super.getValues();
        v.put(KEY_FLOW_ROOT, this.flow);
        v.put(KEY_FLOW_PARENT_WSD, this.parentWSD);
        return v;
    }

    public void setValues(Values val) {
        super.setValues(val);
        this.flow = FlowRoot.createRoot(val.getValues(KEY_FLOW_ROOT));
        this.parentWSD = val.getString(KEY_FLOW_PARENT_WSD);
    }

    public IData getAsData() {
        Values v = super.getValues();
        IDataCursor ic = v.getCursor();
        if (this.flow != null) {
            IDataUtil.put(ic, KEY_FLOW_ROOT, this.flow);
        }
        if (this.parentWSD != null) {
            IDataUtil.put(ic, KEY_FLOW_PARENT_WSD, this.parentWSD);
        }
        ic.destroy();
        return v;
    }

    public void setFromData(IData val) {
        super.setValues(Values.use(val));
        IDataCursor ic = val.getCursor();
        this.flow = FlowRoot.createRoot(IDataUtil.getIData(ic, KEY_FLOW_ROOT));
        this.parentWSD = IDataUtil.getString(ic, KEY_FLOW_PARENT_WSD);
        ic.destroy();
    }

    public abstract Values invoke(Values var1) throws Exception;

    public abstract IData invoke(IData var1) throws Exception;

    public abstract FlowState invokeMonitor(Values var1);

    public abstract FlowState invokeMonitor(IData var1);

    public abstract FlowState invokeMonitorInto(Values var1, FlowState var2);

    public abstract FlowState invokeMonitorInto(IData var1, FlowState var2);
}

