/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowExceptionHandler;
import com.wm.lang.flow.FlowState;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.util.JournalLogger;
import com.wm.util.Values;

public class FlowSequence
extends FlowElement {
    static final int FAILURE = 0;
    static final int SUCCESS = 1;
    static final int DONE = 2;
    public static final String KEY_SEQUENCE_EXITON = "exit-on";
    public static final String[] exitonOptions = new String[]{"FAILURE", "SUCCESS", "DONE"};
    int exiton;
    IData save_pipeline;
    boolean start;
    boolean map;
    static final String KEY_SEQUENCE_STATE_SAVEPIPELINE = "savePipeline";
    static final String KEY_SEQUENCE_STATE_START = "start";
    static final String KEY_SEQUENCE_STATE_MAP = "map";
    static final String VALUE_SUCCESS = "SUCCESS";
    static final String VALUE_FAILURE = "FAILURE";
    static final String VALUE_DONE = "DONE";

    public FlowSequence(Values val) {
        super(val);
        this.type = "SEQUENCE";
    }

    public FlowSequence(IData val) {
        super(val);
        this.type = "SEQUENCE";
    }

    public NSRecord getProperties() {
        NSRecord prop = super.getProperties();
        NSField exiton = new NSField(null, KEY_SEQUENCE_EXITON, 1, 0);
        exiton.setStringOptions(exitonOptions);
        prop.addField(exiton);
        return prop;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_SEQUENCE_EXITON, this.exiton == 1 ? VALUE_SUCCESS : (this.exiton == 2 ? VALUE_DONE : VALUE_FAILURE)}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        super.setValues(val);
        try {
            String eo = val.getString(KEY_SEQUENCE_EXITON);
            if (eo == null || eo.equalsIgnoreCase(VALUE_FAILURE)) {
                this.exiton = 0;
            } else if (eo.equalsIgnoreCase(VALUE_SUCCESS)) {
                this.exiton = 1;
            } else if (eo.equalsIgnoreCase(VALUE_DONE)) {
                this.exiton = 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IData getAsData() {
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        IDataUtil.put(ic, KEY_SEQUENCE_EXITON, this.exiton == 1 ? VALUE_SUCCESS : (this.exiton == 2 ? VALUE_DONE : VALUE_FAILURE));
        ic.destroy();
        return val;
    }

    public void setFromData(IData val) {
        if (val == null) {
            return;
        }
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        try {
            String eo = IDataUtil.getString(ic, KEY_SEQUENCE_EXITON);
            if (eo == null || eo.equalsIgnoreCase(VALUE_FAILURE)) {
                this.exiton = 0;
            } else if (eo.equalsIgnoreCase(VALUE_SUCCESS)) {
                this.exiton = 1;
            } else if (eo.equalsIgnoreCase(VALUE_DONE)) {
                this.exiton = 2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ic.destroy();
    }

    public Values getStateValues() {
        Object[][] o = new Object[][]{{KEY_SEQUENCE_STATE_SAVEPIPELINE, this.save_pipeline}, {KEY_SEQUENCE_STATE_START, String.valueOf(this.start)}, {KEY_SEQUENCE_STATE_MAP, String.valueOf(this.map)}};
        return super.getStateValues().copyFrom(this.getValues()).copyFrom(new Values(o));
    }

    public void setStateValues(Values val) {
        super.setStateValues(val);
        this.setValues(val);
        this.save_pipeline = IDataUtil.clone(val.getValues(KEY_SEQUENCE_STATE_SAVEPIPELINE));
        this.start = val.getBoolean(KEY_SEQUENCE_STATE_START);
        this.map = val.getBoolean(KEY_SEQUENCE_STATE_MAP);
    }

    public void init(FlowState state) {
        this.save_pipeline = IDataUtil.clone(state.getPipeline());
        this.start = true;
    }

    public void invoke(FlowState state) {
        if (!FlowState.isRoot(this) && JournalLogger.isLogEnabled(8, 49, 7)) {
            JournalLogger.log(8, 49, 7, this.getDebugLabel(), state.toString());
        }
        boolean disabled = false;
        FlowElement fe = state.last();
        if (fe != null && !fe.isEnabled()) {
            disabled = true;
        }
        if (state.shouldExit(this) || state.getError() == null && this.exiton == 1 && !this.start && !this.map && !disabled || state.getError() != null && this.exiton == 0) {
            state.setDone(true);
            state.willExit();
            return;
        }
        if (state.getError() != null) {
            FlowExceptionHandler fex = state.getFlowExceptionHandler();
            if (fex != null) {
                fex.resetException();
            }
            state.clearError();
            IData pipe = state.getPipeline();
            IDataCursor cursor = pipe.getCursor();
            if (cursor.first()) {
                while (cursor.delete()) {
                }
            }
            cursor.destroy();
            IDataUtil.append(this.save_pipeline, pipe);
        } else {
            this.save_pipeline = IDataUtil.clone(state.getPipeline());
        }
        if (state.pushNextNode() == null) {
            state.setDone(true);
        } else {
            this.map = state.current().type.equals("MAP");
        }
        if (this.start) {
            this.start = false;
        }
    }
}

