/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowSequence;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.sig.SignatureState;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.Namespace;
import com.wm.util.Values;
import java.util.StringTokenizer;

public class FlowRoot
extends FlowSequence {
    public static final String KEY_ROOT_VERSION = "version";
    public static final String KEY_ROOT_CLEANUP = "cleanup";
    public static final String FLOW_VERSION = "3.0";
    public static final String KEY_ROOT_PERSISTABLE = "persistable";
    public static final String KEY_ROOT_PARENT_WSD = "parentWsd";
    public static final String KEY_ELEMENT_STARTX = "start-x";
    public static final String KEY_ELEMENT_STARTY = "start-y";
    public static final String KEY_ELEMENT_ENDX = "end-x";
    public static final String KEY_ELEMENT_ENDY = "end-y";
    public static final String KEY_ELEMENT_ZOOM = "zoom";
    private int startX;
    private int startY;
    private int endX;
    private int endY;
    private int zoom;
    private boolean persistable;
    private String parentWSD;
    String version = "3.0";
    boolean cleanup;
    boolean isInitialized;
    String name;
    SignatureState sigState;
    FlowElement currentElement;
    Integer lock = new Integer(0);

    public FlowRoot(Values val) {
        super(val);
        this.type = "ROOT";
    }

    public FlowRoot(IData val) {
        super(val);
        this.type = "ROOT";
    }

    public static FlowRoot createRoot(Values val) {
        if (val == null) {
            return null;
        }
        FlowRoot x = new FlowRoot(val);
        x.setValues(val);
        return x;
    }

    public static FlowRoot createRoot(IData val) {
        if (val == null) {
            return null;
        }
        FlowRoot x = new FlowRoot(val);
        x.setFromData(val);
        return x;
    }

    public NSRecord getProperties() {
        NSRecord prop = super.getProperties();
        prop.addField(new NSField(null, KEY_ROOT_VERSION, 1, 0));
        prop.addField(new NSField(null, KEY_ROOT_CLEANUP, 1, 0));
        return prop;
    }

    public Values getValues() {
        Values v = super.getValues();
        v.remove("exit-on");
        Object[][] o = new Object[][]{{KEY_ROOT_VERSION, this.version}, {KEY_ROOT_CLEANUP, String.valueOf(this.cleanup)}, {KEY_ELEMENT_STARTX, this.startX != 0 ? String.valueOf(this.startX) : null}, {KEY_ELEMENT_STARTY, this.startY != 0 ? String.valueOf(this.startY) : null}, {KEY_ELEMENT_ENDX, this.endX != 0 ? String.valueOf(this.endX) : null}, {KEY_ELEMENT_ENDY, this.endY != 0 ? String.valueOf(this.endY) : null}, {KEY_ELEMENT_ZOOM, this.zoom != 100 ? String.valueOf(this.zoom) : null}, {KEY_ROOT_PERSISTABLE, this.persistable ? "true" : null}, {KEY_ROOT_PARENT_WSD, this.parentWSD}};
        Values temp = v.copyFrom(new Values(o));
        return temp;
    }

    public void setValues(Values val) {
        super.setValues(val);
        if (val == null) {
            return;
        }
        try {
            if (val.containsKey(KEY_ROOT_VERSION)) {
                this.version = val.getString(KEY_ROOT_VERSION);
            }
            this.cleanup = val.containsKey(KEY_ROOT_CLEANUP) ? Boolean.valueOf(val.getString(KEY_ROOT_CLEANUP)) : true;
            this.startX = val.getInt(KEY_ELEMENT_STARTX, 0);
            this.startY = val.getInt(KEY_ELEMENT_STARTY, 0);
            this.endX = val.getInt(KEY_ELEMENT_ENDX, 0);
            this.endY = val.getInt(KEY_ELEMENT_ENDY, 0);
            this.zoom = val.getInt(KEY_ELEMENT_ZOOM, 100);
            this.persistable = val.getBoolean(KEY_ROOT_PERSISTABLE);
            this.parentWSD = val.getString(KEY_ROOT_PARENT_WSD);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IData getAsData() {
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        if (ic.first("exit-on")) {
            ic.delete();
        }
        IDataUtil.put(ic, KEY_ROOT_VERSION, this.version);
        IDataUtil.put(ic, KEY_ROOT_CLEANUP, String.valueOf(this.cleanup));
        if (this.startX != 0) {
            IDataUtil.put(ic, KEY_ELEMENT_STARTX, String.valueOf(this.startX));
        }
        if (this.startY != 0) {
            IDataUtil.put(ic, KEY_ELEMENT_STARTY, String.valueOf(this.startY));
        }
        if (this.endX != 0) {
            IDataUtil.put(ic, KEY_ELEMENT_ENDX, String.valueOf(this.endX));
        }
        if (this.endY != 0) {
            IDataUtil.put(ic, KEY_ELEMENT_ENDY, String.valueOf(this.endY));
        }
        if (this.zoom != 100) {
            IDataUtil.put(ic, KEY_ELEMENT_ZOOM, String.valueOf(this.zoom));
        }
        if (this.persistable) {
            IDataUtil.put(ic, KEY_ROOT_PERSISTABLE, "true");
        }
        IDataUtil.put(ic, KEY_ROOT_PARENT_WSD, this.parentWSD);
        ic.destroy();
        return val;
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        if (val == null) {
            return;
        }
        IDataCursor ic = val.getCursor();
        try {
            if (ic.first(KEY_ROOT_VERSION)) {
                this.version = IDataUtil.getString(ic, KEY_ROOT_VERSION);
            }
            this.cleanup = ic.first(KEY_ROOT_CLEANUP) ? Boolean.valueOf(IDataUtil.getString(ic, KEY_ROOT_CLEANUP)) : true;
            this.startX = IDataUtil.getInt(ic, KEY_ELEMENT_STARTX, 0);
            this.startY = IDataUtil.getInt(ic, KEY_ELEMENT_STARTY, 0);
            this.endX = IDataUtil.getInt(ic, KEY_ELEMENT_ENDX, 0);
            this.endY = IDataUtil.getInt(ic, KEY_ELEMENT_ENDY, 0);
            this.zoom = IDataUtil.getInt(ic, KEY_ELEMENT_ZOOM, 100);
            if (ic.first(KEY_ROOT_PERSISTABLE)) {
                this.persistable = IDataUtil.getBoolean(ic);
            }
            if (ic.first(KEY_ROOT_PARENT_WSD)) {
                this.parentWSD = IDataUtil.getString(ic);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ic.destroy();
    }

    public Values getStateValues() {
        return super.getStateValues().copyFrom(this.getValues());
    }

    public void setStateValues(Values val) {
        super.setStateValues(val);
        this.setValues(val);
    }

    public String getParentWSD() {
        return this.parentWSD;
    }

    public void setParentWSD(String parent) {
        this.parentWSD = parent;
    }

    public void setNSName(String name) {
        this.name = name;
    }

    public String getNSName() {
        return this.name;
    }

    public FlowElement getNode(String path) {
        if (path == null) {
            return null;
        }
        FlowElement next = this;
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreElements()) {
            int node = Integer.parseInt(st.nextToken());
            next = next.getNodeAt(node);
        }
        return next;
    }

    public void invoke(FlowState state) {
        super.invoke(state);
    }

    public void init(FlowState state) {
        this.save_pipeline = state.getPipeline();
        this.start = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(Namespace ns) {
        if (this.isInitialized) {
            return;
        }
        Integer n = this.lock;
        synchronized (n) {
            if (this.isInitialized) {
                return;
            }
            super.init(ns);
            this.isInitialized = true;
        }
    }

    public SignatureState getSignatureState(Namespace ns, NSSignature sig) {
        if (this.sigState == null) {
            this.sigState = new SignatureState(this, ns, sig);
        }
        return this.sigState;
    }

    public int getStartX() {
        return this.startX;
    }

    public void setStartX(int newSX) {
        this.startX = newSX;
    }

    public int getStartY() {
        return this.startY;
    }

    public void setStartY(int newSY) {
        this.startY = newSY;
    }

    public int getEndX() {
        return this.endX;
    }

    public void setEndX(int newEX) {
        this.endX = newEX;
    }

    public int getEndY() {
        return this.endY;
    }

    public void setEndY(int newEY) {
        this.endY = newEY;
    }

    public int getZoom() {
        return this.zoom;
    }

    public void setZoom(int newZoom) {
        this.zoom = newZoom;
    }

    public void setPersistable(boolean flag) {
        this.persistable = flag;
    }

    public boolean isPersistable() {
        return this.persistable;
    }

    public FlowElement getSelectedElement() {
        return this.currentElement;
    }

    public void setSelectedElement(FlowElement element) {
        this.currentElement = element;
    }
}

