/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.MapSet;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.util.JournalLogger;
import com.wm.util.Values;

public class FlowRetry
extends FlowElement {
    static final boolean SUCCESS = true;
    static final boolean FAILURE = false;
    public static final String KEY_RETRY_MAXCOUNT = "count";
    public static final String KEY_RETRY_BACKOFF = "backoff";
    public static final String KEY_RETRY_LOOPON = "repeat-on";
    static final String[] looponOptions = new String[]{"FAILURE", "SUCCESS"};
    public static final String KEY_RETRY_COUNT = "$retries";
    long backoff_ms;
    String backoffString;
    Object[] backoffSubList;
    boolean loopon;
    int count;
    String countString;
    Object[] countSubList;
    IData save_pipeline;
    int retries;
    static final String KEY_RETRY_STATE_SAVEPIPELINE = "savePipeline";
    static final String KEY_RETRY_STATE_RETRIES = "retries";

    public FlowRetry(Values val) {
        super(val);
        this.type = "RETRY";
    }

    public NSRecord getProperties() {
        NSRecord params = super.getProperties();
        params.addField(new NSField(null, KEY_RETRY_MAXCOUNT, 1, 0));
        params.addField(new NSField(null, KEY_RETRY_BACKOFF, 1, 0));
        NSField loopon = new NSField(null, KEY_RETRY_LOOPON, 1, 0);
        loopon.setStringOptions(looponOptions);
        params.addField(loopon);
        return params;
    }

    public String getDisplayType() {
        return "REPEAT";
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_RETRY_MAXCOUNT, this.countString}, {KEY_RETRY_BACKOFF, this.backoffString}, {KEY_RETRY_LOOPON, this.loopon ? "SUCCESS" : "FAILURE"}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        super.setValues(val);
        try {
            String LO;
            this.countString = val.getString(KEY_RETRY_MAXCOUNT);
            this.countSubList = MapSet.processPath(MapSet.parseVars(this.countString));
            if (this.countSubList == null) {
                this.count = val.getInt(KEY_RETRY_MAXCOUNT);
            }
            this.loopon = (LO = val.getString(KEY_RETRY_LOOPON)) != null ? LO.equalsIgnoreCase("success") : false;
            this.backoffString = val.getString(KEY_RETRY_BACKOFF);
            this.backoffSubList = MapSet.processPath(MapSet.parseVars(this.backoffString));
            if (this.backoffSubList == null) {
                this.backoff_ms = FlowElement.convertTime(this.backoffString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IData getAsData() {
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        if (this.countString != null) {
            IDataUtil.put(ic, KEY_RETRY_MAXCOUNT, this.countString);
        }
        if (this.backoffString != null) {
            IDataUtil.put(ic, KEY_RETRY_BACKOFF, this.backoffString);
        }
        IDataUtil.put(ic, KEY_RETRY_LOOPON, this.loopon ? "SUCCESS" : "FAILURE");
        ic.destroy();
        return val;
    }

    public void setFromData(IData val) {
        if (val == null) {
            return;
        }
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        try {
            String LO;
            this.countString = IDataUtil.getString(ic, KEY_RETRY_MAXCOUNT);
            this.countSubList = MapSet.processPath(MapSet.parseVars(this.countString));
            if (this.countSubList == null) {
                this.count = ic.first(KEY_RETRY_MAXCOUNT) ? IDataUtil.getInt(ic) : 0;
            }
            this.loopon = (LO = IDataUtil.getString(ic, KEY_RETRY_LOOPON)) != null ? LO.equalsIgnoreCase("success") : false;
            this.backoffString = IDataUtil.getString(ic, KEY_RETRY_BACKOFF);
            this.backoffSubList = MapSet.processPath(MapSet.parseVars(this.backoffString));
            if (this.backoffSubList == null) {
                this.backoff_ms = FlowElement.convertTime(this.backoffString);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ic.destroy();
    }

    public Values getStateValues() {
        Object[][] o = new Object[][]{{KEY_RETRY_STATE_SAVEPIPELINE, this.save_pipeline}, {KEY_RETRY_STATE_RETRIES, String.valueOf(this.retries)}};
        return super.getStateValues().copyFrom(this.getValues()).copyFrom(new Values(o));
    }

    public void setStateValues(Values val) {
        super.setStateValues(val);
        this.setValues(val);
        this.save_pipeline = val.getValues(KEY_RETRY_STATE_SAVEPIPELINE);
        this.retries = val.getInt(KEY_RETRY_STATE_RETRIES);
    }

    public void init(FlowState state) {
        this.save_pipeline = IDataUtil.clone(state.getPipeline());
        this.retries = 0;
        if (this.countSubList != null) {
            try {
                IData preScopePipeLine = state.getPipeline();
                IData scopedPipeLine = state.getScope(this, preScopePipeLine);
                String s = null;
                s = scopedPipeLine != null ? MapSet.substituteVars(this.countSubList, scopedPipeLine) : MapSet.substituteVars(this.countSubList, preScopePipeLine);
                this.count = Integer.valueOf(s);
            }
            catch (Exception e) {
                this.count = -1;
            }
        }
        if (this.backoffSubList != null) {
            String s = MapSet.substituteVars(this.backoffSubList, state.getPipeline());
            this.backoff_ms = FlowRetry.convertTime(s);
        }
    }

    public void invoke(FlowState state) {
        IData pipeline;
        IDataCursor cursor;
        if (JournalLogger.isLogEnabled(7, 49, 7)) {
            JournalLogger.log(7, 49, 7, this.getDebugLabel(), state.toString());
        }
        if (state.shouldExit(this)) {
            state.willExit();
            state.setDone(true);
        } else {
            if (!state.hasMoreNodes() || state.getError() != null) {
                if (state.getError() != null && !this.loopon || state.getError() == null && this.loopon) {
                    ++this.retries;
                    if (this.count >= 0 && this.retries > this.count) {
                        state.setDone(true);
                    } else {
                        if (JournalLogger.isLogEnabled(17, 49, 7)) {
                            JournalLogger.log(17, 49, 7, String.valueOf(this.retries), String.valueOf(this.count));
                        }
                        if (state.getError() != null) {
                            state.clearError();
                            IData pipe = state.getPipeline();
                            cursor = pipe.getCursor();
                            if (cursor.first()) {
                                while (cursor.delete()) {
                                }
                            }
                            cursor.destroy();
                            IDataUtil.append(this.save_pipeline, pipe);
                        }
                        if ((cursor = (pipeline = state.getPipeline()).getCursor()).first(KEY_RETRY_COUNT)) {
                            cursor.setValue(String.valueOf(this.retries));
                        } else {
                            cursor.insertAfter(KEY_RETRY_COUNT, String.valueOf(this.retries));
                        }
                        state.setNextNode(0);
                        if (!state.ignoreTimeouts && this.backoff_ms > 0L) {
                            try {
                                Thread.currentThread();
                                Thread.sleep(this.backoff_ms);
                            }
                            catch (Exception e) {}
                        }
                    }
                } else {
                    state.setDone(true);
                }
            }
            if (state.pushNextNode() == null) {
                state.setDone(true);
            }
        }
        if (state.current().isDone() && (cursor = (pipeline = state.getPipeline()).getCursor()).first(KEY_RETRY_COUNT)) {
            cursor.delete();
        }
    }
}

