/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowInvoke;
import com.wm.lang.flow.FlowMap;
import com.wm.lang.flow.FlowMapCopy;
import com.wm.lang.flow.FlowMapDelete;
import com.wm.lang.flow.FlowMapSet;
import com.wm.lang.flow.FlowRoot;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.ServicePathInfo;
import com.wm.lang.ns.WmPathItem;

public class FlowPathInfo
extends ServicePathInfo {
    private static final String VERSION_TAG = "Flow Path";
    private static final String VERSION_NUMBER = "1.0";
    private static FlowPathInfo _instance;

    protected FlowPathInfo() {
    }

    public static ServicePathInfo current() {
        if (_instance == null) {
            _instance = new FlowPathInfo();
        }
        return _instance;
    }

    protected String getVersionTag() {
        return VERSION_TAG;
    }

    protected String getVersionNumber() {
        return VERSION_NUMBER;
    }

    public String createPath(FlowElement node, String attr, String attrPath) {
        if (node == null) {
            return null;
        }
        StringBuffer p = new StringBuffer(this.createVersion());
        this.createPath(p, node, attr, attrPath);
        return p.toString();
    }

    public String createPath(FlowElement node) {
        return this.createPath(node, null, null);
    }

    private void createPath(StringBuffer path, FlowElement node, String attr, String attrPath) {
        if (node instanceof FlowRoot) {
            return;
        }
        FlowElement parent = node.getParent();
        this.createPath(path, parent, null, null);
        if (parent instanceof FlowInvoke && node instanceof FlowMap) {
            attr = parent.getInputMap() == node ? "input_map" : "output_map";
            ServicePathInfo.ServicePathItem item = new ServicePathInfo.ServicePathItem(attr, -2, null);
            path.append(item.toString());
        } else {
            ServicePathInfo.ServicePathItem item = new ServicePathInfo.ServicePathItem(node.getFlowType(), this.indexOf(parent, node), null);
            path.append(item.toString());
            if (attr != null) {
                item = new ServicePathInfo.ServicePathItem(attr, -2, attrPath);
                path.append(item.toString());
            }
        }
    }

    private int indexOf(FlowElement parent, FlowElement node) {
        int size = parent.nodes.size();
        for (int i = 0; i < size; ++i) {
            if (node != parent.nodes.elementAt(i)) continue;
            return i;
        }
        return -1;
    }

    public Object get(FlowRoot root, String path) {
        if (root == null || path == null) {
            return null;
        }
        ServicePathInfo.ServicePathItem[] items = null;
        try {
            items = this.parsePath(path);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (items == null) {
            return null;
        }
        FlowElement parent = root;
        for (int i = 0; i < items.length; ++i) {
            Object o = this.get(parent, items[i]);
            if (!(o instanceof FlowElement)) {
                return o;
            }
            parent = (FlowElement)o;
        }
        return parent;
    }

    public Object[] getPathNodes(FlowRoot root, String path) {
        if (root == null || path == null) {
            return null;
        }
        ServicePathInfo.ServicePathItem[] items = null;
        try {
            items = this.parsePath(path);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (items == null) {
            return null;
        }
        Object[] nodes = new Object[items.length];
        FlowElement parent = root;
        for (int i = 0; i < items.length; ++i) {
            Object o;
            nodes[i] = o = this.get(parent, items[i]);
            if (!(o instanceof FlowElement)) {
                return nodes;
            }
            parent = (FlowElement)o;
        }
        return nodes;
    }

    public Object get(FlowElement parent, ServicePathInfo.ServicePathItem item) {
        if (item.getIndex() >= 0) {
            return parent.getNodeAt(item.getIndex());
        }
        if (item.getIndex() == -1) {
            return null;
        }
        String attr = item.getType();
        if (parent instanceof FlowInvoke) {
            if ("input_map".equals(attr)) {
                return parent.getInputMap();
            }
            if ("output_map".equals(attr)) {
                return parent.getOutputMap();
            }
            return null;
        }
        if (parent.getParent() instanceof FlowMap) {
            String field = null;
            if (parent instanceof FlowMapCopy && "to_field".equals(attr)) {
                field = ((FlowMapCopy)parent).getMapTo();
            } else if (parent instanceof FlowMapCopy && "from_field".equals(attr)) {
                field = ((FlowMapCopy)parent).getMapFrom();
            } else if (parent instanceof FlowMapSet && "field".equals(attr)) {
                field = ((FlowMapSet)parent).getField();
            } else if (parent instanceof FlowMapDelete && "field".equals(attr)) {
                field = ((FlowMapDelete)parent).getField();
            }
            return field;
        }
        return null;
    }

    public Object set(FlowRoot root, Object node, String path) {
        if (root == null || path == null) {
            return null;
        }
        ServicePathInfo.ServicePathItem[] items = null;
        try {
            items = this.parsePath(path);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (items == null) {
            return null;
        }
        FlowElement parent = root;
        for (int i = 0; i < items.length - 1; ++i) {
            Object o = this.get(parent, items[i]);
            if (!(o instanceof FlowElement)) {
                return null;
            }
            parent = (FlowElement)o;
        }
        int index = items[items.length - 1].getIndex();
        if (index >= 0 && node instanceof FlowElement) {
            FlowElement ret = parent.getNodeAt(index);
            parent.setNodeAt((FlowElement)node, index);
            return ret;
        }
        if (index == -1) {
            return null;
        }
        String attr = items[items.length - 1].getType();
        if (parent.getParent() instanceof FlowMap && node instanceof String) {
            String field = (String)node;
            String ret = null;
            if (parent instanceof FlowMapCopy) {
                if ("to_field".equals(attr)) {
                    ret = ((FlowMapCopy)parent).getMapTo();
                    ((FlowMapCopy)parent).setMapTo(field);
                } else if ("from_field".equals(attr)) {
                    ret = ((FlowMapCopy)parent).getMapFrom();
                    ((FlowMapCopy)parent).setMapFrom(field);
                }
            } else if (parent instanceof FlowMapSet && "field".equals(attr)) {
                ret = ((FlowMapSet)parent).getField();
                ((FlowMapSet)parent).setField(field);
            } else if (parent instanceof FlowMapDelete && "field".equals(attr)) {
                ret = ((FlowMapDelete)parent).getField();
                ((FlowMapDelete)parent).setField(field);
            }
            return ret;
        }
        if (parent instanceof FlowInvoke && node instanceof FlowMap) {
            FlowMap ret = null;
            if ("input_map".equals(attr)) {
                ret = parent.getInputMap();
                parent.setInputMap((FlowMap)node);
            } else if ("output_map".equals(attr)) {
                ret = parent.getOutputMap();
                parent.setOutputMap((FlowMap)node);
            }
            return ret;
        }
        return null;
    }

    public String validateMapPath(FlowRoot root, String path, NSRecord record) {
        if (root == null || path == null || record == null) {
            return null;
        }
        Object o = this.get(root, path);
        if (!(o instanceof String)) {
            return null;
        }
        MapWmPathInfo pathInfo = MapWmPathInfo.create((String)o);
        if (pathInfo == null) {
            return null;
        }
        WmPathItem[] items = pathInfo.getPathItems();
        String targetName = record.getNSName().toString();
        for (int i = 0; i < items.length - 1; ++i) {
            if (!targetName.equals(items[i].getNSName())) continue;
            NSRecord parent = record;
            for (int j = i + 1; j < items.length - 1; ++j) {
                NSField field = NSRecordWmPathProcessor.get(parent, items[j]);
                if (!(field instanceof NSRecord)) {
                    StringBuffer sb = new StringBuffer();
                    for (int k = 0; k <= j; ++k) {
                        sb.append(items[k].toString());
                    }
                    return sb.toString();
                }
                parent = (NSRecord)field;
            }
            if (NSRecordWmPathProcessor.get(parent, items[items.length - 1]) == null) {
                return (String)o;
            }
            return null;
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

