/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.util.JournalLogger;
import com.wm.util.Values;

public class FlowNotify
extends FlowElement {
    public static final String KEY_NOTIFY_INPUT = "input";
    public static final String KEY_NOTIFY_FLOWID = "flowId";
    MapWmPathInfo inputPath;
    MapWmPathInfo flowIdPath;

    public FlowNotify(Values val) {
        super(val);
        this.type = "NOTIFY";
    }

    public NSRecord getProperties() {
        NSRecord params = super.getProperties();
        params.addField(new NSField(null, KEY_NOTIFY_INPUT, 1, 0));
        params.addField(new NSField(null, KEY_NOTIFY_FLOWID, 1, 0));
        return params;
    }

    public String getFlowIdPath() {
        return this.flowIdPath == null ? null : this.flowIdPath.getPathString();
    }

    public String getIntputPath() {
        return this.inputPath == null ? null : this.inputPath.getPathString();
    }

    public boolean hasNodes() {
        return false;
    }

    public Values getValues() {
        String inputPathString = this.inputPath != null ? this.inputPath.getPathString() : null;
        String flowIdPathString = this.flowIdPath != null ? this.flowIdPath.getPathString() : null;
        Object[][] o = new Object[][]{{KEY_NOTIFY_INPUT, inputPathString}, {KEY_NOTIFY_FLOWID, flowIdPathString}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
        this.inputPath = MapWmPathInfo.create(val.getString(KEY_NOTIFY_INPUT));
        this.flowIdPath = MapWmPathInfo.create(val.getString(KEY_NOTIFY_FLOWID));
    }

    public IData getAsData() {
        String inputPathString = this.inputPath != null ? this.inputPath.getPathString() : null;
        String flowIdPathString = this.flowIdPath != null ? this.flowIdPath.getPathString() : null;
        IData val = super.getAsData();
        IDataCursor ic = val.getCursor();
        IDataUtil.put(ic, KEY_NOTIFY_INPUT, inputPathString);
        IDataUtil.put(ic, KEY_NOTIFY_FLOWID, flowIdPathString);
        ic.destroy();
        return val;
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this.inputPath = MapWmPathInfo.create(IDataUtil.getString(ic, KEY_NOTIFY_INPUT));
        this.flowIdPath = MapWmPathInfo.create(IDataUtil.getString(ic, KEY_NOTIFY_FLOWID));
        ic.destroy();
    }

    public Values getStateValues() {
        return super.getStateValues();
    }

    public void setStateValues(Values val) {
        super.setStateValues(val);
        this.setValues(val);
    }

    public void init(FlowState state) {
    }

    public void invoke(FlowState state) {
        if (JournalLogger.isLogEnabled(6, 49, 7)) {
            JournalLogger.log(6, 49, 7, this.getDebugLabel(), state.toString());
        }
        if (state.shouldExit(this)) {
            state.willExit();
        }
    }

    public Values getReportable() {
        String inputPathString = this.inputPath != null ? this.inputPath.getPathString() : null;
        String flowIdPathString = this.flowIdPath != null ? this.flowIdPath.getPathString() : null;
        Object[][] o = new Object[][]{{KEY_NOTIFY_INPUT, inputPathString}, {KEY_NOTIFY_FLOWID, flowIdPathString}};
        return super.getReportable().copyFrom(new Values(o));
    }
}

