/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.MapError;
import com.wm.lang.flow.MapIf;
import com.wm.lang.flow.MapSet;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.MapWmPathUtil;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.WmPathInfo;
import com.wm.util.Base64;
import com.wm.util.ByteOutputBuffer;
import com.wm.util.EncUtil;
import com.wm.util.JournalLogger;
import com.wm.util.Values;
import com.wm.util.coder.XMLCoder;
import java.io.IOException;

public class FlowMapSet
extends FlowElement
implements MapIf {
    private static final boolean debug = false;
    public static final String FIELD = "field";
    public static final String IS_STRING = "isString";
    public static final String ENCODING_BASE64 = "b64";
    public static final String ENCODING_XML_VALUES = "XMLValues";
    static final String XMLHEADER = "<?xml version=\"1.0\"?>\n\n";
    static final String XMLUTF8HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n";
    XMLCoder coder;
    String field;
    boolean sourceIsUTF8 = false;
    String position;
    String encoding;
    boolean overwrite;
    boolean variables;
    String className;
    NSField dtype;
    Object data;
    public static final String KEY_RULE_FIELD = "field";
    public static final String KEY_RULE_OVERWRITE = "overwrite";
    public static final String KEY_RULE_VARIABLES = "variables";
    public static final String KEY_RULE_CLASSNAME = "className";
    public static final String KEY_RULE_DATA = "data";
    public static final String KEY_RULE_DATATYPE = "dtype";
    public static final String KEY_RULE_DENC = "d_enc";
    public static final String KEY_RULE_I18N = "mapseti18n";
    public static final String KEY_RULE_POSITION = "fieldPosition";
    public static final String POSITION_SOURCE = "source";
    public static final String POSITION_TARGET = "target";
    MapSet mapSet;
    MapWmPathInfo mapPath;

    public FlowMapSet(Values val) {
        super(val);
        this.type = "MAPSET";
    }

    public Object deepClone() {
        FlowMapSet clonedFlowMapSet = (FlowMapSet)super.deepClone();
        try {
            IData[] clonedDataArray;
            if (this.data != null && this.data instanceof IData[]) {
                IData[] localData = (IData[])this.data;
                clonedDataArray = new IData[localData.length];
                for (int i = 0; i < localData.length; ++i) {
                    clonedDataArray[i] = IDataUtil.deepClone(localData[i]);
                }
            } else {
                return clonedFlowMapSet;
            }
            clonedFlowMapSet.setInput(clonedDataArray);
        }
        catch (IOException x) {
            System.err.println(x);
        }
        return clonedFlowMapSet;
    }

    public void invoke(FlowState state) {
        throw new RuntimeException("Cannot invoke " + this.getFlowType() + " elements");
    }

    public boolean hasNodes() {
        return false;
    }

    public String getField() {
        return this.field;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public boolean isVariables() {
        return this.variables;
    }

    public String getClassName() {
        return this.className;
    }

    public Object getInput() {
        return this.data;
    }

    public NSField getInputType() {
        return this.dtype;
    }

    public String getFieldPosition() {
        return this.position;
    }

    public void setEncoding(String encode) {
        this.encoding = encode;
    }

    public void setOverwrite(boolean b) {
        this.overwrite = b;
    }

    public void setVariables(boolean b) {
        this.variables = b;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public void setInput(Object data) {
        this.data = data;
    }

    public void setInputType(NSField dtype) {
        this.dtype = dtype;
    }

    public void setFieldPosition(String position) {
        this.position = position;
    }

    public void setField(String field) {
        this.field = field;
        this.mapPath = MapWmPathInfo.create(field);
        if (this.mapPath == null) {
            throw new IllegalArgumentException("Illegal path: " + field);
        }
    }

    public void setField(String name, int type, int dim) {
        this.setField(WmPathInfo.getPath(name, type, dim));
    }

    public void setField(String[] names, int[] types, int[] dims) {
        this.setField(WmPathInfo.getPath(names, types, dims));
    }

    public Values getValues() {
        Values parData = new Values();
        this.sourceIsUTF8 = true;
        parData.put("field", this.field);
        if (this.encoding == null) {
            this.encoding = ENCODING_XML_VALUES;
        }
        parData.put(KEY_RULE_DENC, this.encoding);
        parData.put(KEY_RULE_OVERWRITE, this.overwrite ? "true" : "false");
        parData.put(KEY_RULE_VARIABLES, this.variables ? "true" : "false");
        if (this.className != null) {
            parData.put(KEY_RULE_CLASSNAME, this.className);
        }
        if (this.position != null) {
            parData.put(KEY_RULE_POSITION, this.position);
        }
        if (this.data != null) {
            Object[][] in = new Object[][]{{"xml", this.data}, {"type", this.dtype}};
            if (this.coder == null) {
                this.coder = new XMLCoder(true);
                this.coder.setUseXMLHeader(false);
            }
            if (this.encoding.equals(ENCODING_BASE64)) {
                try {
                    byte[] encData = this.coder.encodeToBytes(new Values(in));
                    parData.put(KEY_RULE_DATA, new String(Base64.encode(encData), "UTF8"));
                }
                catch (Exception e) {
                    JournalLogger.log(13, 49, 4, (Object)e);
                }
            } else if (this.encoding.equals(ENCODING_XML_VALUES)) {
                try {
                    ByteOutputBuffer os = new ByteOutputBuffer();
                    this.coder.encode(os, new Values(in));
                    byte[] encData = os.toByteArray();
                    parData.put(KEY_RULE_DATA, new String(encData, "UTF8"));
                }
                catch (Exception e) {
                    JournalLogger.log(13, 49, 4, (Object)e);
                }
            } else {
                JournalLogger.log(12, 49, 4, (Object)this.encoding);
            }
        }
        parData.put(KEY_RULE_I18N, "true");
        return super.getValues().copyFrom(parData);
    }

    public void setValues(Values val) {
        String str;
        if (val == null) {
            return;
        }
        super.setValues(val);
        this.field = val.getString("field");
        this.encoding = val.getString(KEY_RULE_DENC);
        if (this.encoding == null) {
            this.encoding = ENCODING_XML_VALUES;
        }
        this.overwrite = (str = val.getString(KEY_RULE_OVERWRITE)) == null || !str.equals("false");
        str = val.getString(KEY_RULE_VARIABLES);
        this.variables = str == null || !str.equals("false");
        this.className = val.getString(KEY_RULE_CLASSNAME);
        this.position = val.getString(KEY_RULE_POSITION);
        str = val.getString(KEY_RULE_I18N);
        this.sourceIsUTF8 = str == null || !str.equals("false");
        String raw = val.getString(KEY_RULE_DATA);
        if (raw == null) {
            return;
        }
        if (this.coder == null) {
            this.coder = new XMLCoder(this.sourceIsUTF8);
            this.coder.setUseXMLHeader(false);
        }
        if (this.encoding.equals(ENCODING_BASE64)) {
            try {
                Values decData;
                if (this.sourceIsUTF8) {
                    raw = this.addXMLHeader(Base64.decodeUTF8(raw));
                    decData = this.coder.decodeFromBytes(raw.getBytes("UTF8"));
                } else {
                    raw = this.addXMLHeader(Base64.decode(raw));
                    decData = !EncUtil.getNetEncoding().equals("UTF8") ? this.coder.decodeFromBytes(raw.getBytes(EncUtil.getNetEncoding())) : this.coder.decodeFromBytes(raw.getBytes(EncUtil.getFileEncoding()));
                }
                this.data = decData.get("xml");
                this.dtype = NSField.create(null, decData.getValues("type"));
            }
            catch (Exception e) {
                JournalLogger.log(13, 49, 4, (Object)e);
            }
        } else if (this.encoding.equals(ENCODING_XML_VALUES)) {
            try {
                raw = this.addXMLHeader(raw);
                Values decData = this.sourceIsUTF8 ? this.coder.decodeFromBytes(raw.getBytes("UTF8")) : (!EncUtil.getNetEncoding().equals("UTF8") ? this.coder.decodeFromBytes(raw.getBytes(EncUtil.getNetEncoding())) : this.coder.decodeFromBytes(raw.getBytes(EncUtil.getFileEncoding())));
                this.data = decData.get("xml");
                this.dtype = NSField.create(null, decData.getValues("type"));
            }
            catch (Exception e) {
                JournalLogger.log(13, 49, 4, (Object)e);
            }
        } else {
            JournalLogger.log(12, 49, 4, (Object)this.encoding);
        }
    }

    public IData getAsData() {
        IData parData = super.getAsData();
        IDataCursor ic = parData.getCursor();
        this.sourceIsUTF8 = true;
        IDataUtil.put(ic, "field", this.field);
        if (this.encoding == null) {
            this.encoding = ENCODING_XML_VALUES;
        }
        IDataUtil.put(ic, KEY_RULE_DENC, this.encoding);
        IDataUtil.put(ic, KEY_RULE_OVERWRITE, this.overwrite ? "true" : "false");
        IDataUtil.put(ic, KEY_RULE_VARIABLES, this.variables ? "true" : "false");
        if (this.className != null) {
            IDataUtil.put(ic, KEY_RULE_CLASSNAME, this.className);
        }
        if (this.position != null) {
            IDataUtil.put(ic, KEY_RULE_POSITION, this.position);
        }
        if (this.data != null) {
            IDataUtil.put(ic, KEY_RULE_DATA, this.data);
        }
        IDataUtil.put(ic, KEY_RULE_I18N, "true");
        ic.destroy();
        return parData;
    }

    public void setFromData(IData val) {
        String str;
        if (val == null) {
            return;
        }
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this.field = IDataUtil.getString(ic, "field");
        this.encoding = IDataUtil.getString(ic, KEY_RULE_DENC);
        if (this.encoding == null) {
            this.encoding = ENCODING_XML_VALUES;
        }
        this.overwrite = (str = IDataUtil.getString(ic, KEY_RULE_OVERWRITE)) == null || !str.equals("false");
        str = IDataUtil.getString(ic, KEY_RULE_VARIABLES);
        this.variables = str == null || !str.equals("false");
        this.className = IDataUtil.getString(ic, KEY_RULE_CLASSNAME);
        this.position = IDataUtil.getString(ic, KEY_RULE_POSITION);
        str = IDataUtil.getString(ic, KEY_RULE_I18N);
        this.sourceIsUTF8 = str == null || !str.equals("false");
        IData data = (IData)IDataUtil.get(ic, KEY_RULE_DATA);
        ic.destroy();
    }

    public void set(IData pipeline) {
        this.set(pipeline, pipeline);
    }

    public void set(IData pipeline, IData source) {
        block4: {
            if (this.mapSet == null || this.data == null) {
                return;
            }
            try {
                this.mapSet.set(pipeline, source);
                MapError mapError = MapError.create(pipeline);
                if (mapError != null) {
                    mapError.logLastField(this.getParsedPath().getPathID());
                }
            }
            catch (Exception e) {
                if (!JournalLogger.isLogEnabled(5, 50, 7)) break block4;
                JournalLogger.log(5, 50, 7, e.getMessage(), this.field);
                MapError mapError = MapError.create(pipeline);
                if (mapError == null) break block4;
                mapError.logError("Set", e.getMessage() + "  field=" + this.field);
            }
        }
    }

    public boolean isValid() {
        MapWmPathInfo mapPath = MapWmPathInfo.create(this.field);
        if (this.dtype != null) {
            return mapPath.getDataType() == this.dtype.getType() && mapPath.getDataDimension() == this.dtype.getDimensions();
        }
        if (this.data != null) {
            return MapWmPathUtil.dataCheck(this.data, mapPath.getDataPathItem(), null);
        }
        return true;
    }

    protected String addXMLHeader(String data) {
        if (data != null && !data.startsWith("<?xml")) {
            if (this.sourceIsUTF8) {
                return XMLUTF8HEADER + data;
            }
            return XMLHEADER + data;
        }
        return data;
    }

    public void init(NSRecord source, NSRecord target) {
        this.mapPath = MapWmPathInfo.create(this.field);
        this.mapPath.setClassName(this.className);
        if (this.mapPath != null) {
            this.mapPath.compile(target);
            this.mapSet = new MapSet(this.data, this.variables, this.overwrite, this.mapPath);
        } else {
            this.mapSet = null;
        }
    }

    public MapWmPathInfo getParsedPath() {
        if (this.mapPath != null) {
            return this.mapPath;
        }
        if (this.field != null) {
            this.mapPath = MapWmPathInfo.create(this.field);
            return this.mapPath;
        }
        return null;
    }

    public Values getReportable() {
        Values reportableData = new Values();
        reportableData.put("field", this.field);
        reportableData.put(KEY_RULE_OVERWRITE, this.overwrite ? "true" : "false");
        reportableData.put(KEY_RULE_VARIABLES, this.variables ? "true" : "false");
        reportableData.put(KEY_RULE_DATA, this.data);
        MapWmPathInfo parsedPath = this.getParsedPath();
        NSRecord root = new NSRecord(null);
        NSField b = NSRecordWmPathProcessor.create(root, this.field);
        if (root.getFieldNodes() != null && root.getFieldNodes().length > 0) {
            Values aField = root.getFieldNodes()[0].getReportable();
            int fieldType = parsedPath.getTypeInfo()[0];
            if (fieldType == 4) {
                aField.put("field_type", "recref");
                String refNSName = parsedPath.getPathItems()[0].getNSName();
                NSName refName = NSName.create(refNSName);
                aField.put("ref_name", refName != null ? refName.getNodeName() : null);
            }
            reportableData.put("field", aField);
        }
        boolean isScalarString = parsedPath.getDataType() == 1 && parsedPath.getDataDimension() == 0;
        reportableData.put(IS_STRING, isScalarString ? "true" : "false");
        if (isScalarString) {
            String isPassword = null;
            if (this.dtype != null && this.dtype.getHints() != null) {
                IDataCursor ic = this.dtype.getHints().getCursor();
                isPassword = (String)IDataUtil.get(ic, "field_password");
                ic.destroy();
            }
            reportableData.put("field_password", isPassword);
        }
        return super.getReportable().copyFrom(reportableData);
    }

    public static void main(String[] args) {
        FlowMapSet set = new FlowMapSet(null);
        String str = "select * from %value table% where id >= 0";
        set.setInput(str);
        String[] vars = FlowMapSet.parseVars(str);
        if (vars != null) {
            for (int i = 0; i < vars.length; ++i) {
                System.out.println("i=" + vars[i] + "=");
            }
        }
    }
}

