/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowException;
import com.wm.lang.flow.FlowInvoke;
import com.wm.lang.flow.FlowMap;
import com.wm.lang.flow.FlowMapCopy;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.MapIf;
import com.wm.lang.flow.resources.FlowExceptionBundle;
import com.wm.lang.ns.NSRecord;
import com.wm.util.Values;
import java.util.StringTokenizer;

public class FlowMapInvoke
extends FlowInvoke
implements MapIf {
    public static final String KEY_MAPINVOKE_INVOKEORDER = "invoke-order";
    private boolean validInputMap = false;
    int invokeOrder;
    IData pipelet;
    boolean found;
    FlowMapInvoke donor;

    public FlowMapInvoke(Values val) {
        super(val);
        this.type = "MAPINVOKE";
    }

    public Values getValues() {
        Values parData = super.getValues();
        parData.put(KEY_MAPINVOKE_INVOKEORDER, String.valueOf(this.invokeOrder));
        return parData;
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        super.setValues(val);
        try {
            this.invokeOrder = Integer.parseInt(val.getString(KEY_MAPINVOKE_INVOKEORDER));
        }
        catch (Exception e) {
            this.invokeOrder = 0;
        }
    }

    public IData getAsData() {
        IData parData = super.getAsData();
        IDataCursor ic = parData.getCursor();
        IDataUtil.put(ic, KEY_MAPINVOKE_INVOKEORDER, String.valueOf(this.invokeOrder));
        ic.destroy();
        return parData;
    }

    public void setFromData(IData val) {
        if (val == null) {
            return;
        }
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        try {
            this.invokeOrder = Integer.parseInt(IDataUtil.getString(ic, KEY_MAPINVOKE_INVOKEORDER));
        }
        catch (Exception e) {
            this.invokeOrder = 0;
        }
        ic.destroy();
    }

    public int getInvokeOrder() {
        return this.invokeOrder;
    }

    public void setInvokeOrder(int invokeOrder) {
        this.invokeOrder = invokeOrder;
    }

    public void setInputMap(FlowMap input_map) {
        this.input_map = input_map;
        if (input_map != null) {
            input_map.setMode("INVOKEINPUT");
        }
    }

    public void setOutputMap(FlowMap output_map) {
        this.output_map = output_map;
        if (output_map != null) {
            output_map.setMode("INVOKEOUTPUT");
        }
    }

    public IData getPipelet() {
        return this.pipelet;
    }

    public void setPipelet(IData pipelet) {
        this.pipelet = pipelet;
    }

    public boolean isFound() {
        return this.found;
    }

    public void setFound(boolean b) {
        this.found = b;
    }

    public void init(NSRecord source, NSRecord target) {
        this.validInputMap = this.hasValidInputMap();
    }

    public boolean isValid() {
        return true;
    }

    public FlowElement getOutputNode(String path) {
        if (path == null) {
            return null;
        }
        FlowElement next = this.getOutputMap();
        StringTokenizer st = new StringTokenizer(path, "/");
        while (st.hasMoreElements()) {
            int node = Integer.parseInt(st.nextToken());
            next = next.getNodeAt(node);
        }
        return next;
    }

    public void invokeService(IData pipeline, FlowState fs) {
        if (!this.validInputMap) {
            FlowException le = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.TRANSFORMER_LOOP_ERR, "", this.service.toString());
            throw new RuntimeException(le.getLocalizedMessage(fs.getLocale()));
        }
        FlowMap fm_in = this.getInputMap();
        FlowMap fm_out = this.getOutputMap();
        if (!fs.mapInvokeOutput) {
            fs.setPipelet(IDataFactory.create());
            if (fm_in != null) {
                IData clonePipe = IDataUtil.clone(pipeline);
                fm_in.invokeInputPipelet(clonePipe, fs.getPipelet());
            }
            if (!fs.mapInvokeInput) {
                this.invoke(fs);
                this.pipelet = fs.getPipelet();
            } else {
                fs.setTformFlowMapInvoke(this);
            }
        }
        if (!fs.mapInvokeInput && fs.mapInvokeOutput()) {
            fs.setPipelet(fs.getChildResults());
        }
    }

    boolean hasValidInputMap() {
        FlowMap in = this.getInputMap();
        if (in == null) {
            return true;
        }
        FlowMapCopy[] copys = in.getCopyMaps();
        if (copys == null) {
            return true;
        }
        for (int i = 0; i < copys.length; ++i) {
            if (!copys[i].needLooping()) continue;
            return false;
        }
        return true;
    }
}

