/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.MapDelete;
import com.wm.lang.flow.MapIf;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.WmPathInfo;
import com.wm.util.Values;

public class FlowMapDelete
extends FlowElement
implements MapIf {
    public static final String FIELD = "field";
    String field;
    String position;
    public static final String KEY_RULE_FIELD = "field";
    public static final String KEY_RULE_POSITION = "fieldPosition";
    public static final String POSITION_SOURCE = "source";
    public static final String POSITION_TARGET = "target";
    MapDelete mapDelete;
    MapWmPathInfo mapPath;

    public FlowMapDelete(Values val) {
        super(val);
        this.type = "MAPDELETE";
    }

    public void invoke(FlowState state) {
        throw new RuntimeException("Cannot invoke " + this.getFlowType() + " elements");
    }

    public boolean hasNodes() {
        return false;
    }

    public String getField() {
        return this.field;
    }

    public void setFieldPosition(String position) {
        this.position = position;
    }

    public String getFieldPosition() {
        return this.position;
    }

    public void setField(String field) {
        this.field = field;
        this.mapPath = MapWmPathInfo.create(field);
        if (this.mapPath == null) {
            throw new IllegalArgumentException("Illegal path: " + field);
        }
    }

    public void setField(String name, int type, int dim) {
        this.setField(WmPathInfo.getPath(name, type, dim));
    }

    public void setField(String[] names, int[] types, int[] dims) {
        this.setField(WmPathInfo.getPath(names, types, dims));
    }

    public Values getValues() {
        Values parData = super.getValues();
        parData.put("field", this.field);
        if (this.position != null) {
            parData.put(KEY_RULE_POSITION, this.position);
        }
        return parData;
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        super.setValues(val);
        this.field = val.getString("field");
        this.position = val.getString(KEY_RULE_POSITION);
    }

    public IData getAsData() {
        IData parData = super.getAsData();
        IDataCursor ic = parData.getCursor();
        if (this.field != null) {
            IDataUtil.put(ic, "field", this.field);
        }
        if (this.position != null) {
            IDataUtil.put(ic, KEY_RULE_POSITION, this.position);
        }
        ic.destroy();
        return parData;
    }

    public void setFromData(IData val) {
        if (val == null) {
            return;
        }
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this.field = IDataUtil.getString(ic, "field");
        this.position = IDataUtil.getString(ic, KEY_RULE_POSITION);
        ic.destroy();
    }

    public boolean isValid() {
        return MapWmPathInfo.create(this.field) != null;
    }

    public void markDelete(IData pipeline) {
        if (this.mapDelete != null) {
            this.mapDelete.markDelete(pipeline);
        }
    }

    public void deleteMarker(IData pipeline) {
        if (this.mapDelete != null) {
            this.mapDelete.deleteMarker(pipeline);
        }
    }

    public void init(NSRecord source, NSRecord target) {
        if (this.field != null && this.field.length() != 0) {
            this.mapPath = MapWmPathInfo.create(this.field);
            if (this.mapPath == null) {
                this.mapDelete = null;
            } else {
                this.mapPath.compile(target);
                this.mapDelete = new MapDelete(this.mapPath);
            }
        }
    }

    public MapWmPathInfo getParsedPath() {
        if (this.mapPath != null) {
            return this.mapPath;
        }
        if (this.field != null) {
            this.mapPath = MapWmPathInfo.create(this.field);
            return this.mapPath;
        }
        return null;
    }

    public Values getReportable() {
        Values reportableData = super.getReportable();
        NSRecord root = new NSRecord(null);
        NSField a = NSRecordWmPathProcessor.create(root, this.field);
        if (root.getFieldNodes() != null && root.getFieldNodes().length > 0) {
            Values aField = root.getFieldNodes()[0].getReportable();
            int fieldType = this.getParsedPath().getTypeInfo()[0];
            if (fieldType == 4) {
                aField.put("field_type", "recref");
                String refNSName = this.getParsedPath().getPathItems()[0].getNSName();
                NSName refName = NSName.create(refNSName);
                aField.put("ref_name", refName != null ? refName.getNodeName() : null);
            }
            reportableData.put("field", aField);
        }
        return reportableData;
    }
}

