/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.ExpressionEvaluator;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowException;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.MalformedExpressionException;
import com.wm.lang.flow.MapCopyFactory;
import com.wm.lang.flow.MapCopyIf;
import com.wm.lang.flow.MapError;
import com.wm.lang.flow.MapIf;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.resources.FlowExceptionBundle;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.WmPathInfo;
import com.wm.lang.ns.WmPathItem;
import com.wm.util.Debug2;
import com.wm.util.JournalLogger;
import com.wm.util.LocalizedIllegalArgumentException;
import com.wm.util.Values;
import java.util.Locale;

public class FlowMapCopy
extends FlowElement
implements MapIf {
    private static final boolean debug = false;
    public static final String FROM_FIELD = "from_field";
    public static final String TO_FIELD = "to_field";
    private boolean looping = false;
    private boolean loopingSet = false;
    private String from;
    private String to;
    String condition;
    String className;
    boolean conditionDisabled;
    public static final String KEY_RULE_FROM = "from";
    public static final String KEY_RULE_TO = "to";
    public static final String KEY_RULE_CONDITION = "condition";
    public static final String KEY_RULE_CLASSNAME = "className";
    public static final String KEY_RULE_CONDITION_DISABLED = "condition-disabled";
    MapCopyIf mapCopy;
    private MapWmPathInfo fromPath;
    private MapWmPathInfo toPath;
    boolean isSameField;

    public FlowMapCopy(Values val) {
        super(val);
        this.type = "MAPCOPY";
    }

    public void invoke(FlowState state) {
        throw new RuntimeException("Cannot invoke " + this.getFlowType() + " elements");
    }

    public boolean hasNodes() {
        return false;
    }

    public String getMapFrom() {
        return this.from;
    }

    public String getMapTo() {
        return this.to;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String name) {
        this.className = name;
    }

    public void setMapFrom(String from) {
        this.from = from;
        this.fromPath = MapWmPathInfo.create(from);
        if (this.fromPath == null) {
            throw new LocalizedIllegalArgumentException(FlowExceptionBundle.class, FlowExceptionBundle.ILLEGAL_PATH, "", from);
        }
    }

    public void setMapTo(String to) {
        this.to = to;
        this.toPath = MapWmPathInfo.create(to);
        if (this.toPath == null) {
            throw new LocalizedIllegalArgumentException(FlowExceptionBundle.class, FlowExceptionBundle.ILLEGAL_PATH, "", to);
        }
    }

    public void setMapFrom(String name, int type, int dim) {
        this.setMapFrom(WmPathInfo.getPath(name, type, dim));
    }

    public void setMapTo(String name, int type, int dim) {
        this.setMapTo(WmPathInfo.getPath(name, type, dim));
    }

    public void setMapFrom(String[] names, int[] types, int[] dims) {
        this.setMapFrom(WmPathInfo.getPath(names, types, dims));
    }

    public void setMapTo(String[] names, int[] types, int[] dims) {
        this.setMapTo(WmPathInfo.getPath(names, types, dims));
    }

    public void setCondition(String cond) throws MalformedExpressionException {
        if (cond != null && cond.trim().length() > 0) {
            ExpressionEvaluator.syntaxCheck(cond);
        }
        this.condition = cond;
    }

    public String getCondition() {
        return this.condition;
    }

    public boolean isConditionDisabled() {
        return this.conditionDisabled;
    }

    public void setConditionDisabled(boolean flag) {
        this.conditionDisabled = flag;
    }

    public Values getValues() {
        Values parData = super.getValues();
        parData.put(KEY_RULE_FROM, this.from);
        parData.put(KEY_RULE_TO, this.to);
        parData.put(KEY_RULE_CONDITION, this.condition);
        if (this.className != null) {
            parData.put(KEY_RULE_CLASSNAME, this.className);
        }
        parData.put(KEY_RULE_CONDITION_DISABLED, this.conditionDisabled ? "true" : null);
        return parData;
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        super.setValues(val);
        this.from = val.getString(KEY_RULE_FROM);
        this.to = val.getString(KEY_RULE_TO);
        this.condition = val.getString(KEY_RULE_CONDITION);
        this.className = val.getString(KEY_RULE_CLASSNAME);
        this.conditionDisabled = val.getBoolean(KEY_RULE_CONDITION_DISABLED);
    }

    public IData getAsData() {
        IData parData = super.getAsData();
        IDataCursor ic = parData.getCursor();
        if (this.from != null) {
            IDataUtil.put(ic, KEY_RULE_FROM, this.from);
        }
        if (this.to != null) {
            IDataUtil.put(ic, KEY_RULE_TO, this.to);
        }
        if (this.condition != null) {
            IDataUtil.put(ic, KEY_RULE_CONDITION, this.condition);
        }
        if (this.className != null) {
            IDataUtil.put(ic, KEY_RULE_CLASSNAME, this.className);
        }
        if (this.conditionDisabled) {
            IDataUtil.put(ic, KEY_RULE_CONDITION_DISABLED, "true");
        }
        ic.destroy();
        return parData;
    }

    public void setFromData(IData val) {
        if (val == null) {
            return;
        }
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this.from = IDataUtil.getString(ic, KEY_RULE_FROM);
        this.to = IDataUtil.getString(ic, KEY_RULE_TO);
        this.condition = IDataUtil.getString(ic, KEY_RULE_CONDITION);
        this.className = IDataUtil.getString(ic, KEY_RULE_CLASSNAME);
        this.conditionDisabled = ic.first(KEY_RULE_CONDITION_DISABLED) ? IDataUtil.getBoolean(ic) : false;
        ic.destroy();
    }

    public boolean isValid() {
        return FlowMapCopy.isValid(this.from, this.to);
    }

    public static boolean isValid(String pathFrom, String pathTo) {
        return FlowMapCopy.getValidation(pathFrom, pathTo) == null;
    }

    public static String getValidation(String pathFrom, String pathTo) {
        MapWmPathInfo mapPathFrom = MapWmPathInfo.create(pathFrom);
        MapWmPathInfo mapPathTo = MapWmPathInfo.create(pathTo);
        return FlowMapCopy.getValidation(mapPathFrom, mapPathTo);
    }

    public static String getValidation(MapWmPathInfo mapPathFrom, MapWmPathInfo mapPathTo) {
        int toType;
        if (mapPathFrom == null) {
            FlowException error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.INVALID_SOURCE_PATH, "");
            return error.getLocalizedMessage(Locale.getDefault());
        }
        if (mapPathTo == null) {
            FlowException error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.INVALID_TARGET_PATH, "");
            return error.getLocalizedMessage(Locale.getDefault());
        }
        int fromType = mapPathFrom.getPathType();
        if (fromType == (toType = mapPathTo.getPathType())) {
            return null;
        }
        if (toType == 3) {
            return null;
        }
        if (fromType == 3) {
            return null;
        }
        if (NSField.isRecordType(fromType) && NSField.isRecordType(toType)) {
            return null;
        }
        Object[] args = new String[]{mapPathFrom.getPathDisplayString(), mapPathTo.getPathDisplayString()};
        FlowException error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.CANNOT_COPY, "", args);
        return error.getLocalizedMessage(Locale.getDefault());
    }

    public boolean isSameFieldCopy() {
        return this.isSameField;
    }

    public boolean isValidImplicit() {
        return FlowMapCopy.isValidImplicit(this.from, this.to);
    }

    public static boolean isValidImplicit(String pathFrom, String pathTo) {
        MapWmPathInfo mapFromPath = MapWmPathInfo.create(pathFrom);
        MapWmPathInfo mapToPath = MapWmPathInfo.create(pathTo);
        if (mapFromPath == null) {
            return false;
        }
        return mapFromPath.getPathID().equals(mapToPath.getPathID());
    }

    public void copy(IData pipeline, IData cloned) {
        this.copy(pipeline, cloned, pipeline);
    }

    public void copy(IData pipeline, IData cloned, IData condVars) {
        MapError errLogs;
        block9: {
            if (this.mapCopy == null) {
                return;
            }
            errLogs = null;
            String condition = this.getCondition();
            if (condition != null && Debug2.getLevel() < 9 && (errLogs = MapError.create(pipeline)) != null) {
                errLogs.removeLogs(pipeline);
            }
            try {
                MapError mapError;
                boolean excuted = false;
                if (condition != null & !this.isConditionDisabled()) {
                    if (ExpressionEvaluator.evalToBoolean(condition, condVars)) {
                        this.mapCopy.copy(pipeline, cloned);
                        excuted = true;
                    }
                } else {
                    this.mapCopy.copy(pipeline, cloned);
                    excuted = true;
                }
                if (excuted && (mapError = MapError.create(pipeline)) != null) {
                    mapError.logLastField(this.getParsedTo().getPathID());
                }
            }
            catch (Exception e) {
                if (!JournalLogger.isLogEnabled(4, 50, 6)) break block9;
                Object[] o = new Object[]{e.getMessage(), this.to, this.from};
                JournalLogger.log(4, 50, 6, o);
                MapError mapError = MapError.create(pipeline);
                if (mapError == null) break block9;
                mapError.logError("Copy", e.getMessage() + "  to=" + this.to + "  from=" + this.from);
            }
        }
        if (errLogs != null) {
            errLogs.addLogs(pipeline);
        }
    }

    public void init(NSRecord sourceSchema, NSRecord targetSchema) {
        this.fromPath = MapWmPathInfo.create(this.from);
        this.toPath = MapWmPathInfo.create(this.to);
        if (this.fromPath != null && this.toPath != null) {
            this.setNeedsLooping();
            int diff = this.fromPath.getPathDimension() - this.toPath.getPathDimension();
            if (diff > 0) {
                WmPathItem[] pathInfo = this.fromPath.getPathItems();
                for (int i = 0; i < pathInfo.length && diff != 0; ++i) {
                    if (pathInfo[i].getDimension() == 1) {
                        if (pathInfo[i].getNodeDimension() == pathInfo[i].getDimension()) {
                            pathInfo[i].setArrayIndex(0);
                        } else {
                            pathInfo[i].setTableIndex(0);
                        }
                        --diff;
                        continue;
                    }
                    if (pathInfo[i].getDimension() != 2) continue;
                    pathInfo[i].setArrayIndex(0);
                    --diff;
                }
                String newFrom = this.fromPath.getPathString();
                this.fromPath = MapWmPathInfo.create(newFrom);
            }
            this.fromPath.compile(sourceSchema, false);
            this.toPath.compile(targetSchema, true);
            this.toPath.setClassName(this.className);
            this.mapCopy = MapCopyFactory.create(this.fromPath, this.toPath);
            this.isSameField = this.fromPath.getPathID().equals(this.toPath.getPathID());
        } else {
            this.mapCopy = null;
        }
    }

    public MapWmPathInfo getParsedFrom() {
        if (this.fromPath != null) {
            return this.fromPath;
        }
        if (this.from != null) {
            this.fromPath = MapWmPathInfo.create(this.from);
            return this.fromPath;
        }
        return null;
    }

    public MapWmPathInfo getParsedTo() {
        if (this.toPath != null) {
            return this.toPath;
        }
        if (this.to != null) {
            this.toPath = MapWmPathInfo.create(this.to);
            return this.toPath;
        }
        return null;
    }

    public Values getReportable() {
        int fieldType;
        Values reportableData = super.getReportable();
        NSRecord fromRoot = new NSRecord(null);
        NSField a = NSRecordWmPathProcessor.create(fromRoot, this.from);
        if (fromRoot.getFieldNodes() != null && fromRoot.getFieldNodes().length > 0) {
            Values fromField = fromRoot.getFieldNodes()[0].getReportable();
            fieldType = this.getParsedFrom().getTypeInfo()[0];
            if (fieldType == 4) {
                fromField.put("field_type", "recref");
                String fromRefNSName = this.getParsedFrom().getPathItems()[0].getNSName();
                NSName fromRefName = NSName.create(fromRefNSName);
                fromField.put("ref_name", fromRefName != null ? fromRefName.getNodeName() : null);
            }
            reportableData.put(FROM_FIELD, fromField);
        }
        NSRecord toRoot = new NSRecord(null);
        NSField b = NSRecordWmPathProcessor.create(toRoot, this.to);
        if (toRoot.getFieldNodes() != null && toRoot.getFieldNodes().length > 0) {
            Values toField = toRoot.getFieldNodes()[0].getReportable();
            fieldType = this.getParsedTo().getTypeInfo()[0];
            if (fieldType == 4) {
                toField.put("field_type", "recref");
                String toRefNSName = this.getParsedTo().getPathItems()[0].getNSName();
                NSName toRefName = NSName.create(toRefNSName);
                toField.put("ref_name", toRefName != null ? toRefName.getNodeName() : null);
            }
            reportableData.put(TO_FIELD, toField);
        }
        return reportableData;
    }

    private void setNeedsLooping() {
        this.loopingSet = true;
        this.looping = false;
        if (this.from == null || this.to == null) {
            return;
        }
        MapWmPathInfo fromP = MapWmPathInfo.create(this.from);
        MapWmPathInfo toP = MapWmPathInfo.create(this.to);
        if (fromP == null || toP == null) {
            return;
        }
        if (fromP.getPathDimension() > toP.getPathDimension()) {
            this.looping = true;
        }
    }

    public boolean needLooping() {
        if (!this.loopingSet) {
            this.setNeedsLooping();
        }
        return this.looping;
    }
}

