/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowMapCopy;
import com.wm.lang.flow.FlowMapDelete;
import com.wm.lang.flow.FlowMapInvoke;
import com.wm.lang.flow.FlowMapSet;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.MapCompiler;
import com.wm.lang.flow.MapError;
import com.wm.lang.flow.MapUtil;
import com.wm.lang.flow.MapValidator;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.SuperMapCopy;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSRecordRef;
import com.wm.lang.ns.NSRecordWmPathProcessor;
import com.wm.lang.ns.Namespace;
import com.wm.lang.ns.WmPathItem;
import com.wm.util.JournalLogger;
import com.wm.util.Values;
import com.wm.util.coder.XMLCoder;
import java.util.ArrayList;
import java.util.Vector;

public class FlowMap
extends FlowElement {
    private static final boolean debug = false;
    public static final String MODE_STANDALONE = "STANDALONE";
    public static final String MODE_INPUT = "INPUT";
    public static final String MODE_OUTPUT = "OUTPUT";
    public static final String MODE_INVOKEINPUT = "INVOKEINPUT";
    public static final String MODE_INVOKEOUTPUT = "INVOKEOUTPUT";
    public static final String KEY_MODE = "mode";
    public static final String KEY_TARGET = "target";
    public static final String KEY_SOURCE = "source";
    public static final String HAS_EXPLICIT_MAPPING = "hasexplicitmapping";
    static final String XMLHEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n\n";
    String mode;
    MapCompiler compiler;
    MapValidator validator;
    Values target;
    Values source;
    private NSRecord targetRec;
    private NSRecord sourceRec;
    private boolean isSchemaInit = false;
    boolean invokeSameCopy;
    private boolean disabledNodes = false;
    private static final IData NOT_YET_CLONED = IDataFactory.create();
    XMLCoder xmlCoder;

    public FlowMap(Values val) {
        super(val);
        this.type = "MAP";
        this.validator = new MapValidator(this);
    }

    public void init(Namespace ns) {
        this.validator.validate();
        this.compiler = new MapCompiler(this);
        this.initSchema(ns);
        FlowMapInvoke[] nodes = this.validator.getInvokeMaps();
        if (nodes != null) {
            for (int i = 0; i < nodes.length; ++i) {
                FlowMap fm = nodes[i].input_map;
                if (fm != null) {
                    fm.init(ns);
                }
                if ((fm = nodes[i].output_map) == null) continue;
                fm.init(ns);
            }
        }
        this.compiler.init(this.sourceRec, this.targetRec);
        Object[] tempNodes = this.compiler.getExecNodes();
        if (tempNodes != null) {
            for (int i = 0; i < tempNodes.length; ++i) {
                if (tempNodes[i] instanceof FlowMapInvoke) {
                    if (((FlowElement)tempNodes[i]).isEnabled()) continue;
                    this.disabledNodes = true;
                    continue;
                }
                if (!(tempNodes[i] instanceof SuperMapCopy)) continue;
                if (((SuperMapCopy)tempNodes[i]).getMapInvoke() == null) {
                    this.disabledNodes = true;
                    continue;
                }
                if (((SuperMapCopy)tempNodes[i]).getMapInvoke().isEnabled()) continue;
                this.disabledNodes = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(FlowState state) {
        MapError mapLog;
        if (state.getMapLog() != null) {
            mapLog = state.getMapLog();
            mapLog.logLastField(null);
            mapLog.addLogs(state.getPipeline());
        }
        try {
            this.invoke(state.getPipeline(), state);
            if (MODE_STANDALONE.equals(this.mode) && !state.isStepMap()) {
                state.setDone(true);
            }
        }
        finally {
            if (state.getMapLog() != null) {
                mapLog = state.getMapLog();
                mapLog.removeLogs(state.getPipeline());
            }
        }
    }

    public void invoke(IData pipeline) {
        this.invoke(pipeline, null);
    }

    private IData getPipelineOrClone(IData pipeline) {
        IData cloned = this.compiler.clonePipeline() ? MapUtil.cloneIDataObject(pipeline) : pipeline;
        return cloned;
    }

    private void invoke(IData pipeline, FlowState fs) {
        IData cloned = NOT_YET_CLONED;
        Object[] nodes = this.compiler.getExecNodes();
        if (this.disabledNodes && nodes != null) {
            ArrayList<Object> a = new ArrayList<Object>(nodes.length);
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i] instanceof FlowMapInvoke) {
                    if (!((FlowElement)nodes[i]).isEnabled()) continue;
                    a.add(nodes[i]);
                    continue;
                }
                if (nodes[i] instanceof SuperMapCopy) {
                    if (((SuperMapCopy)nodes[i]).getMapInvoke() == null || !((SuperMapCopy)nodes[i]).getMapInvoke().isEnabled()) continue;
                    a.add(nodes[i]);
                    continue;
                }
                a.add(nodes[i]);
            }
            nodes = a.toArray();
        }
        if (nodes == null || nodes.length == 0) {
            if (fs.isStepMap()) {
                fs.setDone(true);
                fs.setStepMap(false);
            }
            return;
        }
        int first = 0;
        int last = nodes.length;
        if (fs != null && fs.isStepMap()) {
            int nextMap = fs.getNextMap();
            if (nextMap < 0) {
                fs.setDone(true);
                fs.setNextMap(0);
                fs.setStepMap(false);
                fs.setChildResults(null);
                return;
            }
            if (++nextMap > last) {
                fs.setNextMap(-1);
            } else {
                fs.setNextMap(nextMap);
            }
            first = nextMap - 2;
            last = first + 1;
        }
        if (first >= 0) {
            boolean isMapInvoke = false;
            if (first == 0) {
                fs.setMapInvokeError(false);
            }
            for (int i = first; i < last; ++i) {
                if (nodes[i] instanceof FlowMapCopy) {
                    FlowMapCopy copy = (FlowMapCopy)nodes[i];
                    if (!copy.isSameFieldCopy()) {
                        if (cloned == NOT_YET_CLONED) {
                            cloned = this.getPipelineOrClone(pipeline);
                        }
                        copy.copy(pipeline, cloned);
                    }
                } else if (nodes[i] instanceof FlowMapSet) {
                    if (cloned == NOT_YET_CLONED) {
                        cloned = this.getPipelineOrClone(pipeline);
                    }
                    ((FlowMapSet)nodes[i]).set(pipeline);
                } else if (nodes[i] instanceof FlowMapDelete) {
                    ((FlowMapDelete)nodes[i]).markDelete(pipeline);
                } else if (nodes[i] instanceof FlowMapInvoke) {
                    if (((FlowElement)nodes[i]).isEnabled()) {
                        if (cloned == NOT_YET_CLONED) {
                            cloned = this.getPipelineOrClone(pipeline);
                        }
                        ((FlowMapInvoke)nodes[i]).invokeService(cloned, fs);
                        isMapInvoke = true;
                    }
                } else if (nodes[i] instanceof SuperMapCopy && ((SuperMapCopy)nodes[i]).getMapInvoke().isEnabled()) {
                    ((SuperMapCopy)nodes[i]).copy(pipeline);
                }
                if (i != nodes.length - 1) continue;
                this.deleteMarkedNodes(pipeline);
                if (!isMapInvoke || fs.isMapInvokeError()) continue;
                fs.clearLastErrorInfo();
            }
        }
        if (fs != null && fs.isStepMap()) {
            if (fs.getNextMap() < 0) {
                fs.supermapPath = null;
            } else {
                Object nextItem = nodes[first + 1];
                if (nextItem instanceof FlowMapInvoke) {
                    FlowMapInvoke nextNode = (FlowMapInvoke)nextItem;
                    fs.supermapPath = new String[]{nextNode.donor.getPathByRef()};
                } else if (nextItem instanceof SuperMapCopy) {
                    SuperMapCopy nextNode = (SuperMapCopy)nextItem;
                    FlowMapInvoke fmi = nextNode.getMapInvoke();
                    FlowMapCopy fmc = nextNode.getMapCopy();
                    FlowMap fm = fmi.getOutputMap();
                    fs.supermapPath = new String[]{fmi.donor.getPathByRef(), nextNode.getMapCopy().getPathByRef(fmi.donor.getOutputMap())};
                } else {
                    FlowElement nextNode = (FlowElement)nextItem;
                    fs.supermapPath = new String[]{nextNode.getPathByRef()};
                }
            }
        }
        if (fs != null) {
            fs.setChildResults(null);
        }
    }

    void deleteMarkedNodes(IData pipeline) {
        FlowMapDelete[] deletes = this.compiler.getDeleteMaps();
        if (deletes == null) {
            return;
        }
        for (int i = 0; i < deletes.length; ++i) {
            deletes[i].deleteMarker(pipeline);
        }
    }

    public void invokeInputPipelet(IData pipeline, IData pipelet) {
        Object[] nodes = this.compiler.getExecNodes();
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] instanceof FlowMapCopy) {
                ((FlowMapCopy)nodes[i]).copy(pipelet, pipeline, pipeline);
                continue;
            }
            if (!(nodes[i] instanceof FlowMapSet)) continue;
            ((FlowMapSet)nodes[i]).set(pipelet, pipeline);
        }
    }

    public void invokeOutputPipelet(IData pipeline, IData pipelet) {
        Object[] nodes = this.compiler.getExecNodes();
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            if (!(nodes[i] instanceof FlowMapCopy)) continue;
            ((FlowMapCopy)nodes[i]).copy(pipeline, pipelet);
        }
    }

    public void addNode(FlowElement node) {
        if (this.isValid(node)) {
            super.addNode(node);
            if (this.validator != null) {
                this.validator.addAssignedField(node);
            }
            return;
        }
    }

    public void insertNodeAt(FlowElement node, int index) {
        if (this.isValid(node)) {
            super.insertNodeAt(node, index);
            if (this.validator != null) {
                this.validator.addAssignedField(node);
            }
            return;
        }
        System.err.println("Rejecting: " + node);
    }

    public void deleteNode(FlowElement node) {
        super.deleteNode(node);
        if (this.validator != null) {
            this.validator.deleteAssignedField(node);
        }
    }

    public void deleteNodeAt(int index) {
        FlowElement node = this.getNodeAt(index);
        super.deleteNodeAt(index);
        if (this.validator != null) {
            this.validator.deleteAssignedField(node);
        }
    }

    public FlowMapInvoke[] getInvalidTransformers() {
        if (this.validator != null) {
            return this.validator.getInvalidTransformers();
        }
        return null;
    }

    public Values getValues() {
        Values parData = super.getValues();
        parData.put(KEY_MODE, this.mode == null ? MODE_STANDALONE : this.mode);
        String s = this.encodeValues(this.source);
        if (s != null) {
            parData.put(KEY_SOURCE, s);
        }
        if ((s = this.encodeValues(this.target)) != null) {
            parData.put(KEY_TARGET, s);
        }
        return parData;
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        super.setValues(val);
        this.mode = val.getString(KEY_MODE);
        if (this.mode == null) {
            this.mode = MODE_STANDALONE;
        }
        this.target = this.decodeValues(val.getString(KEY_TARGET));
        this.source = this.decodeValues(val.getString(KEY_SOURCE));
        this.targetRec = null;
        this.sourceRec = null;
        this.isSchemaInit = false;
    }

    public IData getAsData() {
        IData parData = super.getAsData();
        IDataCursor ic = parData.getCursor();
        IDataUtil.put(ic, KEY_MODE, this.mode == null ? MODE_STANDALONE : this.mode);
        if (this.source != null) {
            IDataUtil.put(ic, KEY_SOURCE, this.source);
        }
        if (this.target != null) {
            IDataUtil.put(ic, KEY_TARGET, this.target);
        }
        ic.destroy();
        return parData;
    }

    public void setFromData(IData val) {
        if (val == null) {
            return;
        }
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this.mode = IDataUtil.getString(ic, KEY_MODE);
        if (this.mode == null) {
            this.mode = MODE_STANDALONE;
        }
        this.target = Values.use(IDataUtil.getIData(ic, KEY_TARGET));
        this.source = Values.use(IDataUtil.getIData(ic, KEY_SOURCE));
        ic.destroy();
        this.targetRec = null;
        this.sourceRec = null;
        this.isSchemaInit = false;
    }

    XMLCoder getXMLCoder() {
        if (this.xmlCoder == null) {
            this.xmlCoder = new XMLCoder(true);
            this.xmlCoder.setUseXMLHeader(false);
        }
        return this.xmlCoder;
    }

    String encodeValues(Values val) {
        if (val == null) {
            return null;
        }
        Object[][] in = new Object[][]{{"xml", val}};
        XMLCoder coder = this.getXMLCoder();
        try {
            byte[] encData = coder.encodeToBytes(new Values(in));
            return new String(encData, "UTF8");
        }
        catch (Exception e) {
            if (JournalLogger.isLogEnabled(17, 50, 1)) {
                JournalLogger.log(17, 50, 1, (Object)e.toString());
            }
            return null;
        }
    }

    Values decodeValues(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        XMLCoder coder = this.getXMLCoder();
        try {
            str = this.addXMLHeader(str);
            Values decData = coder.decodeFromBytes(str.getBytes("UTF8"));
            return decData.getValues("xml");
        }
        catch (Exception e) {
            if (JournalLogger.isLogEnabled(18, 50, 1)) {
                JournalLogger.log(18, 50, 1, (Object)e.toString());
            }
            return null;
        }
    }

    protected String addXMLHeader(String data) {
        if (data != null && !data.startsWith("<?xml")) {
            return XMLHEADER + data;
        }
        return data;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setSchemaInfo(NSRecord sourceSchema, NSRecord targetSchema) {
        this.sourceRec = this.compressSchema((NSRecord)sourceSchema.deepClone(), KEY_SOURCE);
        this.targetRec = this.compressSchema((NSRecord)targetSchema.deepClone(), KEY_TARGET);
        this.source = this.getRecordValues(this.sourceRec);
        this.target = this.getRecordValues(this.targetRec);
        this.sourceRec = null;
        this.targetRec = null;
        this.isSchemaInit = false;
    }

    public NSRecord getTarget(Namespace ns) {
        NSRecord record = this.target != null ? NSRecord.createRecord(ns, this.target) : null;
        return record;
    }

    public NSRecord getSource(Namespace ns) {
        NSRecord record = this.source != null ? NSRecord.createRecord(ns, this.source) : null;
        return record;
    }

    void initSchema(Namespace ns) {
        this.targetRec = this.target != null ? NSRecord.createRecord(ns, this.target) : null;
        this.sourceRec = this.source != null ? NSRecord.createRecord(ns, this.source) : null;
        this.isSchemaInit = true;
    }

    public MapValidator getValidator() {
        return this.validator;
    }

    public FlowMapCopy[] getCopyMaps() {
        return this.validator.getCopyMaps();
    }

    public FlowMapSet[] getSetMaps() {
        return this.validator.getSetMaps();
    }

    public FlowMapDelete[] getDeleteMaps() {
        return this.validator.getDeleteMaps();
    }

    public FlowMapInvoke[] getInvokeMaps() {
        return this.validator.getInvokeMaps();
    }

    public void setCopyMode(boolean invokeSameCopy) {
        this.invokeSameCopy = invokeSameCopy;
    }

    public void changeRecRefs(String newName, String oldName, Namespace ns) {
        this.changeRecRefs(this.target, newName, oldName);
        this.changeRecRefs(this.source, newName, oldName);
        this.init(ns);
    }

    void changeRecRefs(Values rec, String newName, String oldName) {
        Values[] recFields;
        if (rec == null || newName == null || oldName == null) {
            return;
        }
        String recRef = rec.getString("rec_ref");
        if (recRef != null && recRef.equals(oldName)) {
            rec.put("rec_ref", newName);
        }
        if ((recFields = rec.getValuesArray("rec_fields")) == null) {
            return;
        }
        for (int i = 0; i < recFields.length; ++i) {
            this.changeRecRefs(recFields[i], newName, oldName);
        }
    }

    public boolean isValid(FlowElement map) {
        return this.validator.isValid(map);
    }

    public String getValidation(FlowElement map) {
        return this.validator.getValidation(map);
    }

    public boolean isValidAssignedField(String to) {
        return this.validator.isValidAssignedField(to);
    }

    public boolean isValidCopy(String from, String to) {
        return this.validator.isValidCopy(from, to, false);
    }

    public boolean isValidImplicit(String from, String to) {
        if (!FlowMapCopy.isValidImplicit(from, to)) {
            return false;
        }
        return this.isValidCopy(from, to);
    }

    public Values getReportable() {
        Values reportableData = super.getReportable();
        reportableData.put(KEY_MODE, this.mode == null ? MODE_STANDALONE : this.mode);
        boolean explicitmapping = this.getCopyMaps() != null && this.getCopyMaps().length > 0 || this.getSetMaps() != null && this.getSetMaps().length > 0 || this.getDeleteMaps() != null && this.getDeleteMaps().length > 0;
        reportableData.put(HAS_EXPLICIT_MAPPING, explicitmapping ? "true" : "false");
        FlowMapInvoke[] invokes = this.getInvokeMaps();
        if (invokes != null) {
            Vector<Values> mapinvokes = new Vector<Values>(invokes.length);
            for (int i = 0; i < invokes.length; ++i) {
                mapinvokes.addElement(invokes[i].getReportable());
            }
            reportableData.put("mapinvokenodes", mapinvokes);
        }
        return reportableData;
    }

    public Object deepClone() {
        FlowMap clone = (FlowMap)super.deepClone();
        clone.validator = new MapValidator(clone);
        return clone;
    }

    public Object clone() {
        FlowMap fm = (FlowMap)super.clone();
        if (this.compiler != null) {
            fm.compiler = (MapCompiler)this.compiler.clone();
        }
        fm.validator = new MapValidator(fm);
        return fm;
    }

    public void compressSchema(Namespace ns) {
        NSRecord record;
        if (this.target != null) {
            record = NSRecord.createRecord(ns, this.target);
            record = this.compressSchema(record, KEY_TARGET);
            this.target = this.getRecordValues(record);
        }
        if (this.source != null) {
            record = NSRecord.createRecord(ns, this.source);
            record = this.compressSchema(record, KEY_SOURCE);
            this.source = this.getRecordValues(record);
        }
    }

    private Values getRecordValues(NSRecord record) {
        if (record == null) {
            return null;
        }
        Values v = record.getValues();
        NSField[] children = record.getFieldNodes();
        if (children == null || children.length == 0) {
            return v;
        }
        Values[] vals = new Values[children.length];
        for (int i = 0; i < children.length; ++i) {
            if (children[i] == null) continue;
            vals[i] = children[i].getType() == 2 ? this.getRecordValues((NSRecord)children[i]) : children[i].getValues();
        }
        v.put("rec_fields", vals);
        return v;
    }

    private NSRecord compressSchema(NSRecord record, String type) {
        FlowElement[] nodes = this.getNodes();
        if (nodes == null || nodes.length == 0 || record == null) {
            return null;
        }
        if (record instanceof NSRecordRef) {
            return record;
        }
        NSField[] fields = record.getFieldNodes();
        if (fields == null || fields.length == 0) {
            return record;
        }
        boolean isTarget = type.equals(KEY_TARGET);
        record.setUIEditable(true);
        this.markRecord(record);
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i] instanceof FlowMapCopy) {
                MapWmPathInfo pathInfo = isTarget ? ((FlowMapCopy)nodes[i]).getParsedTo() : ((FlowMapCopy)nodes[i]).getParsedFrom();
                this.filterRecord(record, pathInfo);
                continue;
            }
            if (nodes[i] instanceof FlowMapSet) {
                if (!isTarget) continue;
                this.filterRecord(record, ((FlowMapSet)nodes[i]).getParsedPath());
                continue;
            }
            if (nodes[i] instanceof FlowMapDelete) {
                this.filterRecord(record, ((FlowMapDelete)nodes[i]).getParsedPath());
                continue;
            }
            if (!(nodes[i] instanceof FlowMapInvoke)) continue;
            FlowMap map = isTarget ? nodes[i].getOutputMap() : nodes[i].getInputMap();
            FlowMapCopy[] copys = null;
            if (map != null) {
                copys = map.getCopyMaps();
            }
            if (copys == null) continue;
            for (int j = 0; j < copys.length; ++j) {
                MapWmPathInfo pathInfo = isTarget ? copys[j].getParsedTo() : copys[j].getParsedFrom();
                this.filterRecord(record, pathInfo);
            }
        }
        this.deleteRecord(record);
        return record;
    }

    private void filterRecord(NSRecord record, MapWmPathInfo path) {
        if (record == null || path == null) {
            return;
        }
        WmPathItem[] items = path.getPathItems();
        NSRecord parent = record;
        for (int i = 0; i < items.length; ++i) {
            NSField field = NSRecordWmPathProcessor.get(parent, items[i]);
            if (field == null) {
                return;
            }
            field.setUIEditable(false);
            if (i == 0) {
                record.setUIEditable(false);
            }
            if (field.getType() != 2) {
                return;
            }
            parent = (NSRecord)field;
        }
    }

    private void markRecord(NSRecord record) {
        NSField[] fields = record.getFieldNodes();
        if (fields == null) {
            return;
        }
        for (int i = 0; i < fields.length; ++i) {
            fields[i].setUIEditable(true);
            if (fields[i].getType() != 2) continue;
            this.markRecord((NSRecord)fields[i]);
        }
    }

    private void deleteRecord(NSRecord record) {
        if (record.isUIEditable()) {
            record.removeAllFields();
        } else {
            NSField[] fields = record.getFieldNodes();
            if (fields == null) {
                return;
            }
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].getType() != 2) continue;
                this.deleteRecord((NSRecord)fields[i]);
            }
        }
    }
}

