/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowExit;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.flow.MapUtil;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.TableUtil;
import com.wm.lang.flow.resources.FlowExceptionBundle;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.util.JournalLogger;
import com.wm.util.Values;
import com.wm.util.pluggable.WmIDataList;
import java.lang.reflect.Array;
import java.util.Vector;

public class FlowLoop
extends FlowElement {
    public static final String KEY_LOOP_INARRAY = "in-array";
    public static final String KEY_LOOP_OUTARRAY = "out-array";
    public static final String KEY_LOOP_ITERATION = "$iteration";
    MapWmPathInfo inarray;
    MapWmPathInfo outarray;
    int position;
    int looplen;
    Object[] pipeline_inarray;
    Vector pipeline_outarray;
    Object[] saved_outarray;
    Class inarray_type;
    static final String KEY_LOOP_STATE_POSITION = "position";
    static final String KEY_LOOP_STATE_LOOPLEN = "looplen";
    static final String KEY_LOOP_STATE_INARRAY = "inarray";
    static final String KEY_LOOP_STATE_OUTARRAY = "outarray";
    static final String KEY_LOOP_STATE_SAVEDOUTARRAY = "savedOutarray";
    static final String KEY_LOOP_STATE_INARRAYTYPE = "inarrayType";

    public FlowLoop(Values val) {
        super(val);
        this.type = "LOOP";
    }

    public NSRecord getProperties() {
        NSRecord params = super.getProperties();
        params.addField(new NSField(null, KEY_LOOP_INARRAY, 1, 0));
        params.addField(new NSField(null, KEY_LOOP_OUTARRAY, 1, 0));
        return params;
    }

    public String getInArray() {
        return this.inarray == null ? null : this.inarray.getPathString();
    }

    public String getOutArray() {
        return this.outarray == null ? null : this.outarray.getPathString();
    }

    public Values getValues() {
        String inPath = this.inarray != null ? this.inarray.getPathString() : null;
        String outPath = this.outarray != null ? this.outarray.getPathString() : null;
        Object[][] o = new Object[][]{{KEY_LOOP_INARRAY, inPath}, {KEY_LOOP_OUTARRAY, outPath}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
        this.inarray = MapWmPathInfo.create(val.getString(KEY_LOOP_INARRAY));
        this.outarray = MapWmPathInfo.create(val.getString(KEY_LOOP_OUTARRAY));
    }

    public IData getAsData() {
        String inPath = this.inarray != null ? this.inarray.getPathString() : null;
        String outPath = this.outarray != null ? this.outarray.getPathString() : null;
        IData result = super.getAsData();
        IDataCursor ic = result.getCursor();
        if (inPath != null) {
            IDataUtil.put(ic, KEY_LOOP_INARRAY, inPath);
        }
        if (outPath != null) {
            IDataUtil.put(ic, KEY_LOOP_OUTARRAY, outPath);
        }
        ic.destroy();
        return result;
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this.inarray = MapWmPathInfo.create(IDataUtil.getString(ic, KEY_LOOP_INARRAY));
        this.outarray = MapWmPathInfo.create(IDataUtil.getString(ic, KEY_LOOP_OUTARRAY));
        ic.destroy();
    }

    public Values getStateValues() {
        Object[][] o = new Object[][]{{KEY_LOOP_STATE_POSITION, String.valueOf(this.position)}, {KEY_LOOP_STATE_LOOPLEN, String.valueOf(this.looplen)}, {KEY_LOOP_STATE_INARRAY, this.pipeline_inarray}, {KEY_LOOP_STATE_OUTARRAY, this.pipeline_outarray}, {KEY_LOOP_STATE_SAVEDOUTARRAY, this.saved_outarray}, {KEY_LOOP_STATE_INARRAYTYPE, this.inarray_type.getName()}};
        return super.getStateValues().copyFrom(this.getValues()).copyFrom(new Values(o));
    }

    public void setStateValues(Values val) {
        super.setStateValues(val);
        this.setValues(val);
        try {
            this.position = val.getInt(KEY_LOOP_STATE_POSITION);
            this.looplen = val.getInt(KEY_LOOP_STATE_LOOPLEN);
            this.pipeline_inarray = (Object[])val.get(KEY_LOOP_STATE_INARRAY);
            this.pipeline_outarray = (Vector)val.get(KEY_LOOP_STATE_OUTARRAY);
            this.saved_outarray = (Object[])val.get(KEY_LOOP_STATE_SAVEDOUTARRAY);
            this.inarray_type = Class.forName(val.getString(KEY_LOOP_STATE_INARRAYTYPE));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void init(FlowState state) {
        this.position = 0;
        this.looplen = 0;
        this.pipeline_inarray = null;
        this.pipeline_outarray = null;
    }

    public void invoke(FlowState state) {
        if (JournalLogger.isLogEnabled(6, 49, 7)) {
            JournalLogger.log(6, 49, 7, this.getDebugLabel(), state.toString());
        }
        IData pipeline = state.getPipeline();
        WmIDataList[] findTable = null;
        if (this.pipeline_inarray == null) {
            if (this.inarray == null) {
                FlowExit exit = new FlowExit(new Values(new Object[][]{{"from", "$flow"}, {"signal", FlowExit.signalOptions[1]}}));
                exit.setLocalizedExceptionInfo(FlowExceptionBundle.NO_PROP_IN_ARRAY, "", this.getVerboseName(state.getLocale()));
                state.setExit(exit);
                state.setDone(true);
                return;
            }
            Object o = IDataWmPathProcessor.getNode(pipeline, this.inarray.getPathItems());
            if (o == null || !o.getClass().isArray()) {
                state.setDone(true);
                return;
            }
            this.pipeline_inarray = (Object[])o;
            this.looplen = this.pipeline_inarray.length;
            this.inarray_type = this.pipeline_inarray.getClass().getComponentType();
            if (this.inarray_type == null) {
                if (JournalLogger.isLogEnabled(10, 49, 7)) {
                    JournalLogger.log(10, 49, 7, this.getName(), this.inarray.getPathDisplayString());
                }
                this.looplen = -1;
            }
            if (this.outarray != null) {
                findTable = TableUtil.findTable(pipeline, this.outarray.getPathItems(), pipeline);
                Object op = IDataWmPathProcessor.getNode(pipeline, this.outarray.getPathItems());
                if (op != null) {
                    if (op.getClass().isArray()) {
                        if (((Object[])op).length != this.pipeline_inarray.length && JournalLogger.isLogEnabled(15, 49, 7)) {
                            JournalLogger.log(15, 49, 7, this.getDebugLabel(), state.toString());
                        }
                        this.saved_outarray = (Object[])op;
                        this.pipeline_outarray = new Vector();
                        IDataWmPathProcessor.putNode(pipeline, null, this.outarray.getPathItems());
                    }
                } else {
                    this.pipeline_outarray = new Vector();
                }
            }
            if (this.looplen > 0) {
                this.setNextInitValues(pipeline);
            }
        }
        if (state.shouldExit(this)) {
            this.exit(state, pipeline, false);
            state.willExit();
        } else {
            IDataCursor cursor;
            if (this.looplen > 0) {
                cursor = pipeline.getCursor();
                if (cursor.first(KEY_LOOP_ITERATION)) {
                    cursor.setValue(String.valueOf(this.position + 1));
                } else {
                    cursor.insertAfter(KEY_LOOP_ITERATION, String.valueOf(this.position + 1));
                }
            } else {
                state.setDone(true);
                return;
            }
            cursor.destroy();
            if (state.getError() != null) {
                this.exit(state, pipeline, false);
                state.willExit();
                return;
            }
            if (state.pushNextNode() == null) {
                if (this.position + 1 >= this.looplen) {
                    this.exit(state, pipeline, true);
                } else {
                    this.nextIteration(state, pipeline, true);
                }
            }
        }
        if (findTable != null && findTable.length > 0) {
            TableUtil.recoverTable(pipeline, this.outarray.getPathItems(), findTable);
        }
    }

    private void exit(FlowState state, IData pipeline, boolean updateOutArray) {
        IDataCursor cursor;
        if (this.pipeline_outarray != null && updateOutArray) {
            this.updateOutArray(pipeline);
        }
        if (this.pipeline_inarray != null) {
            IDataWmPathProcessor.putNode(pipeline, (Object)this.pipeline_inarray, this.inarray.getPathItems());
        }
        if (this.pipeline_outarray != null) {
            IDataWmPathProcessor.putNode(pipeline, FlowLoop.stronglyType(this.pipeline_outarray, this.saved_outarray, this.inarray_type), this.outarray.getPathItems());
        }
        if ((cursor = pipeline.getCursor()).first(KEY_LOOP_ITERATION)) {
            cursor.delete();
        }
        cursor.destroy();
        state.setDone(true);
    }

    private void nextIteration(FlowState state, IData pipeline, boolean updateOutArray) {
        if (this.pipeline_outarray != null && updateOutArray) {
            this.updateOutArray(pipeline);
        }
        ++this.position;
        IDataCursor cursor = pipeline.getCursor();
        if (cursor.first(KEY_LOOP_ITERATION)) {
            cursor.setValue(String.valueOf(this.position + 1));
        } else {
            cursor.insertAfter(KEY_LOOP_ITERATION, String.valueOf(this.position + 1));
        }
        cursor.destroy();
        this.setNextInitValues(pipeline);
        state.setNextNode(0);
    }

    private void updateOutArray(IData pipeline) {
        Object o = IDataWmPathProcessor.getNode(pipeline, this.outarray.getPathItems());
        this.pipeline_outarray.addElement(MapUtil.cloneData(o));
        if (o != null) {
            IDataWmPathProcessor.putNode(pipeline, null, this.outarray.getPathItems());
        }
    }

    private void setNextInitValues(IData pipeline) {
        IDataWmPathProcessor.putNode(pipeline, this.pipeline_inarray[this.position], this.inarray.getPathItems());
        if (this.saved_outarray != null && this.position < this.saved_outarray.length) {
            IDataWmPathProcessor.putNode(pipeline, this.saved_outarray[this.position], this.outarray.getPathItems());
        }
    }

    private static Object stronglyType(Vector outarray, Object[] saved, Class defaultType) {
        int len;
        if (outarray == null) {
            return null;
        }
        Object[] collect = null;
        if (saved != null) {
            int i;
            if (outarray.size() <= saved.length) {
                collect = saved;
                len = outarray.size();
                for (i = 0; i < len; ++i) {
                    Object o = outarray.elementAt(i);
                    if (o == null || o.getClass() != collect[i].getClass()) continue;
                    collect[i] = outarray.elementAt(i);
                }
            } else {
                len = outarray.size();
                collect = new Object[len];
                outarray.copyInto(collect);
                len = saved.length;
                for (i = 0; i < len; ++i) {
                    if (collect[i] != null) continue;
                    collect[i] = saved[i];
                }
            }
        } else {
            collect = new Object[outarray.size()];
            outarray.copyInto(collect);
        }
        Class<?> type = null;
        boolean isIData = true;
        len = collect.length;
        for (int i = 0; i < len; ++i) {
            Object o = collect[i];
            if (o == null) continue;
            Class<?> c = o.getClass();
            if (c != null) {
                if (type == null) {
                    type = c;
                } else if (type != c) {
                    type = null;
                    break;
                }
            }
            if (!isIData) continue;
            isIData = o instanceof IData;
        }
        Object result = null;
        if (type == null && isIData) {
            result = new IData[len];
        } else {
            if (type == null) {
                type = defaultType;
            }
            result = Array.newInstance(type, len);
        }
        for (int j = 0; j < len; ++j) {
            Array.set(result, j, collect[j]);
        }
        return result;
    }

    public Values getReportable() {
        String inPath = this.inarray != null ? this.inarray.getPathString() : null;
        String outPath = this.outarray != null ? this.outarray.getPathString() : null;
        Object[][] o = new Object[][]{{KEY_LOOP_INARRAY, inPath}, {KEY_LOOP_OUTARRAY, outPath}};
        return super.getReportable().copyFrom(new Values(o));
    }
}

