/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataUtil;
import com.wm.data.ValuesEmulator;
import com.wm.lang.flow.CopyPathInfo;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowException;
import com.wm.lang.flow.FlowExceptionHandler;
import com.wm.lang.flow.FlowExit;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.resources.FlowExceptionBundle;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSNode;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.NSSignature;
import com.wm.lang.ns.Namespace;
import com.wm.lang.schema.Validator;
import com.wm.lang.schema.ValidatorOptions;
import com.wm.util.JournalLogger;
import com.wm.util.Values;

public class FlowInvoke
extends FlowElement {
    private static final boolean debug = false;
    public static final String KEY_INVOKE_SERVICE = "service";
    public static final String KEY_INVOKE_USER = "as-user";
    public static final String KEY_INVOKE_VALIDATE_IN = "validate-in";
    public static final String KEY_INVOKE_VALIDATE_OUT = "validate-out";
    static final String VAL_ADMINISTRATOR = "Administrator";
    public static final String VAL_NONE = "$none";
    public static final String VAL_DEFAULT = "$default";
    public static final String KEY_ELEMENT_INTERFACE = "interface";
    public static final String KEY_SERVICE_FULL_NAME = "fullservicename";
    NSName service;
    String validateIn;
    String validateOut;

    public FlowInvoke(Values val) {
        super(val);
        this.type = "INVOKE";
    }

    public NSRecord getProperties() {
        NSRecord prop = super.getProperties();
        prop.addField(new NSField(null, KEY_INVOKE_SERVICE, 1, 0));
        NSField validate = new NSField(null, KEY_INVOKE_VALIDATE_IN, 1, 0);
        validate.setStringOptions(new String[]{VAL_NONE, VAL_DEFAULT});
        prop.addField(validate);
        validate = new NSField(null, KEY_INVOKE_VALIDATE_OUT, 1, 0);
        validate.setStringOptions(new String[]{VAL_NONE, VAL_DEFAULT});
        prop.addField(validate);
        return prop;
    }

    public NSName getService() {
        return this.service;
    }

    public NSService getService(Namespace ns, NSName name) {
        NSNode svc = ns.getNode(name);
        if (svc != null && svc.getNodeTypeObj().equals(NSService.TYPE)) {
            return (NSService)svc;
        }
        return null;
    }

    public boolean hasNodes() {
        return false;
    }

    public void setService(NSName service) {
        this.service = service;
    }

    public void setValidateIn(String parm) {
        this.validateIn = parm;
    }

    public void setValiateOut(String parm) {
        this.validateOut = parm;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_INVOKE_SERVICE, this.service != null ? this.service.toString() : null}, {KEY_INVOKE_VALIDATE_IN, this.validateIn}, {KEY_INVOKE_VALIDATE_OUT, this.validateOut}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
        if (val == null) {
            return;
        }
        try {
            this.service = NSName.create(val.getString(KEY_INVOKE_SERVICE));
            this.validateIn = val.getString(KEY_INVOKE_VALIDATE_IN);
            this.validateOut = val.getString(KEY_INVOKE_VALIDATE_OUT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public IData getAsData() {
        IData result = super.getAsData();
        IDataCursor ic = result.getCursor();
        if (this.service != null) {
            IDataUtil.put(ic, KEY_INVOKE_SERVICE, this.service.toString());
        }
        IDataUtil.put(ic, KEY_INVOKE_VALIDATE_IN, this.validateIn);
        IDataUtil.put(ic, KEY_INVOKE_VALIDATE_OUT, this.validateOut);
        ic.destroy();
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromData(IData val) {
        super.setFromData(val);
        if (val == null) {
            return;
        }
        IDataCursor ic = val.getCursor();
        try {
            this.service = NSName.create(IDataUtil.getString(ic, KEY_INVOKE_SERVICE));
            this.validateIn = IDataUtil.getString(ic, KEY_INVOKE_VALIDATE_IN);
            this.validateOut = IDataUtil.getString(ic, KEY_INVOKE_VALIDATE_OUT);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            ic.destroy();
        }
    }

    public Values getStateValues() {
        return super.getStateValues().copyFrom(this.getValues());
    }

    public void setStateValues(Values val) {
        super.setStateValues(val);
        this.setValues(val);
    }

    public void invoke(FlowState state) {
        Object err;
        NSService svc;
        if (JournalLogger.isLogEnabled(5, 49, 7)) {
            JournalLogger.log(5, 49, 7, this.getDebugLabel(), state.toString());
        }
        if ((svc = this.getService(state.getNamespace(), this.service)) == null) {
            Object[] o = new Object[]{this.getVerboseName(state.getLocale()), this.service == null ? "null" : this.service.toString(), this.getNSName()};
            this.setError(state, FlowExceptionBundle.BAD_PROP_SERVICE, "", o);
            return;
        }
        String svcName = svc.getNSName().getFullName();
        IData in = null;
        IData in_clone = null;
        if (this.type == "MAPINVOKE") {
            in = state.getPipelet();
        } else {
            in = state.getPipeline();
            if (svc.getServiceType().isFlowService()) {
                in_clone = IDataUtil.clone(in);
            }
        }
        IData out = null;
        Exception e = null;
        NSSignature signature = svc.getSignature();
        ValidatorOptions defOpts = Validator.getDefaultOptions();
        boolean defEnabled = defOpts.isValidationEnabled();
        try {
            CopyPathInfo copyPathInfo;
            if (this.validateIn != null && this.validateIn.equals(VAL_DEFAULT) && defEnabled) {
                NSRecord inNSRecord = signature.getInput();
                Validator v = Validator.create(in, inNSRecord);
                if (v == null) {
                    throw new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.NO_INPUT_VALIDATOR, "", svcName);
                }
                IData results = v.validate();
                boolean isValid = ValuesEmulator.getBoolean(results, "isValid");
                if (!isValid) {
                    Object[] subs = new Object[]{svcName, FlowInvoke.getValidationMsgs(results)};
                    throw new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.FAILED_INPUT_VALIDATION, "", subs);
                }
            }
            if ((copyPathInfo = CopyPathInfo.create(this, state.getNamespace(), in, state.getPipeline())) != null) {
                copyPathInfo.addPathInfo(in);
            }
            out = in;
            out = svc.invoke(in);
            if (copyPathInfo != null) {
                copyPathInfo.removePathInfo(in);
            }
            if (this.isExpired()) {
                throw new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.TIMEOUT, "", this.getVerboseName(state.getLocale()));
            }
            if (out != in && in_clone == null && svc.getServiceSigtype() < 4) {
                IDataUtil.merge(out, in);
            }
            if (out != null && out instanceof Values) {
                in = Values.use(in);
                ((Values)in).copyPrivateDataFrom((Values)out);
            }
            out = in;
            if (in_clone != null) {
                IDataCursor c = out.getCursor();
                IDataCursor s = in_clone.getCursor();
                while (c.next()) {
                    if (!s.first(c.getKey())) continue;
                    s.delete();
                }
                c.destroy();
                IDataUtil.append(in_clone, out);
                s.destroy();
            }
            if (this.validateOut != null && this.validateOut.equals(VAL_DEFAULT) && defEnabled) {
                NSRecord outNSRecord = signature.getOutput();
                Validator v = Validator.create(out, outNSRecord);
                if (v == null) {
                    throw new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.NO_OUTPUT_VALIDATOR, "", svcName);
                }
                IData results = v.validate();
                boolean isValid = ValuesEmulator.getBoolean(results, "isValid");
                if (!isValid) {
                    Object[] subs = new Object[]{svcName, FlowInvoke.getValidationMsgs(results)};
                    throw new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.FAILED_OUTPUT_VALIDATION, "", subs);
                }
            }
        }
        catch (Exception e2) {
            e = e2;
        }
        if (e == null) {
            if (this.type == "MAPINVOKE") {
                state.setPipelet(out);
            } else {
                state.setPipeline(out);
                state.clearLastErrorInfo();
            }
        } else {
            FlowExceptionHandler fex;
            state.setError(e);
            if (this.type == "MAPINVOKE") {
                state.setMapInvokeError(true);
            }
            if ((fex = state.getFlowExceptionHandler()) != null) {
                state.setLastErrorInfo(fex.getException());
            }
        }
        if (out != null && out instanceof Values && (err = ((Values)out).getPrivate("$exception")) != null) {
            if (err instanceof Exception) {
                state.setError((Exception)err);
            } else {
                state.setError((Throwable)err);
            }
            ((Values)out).removePrivate("$exception");
        }
        if (this.type != "MAPINVOKE") {
            state.setDone(true);
        }
    }

    private void setError(FlowState state, String key, String sourceID, String sub) {
        FlowExit exit = new FlowExit(new Values(new Object[][]{{"from", "$flow"}, {"signal", FlowExit.signalOptions[1]}}));
        exit.setLocalizedExceptionInfo(key, sourceID, sub);
        state.setExit(exit);
        state.setDone(true);
    }

    private void setError(FlowState state, String key, String sourceID, Object[] subs) {
        FlowExit exit = new FlowExit(new Values(new Object[][]{{"from", "$flow"}, {"signal", FlowExit.signalOptions[1]}}));
        exit.setLocalizedExceptionInfo(key, sourceID, subs);
        state.setExit(exit);
        state.setDone(true);
    }

    public static String getValidationMsgs(IData results) {
        IData[] vals = null;
        IDataCursor idhc = results.getCursor();
        if (idhc.first("errors")) {
            vals = (IData[])idhc.getValue();
        }
        idhc.destroy();
        String msg = "";
        for (int i = 0; i < vals.length; ++i) {
            IDataCursor idc = vals[i].getCursor();
            while (idc.next()) {
                if (msg != "") {
                    msg = msg + " ";
                }
                msg = msg + idc.getValue();
            }
        }
        return msg;
    }

    public Values getReportable() {
        Object[][] o = new Object[][]{{KEY_INVOKE_SERVICE, this.service != null ? this.service.getNodeName().toString() : null}, {KEY_SERVICE_FULL_NAME, this.service != null ? this.service.toString() : null}, {KEY_ELEMENT_INTERFACE, this.service != null ? this.getService().getInterfaceName().toString() : null}, {KEY_INVOKE_VALIDATE_IN, this.validateIn}, {KEY_INVOKE_VALIDATE_OUT, this.validateOut}};
        return super.getReportable().copyFrom(new Values(o));
    }
}

