/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowElementSimple;
import com.wm.lang.flow.FlowException;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.MapSet;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.util.JournalLogger;
import com.wm.util.LocalizedExceptionInfo;
import com.wm.util.Values;

public class FlowExit
extends FlowElementSimple {
    public static final String KEY_EXIT_FROM = "from";
    public static final String KEY_EXIT_SIGNAL = "signal";
    public static final String KEY_EXIT_FAILURE_MESSAGE = "failure-message";
    public static final String EXIT_SUCCESS = "SUCCESS";
    public static final String EXIT_FAILURE = "FAILURE";
    public static final String EXCEPTION_BUNDLE_BASE_NAME = "com.wm.lang.flow.resources.FlowExceptionBundle";
    public static final String[] signalOptions = new String[]{"SUCCESS", "FAILURE"};
    static final int SUCCESS = 0;
    static final int FAILURE = 1;
    String from;
    int signal;
    String message;
    LocalizedExceptionInfo localInfo;
    Object[] msgSubList;
    String clonedMessage;
    boolean done;
    static final String KEY_EXIT_STATE_DONE = "done";

    public FlowExit(Values val) {
        super(val);
        this.type = "EXIT";
    }

    public NSRecord getProperties() {
        NSRecord params = super.getProperties();
        NSField from = new NSField(null, KEY_EXIT_FROM, 1, 0);
        IData hints = from.getHints();
        if (hints == null) {
            hints = IDataFactory.create();
            from.setHints(hints);
        }
        IDataCursor ic = hints.getCursor();
        ic.insertAfter("field_usereditable", String.valueOf(true));
        ic.destroy();
        from.setStringOptions(new String[]{"$parent", "$loop", "$flow"});
        params.addField(from);
        NSField signal = new NSField(null, KEY_EXIT_SIGNAL, 1, 0);
        signal.setStringOptions(signalOptions);
        params.addField(signal);
        params.addField(new NSField(null, KEY_EXIT_FAILURE_MESSAGE, 1, 0));
        return params;
    }

    public boolean hasNodes() {
        return false;
    }

    public Values getValues() {
        Object[][] o = new Object[][]{{KEY_EXIT_FROM, this.from}, {KEY_EXIT_SIGNAL, this.signal == 1 ? EXIT_FAILURE : EXIT_SUCCESS}, {KEY_EXIT_FAILURE_MESSAGE, this.message}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
        this.from = val.getNonEmptyString(KEY_EXIT_FROM);
        String ret = val.getString(KEY_EXIT_SIGNAL);
        if (ret == null || ret.equalsIgnoreCase("success")) {
            this.signal = 0;
        } else if (ret.equalsIgnoreCase("failure")) {
            this.signal = 1;
        }
        this.message = val.getString(KEY_EXIT_FAILURE_MESSAGE);
        if (this.message != null) {
            this.msgSubList = MapSet.processPath(MapSet.parseVars(this.message));
            if (this.msgSubList == null) {
                this.clonedMessage = new String(this.message);
            }
        }
    }

    public IData getAsData() {
        IData result = super.getAsData();
        IDataCursor ic = result.getCursor();
        if (this.from != null) {
            IDataUtil.put(ic, KEY_EXIT_FROM, this.from);
        }
        IDataUtil.put(ic, KEY_EXIT_SIGNAL, this.signal == 1 ? EXIT_FAILURE : EXIT_SUCCESS);
        if (this.message != null) {
            IDataUtil.put(ic, KEY_EXIT_FAILURE_MESSAGE, this.message);
        }
        ic.destroy();
        return result;
    }

    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        this.from = IDataUtil.getString(ic, KEY_EXIT_FROM);
        String ret = IDataUtil.getString(ic, KEY_EXIT_SIGNAL);
        if (ret == null || ret.equalsIgnoreCase("success")) {
            this.signal = 0;
        } else if (ret.equalsIgnoreCase("failure")) {
            this.signal = 1;
        }
        this.message = IDataUtil.getString(ic, KEY_EXIT_FAILURE_MESSAGE);
        if (this.message != null) {
            this.msgSubList = MapSet.processPath(MapSet.parseVars(this.message));
            if (this.msgSubList == null) {
                this.clonedMessage = new String(this.message);
            }
        }
    }

    public Values getStateValues() {
        Object[][] o = new Object[][]{{KEY_EXIT_STATE_DONE, String.valueOf(this.done)}};
        return super.getStateValues().copyFrom(this.getValues()).copyFrom(new Values(o));
    }

    public void setStateValues(Values val) {
        super.setStateValues(val);
        this.setValues(val);
        this.done = val.getBoolean(KEY_EXIT_STATE_DONE);
    }

    public void invoke(FlowState state) {
        if (JournalLogger.isLogEnabled(14, 49, 7)) {
            JournalLogger.log(14, 49, 7, this.name, state.toString());
        }
        if (this.msgSubList != null) {
            this.clonedMessage = MapSet.substituteVars(this.msgSubList, state.getPipeline());
        }
        state.setExit(this);
        state.setDone(true);
    }

    boolean isExitFlow() {
        return this.from != null && this.from.equals("$flow");
    }

    boolean isExitParent() {
        return this.from != null && this.from.equals("$parent");
    }

    boolean isExitLoop() {
        return this.from == null || this.from.equals("$loop");
    }

    boolean isExitLabel() {
        return !this.isExitFlow() && !this.isExitParent() && !this.isExitLoop();
    }

    public void setLocalizedExceptionInfo(String key, String sourceID, Object[] subs) {
        this.localInfo = new LocalizedExceptionInfo(EXCEPTION_BUNDLE_BASE_NAME, key, subs, this.getClass().getClassLoader());
    }

    public void setLocalizedExceptionInfo(String key, String sourceID, String sub) {
        this.setLocalizedExceptionInfo(key, sourceID, new Object[]{sub});
    }

    public LocalizedExceptionInfo getLocalizedExceptionInfo() {
        return this.localInfo;
    }

    public boolean shouldExit(FlowElement current) {
        boolean loop;
        if (current == null) {
            return false;
        }
        boolean bl = loop = current.type.equals("LOOP") || current.type.equals("RETRY");
        if (this.isExitFlow()) {
            return true;
        }
        if (this.isExitLoop()) {
            if (loop) {
                this.done = true;
            }
        } else if (this.isExitParent()) {
            this.done = true;
        } else if (current.getName() != null && this.from.equals(current.getName())) {
            this.done = true;
        }
        return true;
    }

    public Exception getFailure() {
        if (this.signal == 1) {
            if (this.localInfo != null) {
                return new FlowException(this.localInfo);
            }
            return new FlowException(this.clonedMessage);
        }
        return null;
    }

    public boolean isExitDone() {
        return this.done;
    }

    public Values getReportable() {
        Object[][] o = new Object[][]{{KEY_EXIT_FROM, this.from}, {KEY_EXIT_SIGNAL, this.signal == 1 ? EXIT_FAILURE : EXIT_SUCCESS}, {KEY_EXIT_FAILURE_MESSAGE, this.message}};
        return super.getReportable().copyFrom(new Values(o));
    }
}

