/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataPortable;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.ExpressionEvaluator;
import com.wm.lang.flow.FlowBranch;
import com.wm.lang.flow.FlowException;
import com.wm.lang.flow.FlowExit;
import com.wm.lang.flow.FlowInvoke;
import com.wm.lang.flow.FlowLoop;
import com.wm.lang.flow.FlowMap;
import com.wm.lang.flow.FlowMapCopy;
import com.wm.lang.flow.FlowMapDelete;
import com.wm.lang.flow.FlowMapInvoke;
import com.wm.lang.flow.FlowMapSet;
import com.wm.lang.flow.FlowNotify;
import com.wm.lang.flow.FlowRetry;
import com.wm.lang.flow.FlowRoot;
import com.wm.lang.flow.FlowSequence;
import com.wm.lang.flow.FlowSpawn;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.FlowWait;
import com.wm.lang.flow.MalformedExpressionException;
import com.wm.lang.flow.MapSet;
import com.wm.lang.flow.resources.FlowExceptionBundle;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSName;
import com.wm.lang.ns.NSRecord;
import com.wm.lang.ns.Namespace;
import com.wm.util.CronJob;
import com.wm.util.JournalLogger;
import com.wm.util.Reportable;
import com.wm.util.Strings;
import com.wm.util.Values;
import com.wm.util.coder.ValuesCodable;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public abstract class FlowElement
implements IDataPortable,
ValuesCodable,
Cloneable,
Reportable {
    public static final String TYPE_ROOT = "ROOT";
    public static final String TYPE_INVOKE = "INVOKE";
    public static final String TYPE_BRANCH = "BRANCH";
    public static final String TYPE_RETRY = "RETRY";
    public static final String TYPE_SEQUENCE = "SEQUENCE";
    public static final String TYPE_LOOP = "LOOP";
    public static final String TYPE_MAP = "MAP";
    public static final String TYPE_EXIT = "EXIT";
    public static final String TYPE_NOTIFY = "NOTIFY";
    public static final String TYPE_SPAWN = "SPAWN";
    public static final String TYPE_WAIT = "WAIT";
    public static final String TYPE_MAPCOPY = "MAPCOPY";
    public static final String TYPE_MAPDELETE = "MAPDELETE";
    public static final String TYPE_MAPSET = "MAPSET";
    public static final String TYPE_MAPEMPTY = "MAPEMPTY";
    public static final String TYPE_MAPINVOKE = "MAPINVOKE";
    public static final String KEY_ELEMENT_COMMENT = "comment";
    public static final String KEY_ELEMENT_TYPE = "type";
    public static final String KEY_ELEMENT_NAME = "label";
    public static final String KEY_ELEMENT_SCOPE = "scope";
    public static final String KEY_ELEMENT_INPUT_MAP = "input_map";
    public static final String KEY_ELEMENT_TIMEOUT = "timeout";
    public static final String KEY_ELEMENT_CONDITION = "evaluate-labels";
    public static final String KEY_ELEMENT_EXPAND = "expand";
    public static final String KEY_ELEMENT_NODES = "nodes";
    public static final String KEY_ELEMENT_OUTPUT_MAP = "output_map";
    public static final String KEY_ELEMENT_DISABLED = "disabled";
    public static final String KEY_ELEMENT_INVISIBLE = "invisible";
    public static final String KEY_ELEMENT_XPOS = "x-pos";
    public static final String KEY_ELEMENT_YPOS = "y-pos";
    public static final String KEY_ELEMENT_XTAIL = "x-tail";
    public static final String KEY_ELEMENT_YTAIL = "y-tail";
    static final String KEY_ELEMENT_STATE_NODEINDEX = "nodeIndex";
    static final String KEY_ELEMENT_STATE_PIPESTART = "pipeStart";
    static final String KEY_ELEMENT_STATE_PIPEDONE = "pipeDone";
    static final String KEY_ELEMENT_STATE_ID = "ID";
    String type;
    String name;
    String comment;
    String scope;
    Vector nodes;
    FlowMap input_map;
    FlowMap output_map;
    FlowElement parent;
    String timeout;
    String subsTimeout;
    Object[] timeoutSubList;
    boolean expand;
    long timeout_ms;
    long jobTime;
    boolean isRegex;
    boolean hasBreakPoint = false;
    boolean hasWatchPoint = false;
    boolean disabled = false;
    boolean invisible = false;
    int xPos = 0;
    int yPos = 0;
    int xTail = 0;
    int yTail = 0;
    PatternCompiler compiler;
    PatternMatcher matcher;
    Pattern pattern;
    CronJob timeoutTask;
    boolean inputMapOnly;
    boolean outputMapOnly;
    int id;
    int nodeIndex;
    boolean pipeStart = true;
    boolean pipeDone = false;
    boolean isCondition = false;

    public FlowElement(Values val) {
        this.setValues(val);
    }

    public FlowElement(IData val) {
        this.setFromData(val);
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public boolean equals(FlowElement fe) {
        return fe.getID() == this.getID();
    }

    public String getName() {
        if (this.name != null && this.name.length() == 0) {
            return null;
        }
        return this.name;
    }

    public String getDebugLabel() {
        return this.name == null ? "" : this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayType() {
        return this.getDisplayType(Locale.getDefault());
    }

    public String getDisplayType(Locale locale) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.wm.lang.flow.resources.FlowTypesBundle", locale);
        if (bundle == null) {
            return this.type;
        }
        String local_type = bundle.getString(this.type);
        if (local_type != null && local_type.length() != 0) {
            return local_type;
        }
        return this.type;
    }

    public String getVerboseName() {
        return this.getVerboseName(Locale.getDefault());
    }

    public String getVerboseName(Locale locale) {
        FlowInvoke temp;
        NSName service;
        if (this.name != null && this.name.length() > 0) {
            return this.name;
        }
        if (this.getFlowType().equals(TYPE_MAPINVOKE) && (service = (temp = (FlowInvoke)this).getService()) != null) {
            FlowException invokeError = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.TRANSFORMER, "", service.getFullName());
            return invokeError.getMsgOnly(locale);
        }
        if (this.getFlowType().equals(TYPE_INVOKE) && (service = (temp = (FlowInvoke)this).getService()) != null) {
            FlowException invokeError = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.INVOKE_FOR, "", service.getFullName());
            return invokeError.getMsgOnly(locale);
        }
        FlowException error = new FlowException(FlowExceptionBundle.class, FlowExceptionBundle.UNLABELED, "");
        String unlabeled = error.getMsgOnly(locale);
        return unlabeled + " " + this.getDisplayType(locale);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public String getFlowType() {
        return this.type;
    }

    public long getTimeout() {
        return this.timeout_ms;
    }

    public void init(FlowState state) {
    }

    public void init(Namespace ns) {
        FlowElement[] nodes;
        if (this.input_map != null) {
            this.input_map.init(ns);
        }
        if (this.output_map != null) {
            this.output_map.init(ns);
        }
        if ((nodes = this.getNodes()) == null || nodes.length == 0) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i].init(ns);
        }
    }

    public abstract void invoke(FlowState var1);

    public NSRecord getProperties() {
        NSRecord params = new NSRecord(null);
        params.addField(new NSField(null, KEY_ELEMENT_COMMENT, 1, 0));
        params.addField(new NSField(null, KEY_ELEMENT_SCOPE, 1, 0));
        params.addField(new NSField(null, KEY_ELEMENT_TIMEOUT, 1, 0));
        NSField label = new NSField(null, KEY_ELEMENT_NAME, 1, 0);
        IData hints = label.getHints();
        if (hints == null) {
            hints = IDataFactory.create();
            label.setHints(hints);
        }
        IDataCursor ic = hints.getCursor();
        ic.insertAfter("field_usereditable", String.valueOf(true));
        ic.destroy();
        label.setStringOptions(new String[]{"$default", "$null"});
        params.addField(label);
        return params;
    }

    public boolean hasNodes() {
        return true;
    }

    public String getNSName() {
        FlowElement root;
        FlowElement tmp = root = this;
        while (tmp != null) {
            if (root instanceof FlowRoot) {
                return root.getNSName();
            }
            tmp = root.getParent();
            if (tmp == null) continue;
            root = tmp;
        }
        return null;
    }

    public boolean isExpired() {
        if (this.jobTime == 0L) {
            return false;
        }
        if (this.jobTime < System.currentTimeMillis()) {
            JournalLogger.log(16, 49, 7, (Object)this.getVerboseName());
            return true;
        }
        return false;
    }

    public void setDone(boolean done) {
        this.pipeDone = done;
    }

    public boolean isDone() {
        return this.pipeDone;
    }

    public String getScope() {
        return this.scope;
    }

    public String getFullScope() {
        StringBuffer fullScope = new StringBuffer();
        for (FlowElement element = this; element != null; element = element.getParent()) {
            String elemScope = element.getScope();
            if (elemScope == null || elemScope.length() <= 0) continue;
            if (fullScope.length() > 0) {
                fullScope.insert(0, "/");
            }
            fullScope.insert(0, elemScope);
        }
        return fullScope.toString();
    }

    public FlowElement getNodeAt(int index) {
        if (this.nodes == null || index < 0 || index >= this.nodes.size()) {
            return null;
        }
        return (FlowElement)this.nodes.elementAt(index);
    }

    FlowElement setNodeAt(FlowElement node, int index) {
        FlowElement ret = this.getNodeAt(index);
        if (ret == null) {
            return null;
        }
        this.nodes.setElementAt(node, index);
        return ret;
    }

    public FlowElement[] getNodes() {
        if (this.nodes == null) {
            return null;
        }
        Object[] e = new FlowElement[this.nodes.size()];
        this.nodes.copyInto(e);
        return e;
    }

    public int getNodeCount() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public void addNode(FlowElement node) {
        if (this.hasNodes()) {
            this.insertNodeAt(node, -1);
        }
    }

    public void insertNodeAt(FlowElement node, int index) {
        if (!this.hasNodes()) {
            return;
        }
        if (this.nodes == null) {
            this.nodes = new Vector(1);
        }
        if (index < 0 || index > this.nodes.size()) {
            this.nodes.addElement(node);
        } else {
            this.nodes.insertElementAt(node, index);
        }
        node.parent = this;
    }

    public void deleteNode(FlowElement node) {
        if (this.hasNodes() && this.nodes != null) {
            this.nodes.removeElement(node);
        }
    }

    public void deleteNodeAt(int index) {
        if (this.hasNodes() && this.nodes != null) {
            this.nodes.removeElementAt(index);
        }
    }

    public void deleteAllNodes() {
        if (this.hasNodes() && this.nodes != null) {
            this.nodes.removeAllElements();
        }
    }

    public String getPath() {
        if (this.parent != null) {
            return Strings.cat(this.parent.getPath(), "/", Integer.toString(this.parent.indexOf(this)));
        }
        return "";
    }

    public String getPathByRef() {
        if (this.parent != null) {
            return Strings.cat(this.parent.getPathByRef(), "/", Integer.toString(this.parent.indexByRef(this)));
        }
        return "";
    }

    public String getPathByRef(FlowElement home) {
        if (this.parent != null && this != home) {
            return Strings.cat(this.parent.getPathByRef(home), "/", Integer.toString(this.parent.indexByRef(this)));
        }
        return "";
    }

    public int getNodeIndex() {
        return this.nodeIndex;
    }

    public void nextNodeIndex() {
        ++this.nodeIndex;
    }

    public void setNodeIndex(int nodeIndex) {
        this.nodeIndex = nodeIndex;
    }

    int indexOf(FlowElement fe) {
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                if (!((FlowElement)this.nodes.elementAt(i)).equals(fe)) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexByRef(FlowElement fe) {
        if (this.nodes != null) {
            for (int i = 0; i < this.nodes.size(); ++i) {
                if ((FlowElement)this.nodes.elementAt(i) != fe) continue;
                return i;
            }
        }
        return -1;
    }

    public FlowElement getNode(String type, String name) {
        if (type == null) {
            return null;
        }
        if (this.type.equals(type)) {
            if (name == null && this.name == null) {
                return this;
            }
            if (this.name.equals(name)) {
                return this;
            }
        }
        if (this.nodes == null) {
            return null;
        }
        for (int i = 0; i < this.nodes.size(); ++i) {
            FlowElement result;
            FlowElement result2;
            if (this.input_map != null && (result2 = this.input_map.getNode(type, name)) != null) {
                return result2;
            }
            if (this.output_map != null && (result2 = this.output_map.getNode(type, name)) != null) {
                return result2;
            }
            FlowElement fe = (FlowElement)this.nodes.elementAt(i);
            if (fe == null || (result = fe.getNode(type, name)) == null) continue;
            return result;
        }
        return null;
    }

    public static FlowElement create(Values val) {
        if (val == null) {
            return null;
        }
        String type = val.getString(KEY_ELEMENT_TYPE);
        if (type == null) {
            return null;
        }
        if (type.equals(TYPE_INVOKE)) {
            return new FlowInvoke(val);
        }
        if (type.equals(TYPE_SEQUENCE)) {
            return new FlowSequence(val);
        }
        if (type.equals(TYPE_BRANCH)) {
            return new FlowBranch(val);
        }
        if (type.equals(TYPE_RETRY)) {
            return new FlowRetry(val);
        }
        if (type.equals(TYPE_LOOP)) {
            return new FlowLoop(val);
        }
        if (type.equals(TYPE_MAP)) {
            return new FlowMap(val);
        }
        if (type.equals(TYPE_EXIT)) {
            return new FlowExit(val);
        }
        if (type.equals(TYPE_SPAWN)) {
            return new FlowSpawn(val);
        }
        if (type.equals(TYPE_NOTIFY)) {
            return new FlowNotify(val);
        }
        if (type.equals(TYPE_WAIT)) {
            return new FlowWait(val);
        }
        if (type.equals(TYPE_MAPCOPY)) {
            return new FlowMapCopy(val);
        }
        if (type.equals(TYPE_MAPDELETE)) {
            return new FlowMapDelete(val);
        }
        if (type.equals(TYPE_MAPSET)) {
            return new FlowMapSet(val);
        }
        if (type.equals(TYPE_MAPINVOKE)) {
            return new FlowMapInvoke(val);
        }
        return null;
    }

    public String toString() {
        return this.type;
    }

    public Object clone() {
        try {
            FlowElement newElement = (FlowElement)super.clone();
            return newElement;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public Object deepClone() {
        FlowElement newElement = (FlowElement)this.clone();
        if (newElement.nodes != null) {
            Vector newNodes = newElement.nodes = (Vector)newElement.nodes.clone();
            for (int i = 0; i < newNodes.size(); ++i) {
                newNodes.setElementAt(((FlowElement)newNodes.elementAt(i)).deepClone(), i);
                ((FlowElement)newNodes.elementAt(i)).setParent(newElement);
            }
        }
        if (newElement.input_map != null) {
            newElement.input_map = (FlowMap)newElement.input_map.deepClone();
        }
        if (newElement.output_map != null) {
            newElement.output_map = (FlowMap)newElement.output_map.deepClone();
        }
        return newElement;
    }

    public void setParent(FlowElement parent) {
        this.parent = parent;
    }

    public FlowElement getParent() {
        return this.parent;
    }

    public FlowElement getFlowRoot() {
        FlowElement root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public boolean isCondition() {
        return this.isCondition;
    }

    public void setIsCondition(boolean flag) {
        this.isCondition = flag;
    }

    public boolean containsNode(FlowElement node) {
        for (FlowElement parentNode = node.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
            if (parentNode != this) continue;
            return true;
        }
        return false;
    }

    public static long convertTime(String val) {
        long result = 0L;
        int time = 115;
        if (val == null) {
            return result;
        }
        if (val.length() == 0) {
            return result;
        }
        try {
            result = val != null ? Long.parseLong(val.toString()) : 0L;
        }
        catch (NumberFormatException e) {
            time = val.charAt(val.length() - 1);
            try {
                result = Long.parseLong(val.substring(0, val.length() - 1));
            }
            catch (NumberFormatException ee) {
                result = 0L;
            }
        }
        switch (time) {
            case 115: {
                result *= 1000L;
                break;
            }
            case 109: {
                result *= 60000L;
                break;
            }
            case 104: {
                result *= 3600000L;
            }
        }
        return result;
    }

    public static String[] parseVars(String str) {
        return MapSet.parseVars(str);
    }

    protected String substituteVars(String[] list, Values pipeline) {
        StringBuffer sb = new StringBuffer();
        int length = list.length / 2 * 2;
        for (int i = 0; i < length; i += 2) {
            Object ob;
            sb.append(list[i]);
            String var = list[i + 1];
            if (var.startsWith("/")) {
                var = var.substring(1);
            }
            if ((ob = pipeline.getNode(var)) instanceof String) {
                sb.append((String)ob);
                continue;
            }
            sb.append("%" + var + "%");
        }
        if (list.length / 2 * 2 != list.length) {
            sb.append(list[list.length - 1]);
        }
        return sb.toString();
    }

    public FlowMap getInputMap() {
        return this.input_map;
    }

    public FlowMap getOutputMap() {
        return this.output_map;
    }

    public void setInputMap(FlowMap input_map) {
        this.input_map = input_map;
        if (input_map != null) {
            input_map.setMode("INPUT");
            input_map.parent = this;
        }
    }

    public void setOutputMap(FlowMap output_map) {
        this.output_map = output_map;
        if (output_map != null) {
            output_map.setMode("OUTPUT");
            output_map.parent = this;
        }
    }

    public IData getAsData() {
        Vector tempNodes = null;
        tempNodes = this.nodes == null ? new Vector() : (Vector)this.nodes.clone();
        if (this.input_map != null) {
            tempNodes.addElement(this.input_map.getAsData());
        }
        if (this.output_map != null) {
            tempNodes.addElement(this.output_map.getAsData());
        }
        if (tempNodes.isEmpty()) {
            tempNodes = null;
        }
        IData values = IDataFactory.create();
        IDataCursor ic = values.getCursor();
        if (this.comment != null) {
            ic.insertAfter(KEY_ELEMENT_COMMENT, this.comment);
        }
        if (this.scope != null) {
            ic.insertAfter(KEY_ELEMENT_SCOPE, this.scope);
        }
        ic.insertAfter(KEY_ELEMENT_TYPE, this.getFlowType());
        ic.insertAfter(KEY_ELEMENT_NAME, this.getName());
        if (tempNodes != null) {
            ic.insertAfter(KEY_ELEMENT_NODES, tempNodes);
        }
        if (this.timeout != null) {
            ic.insertAfter(KEY_ELEMENT_TIMEOUT, this.timeout);
        }
        if (this.disabled) {
            ic.insertAfter(KEY_ELEMENT_DISABLED, "true");
        }
        if (this.invisible) {
            ic.insertAfter(KEY_ELEMENT_INVISIBLE, "true");
        }
        if (this.isCondition) {
            ic.insertAfter(KEY_ELEMENT_CONDITION, "true");
        }
        if (this.expand) {
            ic.insertAfter(KEY_ELEMENT_EXPAND, "true");
        }
        if (this.xPos != 0) {
            ic.insertAfter(KEY_ELEMENT_INVISIBLE, String.valueOf(this.xPos));
        }
        if (this.yPos != 0) {
            ic.insertAfter(KEY_ELEMENT_INVISIBLE, String.valueOf(this.yPos));
        }
        if (this.xTail != 0) {
            ic.insertAfter(KEY_ELEMENT_INVISIBLE, String.valueOf(this.xTail));
        }
        if (this.yTail != 0) {
            ic.insertAfter(KEY_ELEMENT_INVISIBLE, String.valueOf(this.yTail));
        }
        ic.destroy();
        return values;
    }

    public void setFromData(IData val) {
        if (val == null) {
            return;
        }
        IDataCursor ic = val.getCursor();
        this.type = IDataUtil.getString(ic, KEY_ELEMENT_TYPE);
        this.name = IDataUtil.getString(ic, KEY_ELEMENT_NAME);
        this.comment = IDataUtil.getString(ic, KEY_ELEMENT_COMMENT);
        this.scope = IDataUtil.getString(ic, KEY_ELEMENT_SCOPE);
        if (ic.first(KEY_ELEMENT_DISABLED)) {
            this.disabled = IDataUtil.getBoolean(ic);
        }
        if (ic.first(KEY_ELEMENT_INVISIBLE)) {
            this.invisible = IDataUtil.getBoolean(ic);
        }
        if (ic.first(KEY_ELEMENT_CONDITION)) {
            this.isCondition = IDataUtil.getBoolean(ic);
        }
        if (ic.first(KEY_ELEMENT_EXPAND)) {
            this.expand = IDataUtil.getBoolean(ic);
        }
        this.xPos = IDataUtil.getInt(ic, KEY_ELEMENT_XPOS, 0);
        this.yPos = IDataUtil.getInt(ic, KEY_ELEMENT_YPOS, 0);
        this.xTail = IDataUtil.getInt(ic, KEY_ELEMENT_XTAIL, 0);
        this.yTail = IDataUtil.getInt(ic, KEY_ELEMENT_YTAIL, 0);
        if (this.scope != null && this.scope.length() == 0) {
            this.scope = null;
        }
        this.timeout = IDataUtil.getString(ic, KEY_ELEMENT_TIMEOUT);
        this.timeoutSubList = MapSet.processPath(MapSet.parseVars(this.timeout));
        if (this.timeoutSubList == null) {
            this.timeout_ms = FlowElement.convertTime(this.timeout);
        }
        if (this.name != null && this.name.length() >= 2 && this.name.startsWith("/") && this.name.endsWith("/")) {
            this.isRegex = true;
        }
        try {
            this.nodes = FlowElement.vectorFromValues(this, IDataUtil.get(ic, KEY_ELEMENT_NODES));
        }
        catch (Exception exception) {
            // empty catch block
        }
        ic.destroy();
    }

    public Values getValues() {
        Vector tempNodes = null;
        tempNodes = this.nodes == null ? new Vector() : (Vector)this.nodes.clone();
        if (this.input_map != null) {
            tempNodes.addElement(this.input_map.getValues());
        }
        if (this.output_map != null) {
            tempNodes.addElement(this.output_map.getValues());
        }
        if (tempNodes.isEmpty()) {
            tempNodes = null;
        }
        Object[][] o = new Object[][]{{KEY_ELEMENT_COMMENT, this.comment}, {KEY_ELEMENT_SCOPE, this.scope}, {KEY_ELEMENT_TYPE, this.getFlowType()}, {KEY_ELEMENT_NAME, this.getName()}, {KEY_ELEMENT_NODES, tempNodes}, {KEY_ELEMENT_TIMEOUT, this.timeout}, {KEY_ELEMENT_DISABLED, this.disabled ? "true" : null}, {KEY_ELEMENT_INVISIBLE, this.invisible ? "true" : null}, {KEY_ELEMENT_CONDITION, this.isCondition ? "true" : null}, {KEY_ELEMENT_EXPAND, this.expand ? "true" : null}, {KEY_ELEMENT_XPOS, this.xPos != 0 ? String.valueOf(this.xPos) : null}, {KEY_ELEMENT_YPOS, this.yPos != 0 ? String.valueOf(this.yPos) : null}, {KEY_ELEMENT_XTAIL, this.xTail != 0 ? String.valueOf(this.xTail) : null}, {KEY_ELEMENT_YTAIL, this.yTail != 0 ? String.valueOf(this.yTail) : null}};
        Values values = new Values(o);
        return values;
    }

    public void setValues(Values val) {
        if (val == null) {
            return;
        }
        this.type = val.getString(KEY_ELEMENT_TYPE);
        this.name = val.getString(KEY_ELEMENT_NAME);
        this.comment = val.getString(KEY_ELEMENT_COMMENT);
        this.scope = val.getString(KEY_ELEMENT_SCOPE);
        this.disabled = val.getBoolean(KEY_ELEMENT_DISABLED);
        this.invisible = val.getBoolean(KEY_ELEMENT_INVISIBLE);
        this.isCondition = val.getBoolean(KEY_ELEMENT_CONDITION);
        this.expand = val.getBoolean(KEY_ELEMENT_EXPAND);
        this.xPos = val.getInt(KEY_ELEMENT_XPOS, 0);
        this.yPos = val.getInt(KEY_ELEMENT_YPOS, 0);
        this.xTail = val.getInt(KEY_ELEMENT_XTAIL, 0);
        this.yTail = val.getInt(KEY_ELEMENT_YTAIL, 0);
        if (this.scope != null && this.scope.length() == 0) {
            this.scope = null;
        }
        this.timeout = val.getString(KEY_ELEMENT_TIMEOUT);
        this.timeoutSubList = MapSet.processPath(MapSet.parseVars(this.timeout));
        if (this.timeoutSubList == null) {
            this.timeout_ms = FlowElement.convertTime(this.timeout);
        }
        if (this.name != null && this.name.length() >= 2 && this.name.startsWith("/") && this.name.endsWith("/")) {
            this.isRegex = true;
        }
        try {
            this.nodes = FlowElement.vectorFromValues(this, val.get(KEY_ELEMENT_NODES));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Values getStateValues() {
        Object[][] o = new Object[][]{{KEY_ELEMENT_STATE_NODEINDEX, String.valueOf(this.nodeIndex)}, {KEY_ELEMENT_STATE_PIPESTART, String.valueOf(this.pipeStart)}, {KEY_ELEMENT_STATE_PIPEDONE, String.valueOf(this.pipeDone)}, {KEY_ELEMENT_STATE_ID, String.valueOf(this.id)}};
        return new Values(o);
    }

    public void setStateValues(Values val) {
        this.nodeIndex = val.getInt(KEY_ELEMENT_STATE_NODEINDEX);
        this.pipeStart = val.getBoolean(KEY_ELEMENT_STATE_PIPESTART);
        this.pipeDone = val.getBoolean(KEY_ELEMENT_STATE_PIPEDONE);
        this.id = val.getInt(KEY_ELEMENT_STATE_ID);
    }

    public static Vector vectorFromValues(FlowElement parent, Object on) {
        if (on == null) {
            return null;
        }
        if (on instanceof Vector) {
            Vector v = (Vector)on;
            Vector nodes = new Vector(v.size());
            for (int i = 0; i < v.size(); ++i) {
                FlowElement.createFlowElement(parent, v.elementAt(i), nodes);
            }
            return nodes;
        }
        if (on instanceof Values[]) {
            Values[] v = (Values[])on;
            Vector nodes = new Vector(v.length);
            for (int i = 0; i < v.length; ++i) {
                FlowElement.createFlowElement(parent, v[i], nodes);
            }
            return nodes;
        }
        return null;
    }

    static void createFlowElement(FlowElement parent, Object v, Vector nodes) {
        FlowElement next = v instanceof Values ? FlowElement.create((Values)v) : (FlowElement)v;
        if (next != null) {
            next.parent = parent;
            if (next.type != null && next.type == TYPE_MAP && !parent.type.equals(TYPE_ROOT)) {
                FlowMap fm = (FlowMap)next;
                if (fm.mode.equals("INPUT") || fm.mode.equals("INVOKEINPUT")) {
                    parent.setInputMap(fm);
                    return;
                }
                if (fm.mode.equals("OUTPUT") || fm.mode.equals("INVOKEOUTPUT")) {
                    parent.setOutputMap(fm);
                    return;
                }
            }
            nodes.addElement(next);
        }
    }

    synchronized boolean initPattern() {
        this.compiler = new Perl5Compiler();
        this.matcher = new Perl5Matcher();
        try {
            String tmp = this.name.substring(1, this.name.length() - 1);
            this.pattern = this.compiler.compile(tmp, 32768);
            return true;
        }
        catch (MalformedPatternException mpe) {
            if (JournalLogger.isLogEnabled(4, 49, 7)) {
                JournalLogger.log(4, 49, 7, this.getName(), mpe.toString());
            }
            this.isRegex = false;
            return false;
        }
    }

    synchronized boolean isRegexMatch(Object keyVal) {
        if (keyVal == null) {
            return false;
        }
        String s = keyVal.toString();
        if (this.pattern == null && !this.initPattern()) {
            return false;
        }
        return this.matcher.contains(s, this.pattern);
    }

    boolean isConditionMatch(Object pipeline) {
        block5: {
            if (pipeline == null) {
                return false;
            }
            if (!(pipeline instanceof IData)) {
                return false;
            }
            try {
                if (ExpressionEvaluator.evalToBoolean(this.name, (IData)pipeline)) {
                    return true;
                }
            }
            catch (MalformedExpressionException mpe) {
                if (!JournalLogger.isLogEnabled(4, 49, 7)) break block5;
                JournalLogger.log(4, 49, 7, this.getName(), mpe.toString());
            }
        }
        return false;
    }

    boolean matches(Object keyVal, boolean isCondition) {
        if (this.name == null) {
            return keyVal != null && keyVal.toString().equals("");
        }
        if (isCondition) {
            return this.isConditionMatch(keyVal);
        }
        if (keyVal == null) {
            return this.name.equals("$null");
        }
        if (this.name.equals(keyVal.toString())) {
            return true;
        }
        if (this.isRegex) {
            return this.isRegexMatch(keyVal);
        }
        return false;
    }

    boolean isDefault() {
        return this.name != null && this.name.equals("$default");
    }

    public void startTimer(FlowState state) {
        long computedTimeout;
        if (this.timeoutSubList != null) {
            this.subsTimeout = MapSet.substituteVars(this.timeoutSubList, state.getPipeline());
            computedTimeout = FlowElement.convertTime(this.subsTimeout);
        } else {
            computedTimeout = this.timeout_ms;
        }
        if (computedTimeout > 0L) {
            this.jobTime = System.currentTimeMillis() + computedTimeout;
        }
    }

    public void cancelTimer() {
        if (this.jobTime > 0L) {
            this.jobTime = 0L;
        }
    }

    public boolean hasBreakPoint() {
        return this.hasBreakPoint;
    }

    public void setBreakPoint(boolean enable) {
        this.hasBreakPoint = enable;
    }

    public boolean hasWatchPoint() {
        return this.hasWatchPoint;
    }

    public void setWatchPoint(boolean enable) {
        this.hasWatchPoint = enable;
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void setEnabled(boolean enable) {
        this.disabled = !enable;
    }

    public boolean isExpanded() {
        return this.expand;
    }

    public void setExpanded(boolean expand) {
        this.expand = expand;
    }

    public void resetChildrenPosition() {
        FlowElement[] children = this.getNodes();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                FlowElement child = children[i];
                child.resetChildrenPosition();
                child.setXPos(0);
                child.setYPos(0);
                child.setXTail(0);
                child.setYTail(0);
            }
        }
    }

    public void setXPos(int x) {
        this.xPos = x;
    }

    public int getXPos() {
        return this.xPos;
    }

    public void setYPos(int y) {
        this.yPos = y;
    }

    public int getYPos() {
        return this.yPos;
    }

    public void setXTail(int x) {
        this.xTail = x;
    }

    public int getXTail() {
        return this.xTail;
    }

    public void setYTail(int y) {
        this.yTail = y;
    }

    public int getYTail() {
        return this.yTail;
    }

    public void setInvisible(boolean b) {
        this.invisible = b;
    }

    public boolean isInvisible() {
        return this.invisible;
    }

    public void setVisible(boolean b) {
        this.invisible = !b;
    }

    public boolean isVisible() {
        return !this.invisible;
    }

    public void setInputMapOnly(boolean flag) {
        this.inputMapOnly = flag;
    }

    public void setOutputMapOnly(boolean flag) {
        this.outputMapOnly = flag;
    }

    public boolean inputMapOnly() {
        return this.inputMapOnly;
    }

    public boolean outputMapOnly() {
        return this.outputMapOnly;
    }

    public Values getReportable() {
        Vector<Values> tempNodes = new Vector<Values>();
        if (this.input_map != null) {
            tempNodes.addElement(this.input_map.getReportable());
        }
        if (this.nodes != null && this.nodes.size() != 0) {
            Enumeration nodesEnum = this.nodes.elements();
            while (nodesEnum.hasMoreElements()) {
                FlowElement element = (FlowElement)nodesEnum.nextElement();
                tempNodes.addElement(element.getReportable());
            }
        }
        if (this.output_map != null) {
            tempNodes.addElement(this.output_map.getReportable());
        }
        if (tempNodes.isEmpty()) {
            tempNodes = null;
        }
        Object[][] o = new Object[][]{{KEY_ELEMENT_COMMENT, this.comment}, {KEY_ELEMENT_SCOPE, this.scope}, {KEY_ELEMENT_TYPE, this.getFlowType()}, {KEY_ELEMENT_NAME, this.getName()}, {KEY_ELEMENT_NODES, tempNodes}, {KEY_ELEMENT_TIMEOUT, this.timeout}, {KEY_ELEMENT_DISABLED, this.disabled ? "true" : null}, {KEY_ELEMENT_CONDITION, this.isCondition ? "true" : null}};
        return new Values(o);
    }

    public void compressSchema(Namespace ns) {
        FlowElement[] nodes;
        if (this.input_map != null) {
            this.input_map.compressSchema(ns);
        }
        if (this.output_map != null) {
            this.output_map.compressSchema(ns);
        }
        if ((nodes = this.getNodes()) == null || nodes.length == 0) {
            return;
        }
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i].compressSchema(ns);
        }
    }
}

