/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.FlowElement;
import com.wm.lang.flow.FlowExit;
import com.wm.lang.flow.FlowState;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.resources.FlowExceptionBundle;
import com.wm.lang.ns.NSField;
import com.wm.lang.ns.NSRecord;
import com.wm.util.JournalLogger;
import com.wm.util.Values;

public class FlowBranch
extends FlowElement {
    public static final String KEY_BRANCH_SWITCH = "switch";
    static final int BRANCH_NONE = -1;
    static final int BRANCH_UNSELECTED = -2;
    MapWmPathInfo keyPath;
    int selectedBranch;
    static final String KEY_BRANCH_STATE_SELECTED = "selectedBranch";
    static final String LOGSTRING_NULL = "<<NULL>>";

    public FlowBranch(Values val) {
        super(val);
        this.type = "BRANCH";
    }

    public NSRecord getProperties() {
        NSRecord prop = super.getProperties();
        NSField cond = new NSField(null, "evaluate-labels", 1, 0);
        IData hints = cond.getHints();
        if (hints == null) {
            hints = IDataFactory.create();
            cond.setHints(hints);
        }
        IDataCursor ic = hints.getCursor();
        ic.insertAfter("field_usereditable", String.valueOf(true));
        ic.destroy();
        cond.setStringOptions(new String[]{"false", "true"});
        prop.addField(new NSField(null, KEY_BRANCH_SWITCH, 1, 0));
        prop.addField(cond);
        return prop;
    }

    public IData getAsData() {
        String key = this.keyPath == null ? null : this.keyPath.getPathString();
        IData result = super.getAsData();
        if (key != null) {
            IDataCursor ic = result.getCursor();
            IDataUtil.put(ic, KEY_BRANCH_SWITCH, key);
            ic.destroy();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFromData(IData val) {
        super.setFromData(val);
        IDataCursor ic = val.getCursor();
        try {
            String key = IDataUtil.getString(ic, KEY_BRANCH_SWITCH);
            this.keyPath = MapWmPathInfo.create(key);
        }
        catch (Exception e) {
            JournalLogger.logDebugPlus(3, 4, 49, this.getDebugLabel(), e.toString());
            e.printStackTrace();
        }
        finally {
            ic.destroy();
        }
    }

    public Values getValues() {
        String key = this.keyPath == null ? null : this.keyPath.getPathString();
        Object[][] o = new Object[][]{{KEY_BRANCH_SWITCH, key}};
        return super.getValues().copyFrom(new Values(o));
    }

    public void setValues(Values val) {
        super.setValues(val);
        try {
            String key = val.getNonEmptyString(KEY_BRANCH_SWITCH);
            this.keyPath = MapWmPathInfo.create(key);
        }
        catch (Exception e) {
            JournalLogger.logDebugPlus(3, 4, 49, this.getDebugLabel(), e.toString());
            e.printStackTrace();
        }
    }

    public Values getStateValues() {
        Object[][] o = new Object[][]{{KEY_BRANCH_STATE_SELECTED, String.valueOf(this.selectedBranch)}};
        return super.getStateValues().copyFrom(this.getValues()).copyFrom(new Values(o));
    }

    public void setStateValues(Values val) {
        super.setStateValues(val);
        this.setValues(val);
        this.selectedBranch = val.getInt(KEY_BRANCH_STATE_SELECTED);
    }

    public void init(FlowState state) {
        this.selectedBranch = -2;
    }

    public void invoke(FlowState state) {
        if (JournalLogger.isLogEnabled(4, 49, 7)) {
            JournalLogger.log(4, 49, 8, this.getDebugLabel(), state.toString());
        }
        if (state.shouldExit(this)) {
            state.setDone(true);
            state.willExit();
            return;
        }
        if (this.selectedBranch == -2) {
            this.selectedBranch = this.selectBranch(state);
            if (this.selectedBranch < 0) {
                state.setDone(true);
                return;
            }
        } else {
            this.selectedBranch = -2;
            state.setDone(true);
            return;
        }
        state.setNextNode(this.selectedBranch);
        if (state.pushNextNode() == null) {
            state.setDone(true);
        }
    }

    int selectBranch(FlowState state) {
        int def = -1;
        int found = -1;
        if (this.keyPath == null && !this.isCondition()) {
            FlowExit exit = new FlowExit(new Values(new Object[][]{{"from", "$flow"}, {"signal", FlowExit.signalOptions[1]}}));
            exit.setLocalizedExceptionInfo(FlowExceptionBundle.NO_PROP_SWITCH, "", this.getVerboseName(state.getLocale()));
            state.setExit(exit);
            return -1;
        }
        if (this.keyPath != null && this.isCondition()) {
            FlowExit exit = new FlowExit(new Values(new Object[][]{{"from", "$flow"}, {"signal", FlowExit.signalOptions[1]}}));
            exit.setLocalizedExceptionInfo(FlowExceptionBundle.INVALID_SWITCH_LABEL, "", this.getVerboseName());
            state.setExit(exit);
            return -1;
        }
        Object keyVal = this.isCondition() ? state.getPipeline() : IDataWmPathProcessor.getNode(state.getPipeline(), this.keyPath.getPathItems());
        FlowElement[] node = this.getNodes();
        if (node == null) {
            return -1;
        }
        for (int i = 0; i < node.length; ++i) {
            if (!node[i].isEnabled()) continue;
            if (def < 0 && node[i].isDefault()) {
                def = i;
                continue;
            }
            if (!node[i].matches(keyVal, this.isCondition())) continue;
            found = i;
            break;
        }
        if (found < 0) {
            found = def;
            if (found < 0) {
                if (this.isCondition()) {
                    if (JournalLogger.isLogEnabled(18, 49, 7)) {
                        JournalLogger.log(18, 49, 7, (Object)super.getVerboseName());
                    }
                } else if (JournalLogger.isLogEnabled(1, 49, 7)) {
                    Object[] o = new Object[]{super.getVerboseName(), keyVal == null ? LOGSTRING_NULL : keyVal.toString(), this.keyPath == null ? null : this.keyPath.getPathString()};
                    JournalLogger.log(1, 49, 7, o);
                }
            } else if (this.isCondition()) {
                if (JournalLogger.isLogEnabled(19, 49, 7)) {
                    Object[] o = new Object[]{super.getName(), this.getVerboseName().toString(), node[found].getVerboseName()};
                    JournalLogger.log(19, 49, 7, o);
                }
            } else if (JournalLogger.isLogEnabled(2, 49, 7)) {
                String debugLabel = keyVal == null ? LOGSTRING_NULL : keyVal.toString();
                Object[] o = new Object[]{super.getName(), debugLabel, node[found].getVerboseName()};
                JournalLogger.log(2, 49, 7, o);
            }
        } else if (JournalLogger.isLogEnabled(3, 49, 7)) {
            String debugLabel = null;
            debugLabel = this.isCondition() ? node[found].getVerboseName() : (keyVal == null ? LOGSTRING_NULL : keyVal.toString());
            JournalLogger.log(3, 49, 7, super.getName(), debugLabel.toString());
        }
        return found;
    }

    public Values getReportable() {
        String key = this.keyPath == null ? null : this.keyPath.getPathString();
        Object[][] o = new Object[][]{{KEY_BRANCH_SWITCH, key}};
        return super.getReportable().copyFrom(new Values(o));
    }
}

