/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.data.IDataUtil;
import com.wm.lang.flow.ExpressionFunctionIf;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.flow.MalformedExpressionException;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.flow.resources.ExpressionEvaluatorExceptionBundle;
import com.wm.util.SimpleDateFormatPool;
import com.wm.util.Trace;
import java.math.BigDecimal;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class ExpressionEvaluator {
    public static final boolean CASE_SENSITIVE = true;
    public static final boolean CASE_INSENSITIVE = false;
    static final String DefaultDateFormat = Trace.DEFAULT_DATE_FORMAT;
    static final SimpleDateFormatPool sdfPool = new SimpleDateFormatPool(DefaultDateFormat);
    private static Hashtable gFunctions = new Hashtable();
    private static final String DELIMITERS = "=!><&|()\"'\\/% \t\n\r,";
    private static final String QUOTE_DELIMITERS = "\"'%/";
    private static final String QUOTE_FIELD = "%";
    private static final String QUOTE_REGEXP = "/";
    private static final String ESCAPE = "\\";
    private static final int MAX_NUMBER_LENGTH = 20;
    private static final int MIN_NUMBER_LENGTH = 0;
    private static final String NUMBER_CHARS = "0123456789.eE+-";
    protected static final int TYPE_STRING = 0;
    protected static final int TYPE_FIELD = 1;
    protected static final int TYPE_REGEXP = 2;
    protected static final int TYPE_UNQUOTED = 3;
    protected static final int TYPE_COMPARATOR = 4;
    protected static final int TYPE_BUILTIN = 5;
    protected static final Token TOKEN_AND = new Token(5, null);
    protected static final Token TOKEN_OR = new Token(5, null);
    protected static final Token TOKEN_EQUALS = new Token(4, null);
    protected static final Token TOKEN_NOT_EQUALS = new Token(4, null);
    protected static final Token TOKEN_GREATER_THAN = new Token(4, null);
    protected static final Token TOKEN_GREATER_OR_EQUAL = new Token(4, null);
    protected static final Token TOKEN_LESS_THAN = new Token(4, null);
    protected static final Token TOKEN_LESS_OR_EQUAL = new Token(4, null);
    protected static final Token TOKEN_NOT = new Token(5, null);
    protected static final Token TOKEN_NULL = new Token(5, null);
    protected static final Token TOKEN_OPEN_PAREN = new Token(5, null);
    protected static final Token TOKEN_CLOSE_PAREN = new Token(5, null);
    protected static final Token TOKEN_COMMA = new Token(5, null);
    protected static final Token TOKEN_L_EQUALS = new Token(4, null);
    protected static final Token TOKEN_L_NOT_EQUALS = new Token(4, null);
    protected static final Token TOKEN_L_GREATER_THAN = new Token(4, null);
    protected static final Token TOKEN_L_GREATER_OR_EQUAL = new Token(4, null);
    protected static final Token TOKEN_L_LESS_THAN = new Token(4, null);
    protected static final Token TOKEN_L_LESS_OR_EQUAL = new Token(4, null);
    private static final Object[][] TOKEN_TABLE = new Object[][]{{"=", TOKEN_EQUALS}, {"==", TOKEN_EQUALS}, {"!=", TOKEN_NOT_EQUALS}, {"<>", TOKEN_NOT_EQUALS}, {">", TOKEN_GREATER_THAN}, {">=", TOKEN_GREATER_OR_EQUAL}, {"<", TOKEN_LESS_THAN}, {"<=", TOKEN_LESS_OR_EQUAL}, {"&", TOKEN_AND}, {"&&", TOKEN_AND}, {"and", TOKEN_AND}, {"|", TOKEN_OR}, {"||", TOKEN_OR}, {"or", TOKEN_OR}, {"!", TOKEN_NOT}, {"not", TOKEN_NOT}, {"(", TOKEN_OPEN_PAREN}, {")", TOKEN_CLOSE_PAREN}, {"$null", TOKEN_NULL}, {",", TOKEN_COMMA}, {"L_EQUALS", TOKEN_L_EQUALS}, {"L_NOT_EQUALS", TOKEN_L_NOT_EQUALS}, {"L_GREATER_THAN", TOKEN_L_GREATER_THAN}, {"L_GREATER_OR_EQUAL", TOKEN_L_GREATER_OR_EQUAL}, {"L_LESS_THAN", TOKEN_L_LESS_THAN}, {"L_LESS_OR_EQUAL", TOKEN_L_LESS_OR_EQUAL}};
    private static final int TABLE_LENGTH = TOKEN_TABLE.length;
    private static final Object NULL_OBJECT = new Object();
    private static final Object TRUE_OBJECT = new Object();
    private static final Object FALSE_OBJECT = new Object();
    private static final int STATE_NORMAL = 0;
    private static final int STATE_QUOTE = 1;
    private static final int STATE_ESCAPE = 2;
    private int gState = 0;
    private int gNextState;
    private String gQuoteStr;
    protected Stack gStack = new Stack();
    private IData gData;
    private IDataCursor gDataCursor;
    private boolean gCaseSensitive = true;
    private Locale gLocale = null;
    protected static Collator gCollator = null;
    private static Object gLock = new Object();
    private static boolean gColInitialized = false;
    private static int gCount = 0;

    public static boolean evalToBoolean(String expression, IData data, boolean caseSensitive, boolean useNumbers) throws MalformedExpressionException {
        return ExpressionEvaluator.evalToBoolean(expression, data, caseSensitive, useNumbers, null);
    }

    public static boolean evalToBoolean(String expression, IData data, boolean caseSensitive, boolean useNumbers, Locale locale) throws MalformedExpressionException {
        ExpressionEvaluator eval = new ExpressionEvaluator(data, caseSensitive, useNumbers, locale);
        return ExpressionEvaluator.getBoolean(eval.evaluate(expression));
    }

    public static boolean evalToBoolean(String expression, IData data, Locale locale) throws MalformedExpressionException {
        return ExpressionEvaluator.evalToBoolean(expression, data, true, true, locale);
    }

    public static boolean evalToBoolean(String expression, IData data) throws MalformedExpressionException {
        return ExpressionEvaluator.evalToBoolean(expression, data, true, true);
    }

    public static void registerFunction(String fName, ExpressionFunctionIf fif) {
        gFunctions.put(fName, fif);
    }

    public static void unregisterFunction(String fName) {
        gFunctions.remove(fName);
    }

    public static ExpressionFunctionIf getFunction(String fName) {
        return (ExpressionFunctionIf)gFunctions.get(fName);
    }

    public ExpressionEvaluator(IData data, boolean caseSensitive, boolean useNumbers) {
        this(data, caseSensitive, useNumbers, null);
    }

    public ExpressionEvaluator(IData data, boolean caseSensitive, boolean useNumbers, Locale locale) {
        this.gData = data;
        this.gDataCursor = data.getCursor();
        this.gCaseSensitive = caseSensitive;
        this.gLocale = locale;
    }

    public Object evaluate(String expression) throws MalformedExpressionException {
        if (expression == null) {
            return null;
        }
        Token[] tokens = this.getTokens(expression);
        return this.parse(tokens);
    }

    public static void syntaxCheck(String expression) throws MalformedExpressionException {
        ExpressionEvaluator e = new ExpressionEvaluator(IDataFactory.create(), true, false);
        e.parse(expression);
    }

    public Object parse(String expression) throws MalformedExpressionException {
        if (expression == null) {
            return null;
        }
        Token[] tokens = this.getTokens(expression);
        return this.parse(tokens);
    }

    private static void throwException(String key) throws MalformedExpressionException {
        throw new MalformedExpressionException(ExpressionEvaluatorExceptionBundle.class, key, "");
    }

    private boolean collectibleTokenType(int type) {
        return type == 0 || type == 1 || type == 2;
    }

    private int stringToTokenType(String str) {
        if (str.equals(QUOTE_FIELD)) {
            return 1;
        }
        if (str.equals(QUOTE_REGEXP)) {
            return 2;
        }
        return 0;
    }

    private Token matchToken(String str) {
        for (int i = 0; i < TABLE_LENGTH; ++i) {
            if (!TOKEN_TABLE[i][0].equals(str)) continue;
            return (Token)TOKEN_TABLE[i][1];
        }
        return null;
    }

    private BigDecimal getBigDecimal(Object o) {
        if (o instanceof String) {
            String str = (String)o;
            int len = str.length();
            if (len > 0) {
                try {
                    return new BigDecimal(str);
                }
                catch (NumberFormatException x) {
                    return null;
                }
            }
            return null;
        }
        if (o instanceof BigDecimal) {
            return (BigDecimal)o;
        }
        if (o instanceof Float || o instanceof Double) {
            return new BigDecimal(o.toString());
        }
        if (o instanceof Number) {
            return new BigDecimal(((Number)o).doubleValue());
        }
        return null;
    }

    private Long getDate(Object o) {
        if (o instanceof Date) {
            return new Long(((Date)o).getTime());
        }
        if (o instanceof String) {
            return this.string2Date((String)o);
        }
        return null;
    }

    Long string2Date(String dtstr) {
        SimpleDateFormat sdf = sdfPool.getInstance();
        try {
            Date dt = sdf.parse(dtstr);
            sdfPool.returnInstance(sdf);
            return new Long(dt.getTime());
        }
        catch (Throwable t) {
            sdfPool.returnInstance(sdf);
            return null;
        }
    }

    private void addTokenToVector(Vector tokens, Token token) {
        int size = tokens.size();
        if (this.collectibleTokenType(token.type) && size > 0) {
            Token last = (Token)tokens.elementAt(size - 1);
            if (last.type == token.type) {
                last.value = (String)last.value + (String)token.value;
                return;
            }
        }
        tokens.addElement(token);
    }

    private boolean addToken(Vector tokens, String token, String nextToken) throws MalformedExpressionException {
        switch (this.gState) {
            case 2: {
                this.gState = this.gNextState;
                this.addTokenToVector(tokens, new Token(this.stringToTokenType(this.gQuoteStr), token));
                return false;
            }
            case 0: {
                Token builtIn;
                if (token.length() == 1 && nextToken != null && nextToken.length() == 1 && (builtIn = this.matchToken(token + nextToken)) != null) {
                    this.addTokenToVector(tokens, builtIn);
                    return true;
                }
                if (token.length() == 1) {
                    char tokenChar = token.charAt(0);
                    if (QUOTE_DELIMITERS.indexOf(tokenChar) >= 0) {
                        this.gState = 1;
                        this.gQuoteStr = token;
                        return false;
                    }
                    if (Character.isWhitespace(tokenChar)) {
                        return false;
                    }
                }
                if ((builtIn = this.matchToken(token)) != null) {
                    this.addTokenToVector(tokens, builtIn);
                } else {
                    this.addTokenToVector(tokens, new Token(3, token));
                }
                return false;
            }
            case 1: {
                int type = this.stringToTokenType(this.gQuoteStr);
                if (type != 2 && token.equals(ESCAPE)) {
                    this.gNextState = this.gState;
                    this.gState = 2;
                    return false;
                }
                if (nextToken != null && nextToken.equals(this.gQuoteStr)) {
                    this.addTokenToVector(tokens, new Token(type, token));
                    this.gState = 0;
                    return true;
                }
                if (token.equals(this.gQuoteStr)) {
                    this.addTokenToVector(tokens, new Token(type, ""));
                    this.gState = 0;
                    return false;
                }
                this.addTokenToVector(tokens, new Token(type, token));
                return false;
            }
        }
        return false;
    }

    protected Token[] getTokens(String str) throws MalformedExpressionException {
        StringTokenizer tokenizer = new StringTokenizer(str, DELIMITERS, true);
        Vector tokens = new Vector();
        String token = null;
        String nextToken = null;
        boolean skip = false;
        this.gState = 0;
        if (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken();
        }
        while (tokenizer.hasMoreTokens()) {
            nextToken = tokenizer.nextToken();
            skip = this.addToken(tokens, token, nextToken);
            if (skip) {
                if (tokenizer.hasMoreTokens()) {
                    token = tokenizer.nextToken();
                    continue;
                }
                token = null;
                continue;
            }
            token = nextToken;
        }
        if (token != null) {
            this.addToken(tokens, token, null);
        }
        if (this.gState != 0) {
            ExpressionEvaluator.throwException(ExpressionEvaluatorExceptionBundle.NO_CLOSING_DELIMITER);
        }
        Object[] tokenArray = new Token[tokens.size()];
        tokens.copyInto(tokenArray);
        return tokenArray;
    }

    private void checkPosition(Token[] tokens, Position p) throws MalformedExpressionException {
        if (p.get() >= tokens.length) {
            ExpressionEvaluator.throwException(ExpressionEvaluatorExceptionBundle.UNEXPECTED_END);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object parse(Token[] tokens) throws MalformedExpressionException {
        Position pos = new Position(0);
        try {
            if (tokens != null && tokens.length > 0) {
                this.expression(tokens, pos);
                if (pos.get() != tokens.length) {
                    ExpressionEvaluator.throwException(ExpressionEvaluatorExceptionBundle.TOO_MANY_PARTS);
                }
                if (this.gStack.isEmpty()) {
                    ExpressionEvaluator.throwException(ExpressionEvaluatorExceptionBundle.NOT_EXPRESSION);
                }
                Object result = this.popValue();
                if (!this.gStack.isEmpty()) {
                    ExpressionEvaluator.throwException(ExpressionEvaluatorExceptionBundle.TOO_MANY_PARTS);
                }
                Object object = result == NULL_OBJECT || result instanceof Pattern ? null : result;
                return object;
            }
            Object var4_5 = null;
            return var4_5;
        }
        finally {
            this.gStack.removeAllElements();
        }
    }

    private void expression(Token[] tokens, Position p) throws MalformedExpressionException {
        this.logicalAnd(tokens, p);
        while (p.get() < tokens.length && tokens[p.get()] == TOKEN_OR) {
            p.incr();
            this.checkPosition(tokens, p);
            this.logicalAnd(tokens, p);
            this.evalSymOr();
        }
    }

    private void logicalAnd(Token[] tokens, Position p) throws MalformedExpressionException {
        this.comparator(tokens, p);
        while (p.get() < tokens.length && tokens[p.get()] == TOKEN_AND) {
            p.incr();
            this.checkPosition(tokens, p);
            this.comparator(tokens, p);
            this.evalSymAnd();
        }
    }

    private void comparator(Token[] tokens, Position p) throws MalformedExpressionException {
        this.element(tokens, p);
        if (p.get() < tokens.length && tokens[p.get()].type == 4) {
            int savePos = p.get();
            p.incr();
            this.checkPosition(tokens, p);
            this.element(tokens, p);
            this.evalSymComparator(tokens[savePos]);
        }
    }

    private void element(Token[] tokens, Position p) throws MalformedExpressionException {
        Token token = tokens[p.get()];
        if (token.type == 3) {
            this.gStack.push(token);
            int savePos = p.get();
            p.incr();
            this.evalSymElement(token);
        } else if (token.type == 1 || token.type == 0 || token.type == 2 || token == TOKEN_NULL) {
            this.gStack.push(token);
            p.incr();
            this.evalSymElement(token);
        } else if (token == TOKEN_OPEN_PAREN) {
            p.incr();
            this.checkPosition(tokens, p);
            this.expression(tokens, p);
            if (p.get() >= tokens.length || tokens[p.get()] != TOKEN_CLOSE_PAREN) {
                ExpressionEvaluator.throwException(ExpressionEvaluatorExceptionBundle.UNMATCHED_PARENS);
            }
            p.incr();
        } else if (token == TOKEN_NOT) {
            p.incr();
            this.checkPosition(tokens, p);
            this.element(tokens, p);
            this.evalSymNot();
        } else {
            ExpressionEvaluator.throwException(ExpressionEvaluatorExceptionBundle.EXPECTED_EXPR);
        }
    }

    private void list(Token[] tokens, Position p) throws MalformedExpressionException {
        if (p.get() < tokens.length && tokens[p.get()] == TOKEN_CLOSE_PAREN) {
            return;
        }
        this.listElement(tokens, p);
        while (p.get() < tokens.length && tokens[p.get()] != TOKEN_CLOSE_PAREN) {
            if (tokens[p.get()] != TOKEN_COMMA) {
                ExpressionEvaluator.throwException(ExpressionEvaluatorExceptionBundle.UNMATCHED_PARENS);
            }
            p.incr();
            this.checkPosition(tokens, p);
            this.listElement(tokens, p);
        }
    }

    private void listElement(Token[] tokens, Position p) throws MalformedExpressionException {
        Token token = tokens[p.get()];
        if (token.type == 3 || token.type == 1 || token.type == 0) {
            this.gStack.push(token);
            p.incr();
            this.evalSymElement(token);
        } else {
            ExpressionEvaluator.throwException(ExpressionEvaluatorExceptionBundle.EXPECTED_EXPR);
        }
    }

    protected Object popValue() {
        Object o = this.gStack.pop();
        if (o instanceof Token) {
            return this.getValue((Token)o);
        }
        return o;
    }

    protected Object getValue(Token token) {
        String str = (String)token.value;
        if (token.type == 3 && !this.gDataCursor.first(str) && this.getBigDecimal(str) != null) {
            return str;
        }
        return this.getLexicalValue(token);
    }

    private Object getField(String field) {
        Object result = NULL_OBJECT;
        MapWmPathInfo pathInfo = MapWmPathInfo.create(field);
        if (this.gData != null && pathInfo != null) {
            result = IDataWmPathProcessor.getNode(this.gData, pathInfo.getPathItems());
        }
        return result != null ? result : NULL_OBJECT;
    }

    protected Object getRegExp(String regExp) {
        try {
            Perl5Compiler compiler = new Perl5Compiler();
            Pattern pattern = compiler.compile(regExp);
            return pattern;
        }
        catch (MalformedPatternException malformedPatternException) {
            return regExp;
        }
    }

    private boolean regExpMatch(String str, Pattern pattern) {
        Perl5Matcher matcher = new Perl5Matcher();
        return matcher.contains(str, pattern);
    }

    protected boolean evalEquals(Object lhs, Object rhs, BigDecimal lhsBigDec, BigDecimal rhsBigDec, Long lhsLong, Long rhsLong) {
        if (lhsLong != null && rhsLong != null) {
            return lhsLong.longValue() == rhsLong.longValue();
        }
        if (lhsBigDec != null && rhsBigDec != null) {
            return lhsBigDec.compareTo(rhsBigDec) == 0;
        }
        if (lhs instanceof String && rhs instanceof Pattern) {
            return this.regExpMatch((String)lhs, (Pattern)rhs);
        }
        if (lhs instanceof String && rhs instanceof String && !this.gCaseSensitive) {
            return ((String)lhs).equalsIgnoreCase((String)rhs);
        }
        if (lhs instanceof IData && rhs instanceof IData) {
            return IDataUtil.equals((IData)lhs, (IData)rhs);
        }
        return lhs.toString().equals(rhs.toString());
    }

    protected void evalAnd() {
        boolean rhs = ExpressionEvaluator.getBoolean(this.popValue());
        boolean lhs = ExpressionEvaluator.getBoolean(this.popValue());
        this.gStack.push(lhs && rhs ? TRUE_OBJECT : FALSE_OBJECT);
    }

    protected void evalSymAnd() throws MalformedExpressionException {
        this.evalAnd();
    }

    protected void evalOr() {
        boolean rhs = ExpressionEvaluator.getBoolean(this.popValue());
        boolean lhs = ExpressionEvaluator.getBoolean(this.popValue());
        this.gStack.push(lhs || rhs ? TRUE_OBJECT : FALSE_OBJECT);
    }

    protected void evalSymOr() throws MalformedExpressionException {
        this.evalOr();
    }

    protected void evalNot() {
        this.gStack.push(ExpressionEvaluator.getBoolean(this.popValue()) ? FALSE_OBJECT : TRUE_OBJECT);
    }

    protected void evalSymNot() throws MalformedExpressionException {
        this.evalNot();
    }

    protected void evalElement(Token token) {
    }

    protected void evalSymElement(Token token) throws MalformedExpressionException {
        this.evalElement(token);
    }

    protected void evalFunction(Token token) throws MalformedExpressionException {
        int idx = this.gStack.size();
        int numArgs = 0;
        while (--idx >= 0 && this.gStack.elementAt(idx) != token) {
            ++numArgs;
        }
        Object[] args = new Object[numArgs];
        for (int i = numArgs - 1; i >= 0; --i) {
            args[i] = this.popValue();
        }
        this.gStack.pop();
        String function = (String)token.value;
        ExpressionFunctionIf func = (ExpressionFunctionIf)gFunctions.get(function);
        if (func == null) {
            throw new MalformedExpressionException("No such function " + function);
        }
        try {
            this.gStack.push(func.function(args));
        }
        catch (IllegalArgumentException e) {
            throw new MalformedExpressionException("Illegal arguments to function " + function);
        }
        catch (Exception e) {
            this.gStack.push(FALSE_OBJECT);
        }
    }

    protected void evalSymFunction(Token token) throws MalformedExpressionException {
        this.evalFunction(token);
    }

    private boolean isConstantNumber(Token token) {
        String str = (String)token.value;
        return token.type == 3 && !this.gDataCursor.first(str) && this.getBigDecimal(str) != null;
    }

    private boolean useNumbers(Token lhs, Token rhs) {
        if (this.isConstantNumber(lhs) || this.isConstantNumber(rhs)) {
            return true;
        }
        return !(lhs.type != 3 && lhs.type != 1 || rhs.type != 3 && rhs.type != 1);
    }

    protected void evalComparator(Token comp) {
        Object rhs = this.gStack.pop();
        Object lhs = this.gStack.pop();
        BigDecimal lhsBigDec = null;
        BigDecimal rhsBigDec = null;
        Long lhsLong = null;
        Long rhsLong = null;
        boolean result = false;
        boolean useNumbers = false;
        if (this.isLexicalOperator(comp)) {
            if (lhs instanceof Token && rhs instanceof Token) {
                lhs = this.getLexicalValue((Token)lhs);
                rhs = this.getLexicalValue((Token)rhs);
            }
            if (!(lhs instanceof String)) {
                lhs = "";
            }
            if (!(rhs instanceof String)) {
                rhs = "";
            }
            if (comp == TOKEN_L_EQUALS) {
                result = this.compare((String)lhs, (String)rhs) == 0;
            } else if (comp == TOKEN_L_NOT_EQUALS) {
                result = this.compare((String)lhs, (String)rhs) != 0;
            } else if (comp == TOKEN_L_GREATER_THAN) {
                result = this.compare((String)lhs, (String)rhs) > 0;
            } else if (comp == TOKEN_L_GREATER_OR_EQUAL) {
                result = this.compare((String)lhs, (String)rhs) >= 0;
            } else if (comp == TOKEN_L_LESS_THAN) {
                result = this.compare((String)lhs, (String)rhs) < 0;
            } else if (comp == TOKEN_L_LESS_OR_EQUAL) {
                result = this.compare((String)lhs, (String)rhs) <= 0;
            }
        } else {
            if (lhs instanceof Token && rhs instanceof Token) {
                useNumbers = this.useNumbers((Token)lhs, (Token)rhs);
                lhs = this.getValue((Token)lhs);
                rhs = this.getValue((Token)rhs);
            }
            if (lhs instanceof Token) {
                lhs = this.getValue((Token)lhs);
            }
            if (rhs instanceof Token) {
                rhs = this.getValue((Token)rhs);
            }
            if (lhs instanceof Number || rhs instanceof Number) {
                useNumbers = true;
            }
            if (useNumbers) {
                lhsBigDec = this.getBigDecimal(lhs);
                rhsBigDec = this.getBigDecimal(rhs);
            }
            if (lhsBigDec == null && rhsBigDec == null) {
                lhsLong = this.getDate(lhs);
                rhsLong = this.getDate(rhs);
            }
            if (lhs instanceof Character) {
                lhs = lhs.toString();
            }
            if (rhs instanceof Character) {
                rhs = rhs.toString();
            }
            if (lhs instanceof Boolean && rhs instanceof String || rhs instanceof Boolean && lhs instanceof String) {
                lhs = lhs.toString().toUpperCase();
                rhs = rhs.toString().toUpperCase();
            }
            if (comp == TOKEN_EQUALS) {
                result = this.evalEquals(lhs, rhs, lhsBigDec, rhsBigDec, lhsLong, rhsLong);
            } else if (comp == TOKEN_NOT_EQUALS) {
                result = !this.evalEquals(lhs, rhs, lhsBigDec, rhsBigDec, lhsLong, rhsLong);
            } else if (comp == TOKEN_GREATER_THAN) {
                if (lhsLong != null && rhsLong != null) {
                    boolean bl = result = lhsLong > rhsLong;
                }
                if (lhsBigDec != null && rhsBigDec != null) {
                    result = lhsBigDec.compareTo(rhsBigDec) > 0;
                } else if (lhs instanceof String && rhs instanceof String) {
                    result = ((String)lhs).compareTo((String)rhs) > 0;
                }
            } else if (comp == TOKEN_GREATER_OR_EQUAL) {
                if (lhsLong != null && rhsLong != null) {
                    boolean bl = result = lhsLong >= rhsLong;
                }
                if (lhsBigDec != null && rhsBigDec != null) {
                    result = lhsBigDec.compareTo(rhsBigDec) >= 0;
                } else if (lhs instanceof String && rhs instanceof String) {
                    result = ((String)lhs).compareTo((String)rhs) >= 0;
                }
            } else if (comp == TOKEN_LESS_THAN) {
                if (lhsLong != null && rhsLong != null) {
                    boolean bl = result = lhsLong < rhsLong;
                }
                if (lhsBigDec != null && rhsBigDec != null) {
                    result = lhsBigDec.compareTo(rhsBigDec) < 0;
                } else if (lhs instanceof String && rhs instanceof String) {
                    result = ((String)lhs).compareTo((String)rhs) < 0;
                }
            } else if (comp == TOKEN_LESS_OR_EQUAL) {
                if (lhsLong != null && rhsLong != null) {
                    boolean bl = result = lhsLong <= rhsLong;
                }
                if (lhsBigDec != null && rhsBigDec != null) {
                    result = lhsBigDec.compareTo(rhsBigDec) <= 0;
                } else if (lhs instanceof String && rhs instanceof String) {
                    result = ((String)lhs).compareTo((String)rhs) <= 0;
                }
            }
        }
        this.gStack.push(result ? TRUE_OBJECT : FALSE_OBJECT);
    }

    private boolean isLexicalOperator(Token comp) {
        return comp == TOKEN_L_EQUALS || comp == TOKEN_L_NOT_EQUALS || comp == TOKEN_L_GREATER_THAN || comp == TOKEN_L_GREATER_OR_EQUAL || comp == TOKEN_L_LESS_THAN || comp == TOKEN_L_LESS_OR_EQUAL;
    }

    private Object getLexicalValue(Token token) {
        String str = (String)token.value;
        if (token.type == 3 || token.type == 1) {
            return this.getField(str);
        }
        if (token.type == 0) {
            return str;
        }
        if (token.type == 2) {
            return this.getRegExp(str);
        }
        if (token == TOKEN_NULL) {
            return NULL_OBJECT;
        }
        return str;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int compare(String lhs, String rhs) {
        Object object = gLock;
        synchronized (object) {
            if (!gColInitialized) {
                if (this.gLocale == null || this.gLocale.getLanguage().equals("")) {
                    gCollator = null;
                } else {
                    gCollator = Collator.getInstance(this.gLocale);
                    gCollator.setStrength(3);
                    gCollator.setDecomposition(1);
                }
                gColInitialized = true;
            }
        }
        if (gCollator == null) {
            return lhs.compareTo(rhs);
        }
        return gCollator.compare(lhs, rhs);
    }

    protected void evalSymComparator(Token tok) throws MalformedExpressionException {
        this.evalComparator(tok);
    }

    public static boolean getBoolean(Object o) {
        return o != FALSE_OBJECT && o != NULL_OBJECT && o != null;
    }

    public static void main(String[] args) throws Exception {
        ExpressionEvaluator.registerFunction("strcmp", new ExpressionFunctionIf(){

            public Object function(Object[] o) {
                return new Integer(((String)o[0]).compareTo((String)o[1]));
            }
        });
        ExpressionEvaluator.registerFunction("strcat", new ExpressionFunctionIf(){

            public Object function(Object[] o) {
                return (String)o[0] + (String)o[1];
            }
        });
        String expression = args[0];
        IData data = IDataFactory.create();
        IDataCursor c = data.getCursor();
        c.insertAfter("s1", "string1");
        c.insertAfter("s2", "String2");
        c.insertAfter("s3", "string3");
        c.insertAfter("n1", new Integer(123));
        c.insertAfter("n2", new Float(123.0));
        c.insertAfter("b1", Boolean.TRUE);
        c.insertAfter("b2", Boolean.FALSE);
        c.insertAfter("b3", null);
        c.insertAfter("b4", new Boolean(true));
        c.insertAfter("b5", new Boolean(false));
        c.insertAfter("c1", new Character('A'));
        IData sd = IDataFactory.create();
        IDataCursor sdc = sd.getCursor();
        sdc.insertAfter("s", "abc");
        sdc.insertAfter("n", new Integer(5555));
        sdc.destroy();
        c.insertAfter("d", sd);
        c.destroy();
        ExpressionEvaluator e = new ExpressionEvaluator(data, true, false);
        Token[] tokens = e.getTokens(expression);
        Object foo = e.parse(tokens);
        System.out.println(foo);
        System.out.println(ExpressionEvaluator.getBoolean(foo));
        System.out.println(ExpressionEvaluator.evalToBoolean(expression, data));
        System.out.println(Boolean.TRUE.getClass().getName());
    }

    static class Position {
        private int pos;

        public Position(int pos) {
            this.pos = pos;
        }

        public void incr() {
            ++this.pos;
        }

        public int get() {
            return this.pos;
        }
    }

    public static class Token {
        protected int type;
        protected Object value;

        public Token(int type, Object value) {
            this.type = type;
            this.value = value;
        }

        public int getType() {
            return this.type;
        }

        public Object getValue() {
            return this.value;
        }

        public String toString() {
            return "type: " + this.type + ", value: " + this.value;
        }

        public boolean equals(Token t) {
            if (this.type != t.type) {
                return false;
            }
            if (this.type == 5) {
                return this == t;
            }
            if (this.value == null || t.value == null) {
                return this.value == t.value;
            }
            return this.value.equals(t.value);
        }
    }
}

