/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.lang.flow.FlowInvoke;
import com.wm.lang.flow.FlowMap;
import com.wm.lang.flow.FlowMapCopy;
import com.wm.lang.flow.FlowMapInvoke;
import com.wm.lang.flow.IDataWmPathProcessor;
import com.wm.lang.flow.MapFlatData;
import com.wm.lang.flow.MapPathProcessorFactory;
import com.wm.lang.flow.MapPathProcessorIf;
import com.wm.lang.flow.MapWmPathInfo;
import com.wm.lang.ns.NSService;
import com.wm.lang.ns.Namespace;

public class CopyPathInfo {
    public static final String MAPPATH = "$mapPath";
    public static final String PIPELINE = "$oldPipeline";
    public static final String PATHCOPY = "$doPathCopy";
    IData pathInfo;

    CopyPathInfo(IData pathInfo) {
        this.pathInfo = pathInfo;
    }

    public static String getPathInfo(IData pipeline, String dataName) {
        String path = "$mapPath/" + dataName;
        MapWmPathInfo pathInfo = MapWmPathInfo.create(path);
        Object o = IDataWmPathProcessor.getNode(pipeline, pathInfo.getPathItems());
        if (o instanceof String) {
            return (String)o;
        }
        return null;
    }

    public static IData getPathInfo(IData pipeline) {
        IDataCursor cursor = pipeline.getCursor();
        Object copyPathInfo = null;
        if (cursor.first(MAPPATH)) {
            copyPathInfo = cursor.getValue();
        }
        cursor.destroy();
        if (copyPathInfo instanceof IData) {
            return (IData)copyPathInfo;
        }
        return null;
    }

    public static Object[] getData(IData pipeline, String pathName) {
        IData mapPath = CopyPathInfo.getPathInfo(pipeline);
        if (mapPath == null) {
            return null;
        }
        IDataCursor cursor = mapPath.getCursor();
        if (!cursor.first(pathName) || !(cursor.getValue() instanceof String)) {
            cursor.destroy();
            return null;
        }
        String path = (String)cursor.getValue();
        if (path == null) {
            cursor.destroy();
            return null;
        }
        IData oldPipe = null;
        if (cursor.first(PIPELINE) && cursor.getValue() instanceof IData) {
            oldPipe = (IData)cursor.getValue();
        }
        cursor.destroy();
        MapWmPathInfo pathInfo = MapWmPathInfo.create(path);
        if (pathInfo == null) {
            return null;
        }
        MapPathProcessorIf proc = MapPathProcessorFactory.create(pathInfo);
        if (proc == null) {
            return null;
        }
        try {
            MapFlatData data = null;
            data = oldPipe == null ? proc.getDataObject(pipeline, pipeline) : proc.getDataObject(oldPipe, oldPipe);
            if (data == null) {
                return null;
            }
            return data.getData();
        }
        catch (Exception e) {
            return null;
        }
    }

    static CopyPathInfo create(FlowInvoke invoke, Namespace ns, IData pipeline, IData oldPipe) {
        if (invoke == null || ns == null || pipeline == null) {
            return null;
        }
        if (invoke.getInputMap() == null) {
            return null;
        }
        NSService svc = invoke.getService(ns, invoke.service);
        if (svc == null || svc.getServiceType().isJavaService()) {
            return null;
        }
        IDataCursor cursor = pipeline.getCursor();
        Object doCopy = null;
        if (cursor.first(PATHCOPY)) {
            doCopy = cursor.getValue();
        }
        cursor.destroy();
        if (doCopy == null || !"true".equals(doCopy)) {
            return null;
        }
        FlowMap input_map = invoke.getInputMap();
        IData copyPathInfo = CopyPathInfo.getCopyPathInfo(input_map);
        if (copyPathInfo == null) {
            return null;
        }
        if (invoke instanceof FlowMapInvoke && pipeline != oldPipe && oldPipe != null) {
            IDataCursor c = copyPathInfo.getCursor();
            c.last();
            c.insertAfter(PIPELINE, oldPipe);
            c.destroy();
        }
        return new CopyPathInfo(copyPathInfo);
    }

    void addPathInfo(IData pipeline) {
        if (this.pathInfo == null) {
            return;
        }
        IDataCursor cursor = pipeline.getCursor();
        cursor.last();
        cursor.insertAfter(MAPPATH, this.pathInfo);
        cursor.destroy();
    }

    void removePathInfo(IData pipeline) {
        if (this.pathInfo == null) {
            return;
        }
        IDataCursor cursor = pipeline.getCursor();
        if (cursor.first(MAPPATH)) {
            cursor.delete();
        }
        cursor.destroy();
    }

    static IData getCopyPathInfo(FlowMap flowMap) {
        FlowMapCopy[] copys = flowMap.getCopyMaps();
        if (copys == null) {
            return null;
        }
        IData copyPathInfo = IDataFactory.create(copys.length);
        IDataCursor cursor = copyPathInfo.getCursor();
        cursor.first();
        for (int i = 0; i < copys.length; ++i) {
            MapWmPathInfo to = copys[i].getParsedTo();
            cursor.insertAfter(to.getDataName(), copys[i].getMapFrom());
            cursor.next();
        }
        return copyPathInfo;
    }
}

