/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

public class CharacterBuffer {
    int currentIndex = 0;
    int length;
    String s;
    int mark = 0;

    public CharacterBuffer(String s) {
        this.s = s;
        this.length = s.length();
    }

    public int getCurrent() {
        if (this.currentIndex == this.length) {
            return -1;
        }
        return this.s.charAt(this.currentIndex);
    }

    public String getSelection(int offset) {
        int endIndex = this.currentIndex + offset + 1;
        if (endIndex > this.length) {
            endIndex = this.length;
        }
        return this.s.substring(this.mark, endIndex);
    }

    public void advance() {
        if (this.currentIndex < this.length) {
            ++this.currentIndex;
        }
    }

    public void advanceTo(int ch) {
        int next = this.s.indexOf(ch, this.currentIndex);
        this.currentIndex = next == -1 ? this.length : next;
    }

    public void mark() {
        this.mark = this.currentIndex;
    }

    public int next() {
        if (++this.currentIndex >= this.length) {
            this.currentIndex = this.length;
            return -1;
        }
        return this.s.charAt(this.currentIndex);
    }

    public void gotoMark() {
        this.currentIndex = this.mark;
    }

    public void reset() {
        this.currentIndex = 0;
    }

    public void retreat() {
        if (this.currentIndex != 0) {
            --this.currentIndex;
        }
    }
}

