/*
 * Decompiled with CFR 0.152.
 */
package com.wm.lang.flow;

import com.wm.lang.flow.ClassA;
import com.wm.lang.flow.ClassB;

public class CastTest {
    public static void main(String[] argv) {
        ClassB classB;
        long count;
        long iterations;
        ClassA unknownA = new ClassA();
        ClassB unknownB = new ClassB();
        if (argv.length != 1) {
            System.out.println("java CastTest <number-of-iterations>");
            return;
        }
        try {
            iterations = Integer.parseInt(argv[0]);
        }
        catch (NumberFormatException x) {
            System.out.println("argument must be a number");
            return;
        }
        long startMillis = System.currentTimeMillis();
        for (count = 0L; count < iterations; ++count) {
            if (!(unknownA instanceof ClassB)) continue;
            classB = (ClassB)((Object)unknownA);
        }
        long endMillis = System.currentTimeMillis();
        CastTest.showResults("Unsuccessful instanceof check", startMillis, endMillis);
        startMillis = System.currentTimeMillis();
        for (count = 0L; count < iterations; ++count) {
            if (!(unknownB instanceof ClassB)) continue;
            classB = unknownB;
        }
        endMillis = System.currentTimeMillis();
        CastTest.showResults("Successful instanceof check", startMillis, endMillis);
        startMillis = System.currentTimeMillis();
        for (count = 0L; count < iterations; ++count) {
            try {
                ClassB b = unknownB;
                continue;
            }
            catch (ClassCastException x) {
                // empty catch block
            }
        }
        endMillis = System.currentTimeMillis();
        CastTest.showResults("Successful class cast", startMillis, endMillis);
    }

    static void showResults(String msg, long startMillis, long endMillis) {
        System.out.println(msg + ": " + (endMillis - startMillis) / 1000L + " sec");
    }
}

