/*
 * Decompiled with CFR 0.152.
 */
package com.wm.formatter;

import com.wm.formatter.UiFormatter;
import com.wm.g11n.text.NumberUtils;
import com.wm.g11n.text.gParseException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Locale;

public class UiNumberFormatter
extends UiFormatter {
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int INTEGER = 3;
    public static final int LONG = 4;
    public static final int FLOAT = 5;
    public static final int DOUBLE = 6;
    public static final int BYTE_TYPE = 1;
    public static final int INTEGER_TYPE = 2;
    public static final int FLOATING_TYPE = 3;
    private int type;
    private int metatype;
    private Locale locale;

    private UiNumberFormatter(int dType, Locale aLocale, int mType) {
        this.metatype = mType;
        this.type = dType;
        this.locale = aLocale;
    }

    public static UiFormatter getInstance(int dType, Locale aLocale) {
        int mType = 0;
        switch (dType) {
            case 1: {
                mType = 1;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                mType = 2;
                break;
            }
            case 5: 
            case 6: {
                mType = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new UiNumberFormatter(dType, aLocale, mType);
    }

    public String format(Object o) throws ParseException {
        if (o == null) {
            throw new ParseException("", 0);
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof Number) {
            return this.format((Number)o);
        }
        throw new ParseException("", 0);
    }

    private String specialByteFormat(Number n) {
        StringBuffer hexString = new StringBuffer();
        boolean sign = false;
        byte b = n.byteValue();
        if ((b & 0x80) == 128) {
            hexString.append(Integer.toHexString(0 - b).toUpperCase());
            sign = true;
        } else {
            hexString.append(Integer.toHexString(b).toUpperCase());
        }
        while (hexString.length() < 2) {
            hexString.insert(0, '0');
        }
        hexString.insert(0, "0x");
        if (sign) {
            hexString.insert(0, '-');
        }
        return hexString.toString();
    }

    public String format(Number n) throws ParseException {
        if (n == null) {
            return "";
        }
        NumberFormat nf = NumberFormat.getNumberInstance(this.locale);
        nf.setGroupingUsed(false);
        if (this.metatype == 1) {
            return this.specialByteFormat(n);
        }
        if (this.metatype == 3) {
            nf.setMinimumFractionDigits(1);
            if (n instanceof Float) {
                try {
                    return NumberUtils.formatFloat((Float)((Float)n), (Locale)this.locale);
                }
                catch (gParseException gPE) {
                }
            } else if (n instanceof Double) {
                try {
                    return NumberUtils.formatDouble((Double)((Double)n), (Locale)this.locale);
                }
                catch (gParseException gPE) {
                    // empty catch block
                }
            }
            nf.setParseIntegerOnly(false);
            return nf.format(n);
        }
        nf.setMinimumFractionDigits(0);
        nf.setParseIntegerOnly(true);
        nf.setMaximumFractionDigits(0);
        long l = n.longValue();
        return nf.format(l);
    }
}

