/*
 * Decompiled with CFR 0.152.
 */
package com.wm.formatter;

import com.wm.formatter.UiFormatter;
import com.wm.g11n.text.DateUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;

public class UiDateFormatter
extends UiFormatter {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATETIME = 3;
    private Locale locale;
    private int type;

    private UiDateFormatter(int dType, Locale aLocale) {
        this.type = dType;
        this.locale = aLocale;
    }

    public static UiFormatter getInstance(int dType, Locale aLocale) {
        switch (dType) {
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return new UiDateFormatter(dType, aLocale);
    }

    public String format(Object o) throws ParseException {
        if (o instanceof Date) {
            return this.format((Date)o);
        }
        if (o instanceof Calendar) {
            return this.format((Calendar)o);
        }
        throw new ParseException("", 0);
    }

    public String format(Date d) throws ParseException {
        String dString;
        switch (this.type) {
            case 99: {
                dString = DateUtils.getStringFromDate((Date)d, (Locale)this.locale);
                break;
            }
            case 2: {
                dString = DateUtils.getLocalizedStringUsingPattern((Date)d, (Locale)this.locale, (String)"HH:mm:ss.sss z");
                break;
            }
            case 1: 
            case 3: {
                String pattern = DateUtils.calculateDatePattern((Locale)this.locale, (boolean)true);
                TimeZone tz = TimeZone.getDefault();
                GregorianCalendar cal = new GregorianCalendar(tz, this.locale);
                cal.setTime(d);
                if (pattern.indexOf(122) == -1 && pattern.indexOf(90) == -1) {
                    pattern = pattern + "z";
                }
                SimpleDateFormat sdf = new SimpleDateFormat(pattern, this.locale);
                sdf.setTimeZone(tz);
                return sdf.format(cal.getTime());
            }
            default: {
                throw new ParseException("", 0);
            }
        }
        return dString;
    }

    public String format(Calendar c) throws ParseException {
        return this.format(c.getTime());
    }
}

