/*
 * Decompiled with CFR 0.152.
 */
package com.wm.formatter;

import com.wm.formatter.UiBooleanFormatter;
import com.wm.formatter.UiDateFormatter;
import com.wm.formatter.UiFormatter;
import com.wm.formatter.UiNumberFormatter;
import com.wm.formatter.UiTextFormatter;
import java.util.Locale;

public class FormatFactory {
    public static final int FORMAT_TYPE_UNKNOWN = -1;
    public static final int FORMAT_TYPE_BYTE = 101;
    public static final int FORMAT_TYPE_CHARACTER = 102;
    public static final int FORMAT_TYPE_DOUBLE = 103;
    public static final int FORMAT_TYPE_FLOAT = 104;
    public static final int FORMAT_TYPE_INTEGER = 105;
    public static final int FORMAT_TYPE_LONG = 106;
    public static final int FORMAT_TYPE_SHORT = 107;
    public static final int FORMAT_TYPE_DATE = 108;
    public static final int FORMAT_TYPE_STRING = 109;
    public static final int FORMAT_TYPE_TIME = 110;
    public static final int FORMAT_TYPE_DATETIME = 111;
    public static final int FORMAT_TYPE_BOOLEAN = 112;
    private static FormatFactory _formatFactory = new FormatFactory();

    private FormatFactory() {
    }

    public static FormatFactory getInstance() {
        return _formatFactory;
    }

    public static UiFormatter getFormatterInstance(int formatType) throws Exception {
        return FormatFactory.getFormatterInstance(formatType, Locale.getDefault());
    }

    public static UiFormatter getFormatterInstance(int formatType, Locale loc) throws Exception {
        switch (formatType) {
            case 101: {
                return UiNumberFormatter.getInstance(1, loc);
            }
            case 107: {
                return UiNumberFormatter.getInstance(2, loc);
            }
            case 105: {
                return UiNumberFormatter.getInstance(3, loc);
            }
            case 106: {
                return UiNumberFormatter.getInstance(4, loc);
            }
            case 104: {
                return UiNumberFormatter.getInstance(5, loc);
            }
            case 103: {
                return UiNumberFormatter.getInstance(6, loc);
            }
            case 102: 
            case 109: {
                return UiTextFormatter.getInstance(loc);
            }
            case 108: {
                return UiDateFormatter.getInstance(1, loc);
            }
            case 110: {
                return UiDateFormatter.getInstance(2, loc);
            }
            case 111: {
                return UiDateFormatter.getInstance(3, loc);
            }
            case 112: {
                return UiBooleanFormatter.getInstance(loc);
            }
        }
        throw new Exception();
    }
}

