/*
 * Decompiled with CFR 0.152.
 */
package com.wm.ext.iaik;

import com.wm.cert.CertManager;
import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.ext.iaik.wmSessionManager;
import com.wm.net.SocketProviderIf;
import com.wm.net.resources.ServerListenerExceptionBundle;
import com.wm.net.resources.ServerListenerExceptionBundle_en;
import com.wm.net.socket.ISocketFactory;
import com.wm.security.TrustDeciderManager;
import com.wm.security.TrustManager;
import com.wm.security.WmSecurityProvider;
import com.wm.security.ssl.wmChainVerifier;
import com.wm.security.wmTrustDecider;
import com.wm.util.Config;
import com.wm.util.JournalLogger;
import com.wm.util.SecurityUtil;
import com.wm.util.ServerException;
import com.wm.util.Values;
import iaik.asn1.structures.AlgorithmID;
import iaik.security.random.SecRandom;
import iaik.security.ssl.ChainVerifier;
import iaik.security.ssl.CipherSuite;
import iaik.security.ssl.CipherSuiteList;
import iaik.security.ssl.KeyAndCert;
import iaik.security.ssl.SSLClientContext;
import iaik.security.ssl.SSLContext;
import iaik.security.ssl.SSLServerContext;
import iaik.security.ssl.SSLServerSocket;
import iaik.security.ssl.SSLSocket;
import iaik.security.ssl.TrustDecider;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.HashMap;
import java.util.Iterator;

public class IaikSecureSocket
implements SocketProviderIf,
ISocketFactory {
    static final String CLIENT_TIMEOUT_PROPERTY = "watt.net.ssl.server.clientHandshakeTimeout";
    static int clientTimeout = 20000;
    static final int SSL_SETUP_ERROR = 4;
    static final int SSL_RESTRICTED = 6;
    static final int SSL_CIPHER_INFO = 7;
    static final int LOAD_CERT_FROM = 8;
    static final int LOAD_NOCERT_FROM = 9;
    static final int PORT_REQ_CERT = 10;
    static final int START_SSL_HANDSHAKE = 11;
    static final int FINISHED_SSL_HANDSHAKE = 12;
    static final int NULL_PEER_CERT_CHAIN = 13;
    static final int PEER_CERT_NOT_MAPPED = 14;
    static final int PEER_CERT_CHAIN_NOT_TRUSTED = 15;
    static final int SSL_HANDSHAKE_FAILED = 16;
    static final int ASYMMETRIC_EXPORT_GRADE = 512;
    protected Values _context;
    protected boolean _usingServerDefaults = false;
    protected boolean _requestCerts = false;
    protected boolean _requireCerts = false;
    String[] _certChain;
    String _key;
    String _caDir;
    String _keyStoreCADir;
    protected static HashMap keyStoreTypes = new HashMap();
    protected static HashMap keyStoreTypeAliases = new HashMap();
    public static final String DEFAULT_JAVA_SECURITY_PROVIDER = "sun.security.provider.Sun";
    protected String _keyStoreProvider;
    protected String _keyStoreProviderClass;
    protected String _keyStoreType;
    protected String _keyStorePassword;
    protected String _keyStoreLocation;
    protected String _alias;
    protected boolean _useHSM;
    protected Provider _provider;
    protected wmChainVerifier _verifier;
    static final String MIN_VERSION_PROP = "watt.net.ssl.client.handshake.minVersion";
    static final String MAX_VERSION_PROP = "watt.net.ssl.client.handshake.maxVersion";
    static final int MIN_VERSION_DEFAULT = 2;
    static final int MAX_VERSION_DEFAULT = 769;
    private static CipherSuite[] reallyStrongCiphers = null;
    private static boolean useReallyStrongCiphers = false;
    static int MinVersion;
    static int MaxVersion;
    static boolean sslDebug;
    protected SSLServerContext gServerContext = null;
    protected SSLClientContext gClientContext = null;
    protected SSLSocket gSocket = null;
    protected boolean gAutoHandshake = true;
    CipherSuite[] strongCiphers = new CipherSuite[]{CipherSuite.SSL_RSA_WITH_RC4_MD5, CipherSuite.SSL_RSA_WITH_RC4_SHA, CipherSuite.SSL_RSA_WITH_IDEA_CBC_SHA, CipherSuite.SSL_RSA_WITH_DES_CBC_SHA, CipherSuite.SSL_RSA_WITH_3DES_EDE_CBC_SHA, CipherSuite.SSL_RSA_EXPORT_WITH_RC4_40_MD5, CipherSuite.SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5, CipherSuite.SSL_RSA_EXPORT_WITH_DES40_CBC_SHA, CipherSuite.SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA, CipherSuite.SSL_DH_DSS_WITH_DES_CBC_SHA, CipherSuite.SSL_DH_DSS_WITH_3DES_EDE_CBC_SHA, CipherSuite.SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA, CipherSuite.SSL_DH_RSA_WITH_DES_CBC_SHA, CipherSuite.SSL_DH_RSA_WITH_3DES_EDE_CBC_SHA, CipherSuite.SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA, CipherSuite.SSL_DHE_DSS_WITH_DES_CBC_SHA, CipherSuite.SSL_DHE_DSS_WITH_3DES_EDE_CBC_SHA, CipherSuite.SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, CipherSuite.SSL_DHE_RSA_WITH_DES_CBC_SHA, CipherSuite.SSL_DHE_RSA_WITH_3DES_EDE_CBC_SHA, CipherSuite.SSL_DH_anon_EXPORT_WITH_RC4_40_MD5, CipherSuite.SSL_DH_anon_WITH_RC4_MD5, CipherSuite.SSL_DH_anon_EXPORT_WITH_RC4_40_MD5, CipherSuite.SSL_DH_anon_WITH_DES_CBC_SHA, CipherSuite.SSL_DH_anon_WITH_3DES_EDE_CBC_SHA, CipherSuite.SSL_RSA_WITH_NULL_MD5, CipherSuite.SSL_RSA_WITH_NULL_SHA};
    CipherSuite[] exportCiphers = new CipherSuite[]{CipherSuite.SSL_RSA_EXPORT_WITH_RC4_40_MD5, CipherSuite.SSL_RSA_EXPORT_WITH_RC2_CBC_40_MD5, CipherSuite.SSL_RSA_EXPORT_WITH_DES40_CBC_SHA, CipherSuite.SSL_DH_DSS_EXPORT_WITH_DES40_CBC_SHA, CipherSuite.SSL_DH_RSA_EXPORT_WITH_DES40_CBC_SHA, CipherSuite.SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA, CipherSuite.SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA, CipherSuite.SSL_DH_anon_EXPORT_WITH_RC4_40_MD5, CipherSuite.SSL_DH_anon_EXPORT_WITH_RC4_40_MD5};
    public static final int HTTPSLSTN_SSLSETUP_MSG = 14;
    public static final int HTTPSLSTN_CERTNOTLOADED_MSG = 15;
    public static final int HTTPSLSTN_PROVIDER_NOT_LOADED = 18;
    public static final int HTTPSLSTN_PROVIDER_NOT_SPECIFIED = 19;
    public static final int HTTPSLSTN_KEYSTORE_PASSWD_NOT_SPECIFIED = 20;

    public IaikSecureSocket() {
    }

    public IaikSecureSocket(Values context) {
        this();
        this._context = context;
        this.initProperties(this._context);
        this.setup();
    }

    public void setup() {
        this.gClientContext = new SSLClientContext();
        if (useReallyStrongCiphers) {
            this.gClientContext.setEnabledCipherSuites(reallyStrongCiphers);
        } else {
            this.gClientContext.setEnabledCipherSuites(this.strongCiphers);
        }
        this.gClientContext.setAllowedProtocolVersions(MinVersion, MaxVersion);
        if (sslDebug) {
            this.gClientContext.setDebugStream((OutputStream)System.out);
        }
    }

    public Object newRandomGenerator() {
        return SecRandom.getDefault();
    }

    public void setRandomGenerator(Object randomgenerator) {
        if (this.gClientContext != null) {
            this.gClientContext.setRandomGenerator((SecureRandom)randomgenerator);
        }
    }

    public void setAutoHandshake(boolean flag) {
        this.gAutoHandshake = flag;
        if (this.gSocket != null) {
            this.gSocket.setAutoHandshake(this.gAutoHandshake);
        }
    }

    public Socket newSocket(Socket sock) throws IOException {
        wmTrustDecider wmtd;
        TrustDeciderManager tdm = TrustManager.getManager();
        if (tdm != null && (wmtd = (wmTrustDecider)tdm.createTrustDecider()) != null) {
            wmtd.init();
            this.gClientContext.setTrustDecider((TrustDecider)wmtd);
        }
        SSLSocket sslsock = new SSLSocket(sock, (SSLContext)this.gClientContext);
        sslsock.setAutoHandshake(this.gAutoHandshake);
        return sslsock;
    }

    public ServerSocket newServerSocket(int port) throws IOException {
        wmTrustDecider wmtd;
        SSLServerContext context = new SSLServerContext();
        context.setDebugStream((Writer)this.gClientContext.getDebugStream());
        context.setEnabledCipherSuites(this.gClientContext.getEnabledCipherSuites());
        context.setAllowedProtocolVersions(768, 769);
        TrustDeciderManager tdm = TrustManager.getManager();
        if (tdm != null && (wmtd = (wmTrustDecider)tdm.createTrustDecider()) != null) {
            wmtd.init();
            context.setTrustDecider((TrustDecider)wmtd);
        }
        SSLServerSocket sss = new SSLServerSocket(port, context);
        return sss;
    }

    public Socket newSecureSocket(Socket s, boolean clientMode, boolean autoAuth) throws IOException {
        wmTrustDecider wmtd;
        if (this.gServerContext == null) {
            try {
                this.setupServer();
                this.setupClientCert();
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        this.gServerContext.setDebugStream((Writer)this.gClientContext.getDebugStream());
        this.gServerContext.setEnabledCipherSuites(this.gClientContext.getEnabledCipherSuites());
        this.gServerContext.setAllowedProtocolVersions(768, 769);
        TrustDeciderManager tdm = TrustManager.getManager();
        if (tdm != null && (wmtd = (wmTrustDecider)tdm.createTrustDecider()) != null) {
            wmtd.init();
            this.gServerContext.setTrustDecider((TrustDecider)wmtd);
            wmtd.setKeyAndCert(this.gServerContext.getServerCredentials(1));
        }
        SSLSocket sock = new SSLSocket(s, (SSLContext)this.gServerContext);
        sock.setUseClientMode(clientMode);
        sock.setAutoHandshake(autoAuth);
        return sock;
    }

    public Socket newSocket(String host, int port) throws IOException {
        wmTrustDecider wmtd;
        TrustDeciderManager tdm = TrustManager.getManager();
        if (tdm != null && (wmtd = (wmTrustDecider)tdm.createTrustDecider()) != null) {
            wmtd.init();
            this.gClientContext.setTrustDecider((TrustDecider)wmtd);
        }
        this.gSocket = new SSLSocket(host, port, (SSLContext)this.gClientContext);
        this.gSocket.setAutoHandshake(this.gAutoHandshake);
        return this.gSocket;
    }

    public Socket newSocket(String host, int port, KeyAndCert keyAndCert) throws IOException {
        wmTrustDecider wmtd;
        TrustDeciderManager tdm = TrustManager.getManager();
        if (tdm != null && (wmtd = (wmTrustDecider)tdm.createTrustDecider()) != null) {
            try {
                if (keyAndCert != null) {
                    wmtd.setKeyAndCert(keyAndCert);
                }
            }
            catch (Exception e) {
                JournalLogger.logError(9998, 6, e);
            }
            wmtd.init();
            this.gClientContext.setTrustDecider((TrustDecider)wmtd);
        }
        this.gSocket = new SSLSocket(host, port, (SSLContext)this.gClientContext);
        this.gSocket.setAutoHandshake(this.gAutoHandshake);
        return this.gSocket;
    }

    public boolean startHandshake() throws IOException {
        if (this.gSocket != null) {
            int oldTimeout = this.gSocket.getSoTimeout();
            this.gSocket.setSoTimeout(clientTimeout);
            this.gSocket.startHandshake();
            this.gSocket.setSoTimeout(oldTimeout);
            return true;
        }
        return false;
    }

    public static void startHandshake(Socket conn) throws IOException {
        if (conn == null || !(conn instanceof SSLSocket)) {
            return;
        }
        int oldTimeout = conn.getSoTimeout();
        conn.setSoTimeout(clientTimeout);
        JournalLogger.logDebugPlus(5, 11, 6, "");
        try {
            ((SSLSocket)conn).startHandshake();
        }
        catch (IOException ioe) {
            JournalLogger.logError(9998, 6, ioe);
            JournalLogger.logError(16, 6, "");
            throw ioe;
        }
        JournalLogger.logDebugPlus(5, 12, 6, "");
        conn.setSoTimeout(oldTimeout);
    }

    public boolean handleIOException(IOException e) {
        return false;
    }

    public InputStream getSocketInputStream() throws IOException {
        return this.gSocket.getInputStream();
    }

    public OutputStream getSocketOutputStream() throws IOException {
        return this.gSocket.getOutputStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyAndCert getKeyAndCert() throws Exception {
        boolean usedKeyDef = false;
        boolean usedChainDef = false;
        java.security.cert.X509Certificate[] x509Chain = null;
        RSAPrivateKey rsaPrivateKey = null;
        try {
            if (this._key == null || this._key.trim().length() == 0) {
                this._key = Config.getProperty("watt.security.privateKey");
                usedKeyDef = true;
            }
            if (this._key == null) {
                KeyAndCert keyAndCert = null;
                return keyAndCert;
            }
            if (this._certChain == null || this._certChain.length == 0) {
                this._certChain = new String[2];
                this._certChain[0] = Config.getProperty("watt.security.signedCert");
                this._certChain[1] = Config.getProperty("watt.security.caCert");
                usedChainDef = true;
            } else if (this._certChain.length == 2 && (this._certChain[0] == null || this._certChain[0].trim().length() == 0)) {
                this._certChain[0] = Config.getProperty("watt.security.signedCert");
                this._certChain[1] = Config.getProperty("watt.security.caCert");
                usedChainDef = true;
            }
            if (this._certChain.length != 2 || this._certChain[0] == null) {
                KeyAndCert keyAndCert = null;
                return keyAndCert;
            }
            File keyFile = new File(this._key);
            if (!keyFile.exists()) {
                KeyAndCert keyAndCert = null;
                return keyAndCert;
            }
            rsaPrivateKey = (RSAPrivateKey)com.wm.security.Util.loadRSAPrivateKey(keyFile);
            if (rsaPrivateKey == null) {
                throw new Exception("Private key either not in the correct format (PKCS#1 or PKCS#8) or is protected: " + this._key);
            }
            try {
                x509Chain = com.wm.security.Util.loadX509Chain(this._certChain);
            }
            catch (CertificateException ce) {
                throw new ServerException(ServerListenerExceptionBundle.class, ServerListenerExceptionBundle.BAD_CERTIFICATE, "", this._key);
            }
            catch (Exception e) {
                throw new ServerException(e.getMessage());
            }
            KeyAndCert keyAndCert = new KeyAndCert(x509Chain, (PrivateKey)rsaPrivateKey);
            return keyAndCert;
        }
        finally {
            if (usedKeyDef) {
                this._key = null;
            }
            if (usedChainDef) {
                this._certChain = null;
            }
        }
    }

    public static Object[] getClientCredentials(Socket socket) {
        if (socket == null || !(socket instanceof SSLSocket)) {
            return null;
        }
        X509Certificate[] chain = null;
        try {
            chain = Util.convertCertificateChain((Certificate[])((SSLSocket)socket).getPeerCertificateChain());
        }
        catch (Exception e) {
            return null;
        }
        if (chain == null || chain.length == 0) {
            return null;
        }
        Object[] certList = CertManager.newInstanceArray(chain.length);
        for (int i = 0; i < certList.length; ++i) {
            certList[i].setCertificate(chain[i]);
        }
        return certList;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress address, Values context) throws IOException {
        SSLServerSocket socket = null;
        if (this._context == null) {
            this._context = context;
            this.initProperties(this._context);
        }
        try {
            this.setupServer();
            this.setupClientCert();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        socket = address != null ? new SSLServerSocket(port, backlog, address, this.gServerContext) : new SSLServerSocket(port, backlog, this.gServerContext);
        return socket;
    }

    public ServerSocket createServerSocket(int port, int backlog, Values context) throws IOException {
        SSLServerSocket socket = null;
        if (this._context == null) {
            this._context = context;
            this.initProperties(context);
        }
        try {
            this.setupServer();
            this.setupClientCert();
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        socket = new SSLServerSocket(port, backlog, this.gServerContext);
        return socket;
    }

    public Socket createSocket(InetAddress localAddress, int localPort, InetAddress remoteAddress, int port, Values context) throws IOException {
        return this.newSocket(remoteAddress.getHostAddress(), port);
    }

    public Socket createSocket(String host, int port, InetAddress clientaddr, int clientport, Values context) throws IOException {
        wmTrustDecider wmtd;
        TrustDeciderManager tdm = TrustManager.getManager();
        if (tdm != null && (wmtd = (wmTrustDecider)tdm.createTrustDecider()) != null) {
            wmtd.init();
            this.gClientContext.setTrustDecider((TrustDecider)wmtd);
        }
        this.gSocket = new SSLSocket(host, port, clientaddr, clientport, (SSLContext)this.gClientContext);
        this.gSocket.setAutoHandshake(this.gAutoHandshake);
        return this.gSocket;
    }

    public Socket createSocket(InetAddress hostAddress, int port, Values context) throws IOException {
        if ("regularinternal".equals(context.getString("listenerType"))) {
            try {
                return this.newSocket(hostAddress.getHostAddress(), port, this.getKeyAndCert());
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                IOException ioe = new IOException(e.getLocalizedMessage());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }
        return this.newSocket(hostAddress.getHostAddress(), port);
    }

    public Socket createSocket(String host, int port, Values context) throws IOException {
        if (this._context == null) {
            this._context = context;
            this.initProperties(this._context);
        }
        return this.newSocket(host, port);
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.newSocket(host, port);
    }

    public Values getProperties(Values props) {
        String s = "none";
        if (this._requireCerts) {
            s = "require";
        } else if (this._requestCerts) {
            s = "request";
        }
        props.put("ssl", "true");
        props.put("clientAuth", s);
        props.put("certChain", this._certChain);
        props.put("privKey", this._key);
        props.put("caDir", this._caDir);
        props.put("keyStoreProvider", this._keyStoreProvider);
        props.put("keyStoreProviderClass", this._keyStoreProviderClass);
        props.put("keyStoreType", this._keyStoreType);
        props.put("useHSM", this._useHSM ? "true" : "false");
        props.put("password", this._keyStorePassword);
        props.put("keyStoreLocation", this._keyStoreLocation);
        props.put("alias", this._alias);
        props.put("keyStoreCADir", this._keyStoreCADir);
        return props;
    }

    public String getProtocol() {
        return "ssl";
    }

    private void initProperties(Values properties) {
        String s = properties.getString("clientAuth");
        if (s != null && s.length() > 0) {
            if (s.equalsIgnoreCase("request")) {
                this._requestCerts = true;
            }
            if (s.equalsIgnoreCase("require")) {
                this._requestCerts = true;
                this._requireCerts = true;
            }
        }
        String keyName = properties.getString("privKey");
        String caDir = properties.getString("caDir");
        String[] chainName = properties.getStringArray("certChain");
        IData underlying = properties.getIData();
        IDataCursor dc = underlying.getCursor();
        if (dc.first("signedCert")) {
            chainName = new String[2];
            chainName[0] = (String)dc.getValue();
            if (dc.first("caCert")) {
                chainName[1] = (String)dc.getValue();
            }
        }
        this._keyStoreProvider = properties.getString("keyStoreProvider");
        this._keyStoreProviderClass = properties.getString("keyStoreProviderClass");
        this._keyStoreType = properties.getString("keyStoreType");
        if (this._keyStoreProvider == null || this._keyStoreProvider.trim().equals("")) {
            this._keyStoreProvider = this.getProviderForKeyStores(this._keyStoreType);
        }
        this._useHSM = properties.getBoolean("useHSM");
        this._keyStoreLocation = properties.getString("keyStoreLocation");
        this._keyStorePassword = properties.getString("password");
        this._alias = properties.getString("alias");
        if (this._keyStoreLocation != null && this._keyStoreLocation.length() > 0) {
            this._provider = this.getJavaSecurityProvider(this._keyStoreProvider);
            if (this._provider != null) {
                this._keyStoreProviderClass = this._provider.getClass().getName();
                if (sslDebug) {
                    IaikSecureSocket.debug("IaikHTTPSListener---> the Java provider`s class = " + this._keyStoreProviderClass);
                }
            }
        }
        this._keyStoreCADir = properties.getString("keyStoreCADir");
        dc.destroy();
        dc = null;
        underlying = null;
        keyName = keyName == null ? "" : keyName.trim();
        this._certChain = chainName;
        this._key = keyName;
        this._caDir = caDir;
    }

    private void setupServer() throws ServerException {
        boolean usedKeyDef = false;
        boolean usedChainDef = false;
        boolean usedCADirDef = false;
        try {
            RSAKey rsaPrivateKey = null;
            java.security.cert.X509Certificate[] x509Chain = null;
            java.security.cert.X509Certificate[] chain = null;
            if (this._provider != null) {
                if (this._keyStoreLocation == null) {
                    throw new IOException(new ServerException(ServerListenerExceptionBundle.class, ServerListenerExceptionBundle.KEYSTORE_LOC_NOT_SPECIFIED, "").getMessage());
                }
                String keyStoreType = null;
                keyStoreType = this._keyStoreType == null || this._keyStoreType.length() < 1 ? KeyStore.getDefaultType() : this._keyStoreType;
                KeyStore keyStore = null;
                try {
                    keyStore = KeyStore.getInstance(keyStoreType, this._provider.getName());
                }
                catch (Exception e) {
                    throw new IOException(new ServerException(ServerListenerExceptionBundle.class, ServerListenerExceptionBundle.KEYSTORE_NOT_INSTANTIATED, "", new Object[]{this._provider.getName(), e.getLocalizedMessage()}).getMessage());
                }
                File keyStoreFile = new File(this._keyStoreLocation);
                if (!keyStoreFile.exists()) {
                    throw new IOException(new ServerException(ServerListenerExceptionBundle.class, ServerListenerExceptionBundle.KEYSTORE_FILE_NOT_EXIST, "", this._keyStoreLocation).getMessage());
                }
                if (this._keyStorePassword == null || this._keyStorePassword.length() < 1) {
                    this._keyStorePassword = Config.getProperty(null, "server.listeners.keystorePassword");
                }
                if (this._keyStorePassword == null || this._keyStorePassword.length() < 1) {
                    JournalLogger.logCritical(20, 47, this._keyStoreLocation);
                    throw new IOException(new ServerException(ServerListenerExceptionBundle.class, ServerListenerExceptionBundle.PASSWORD_NOT_SPECIFIED, "", this._keyStoreLocation).getMessage());
                }
                try {
                    keyStore.load(new FileInputStream(keyStoreFile), this._keyStorePassword.toCharArray());
                    boolean aliasPresent = keyStore.containsAlias(this._alias);
                    if (!aliasPresent) {
                        throw new IOException(new ServerException(ServerListenerExceptionBundle.class, ServerListenerExceptionBundle.ALIAS_NOT_EXIST, "", this._alias).getMessage());
                    }
                    try {
                        Certificate[] tempchain = keyStore.getCertificateChain(this._alias);
                        chain = new java.security.cert.X509Certificate[tempchain.length];
                        for (int i = 0; i < chain.length; ++i) {
                            chain[i] = (java.security.cert.X509Certificate)tempchain[i];
                        }
                    }
                    catch (Exception e) {
                        throw new IOException(e.getMessage());
                    }
                    Key key = keyStore.getKey(this._alias, this._keyStorePassword.toCharArray());
                    if (key instanceof PrivateKey) {
                        rsaPrivateKey = (RSAPrivateKey)key;
                    }
                    if (rsaPrivateKey == null) {
                        throw new IOException(new ServerException(ServerListenerExceptionBundle.class, ServerListenerExceptionBundle.PRIVATE_KEY_NOT_EXIST, "", this._alias).getMessage());
                    }
                }
                catch (Exception e) {
                    throw new IOException(e.getMessage());
                }
                if (chain != null && chain.length > 0) {
                    x509Chain = new java.security.cert.X509Certificate[chain.length];
                    for (int i = 0; i < chain.length; ++i) {
                        x509Chain[i] = chain[i];
                    }
                }
                if (this._useHSM) {
                    String providerName = null;
                    providerName = this._provider != null ? this._provider.getName() : this._keyStoreProvider;
                    WmSecurityProvider.getInstance(providerName);
                    WmSecurityProvider.setDebug(sslDebug);
                    WmSecurityProvider.registerProviderForKey(rsaPrivateKey.getClass().getName(), providerName);
                }
            }
            this.gServerContext = new SSLServerContext();
            if (sslDebug) {
                this.gServerContext.setDebugStream((OutputStream)System.err);
            }
            this.gServerContext.setAllowedProtocolVersions(768, 769);
            CipherSuiteList ciphers = new CipherSuiteList();
            ciphers.add(CipherSuite.CS_RSA_EXPORT);
            ciphers.add(CipherSuite.CS_RSA_EXPORT1024);
            ciphers.add(CipherSuite.CS_RSA);
            if (Config.getProperty("false", "watt.net.ssl.server.strongcipheronly").equals("true")) {
                CipherSuiteList ciphersuitelist1 = new CipherSuiteList(CipherSuite.CS_RSA);
                ciphers = new CipherSuiteList();
                for (int i = 0; i < ciphersuitelist1.size(); ++i) {
                    if (ciphersuitelist1.elementAt(i).getKeyLength() < 16) continue;
                    ciphers.add(ciphersuitelist1.elementAt(i));
                }
                ciphersuitelist1 = null;
                JournalLogger.logCritical(6, 6);
                for (int j = 0; j < ciphers.size(); ++j) {
                    Object[] o = new Object[]{String.valueOf(j), ciphers.elementAt(j).toString(), String.valueOf(8 * ciphers.elementAt(j).getKeyLength())};
                    JournalLogger.logCritical(7, 6, o);
                }
            }
            ciphers.remove(CipherSuite.SSL_RSA_WITH_IDEA_CBC_SHA);
            ciphers.ensureAvailable();
            this.gServerContext.setEnabledCipherSuiteList(ciphers);
            String string = this._key = this._key == null ? "" : this._key.trim();
            if (this._key.length() == 0) {
                this._key = Config.getProperty("watt.security.privateKey");
                usedKeyDef = true;
            }
            if (this._certChain == null || this._certChain.length == 0) {
                this._certChain = new String[2];
                this._certChain[0] = Config.getProperty("watt.security.signedCert");
                this._certChain[1] = Config.getProperty("watt.security.caCert");
                usedChainDef = true;
            } else if (this._certChain.length == 2 && (this._certChain[0] == null || this._certChain[0].trim().length() == 0)) {
                this._certChain[0] = Config.getProperty("watt.security.signedCert");
                this._certChain[1] = Config.getProperty("watt.security.caCert");
                usedChainDef = true;
            }
            if (x509Chain == null) {
                String string2 = this._caDir = this._caDir == null ? "" : this._caDir.trim();
                if (this._caDir.length() == 0) {
                    this._caDir = Config.getProperty("watt.security.CADir");
                    usedCADirDef = true;
                }
                if (this._key == null) {
                    throw new ServerException(ServerListenerExceptionBundle.class, ServerListenerExceptionBundle.PRIVKEY_NOT_SPECIFIED, "");
                }
                File keyFile = new File(this._key);
                if (!keyFile.exists()) {
                    throw new ServerException(ServerListenerExceptionBundle.class, ServerListenerExceptionBundle.PRIVKEY_FILE_NOT_EXIST, "");
                }
                try {
                    chain = com.wm.security.Util.loadX509Chain(this._certChain);
                }
                catch (CertificateException ce) {
                    throw new ServerException(ServerListenerExceptionBundle.class, ServerListenerExceptionBundle.BAD_CERTIFICATE, "", this._key);
                }
                catch (Exception e) {
                    throw new ServerException(e.getMessage());
                }
                rsaPrivateKey = (RSAPrivateKey)com.wm.security.Util.loadRSAPrivateKey(keyFile);
                if (rsaPrivateKey == null) {
                    throw new Exception("Private key not either not in the correct format (PKCS#1 or PKCS#8) or is protected");
                }
            } else {
                String string3 = this._keyStoreCADir = this._keyStoreCADir == null ? "" : this._keyStoreCADir.trim();
                if (this._keyStoreCADir.length() == 0) {
                    this._keyStoreCADir = Config.getProperty("watt.security.CADir");
                    usedCADirDef = true;
                }
            }
            this.gServerContext.addServerCredentials(chain, rsaPrivateKey);
            BigInteger modulus = rsaPrivateKey.getModulus();
            if (this._provider != null || rsaPrivateKey.getModulus().bitLength() > 512) {
                try {
                    KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA", SecurityUtil.getFipsProvider());
                    gen.initialize(512, SecRandom.getDefault());
                    KeyPair keyPair = gen.generateKeyPair();
                    this.gServerContext.addTemporaryParameter(keyPair);
                }
                catch (Exception e) {
                    JournalLogger.logDebug(4, 6, e);
                }
            }
            this.gServerContext.updateCipherSuites();
        }
        catch (Exception e) {
            JournalLogger.logCritical(9998, 6, e);
            throw new ServerException(e.getMessage());
        }
        catch (Throwable t) {
            JournalLogger.logCritical(9998, 6, t);
            throw new ServerException(t.getMessage());
        }
        finally {
            if (usedKeyDef) {
                this._key = null;
            }
            if (usedChainDef) {
                this._certChain = null;
            }
            if (usedCADirDef) {
                this._caDir = null;
            }
        }
    }

    public void setupClientCert() throws ServerException {
        try {
            String caDir = null;
            boolean useDefaultVerifier = false;
            if (this._keyStoreCADir == null || this._keyStoreCADir.length() == 0) {
                if (this._caDir == null || this._caDir.length() == 0) {
                    useDefaultVerifier = true;
                } else {
                    caDir = this._caDir.trim();
                }
            } else {
                caDir = this._keyStoreCADir.trim();
            }
            if (useDefaultVerifier) {
                this._verifier = wmChainVerifier.getDefaultVerifier();
                this._verifier.loadDefaultAuthorities();
            } else {
                this._verifier = new wmChainVerifier();
                java.security.cert.X509Certificate[] authorities = com.wm.security.Util.loadCertificatesFromDir(caDir);
                if (authorities != null) {
                    JournalLogger.logDebug(8, 6, caDir, "");
                } else {
                    JournalLogger.logDebug(9, 6, caDir, "");
                }
                if (authorities != null && authorities.length > 0) {
                    for (int i = 0; i < authorities.length; ++i) {
                        this._verifier.addTrustedCertificate(authorities[i]);
                    }
                }
            }
            if (this._requestCerts || this._requireCerts) {
                this.gServerContext.setRequestClientCertificate(true);
                JournalLogger.logDebugPlus(5, 10, 6, "");
            } else {
                this.gServerContext.setRequestClientCertificate(false);
            }
            if (!this._requireCerts) {
                this._verifier.addTrustedCertificate(null);
            }
            this.gServerContext.setChainVerifier((ChainVerifier)this._verifier);
        }
        catch (Exception e) {
            JournalLogger.logCritical(9998, 6, e);
            throw new ServerException(e.getMessage());
        }
        catch (Throwable t) {
            JournalLogger.logCritical(9998, 6, t);
            throw new ServerException(t.getMessage());
        }
    }

    public String checkClientCert(Socket socket) throws IOException, ServerException {
        SSLSocket ss = (SSLSocket)socket;
        java.security.cert.X509Certificate[] chain = ss.getPeerCertificateChain();
        if (this._requireCerts && chain == null) {
            JournalLogger.logError(13, 6);
            ss.close();
            throw new ServerException(ServerListenerExceptionBundle_en.class, ServerListenerExceptionBundle.NO_PEER_CERT_CHAIN, "");
        }
        if (chain != null && !this._verifier.isTrustedChain(chain)) {
            JournalLogger.logError(15, 6);
            ss.close();
            throw new ServerException(ServerListenerExceptionBundle_en.class, ServerListenerExceptionBundle.PEER_CERT_CHAIN_NOT_TRUSTED, "");
        }
        return null;
    }

    Provider getJavaSecurityProvider(String providerName) {
        Provider[] providers;
        boolean foundMatch = false;
        if (providerName != null && providerName.length() > 0 && (providers = Security.getProviders()) != null && providers.length > 0) {
            for (int i = 0; i < providers.length; ++i) {
                if (!providers[i].getName().equals(providerName)) continue;
                this._provider = providers[i];
                foundMatch = true;
            }
        }
        if (!foundMatch) {
            try {
                if (this._keyStoreProviderClass != null && this._keyStoreProviderClass.length() > 0) {
                    Class<?> c = Class.forName(this._keyStoreProviderClass);
                    this._provider = (Provider)c.newInstance();
                    Security.addProvider(this._provider);
                }
            }
            catch (Exception e) {
                JournalLogger.logError(18, 47, this._keyStoreProviderClass, e);
            }
            if (this._provider == null) {
                String keyStoreProviderClass = Config.getProperty(DEFAULT_JAVA_SECURITY_PROVIDER, "watt.server.java.security.provider");
                try {
                    if (keyStoreProviderClass != null && keyStoreProviderClass.length() > 0) {
                        Class<?> c = Class.forName(keyStoreProviderClass);
                        this._provider = (Provider)c.newInstance();
                        Security.addProvider(this._provider);
                    }
                }
                catch (Exception e) {
                    JournalLogger.logError(18, 47, keyStoreProviderClass, e);
                }
            }
        }
        return this._provider;
    }

    private String getProviderForKeyStores(String keyStore) {
        if (keyStoreTypes.size() == 0) {
            Provider[] providers = Security.getProviders();
            for (int i = 0; i < providers.length; ++i) {
                Iterator<Object> iter = providers[i].keySet().iterator();
                while (iter.hasNext()) {
                    String prop = ((String)iter.next()).trim();
                    int kindx = prop.indexOf("Alias.KeyStore.");
                    if (kindx > -1) {
                        keyStoreTypeAliases.put(providers[i].getProperty(prop), prop.substring(kindx + "Alias.KeyStore.".length()));
                        continue;
                    }
                    kindx = prop.indexOf("KeyStore.");
                    if (kindx <= -1) continue;
                    keyStoreTypes.put(prop.substring(kindx + "KeyStore.".length()), providers[i].getName());
                }
            }
        }
        String provider = null;
        if (keyStoreTypes.containsKey(keyStore)) {
            provider = (String)keyStoreTypes.get(keyStore);
        }
        if (keyStoreTypeAliases.containsKey(provider)) {
            provider = (String)keyStoreTypeAliases.get(provider);
        }
        return provider;
    }

    static void debug(String msg) {
        System.err.println("<HTTPSListener>: " + msg);
    }

    static {
        sslDebug = false;
        try {
            clientTimeout = Integer.parseInt(System.getProperty(CLIENT_TIMEOUT_PROPERTY, "20000"));
        }
        catch (Throwable t) {
            clientTimeout = 20000;
        }
        try {
            String ver;
            Util.setEncoding((String)"ISO8859_1");
            AlgorithmID algID = new AlgorithmID("1.2.840.113549.1.1.5", "sha1WithRSAEncryption", "SHA/RSA");
            wmSessionManager.init();
            TrustManager.init();
            sslDebug = Boolean.getBoolean("watt.ssl.iaik.debug");
            Util.setEncoding((String)"ISO8859_1");
            MinVersion = Config.getProperty(MIN_VERSION_PROP) == null ? 2 : ((ver = Config.getProperty(MIN_VERSION_PROP)).equals("sslv3") ? 768 : (ver.equals("tls") ? 769 : 2));
            MaxVersion = Config.getProperty(MAX_VERSION_PROP) == null ? 769 : ((ver = Config.getProperty(MAX_VERSION_PROP)).equals("sslv3") ? 768 : (ver.equals("tls") ? 769 : 769));
            if (MinVersion > MaxVersion) {
                MaxVersion = MinVersion;
            }
            if (Config.getProperty("false", "watt.net.ssl.client.strongcipheronly").equals("true")) {
                CipherSuiteList allciphers = new CipherSuiteList(4);
                CipherSuiteList ciphers = new CipherSuiteList();
                for (int ci = 0; ci < allciphers.size(); ++ci) {
                    if (allciphers.elementAt(ci).getKeyLength() < 16) continue;
                    ciphers.add(allciphers.elementAt(ci));
                }
                ciphers.remove(CipherSuite.SSL_RSA_WITH_IDEA_CBC_SHA);
                allciphers = null;
                useReallyStrongCiphers = true;
                reallyStrongCiphers = ciphers.toArray();
                JournalLogger.logDebugPlus(1, 9999, 46, "Outbound SSL restricted to 128 bit or better encryption: ");
                for (int i = 0; i < ciphers.size(); ++i) {
                    JournalLogger.logDebugPlus(2, 9999, 46, " cipher " + i + " = " + ciphers.elementAt(i).toString() + " (" + 8 * ciphers.elementAt(i).getKeyLength() + " bit)");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

