/*
 * Decompiled with CFR 0.152.
 */
package com.wm.ext.iaik;

import com.wm.cert.X509CertIf;
import com.wm.ext.iaik.IAIKName;
import iaik.asn1.structures.Name;
import iaik.x509.X509Certificate;
import java.io.InputStream;
import java.security.Principal;
import java.security.PublicKey;
import java.util.Date;

public class IAIKCert
implements X509CertIf {
    protected X509Certificate gCert;

    public void initialize(InputStream is) throws Exception {
        this.gCert = new X509Certificate(is);
    }

    public void setCertificate(Object cert) {
        if (cert instanceof X509Certificate) {
            this.gCert = (X509Certificate)cert;
        }
    }

    public boolean checkValidity() {
        try {
            this.gCert.checkValidity();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean checkValidity(Date when) {
        try {
            this.gCert.checkValidity(when);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Principal getSubjectDN() {
        return new IAIKName((Name)this.gCert.getSubjectDN());
    }

    public Principal getIssuerDN() {
        return new IAIKName((Name)this.gCert.getIssuerDN());
    }

    public Date getNotBefore() {
        return this.gCert.getNotBefore();
    }

    public Date getNotAfter() {
        return this.gCert.getNotAfter();
    }

    public PublicKey getPublicKey() {
        return this.gCert.getPublicKey();
    }

    public boolean verify() {
        return this.verify(this.gCert.getPublicKey());
    }

    public boolean verify(PublicKey pubKey) {
        boolean valid = false;
        try {
            this.gCert.verify(pubKey);
            valid = true;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valid;
    }

    public int getVersion() {
        return this.gCert.getVersion();
    }

    public byte[] getFingerprint() {
        return this.gCert.getFingerprint();
    }

    public String toString() {
        return this.gCert.toString();
    }
}

