/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b.socket;

import com.wm.driver.comm.b2b.socket.SocketLink;
import com.wm.io.comm.CommException;
import com.wm.io.comm.ILink;
import com.wm.io.comm.ILinkServer;
import com.wm.util.comm.LinkParameters;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.StringTokenizer;

public class SocketLinkServer
implements ILinkServer {
    public static final String BACKLOG_PROP = "SOCKET.BACKLOG";
    public static final String TIMEOUT_PROP = "SOCKET.TIMEOUT";
    boolean done;
    ServerSocket server;

    public SocketLinkServer(LinkParameters lp) throws CommException {
        StringTokenizer st = new StringTokenizer(lp.getURL(), ":");
        String host = null;
        host = st.countTokens() > 1 ? st.nextToken() : null;
        int port = Integer.parseInt(st.nextToken());
        int backlog = Integer.parseInt(lp.getArg(BACKLOG_PROP, "200"));
        this.setup(host, port, backlog);
    }

    private void setup(String local, int port, int backlog) throws CommException {
        try {
            this.server = local != null ? new ServerSocket(port, backlog, InetAddress.getByName(local)) : new ServerSocket(port, backlog);
        }
        catch (IOException e) {
            throw (CommException)new CommException(e.getMessage()).fillInStackTrace();
        }
        this.done = false;
    }

    public ILink accept(long timeout) throws CommException {
        if (this.done) {
            throw new CommException("ConnectionServer closed");
        }
        if (timeout < 0L) {
            timeout = 1L;
        }
        try {
            this.server.setSoTimeout((int)timeout);
            Socket conn = this.server.accept();
            LinkParameters lp = new LinkParameters(conn.getInetAddress().getHostAddress() + ":" + conn.getPort());
            return new SocketLink(conn, lp);
        }
        catch (IOException e) {
            throw (CommException)new CommException(e.getMessage()).fillInStackTrace();
        }
    }

    public void close() {
        try {
            if (!this.done) {
                this.server.close();
                this.done = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "SocketLinkServer:" + this.server.toString();
    }
}

