/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b.socket;

import com.wm.data.IData;
import com.wm.data.IDataCursor;
import com.wm.data.IDataFactory;
import com.wm.driver.comm.b2b.WmLink;
import com.wm.driver.comm.b2b.WmMessage;
import com.wm.driver.comm.b2b.WmSecurityContext;
import com.wm.io.comm.CommException;
import com.wm.io.comm.ILinkListener;
import com.wm.io.comm.ILinkParameters;
import com.wm.io.comm.IMessage;
import com.wm.net.SocketProviderIf;
import com.wm.security.Config;
import com.wm.util.Base64;
import com.wm.util.JournalLogger;
import com.wm.util.Strings;
import com.wm.util.coder.IDataBinCoder;
import com.wm.util.comm.LinkParameters;
import com.wm.util.text.UUID;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.Socket;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class SocketLink
implements WmLink {
    public static final int CONAPI0100 = 100;
    public static final int CONAPI0101 = 101;
    public static final int CONAPI0102 = 102;
    public static final int CONAPI0103 = 103;
    public static final int CONAPI0104 = 104;
    public static final int CONAPI0105 = 105;
    public static final int CONAPI0106 = 106;
    public static final int AVAIL = 1;
    public static final int INUSE = 2;
    public static final int CLOSED = 3;
    static Object cRandomGenerator = null;
    static SocketProviderIf gSecureSocketProvider = null;
    static String cSecureSocketClass = null;
    static boolean useTimeout = false;
    private static Method connectMethod = null;
    private static Constructor constrSocketAddr = null;
    private static Constructor constrSocket = null;
    public static final boolean log = false;
    private String id;
    protected Socket socket;
    protected BufferedOutputStream out;
    protected BufferedInputStream in;
    protected LinkParameters linkParms;
    protected ILinkListener linkListener;
    protected String basicAuth;
    protected Object sslCredentials;
    protected Method getCertificateChain;
    protected boolean isSecure;
    protected int port;
    protected String host;
    protected long lastUsed = 0L;
    protected int state = 1;
    protected IDataBinCoder inBinCoder = null;
    protected IDataBinCoder outBinCoder = null;
    private static Object idlock;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String nextUUID() {
        String uuid = null;
        Object object = idlock;
        synchronized (object) {
            uuid = UUID.generate();
        }
        return uuid;
    }

    public SocketLink(LinkParameters lp) throws CommException {
        this.linkParms = lp;
        try {
            this.parseLink(lp.getURL());
            String secParm = lp.getArg("secure", "false");
            this.isSecure = "true".equalsIgnoreCase(secParm);
            if (this.isSecure) {
                Socket sslSocket = gSecureSocketProvider.newSocket(this.host, this.port);
                sslSocket.setSoTimeout(0);
                this.setup(sslSocket, lp);
            } else {
                this.setup(new Socket(this.host, this.port), lp);
            }
        }
        catch (Exception e) {
            throw new CommException(e);
        }
    }

    public SocketLink(LinkParameters lp, int timeout) throws CommException {
        this.linkParms = lp;
        try {
            this.parseLink(lp.getURL());
            String secParm = lp.getArg("secure", "false");
            this.isSecure = "true".equalsIgnoreCase(secParm);
            if (this.isSecure) {
                Socket sslSocket = gSecureSocketProvider.newSocket(this.host, this.port);
                sslSocket.setSoTimeout(0);
                this.setup(sslSocket, lp);
            } else if (useTimeout && timeout > 0) {
                Socket sock = this.createSocket(this.host, this.port, timeout);
                this.setup(sock, lp);
            } else {
                this.setup(new Socket(this.host, this.port), lp);
            }
        }
        catch (Exception e) {
            throw new CommException(e);
        }
    }

    public SocketLink(Socket s, LinkParameters lp) throws CommException {
        this.setup(s, lp);
    }

    protected void setup(Socket s, LinkParameters lp) throws CommException {
        try {
            this.linkParms = lp;
            WmSecurityContext ctx = (WmSecurityContext)this.linkParms.getSecurityContext();
            if (ctx != null) {
                String user = ctx.getUser();
                String pass = ctx.getPassword();
                this.basicAuth = user != null && user.length() > 0 ? (pass != null ? Base64.encode(Strings.cat(user, ":", pass)) : Base64.encode(Strings.cat(user, ":"))) : null;
                try {
                    this.sslCredentials = ctx.getSSLCredentials();
                    Class<?> clazz = Class.forName("iaik.security.ssl.KeyAndCert");
                    this.getCertificateChain = clazz.getMethod("getCertificateChain", null);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            this.socket = s;
            this.socket.setTcpNoDelay(false);
            this.in = new BufferedInputStream(this.socket.getInputStream());
            this.out = new BufferedOutputStream(this.socket.getOutputStream());
            this.createCoders();
            JournalLogger.logDebugPlus(2, 101, 80, "SocketLink", this.linkParms.getURL());
        }
        catch (Exception e) {
            JournalLogger.logDebugPlus(2, 102, 80, "SocketLink", e.getMessage());
            throw new CommException(e);
        }
    }

    protected void createCoders() {
        this.inBinCoder = new IDataBinCoder();
        this.outBinCoder = new IDataBinCoder();
    }

    public String toString() {
        return this.id + ": " + this.socket.getInetAddress() + " -> " + this.socket.getLocalPort();
    }

    protected void parseLink(String url) throws MalformedURLException {
        StringTokenizer st = new StringTokenizer(url, ":");
        int count = st.countTokens() - 2;
        if (count < 0) {
            throw new MalformedURLException("not enough fields");
        }
        this.host = st.nextToken();
        try {
            this.port = Integer.parseInt(st.nextToken());
        }
        catch (NumberFormatException nfe) {
            throw new MalformedURLException("incorrect port number");
        }
    }

    protected IData createHeader(Properties p) {
        String msgType;
        Vector v;
        IData hdr = IDataFactory.create();
        IDataCursor cr = hdr.getCursor();
        cr.insertAfter("Session", "false");
        String basicCredentials = (String)p.get("Authorization");
        basicCredentials = basicCredentials != null ? basicCredentials : this.basicAuth;
        cr.insertAfter("Authorization", basicCredentials);
        X509Certificate[] secCredentials = (X509Certificate[])p.get("SSL-Authorization");
        if (secCredentials == null && this.sslCredentials != null && this.getCertificateChain != null) {
            try {
                secCredentials = (X509Certificate[])this.getCertificateChain.invoke(this.sslCredentials, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getCause());
            }
        }
        if (secCredentials != null && (v = WmMessage.createSerializableCertificates(secCredentials)) != null) {
            cr.insertAfter("SSL-Authorization", v);
        }
        msgType = (msgType = (String)p.get("MessageType")) != null ? msgType : String.valueOf(3);
        cr.insertAfter("MessageType", msgType);
        p.put("MessageType", msgType);
        String contentType = (String)p.get("Content-Type");
        cr.insertAfter("Content-Type", contentType == null ? this.outBinCoder.getContentType() : contentType);
        cr.insertAfter("Cookie", p.get("Cookie"));
        cr.insertAfter("Accept-Language", p.get("Accept-Language"));
        String requireClientCert = (String)p.get("$clientAuth");
        if (requireClientCert != null) {
            cr.insertAfter("$clientAuth", requireClientCert);
        }
        cr.insertAfter("ProtocolProps", p.get("ProtocolProps"));
        cr.destroy();
        return hdr;
    }

    protected Socket createSocket(String host, int port, int timeout) throws Exception {
        Socket sock = null;
        Object tosockaddr = constrSocketAddr.newInstance(host, new Integer(port));
        sock = (Socket)constrSocket.newInstance(new Object[0]);
        connectMethod.invoke((Object)sock, tosockaddr, new Integer(timeout));
        return sock;
    }

    public synchronized void send(String uuid, String cmd, Properties p, IData data) throws CommException {
        p = p == null ? new Properties() : p;
        IData hdr = this.createHeader(p);
        int msgType = 3;
        try {
            msgType = Integer.parseInt((String)p.get("MessageType"));
        }
        catch (Exception e) {
            // empty catch block
        }
        WmMessage requestMsg = WmMessage.createMessage(uuid, cmd, hdr, data, msgType, p);
        this.send(requestMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IMessage receive(boolean poll) throws CommException {
        WmMessage result = null;
        try {
            if (poll && this.in.available() == 0) {
                return null;
            }
            IDataBinCoder iDataBinCoder = this.inBinCoder;
            synchronized (iDataBinCoder) {
                IData returnData = this.inBinCoder.decode(this.in);
                if (returnData == null) {
                    throw new Exception("Transport Error: Unable to connect, incompatible remote endpoint");
                }
                result = WmMessage.createMessage(returnData);
            }
            WmMessage.checkForError(result);
        }
        catch (IOException ioe) {
            JournalLogger.logDebugPlus(3, 103, 80, "SocketLink", ioe.getMessage());
            if (this.linkListener != null) {
                SocketLink socketLink = this;
                synchronized (socketLink) {
                    this.linkListener.linkDown();
                }
            }
            throw new CommException(ioe.fillInStackTrace());
        }
        catch (Throwable ie) {
            JournalLogger.logDebugPlus(3, 103, 80, "SocketLink", ie.getMessage());
            throw new CommException(ie);
        }
        return result;
    }

    public synchronized void disconnect() {
        if (this.state != 3) {
            try {
                this.socket.close();
                this.state = 3;
                JournalLogger.logDebugPlus(5, 104, 80, "SocketLink", this.linkParms.getURL());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setLinkListener(ILinkListener cl) {
        this.linkListener = cl;
    }

    public ILinkParameters getLinkInfo() {
        return this.linkParms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(WmMessage msg) throws CommException {
        try {
            IDataBinCoder iDataBinCoder = this.outBinCoder;
            synchronized (iDataBinCoder) {
                this.outBinCoder.encode(this.out, msg.getIData());
            }
        }
        catch (IOException ioe) {
            JournalLogger.logDebug(106, 80, "SocketLink", ioe.getMessage());
            if (this.linkListener != null) {
                SocketLink socketLink = this;
                synchronized (socketLink) {
                    this.linkListener.linkDown();
                }
            }
            throw new CommException(ioe.fillInStackTrace());
        }
        catch (Throwable e) {
            throw new CommException(e.fillInStackTrace());
        }
    }

    protected void setEndPointInfo(IData endPointData) {
        Properties props = new Properties();
        String remoteEndPoint = this.socket.getInetAddress().getHostAddress() + ":" + this.socket.getPort();
        props.put("id", this.id);
        props.put("secure", String.valueOf(this.isSecure));
        this.linkParms = new LinkParameters(remoteEndPoint, null, props);
    }

    public Socket getSocket() {
        return this.socket;
    }

    static {
        Config.setupProviders();
        try {
            if (cSecureSocketClass == null) {
                cSecureSocketClass = com.wm.util.Config.getProperty("com.wm.ext.iaik.IaikSecureSocket", "watt.net.socketProvider");
            }
            Class<?> provider = Class.forName(cSecureSocketClass);
            gSecureSocketProvider = (SocketProviderIf)provider.newInstance();
            gSecureSocketProvider.setup();
            if (cRandomGenerator == null) {
                cRandomGenerator = gSecureSocketProvider.newRandomGenerator();
            }
        }
        catch (ClassNotFoundException e) {
            JournalLogger.logDebug(100, 80, e);
            e.printStackTrace();
        }
        catch (Exception e) {
            JournalLogger.logDebug(100, 80, e);
        }
        try {
            constrSocket = Class.forName("java.net.Socket").getConstructor(null);
            Class[] argClass = new Class[]{Class.forName("java.net.SocketAddress"), Integer.TYPE};
            connectMethod = Socket.class.getMethod("connect", argClass);
            Class[] argConstrAddr = new Class[]{Class.forName("java.lang.String"), Integer.TYPE};
            constrSocketAddr = Class.forName("java.net.InetSocketAddress").getConstructor(argConstrAddr);
            useTimeout = true;
        }
        catch (Exception e) {
            useTimeout = false;
        }
        idlock = new Object();
    }
}

