/*
 * Decompiled with CFR 0.152.
 */
package com.wm.driver.comm.b2b.socket;

import com.wm.app.b2b.client.ServiceException;
import com.wm.data.IData;
import com.wm.driver.comm.b2b.WmCommException;
import com.wm.driver.comm.b2b.WmConnection;
import com.wm.driver.comm.b2b.WmConnectionParms;
import com.wm.io.comm.CommException;
import com.wm.io.comm.ILinkListener;
import com.wm.io.comm.IMessage;
import com.wm.io.comm.IMessageHandler;
import com.wm.util.JournalLogger;
import com.wm.util.Values;
import com.wm.util.comm.Connection;
import com.wm.util.text.UUID;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Properties;

public class SocketConnection
implements WmConnection,
ILinkListener {
    public static final int CONAPI0107 = 107;
    public static final int CONAPI0108 = 108;
    public static final boolean log = false;
    protected Connection conn;
    protected WmConnectionParms connParms;
    private int _pendingReqCount = 0;
    private long _timeLastUsed = 0L;
    private boolean _linkClosed = false;
    private String id;

    public SocketConnection(Connection conn, WmConnectionParms cParms) {
        Properties args;
        this.conn = conn;
        this.connParms = cParms;
        this.initHandlers();
        this.id = "sock:" + UUID.generate();
        Properties properties = args = this.connParms != null ? this.connParms.getArgs() : null;
        if (args != null) {
            args.put("id", this.id);
        }
        conn.setLinkListener(this);
    }

    public String send(String cmd, Properties prop, IData data) throws ServiceException {
        ServiceException se = null;
        this.incrPendingReqCount();
        try {
            return this.conn.send(cmd, prop, data);
        }
        catch (CommException ce) {
            this.decrPendingReqCount();
            Throwable t = ce.getWrappedException();
            if (t != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                se = new ServiceException(t.getMessage(), t.getClass().getName(), sw.toString());
            } else {
                se = new ServiceException(ce);
            }
            throw se;
        }
        catch (Exception e) {
            this.decrPendingReqCount();
            se = new ServiceException(e);
            throw se;
        }
    }

    public void sendOnly(String cmd, Properties prop, IData data) throws ServiceException {
        ServiceException se = null;
        try {
            String uuid = UUID.generate();
            this.conn.send(uuid, cmd, prop, data);
        }
        catch (CommException ce) {
            Throwable t = ce.getWrappedException();
            if (t != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                se = new ServiceException(t.getMessage(), t.getClass().getName(), sw.toString());
            } else {
                se = new ServiceException(ce);
            }
            throw se;
        }
        catch (Exception e) {
            se = new ServiceException(e);
            throw se;
        }
    }

    public IData receive(String uuid, long wait) throws ServiceException {
        ServiceException se = null;
        IData retData = null;
        try {
            IMessage msg = this.conn.waitReply(uuid, wait);
            if (msg != null) {
                retData = msg.getData();
            }
            IData iData = retData;
            return iData;
        }
        catch (WmCommException wmce) {
            JournalLogger.logDebugPlus(4, 107, 80, "SocketConnection", wmce.getMessage());
            IData encodedError = wmce.getEncodedError();
            se = encodedError != null ? new ServiceException(Values.use(encodedError)) : new ServiceException(wmce);
            throw se;
        }
        catch (CommException ce) {
            Throwable t = ce.getWrappedException();
            if (t != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                se = new ServiceException(t.getMessage(), t.getClass().getName(), sw.toString());
            } else {
                se = new ServiceException(ce);
            }
            throw se;
        }
        catch (Exception e) {
            se = new ServiceException(e);
            throw se;
        }
        finally {
            this.decrPendingReqCount();
        }
    }

    public IData sendReceive(String cmd, Properties prop, IData data) throws ServiceException {
        int waitTime = 0;
        if (prop != null) {
            try {
                String waitTimeString = prop.getProperty("WAIT_TIME");
                waitTime = Integer.parseInt(waitTimeString);
            }
            catch (Throwable e) {
                waitTime = 0;
            }
        }
        return this.receive(this.send(cmd, prop, data), waitTime);
    }

    public void registerMessageHandler(String cmd, IMessageHandler handler) {
        this.conn.registerMessageHandler(cmd, handler);
    }

    public void unRegisterMessageHandler(String cmd) {
        this.conn.registerMessageHandler(cmd, null);
    }

    public void setDefaultHandler(IMessageHandler handler) {
        this.conn.setDefaultHandler(handler);
    }

    public void setLinkListener(ILinkListener cl) {
        this.conn.setLinkListener(cl);
    }

    public void setLinkReady() {
        this.conn.setLinkReady();
    }

    public void disconnect() {
        this._linkClosed = true;
        this.conn.disconnect();
    }

    public WmConnectionParms getConnectionParms() {
        return this.connParms;
    }

    public void linkDown() {
        JournalLogger.logDebugPlus(4, 108, 80, "SocketConnection");
        this._linkClosed = true;
        this.conn.disconnect();
    }

    public void linkReconnect() {
    }

    public void linkError(CommException e) {
    }

    public boolean isConnectionClosed() {
        return this._linkClosed;
    }

    public synchronized int getPendingReqCount() {
        return this._pendingReqCount;
    }

    private synchronized void incrPendingReqCount() {
        ++this._pendingReqCount;
    }

    private synchronized void decrPendingReqCount() {
        if (this._pendingReqCount > 0) {
            --this._pendingReqCount;
        }
        if (this._pendingReqCount == 0) {
            this._timeLastUsed = System.currentTimeMillis();
        }
    }

    public long getTimeLastUsed() {
        return System.currentTimeMillis() - this._timeLastUsed;
    }

    public String toString() {
        return "SocketConnection:" + this.conn;
    }

    public String getID() {
        return this.id;
    }

    public void handleLinkError(CommException err) {
    }

    private void initHandlers() {
    }

    public IMessage receive(String uuid) throws ServiceException {
        ServiceException se = null;
        try {
            IMessage msg;
            IMessage iMessage = msg = this.conn.waitReply(uuid, 0L);
            return iMessage;
        }
        catch (WmCommException wmce) {
            JournalLogger.logDebugPlus(4, 107, 80, "SocketConnection", wmce.getMessage());
            IData encodedError = wmce.getEncodedError();
            se = encodedError != null ? new ServiceException(Values.use(encodedError)) : new ServiceException(wmce);
            throw se;
        }
        catch (CommException ce) {
            Throwable t = ce.getWrappedException();
            if (t != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                t.printStackTrace(pw);
                se = new ServiceException(t.getMessage(), t.getClass().getName(), sw.toString());
            } else {
                se = ce.getMessage().equals("connection closed") ? new ServiceException(new String("Link down, ") + ce.getMessage(), ce.getClass().getName()) : new ServiceException(ce);
            }
            throw se;
        }
        catch (Exception e) {
            se = new ServiceException(e);
            throw se;
        }
        finally {
            this.decrPendingReqCount();
        }
    }
}

